//Tone Wheel Simulator controller 


#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules
#include "string.h"		// PSoC string function definitions
#include "stdlib.h"		// PSoC standard library function definitions
#include "m8c.h"
#include "DAC9.h"

#pragma interrupt_handler ms_Timer_ISR_C	// Interrupt handlers for the different timers in C.

// ////////////////////////////////////////////////////////////////////////////
void Delay1ms(int);
void RunMotor(void);
void StopMotor(void);
#define BitMask(BitNo)	(0x01 << BitNo)		// Macro to define a Bitmask for a given bit-number
#define SetBit(Var,BitNo) (Var |= BitMask(BitNo))	// Macro to set a bit
#define ClrBit(Var,BitNo) (Var &= ~BitMask(BitNo))	// Macro to clear a bit

#define LED2_PORT 	PRT2DR		//Constant definition for the data port (Port 0) where the LED (LED1) resides.
#define LED2_0_ON 	0x01			//Constant definition to OR with the LED1_PORT to turn on the LED (LED1).
#define LED2_0_OFF 	0xFE			//Constant definition to AND with the LED1_PORT to turn off the LED (LED1).

#define LED2_1_ON 	0x02
#define LED2_1_OFF 	0xFD

#define LED2_2_ON 	0x04
#define LED2_2_OFF 	0xFB

#define LED2_3_ON	0x08
#define LED2_3_OFF	0xF7


#define POWER 		PRT0DR
#define CW 			0x01
#define CCW 		0xFE

#define RUN 		0x02
#define STOP 		0xFD

#define forever		1

int i=0, n=0, x=0;
INT iData;

#if DAC9_OFFSETBINARY
	const INT iMAXVAL=255; // top of ramp
	const INT iMINVAL=0; // bottom of ramp
#else
	#if DAC9_TWOSCOMPLEMENT
		const INT iMAXVAL=127; // top of ramp
		const INT iMINVAL=-128; // bottom of ramp
	#else
		 //DAC9_1_SIGNANDMAGNITUDE
	#endif
#endif


void InitializeHardware(void)
{
    M8C_EnableGInt;                     // Enable global interrupts
	
	ms_Timer_EnableInt();	//Enable timer interrupts
	ADCINCVR_Start(ADCINCVR_HIGHPOWER); // Turn on Analog section
    ADCINCVR_SetResolution(8);			// Set resolution to 8 Bits 
    ADCINCVR_GetSamples(0);             // Start ADC to read continuously
    //PGA_SetGain(PGA_G1_00);
    PGA_Start(PGA_HIGHPOWER);			//The PGA reference is set to GND
	PRT0DR &= ~BitMask(0);				// Clear Bit 0, it is pull down, so we have a low level.
	DirectionPin_Start();				// Direction now set to 0
	RunPin_Start();						// Motor Stop
	DAC9_Start(DAC9_FULLPOWER); 				// power up the DAC
}
// /////////////////////////////////////////////////////

void Wait(void)
{
	// Do Nothing
	// just for better readability
}



void main(void)
{
	INT iData;
	// static unsigned int iData;
	InitializeHardware();   
while(1)
{
		DirectionPin_Off();       	// set it to zero
		RunPin_Off();				// set it to zero
		
	if(POWER & RUN )
		{
			while(ADCINCVR_fIsDataAvailable() == 0) Wait(); 	// Wait for data to be ready.
			iData = ADCINCVR_iGetData();    // Get Data	
			ADCINCVR_ClearFlag();           // Clear data ready flag
				
			if ( POWER & CW ) 
			{
			StopMotor();
			RunMotor();
			
			if (POWER & CCW)
			{
			StopMotor();
			RunMotor();
			DirectionPin_Switch(TRUE);	// set motor direction
			}
			else{wait();}
			
			}	
			else{wait();}
		RunPin_On();	
		DirectionPin_On();		
		}		
	if(POWER & STOP)
		{	
			StopMotor();
			DirectionPin_Off();       	// set it to zero
			RunPin_Off();				// set it to zero
		}

		
}			
} 


void RunMotor(void)
{
	while(ADCINCVR_fIsDataAvailable() == 0)Wait();	// Wait for data to be ready.
															
	DAC9_Start(DAC9_FULLPOWER);				// power up the DAC
	
	iData = ADCINCVR_iGetData();    // Get Data
	
	
	//if(DAC9_OFFSETBINARY)
	//{
		//while(1)
		//{
			//for(iData=iMINVAL; iData <= iMAXVAL; iData++)				//loop to make the motor speed run by a slope
			//{
			//	iData = ADCINCVR_iGetData();    // Get Data	
		
				
				//if(x<=iData)
				//{
					for(x=0; x<=iData;x++)
					{
					Delay1ms(10);
					DAC9_WriteStall(x); 		// update DAC
					ADCINCVR_ClearFlag();           // Clear data ready flag
					}
				//}
			//}	
			DAC9_WriteStall(iData); 		// update DAC
			Delay1ms(5);
			ADCINCVR_ClearFlag();           // Clear data ready flag
		//}
	//}
}
void StopMotor(void)
{
	while(ADCINCVR_fIsDataAvailable() == 0)Wait(); 	// Wait for data to be ready.
											
	DAC9_Start(DAC9_FULLPOWER);				// power up the DAC
	
	iData = ADCINCVR_iGetData();    // Get Data
	
		for(x=iData; x>=0;x--)								//loop to make the motor speed run by a slope till gets to zero.
		{
		Delay1ms(10);
		DAC9_WriteStall(x); 		// update DAC
		ADCINCVR_ClearFlag();           // Clear data ready flag
		}
		
		DAC9_WriteStall(0); 		// update DAC
		Delay1ms(5);
		ADCINCVR_ClearFlag();           // Clear data ready flag
}
void Delay1ms(i)
{
		n=0;
		ms_Timer_Start();
		while(n<i)
		{
		//do nothing while waiting for n interrupts to occur
		//interrupts occur every 1ms		
		}			
		ms_Timer_Stop();
		i=0;
}
void ms_Timer_ISR_C()		// Interrupt handler for the Timer in C.		
{
n++; //increment counter every 1 ms when timer interrupt occurs at end of its count
}