;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: ms_Timer.inc
;;   Version: 2.70, Updated on 2012/3/2 at 9:15:29
;;  Generated by PSoC Designer 5.2.2551
;;
;;  DESCRIPTION: Assembler declarations for the Timer8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2012. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for ms_Timer API's.
;--------------------------------------------------

ms_Timer_CONTROL_REG_START_BIT:            equ 0x01    ; Control register start bit
ms_Timer_INT_REG:                          equ 0x0e1
ms_Timer_INT_MASK:                         equ 0x08


;--------------------------------------------------
; Constants for ms_Timer user defined values
;--------------------------------------------------

ms_Timer_PERIOD:                           equ 0x7d
ms_Timer_COMPARE_VALUE:                    equ 0x00


;--------------------------------------------------
; Register Address Constants for ms_Timer
;--------------------------------------------------

ms_Timer_COUNTER_REG:                  equ 0x2c   ; DR0 Counter register
ms_Timer_PERIOD_REG:                   equ 0x2d   ; DR1 Period register
ms_Timer_COMPARE_REG:                  equ 0x2e   ; DR2 CompareValue register
ms_Timer_CONTROL_REG:                  equ 0x2f   ; Control register
ms_Timer_FUNC_REG:                     equ 0x2c   ; Function register
ms_Timer_INPUT_REG:                    equ 0x2d   ; Input register
ms_Timer_OUTPUT_REG:                   equ 0x2e   ; Output register


;--------------------------------------------------
; ms_Timer Macro 'Functions'
;--------------------------------------------------

   macro ms_Timer_Start_M
   or    reg[ms_Timer_CONTROL_REG],  ms_Timer_CONTROL_REG_START_BIT
   endm

   macro ms_Timer_Stop_M
   and   reg[ms_Timer_CONTROL_REG], ~ms_Timer_CONTROL_REG_START_BIT
   endm

   macro ms_Timer_EnableInt_M
   M8C_EnableIntMask ms_Timer_INT_REG, ms_Timer_INT_MASK
   endm

   macro ms_Timer_DisableInt_M
   M8C_DisableIntMask ms_Timer_INT_REG, ms_Timer_INT_MASK
   endm


; end of file ms_Timer.inc
