//Tone Wheel Simulator controller 


#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules
#include "string.h"		// PSoC string function definitions
#include "stdlib.h"		// PSoC standard library function definitions
#include "m8c.h"
#include "DAC9.h"

#pragma interrupt_handler ms_Timer_ISR_C	// Interrupt handlers for the different timers in C.

// ////////////////////////////////////////////////////////////////////////////
void Delay1ms(int);
void MoveMotor(int RequiredSpeed);
void RunPOT(void);

#define BitMask(BitNo)	(0x01 << BitNo)		// Macro to define a Bitmask for a given bit-number
#define SetBit(Var,BitNo) (Var |= BitMask(BitNo))	// Macro to set a bit
#define ClrBit(Var,BitNo) (Var &= ~BitMask(BitNo))	// Macro to clear a bit
#define Signum(x)		(x > 0?1:-1)				// Signum fuction 
#define abs(x)			(x > 0?x:-x)				// abs function

#define LED2_PORT 	PRT2DR			//Constant definition for the data port (Port 0) where the LED (LED1) resides.
#define LED2_0_ON 	0x01			//Constant definition to OR with the LED1_PORT to turn on the LED (LED1).
#define LED2_0_OFF 	0xFE			//Constant definition to AND with the LED1_PORT to turn off the LED (LED1).

#define LED2_1_ON 	0x02
#define LED2_1_OFF 	0xFD

#define LED2_2_ON 	0x04
#define LED2_2_OFF 	0xFB

#define LED2_3_ON	0x08
#define LED2_3_OFF	0xF7


#define POWER 		PRT0DR
#define CW 			0x01
#define CCW 		0xFE

#define RUN 		0x02
#define STOP 		0xFD

#define forever		1

int i=0, n=0;
//INT iData;

#if DAC9_OFFSETBINARY
	const INT iMAXVAL=255; // top of ramp
	const INT iMINVAL=0; // bottom of ramp
#else
	#if DAC9_TWOSCOMPLEMENT
		const INT iMAXVAL=127; // top of ramp
		const INT iMINVAL=-128; // bottom of ramp
	#else
		 //DAC9_1_SIGNANDMAGNITUDE
	#endif
#endif

static int CurrentSpeed = 0;			// Global speed of motor

void InitializeHardware(void)
{
    M8C_EnableGInt;                     // Enable global interrupts
	
	ms_Timer_EnableInt();	//Enable timer interrupts
	ADCINCVR_Start(ADCINCVR_HIGHPOWER); // Turn on Analog section
    ADCINCVR_SetResolution(8);			// Set resolution to 8 Bits 
    ADCINCVR_GetSamples(0);             // Start ADC to read continuously
    //PGA_SetGain(PGA_G1_00);
    PGA_Start(PGA_HIGHPOWER);			//The PGA reference is set to GND
	PRT0DR &= ~BitMask(0);				// Clear Bit 0, it is pull down, so we have a low level.
	DirectionPin_Start();				// Direction now set to 0
	RunPin_Start();						// Motor Stop
	DAC9_Start(DAC9_FULLPOWER); 				// power up the DAC
	ClrBit(PRT0DR,0);
}
// /////////////////////////////////////////////////////

void Wait(void)
{
	// Do Nothing
	// just for better readability
}



void main(void)
{
	InitializeHardware();   
	DirectionPin_Off();       	// set it to zero
	RunPin_Off();				// set it to zero

	while(forever)
	{
		if(POWER & RUN)
		{
			DirectionPin_Switch(POWER & CW);	// Set the Direction output
			RunPin_On();
			
			while(ADCINCVR_fIsDataAvailable() == 0) Wait(); 	// Wait for data to be ready.
			MoveMotor(ADCINCVR_iGetDataClearFlag());			// Get Data	and set motor-speed
		}
		else
		{	
			MoveMotor(0);				// set it to zero		
			DirectionPin_Off();       	// set it to zero
			RunPin_Off();
		}		
	}
}
//*******************************************************************

void MoveMotor(int WantedSpeed)
{
int x;
int Sign;
int Delta;
INT iData;
	Delta = WantedSpeed - CurrentSpeed;					// Difference 
	Sign  = Signum(Delta);								// Sign is +1 or -1
	Delta = abs(Delta);									// Delta is positive now
	for(x = CurrentSpeed; Delta > 0 ;x += Sign, Delta--)	//loop to make the motor speed run by a slope till gets to desired value.
	{
		Delay1ms(10);
		DAC9_WriteStall(x); 		// update DAC
	}
	CurrentSpeed = x;				// Remember actual speed
}
//*******************************************************************

void Delay1ms(int i)
{
		n=0;
		ms_Timer_Start();
		while(n<i)
		{
		//do nothing while waiting for n interrupts to occur
		//interrupts occur every 1ms		
		}			
		ms_Timer_Stop();
		i=0;
}
//*******************************************************************

void ms_Timer_ISR_C(void)		// Interrupt handler for the Timer in C.		
{
	n++; //increment counter every 1 ms when timer interrupt occurs at end of its count
}