;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   ADCINCVR.inc
;;  Version: 4.00, Updated on 2012/3/2 at 9:12:24
;;  Generated by PSoC Designer 5.2.2551
;;
;;  DESCRIPTION:  Assembler declarations for the ADCINCVR user module interface.
;;
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2012. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************


;--------------------------------------------------
; Register Address Constants for ADCINCVR
;--------------------------------------------------

; Counter Constants
ADCINCVR_bfCounter_Mask:               equ   01h
ADCINCVR_bfCounter_INT_REG:            equ   0e1h

; PWM Constants
ADCINCVR_bfPWM16_Mask:                 equ   04h
ADCINCVR_bfPWM16_INT_REG:              equ   0e1h

; Power Settings
ADCINCVR_bfPOWERMASK:                  equ   03h
ADCINCVR_OFF:                          equ   00h
ADCINCVR_LOWPOWER:                     equ   01h
ADCINCVR_MEDPOWER:                     equ   02h
ADCINCVR_HIGHPOWER:                    equ   03h

; Parameter Settings
ADCINCVR_bNUMBITS:                     equ   8h
ADCINCVR_bCALCTIME:                    equ   2dh
ADCINCVR_bMAXRES:                      equ   0Dh      ; Max resolution 13 bits
ADCINCVR_bMINRES:                      equ   07h      ; Min resolution 7 bits
ADCINCVR_fCOMPARE_TRUE:                equ   08h      ; Bit to enable compare True interrupts

; Functionality constants
ADCINCVR_fFSW0:                        equ   10h      ; Switch Cap FSW0 switch enable
ADCINCVR_NoAZ:                         equ   01h      ; Set if AutoZero is not enabled
ADCINCVR_fAutoZero:                    equ   20h      ; Switch Cap AutoZero switch enable
ADCINCVR_fDBLK_ENABLE:                 equ   01h      ; Digital block enable bit
ADCINCVR_fPULSE_WIDE:                  equ   04h      ; Enable wide terminal count pulse.

; fStatus definitions
ADCINCVR_fDATA_READY:                  equ   10h      ; This bit is set when data is available
ADCINCVR_bRES_MASK:                    equ   0Fh      ; This bit while in integrate cycle

; Data Format
ADCINCVR_DATA_FORMAT:                  equ   0

; Flag in CR2 register mask
ADCINCVR_fRES_SET:                     equ   01h

;--------------------------------------------------
; Registers used by ADCINCVR
;--------------------------------------------------
; ADCINCVR PSoC Block register Definitions
; Integrator Block Register Definitions
ADCINCVR_bfAtoDcr0: equ 80h
ADCINCVR_bfAtoDcr1: equ 81h
ADCINCVR_bfAtoDcr2: equ 82h
ADCINCVR_bfAtoDcr3: equ 83h

; Counter Block Register Definitions
ADCINCVR_fCounterFN:    equ 20h
ADCINCVR_fCounterSL:    equ 21h
ADCINCVR_fCounterOS:    equ 22h
ADCINCVR_bCount:    equ 20h
ADCINCVR_bPeriod:   equ 21h
ADCINCVR_bCompare:  equ 22h
ADCINCVR_bCounter_CR0:  equ 23h

; PWM16 Block Register Definitions
ADCINCVR_bfPWM_LSB_FN:  equ 24h
ADCINCVR_bfPWM_MSB_FN:  equ 28h
ADCINCVR_fPWM_LSB_CR0:  equ 27h
ADCINCVR_fPWM_MSB_CR0:  equ 2bh
ADCINCVR_bPWM_Count_MSB:    equ 28h
ADCINCVR_bPWM_Count_LSB:    equ 24h
ADCINCVR_bPWM_Period_MSB:   equ 29h
ADCINCVR_bPWM_Period_LSB:   equ 25h
ADCINCVR_bPWM_IntTime_MSB:  equ 2ah
ADCINCVR_bPWM_IntTime_LSB:  equ 26h
ADCINCVR_bfPWM_LSB_FN:  equ 24h
ADCINCVR_bfPWM_MSB_FN:  equ 28h


; End of File ADCINCVR.inc


