//*****************************************************************************
//*****************************************************************************
//  FILENAME: DAC9.h
//   Version: 2.2, Updated on 2012/3/2 at 9:13:53
//  Generated by PSoC Designer 5.2.2551
//
//  DESCRIPTION: DAC9 User Module C Language interface file.
//
//-----------------------------------------------------------------------------
//      Copyright (c) Cypress Semiconductor 2012. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
#ifndef DAC9_INCLUDE
#define DAC9_INCLUDE

#include <m8c.h>

//-------------------------------------------------
// Defines for DAC9 API's.
//-------------------------------------------------
// Power Setting Defines
#define DAC9_OFF                 0
#define DAC9_LOWPOWER            1
#define DAC9_MEDPOWER            2
#define DAC9_HIGHPOWER           3
#define DAC9_FULLPOWER           3

// Define constants for declaring function prototypes based on DataFormat parameter
#define DAC9_OffsetBinary            0x04
#define DAC9_TwosComplement          0x02
#define DAC9_SignAndMagnitude        0x01
#define DAC9_RawRegister             0x00
#define DAC9_DATAFORMAT          0x7
#define DAC9_OFFSETBINARY        DAC9_DATAFORMAT & DAC9_OffsetBinary
#define DAC9_TWOSCOMPLEMENT      DAC9_DATAFORMAT & DAC9_TwosComplement
#define DAC9_SIGNANDMAGNITUDE    DAC9_DATAFORMAT & DAC9_SignAndMagnitude

// Declare function fastcall16 pragmas
#pragma fastcall16 DAC9_Start
#pragma fastcall16 DAC9_SetPower
#pragma fastcall16 DAC9_Stop

//-------------------------------------------------
// Prototypes of the DAC9 API.
//-------------------------------------------------
extern void  DAC9_Start(BYTE bPowerSetting);
extern void  DAC9_SetPower(BYTE bPowerSetting);
extern void  DAC9_Stop(void);

// Declare overloaded functions based on DataForamt parameter selected
#if DAC9_OFFSETBINARY
   #pragma fastcall16 DAC9_WriteBlind
   #pragma fastcall16 DAC9_WriteStall
   extern void  DAC9_WriteBlind(WORD wOutputValue);
   extern void  DAC9_WriteStall(WORD wOutputValue);
#else
   #if DAC9_TWOSCOMPLEMENT
      #pragma fastcall16 DAC9_WriteBlind
      #pragma fastcall16 DAC9_WriteStall
      extern void  DAC9_WriteBlind(INT iOutputValue);
      extern void  DAC9_WriteStall(INT iOutputValue);
   #else    //DAC9_SIGNANDMAGNITUDE
      #pragma fastcall16 DAC9_WriteBlind2B
      #pragma fastcall16 DAC9_WriteStall2B
      extern void  DAC9_WriteBlind2B(BYTE bLSB, BYTE bMSB);
      extern void  DAC9_WriteStall2B(BYTE bLSB, BYTE bMSB);
   #endif
#endif

//-------------------------------------------------
// Hardware Addresses for DAC9
//-------------------------------------------------

#pragma ioport  DAC9_LSB_CR0:   0x090                      // LSB Analog control register 0
BYTE            DAC9_LSB_CR0;
#pragma ioport  DAC9_LSB_CR1:   0x091                      // LSB Analog control register 1
BYTE            DAC9_LSB_CR1;
#pragma ioport  DAC9_LSB_CR2:   0x092                      // LSB Analog control register 2
BYTE            DAC9_LSB_CR2;
#pragma ioport  DAC9_LSB_CR3:   0x093                      // LSB Analog control register 3
BYTE            DAC9_LSB_CR3;

#pragma ioport  DAC9_MSB_CR0:   0x094                      // MSB Analog control register 0
BYTE            DAC9_MSB_CR0;
#pragma ioport  DAC9_MSB_CR1:   0x095                      // MSB Analog control register 1
BYTE            DAC9_MSB_CR1;
#pragma ioport  DAC9_MSB_CR2:   0x096                      // MSB Analog control register 2
BYTE            DAC9_MSB_CR2;
#pragma ioport  DAC9_MSB_CR3:   0x097                      // MSB Analog control register 3
BYTE            DAC9_MSB_CR3;

#endif
// end of file DAC9.h
