;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DAC9.inc
;;   Version: 2.2, Updated on 2012/3/2 at 9:13:53
;;  Generated by PSoC Designer 5.2.2551
;;
;;  DESCRIPTION:  Assembler declarations for the DAC9 user module interface.
;;
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2012. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"

;--------------------------------------------------
; Constants for DAC9 API's
;--------------------------------------------------
DAC9_OFF:              equ 00h
DAC9_LOWPOWER:         equ 01h
DAC9_MEDPOWER:         equ 02h
DAC9_HIGHPOWER:        equ 03h
DAC9_FULLPOWER:        equ 03h

DAC9_LSB_CR0:          equ 90h
DAC9_LSB_CR1:          equ 91h
DAC9_LSB_CR2:          equ 92h
DAC9_LSB_CR3:          equ 93h
DAC9_MSB_CR0:          equ 94h
DAC9_MSB_CR1:          equ 95h
DAC9_MSB_CR2:          equ 96h
DAC9_MSB_CR3:          equ 97h

DAC9_OffsetBinary:     equ 04h
DAC9_TwosComplement:   equ 02h
DAC9_SignAndMagnitude: equ 01h
DAC9_RawRegister:      equ 00h

DAC9_DATAFORMAT:       equ 7h
DAC9_OFFSETBINARY:     equ DAC9_DATAFORMAT & DAC9_OffsetBinary
DAC9_TWOSCOMPLEMENT:   equ DAC9_DATAFORMAT & DAC9_TwosComplement
DAC9_SIGNANDMAGNITUDE: equ DAC9_DATAFORMAT & DAC9_SignAndMagnitude

DAC9_PHASE_Normal:     equ 0
DAC9_PHASE_Swapped:    equ 1

DAC9_PHASE_SWAP:       equ DAC9_PHASE_Normal

IF DAC9_PHASE_SWAP
    DAC9_CR0_HIBITS:   equ C0h
ELSE
    DAC9_CR0_HIBITS:   equ 80h
ENDIF

;--------------------------------------------------
; Register Address Constants for DAC9
;--------------------------------------------------
DAC9_LSB_CR0:   equ 90h                          ; LSB SC Block Control Register 0
DAC9_LSB_CR1:   equ 91h                          ; LSB SC Block Control Register 1
DAC9_LSB_CR2:   equ 92h                          ; LSB SC Block Control Register 2
DAC9_LSB_CR3:   equ 93h                          ; LSB SC Block Control Register 3

DAC9_MSB_CR0:   equ 94h                          ; MSB SC Block Control Register 0
DAC9_MSB_CR1:   equ 95h                          ; MSB SC Block Control Register 1
DAC9_MSB_CR2:   equ 96h                          ; MSB SC Block Control Register 2
DAC9_MSB_CR3:   equ 97h                          ; MSB SC Block Control Register 3

; end of file DAC9.inc
