//Tone Wheel Simulator controller 


#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules
#include "string.h"		// PSoC string function definitions
#include "stdlib.h"		// PSoC standard library function definitions
#include "m8c.h"

#pragma interrupt_handler ms_Timer_ISR_C	// Interrupt handlers for the different timers in C.
// ////////////////////////////////////////////////////////////////////////////

void Delay1ms(char);

#define BitMask(BitNo)	(0x01 << BitNo)		// Macro to define a Bitmask for a given bit-number
#define SetBit(Var,BitNo) (Var |= BitMask(BitNo))	// Macro to set a bit
#define ClrBit(Var,BitNo) (Var &= ~BitMask(BitNo))	// Macro to clear a bit
#define LED2_PORT 	PRT2DR					//Constant definition for the data port (Port 0) where the LED (LED1) resides.

#define LED0_Pos	0
#define LED2_0_ON 	0x01					//Constant definition to OR with the LED1_PORT to turn on the LED (LED1).
#define LED2_0_OFF 	0xFE					//Constant definition to AND with the LED1_PORT to turn off the LED (LED1).

#define LED1_Pos	1
#define LED2_1_ON 	0x02
#define LED2_1_OFF 	0xFD

#define LED2_Pos	2
#define LED2_2_ON 	0x04
#define LED2_2_OFF 	0xFB

#define LED3_Pos	3
#define LED2_3_ON	0x08
#define LED2_3_OFF	0xF7


#define POWER 		PRT0DR
#define CW 			0x01
#define CCW 		0xFE

#define RUN 		0x02
#define STOP 		0xFD

#define forever		1

// int i=0, n=0, x=0;

unsigned char msCounter;	// used in interrupt-routine

#if DAC9_OFFSETBINARY
	const INT iMAXVAL=255; // top of ramp *** This is not an int, this is an unsigned char! SAVE MEMORY!!!
	const INT iMINVAL=0; // bottom of ramp
#else
	#if DAC9_TWOSCOMPLEMENT
		const INT iMAXVAL=127; // top of ramp *** This is not an int, this is a (signed) char
		const INT iMINVAL=-128; // bottom of ramp
	#else
		 //DAC9_1_SIGNANDMAGNITUDE
	#endif
#endif

static unsigned int CurrentMotorSpeed = 0;	// Zero for offset binary

void InitializeHardware(void)
{
    M8C_EnableGInt;                     		// Enable global interrupts
	
	ms_Timer_EnableInt();						//Enable timer interrupts
	ADCINCVR_Start(ADCINCVR_HIGHPOWER);		 	// Turn on Analog section
    ADCINCVR_SetResolution(8);					// Set resolution to 8 Bits 
    ADCINCVR_GetSamples(0);     	        	// Start ADC to read continuously
    //PGA_SetGain(PGA_G1_00);	
    PGA_Start(PGA_HIGHPOWER);					//The PGA reference is set to GND
	ClrBit(PRT0DR,0);							// Clear Bit 0, it is pull down, so we have a low level.
	DirectionPin_Start();						// Direction now set to 0
	RunPin_Start();								// Motor Stop
	DAC9_Start(DAC9_FULLPOWER); 				// power up the DAC
	DAC9_WriteStall(0);							// output zero level
}
// /////////////////////////////////////////////////////

void Wait(void)
{
	// Do Nothing
	// just for better readability
}

unsigned char GetPotiPosition(void)
{
	while(!ADCINCVR_fIsDataAvailable()) Wait(); 	// Wait for data to be ready.
	return ADCINCVR_iGetDataClearFlag();   			// Get Data and clear data ready flag
}

void MoveMotorFaster(unsigned int MaxSpeed)
{
unsigned char DACValue;
	for (DACValue = CurrentMotorSpeed;DACValue < MaxSpeed;DACValue++)
	{
		DAC9_WriteStall(DACValue);
		Delay1ms(5);
	}
}

void MoveMotorSlower(unsigned int StartSpeed)
{
unsigned char DACValue;
	for (DACValue = CurrentMotorSpeed;DACValue > 0;DACValue--)
	{
		DAC9_WriteStall(DACValue);
		Delay1ms(5);
	}
}

void MoveMotor(unsigned char MaxSpeed)
{
	if(MaxSpeed < CurrentMotorSpeed)	MoveMotorFaster(MaxSpeed); 
	else								MoveMotorSlower(MaxSpeed);
	CurrentMotorSpeed = MaxSpeed;
}

void main(void)
{
//	INT iData;
//static unsigned int iData;	//***** I did'nt declare this for nothing, there has been some sense behind that. Anyway, we do not need it anymore

	InitializeHardware();   
	DirectionPin_Off();       	// set it to zero *** Set it to zero outside the loop
	RunPin_Off();				// set it to zero *** same
	

	while(forever)			// This is the main loop, executes about a hunderd times per second?
	{	
		if (POWER & RUN)	// Run motor signal
		{
			RunPin_On();		// Set motor running
			if(POWER & CW)		// Check applied direction
			{
				// *** Insert here: When direction changed while motor is running, slow motor down to zero first			
				DirectionPin_Switch(TRUE);	// set motor direction
			}
			MoveMotor(GetPotiPosition());		
		}
	}			
}

void Delay1ms(unsigned char msNumber)
{
	msCounter = msNumber;
	ms_Timer_Start();
	while(msCounter) Wait();	// until msCounter == 0
	{
	//do nothing while waiting for n interrupts to occur
	//interrupts occur every 1ms		
	}			
	ms_Timer_Stop();
}

void ms_Timer_ISR_C(void)
		// Interrupt handler for the Timer in C.
{
	if(msCounter) msCounter--; //decrement counter only if != 0, every 1 ms when timer interrupt occurs at end of its count
}

