/*******************************************************************************
* File Name: main.c
*
* Version: 2.20
*
* Description: 
*   This is a source code for example project of ADC differential mode.
*
* Hardware Connections:
*  Connect analog input from Variable resistor to port P0[0] of DVK1 board.
*
********************************************************************************
* Copyright 2012, Cypress Semiconductor Corporation. All rights reserved.
* This software is owned by Cypress Semiconductor Corporation and is protected
* by and subject to worldwide patent and copyright laws and treaties.
* Therefore, you may use this software only as provided in the license agreement
* accompanying the software package from which you obtained this software.
* CYPRESS AND ITS SUPPLIERS MAKE NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* WITH REGARD TO THIS SOFTWARE, INCLUDING, BUT NOT LIMITED TO, NONINFRINGEMENT,
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*******************************************************************************/

#include <project.h>
#include <stdio.h>

#if defined (__GNUC__)
    /* Add an explicit reference to the floating point printf library */
    /* to allow the usage of floating point conversion specifiers. */
    /* This is not linked in by default with the newlib-nano library. */
    asm (".global _printf_float");
#endif


/*******************************************************************************
* Function Name: main
********************************************************************************
* Summary:
*  Main function performs following functions:
*  1: Initializes the LCD
*  2: Initializes the VDAC.
*  3: Starts ADC 
*  4: Starts ADC converstion.
*  5: Gets the converted result and displays it in LCD.
*
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
int main()
{
    int16 output;
	char8 str[10];
    
    /* Start the components */
    
    LCD_Start();
    VDAC8_1_Start();
    ADC_DelSig_1_Start();
    
    /* Start the ADC conversion */
    ADC_DelSig_1_StartConvert();
    
    /* Display the value of ADC output on LCD */
    LCD_Position(0u, 0u);
    LCD_PrintString("ADC_Output");
    
    for(;;)
    {
        if(ADC_DelSig_1_IsEndConversion(ADC_DelSig_1_RETURN_STATUS))
        {
            output = ADC_DelSig_1_GetResult16();
			output = ADC_DelSig_1_CountsTo_mVolts(output) ;
			sprintf(str, "%d mV", output);
			
			LCD_Position(1u, 0u);
			LCD_PrintString("         ");
			LCD_Position(1u, 0u);
            LCD_PrintString(str);
			CyDelay(100u);
        }
    }
}


/* [] END OF FILE */