/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/

#include "project.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "stdbool.h"

uint16 ms_count = 0;
uint16 ms_count_boot = 0;
bool buttonFlag;

/*****************************************************************************
* Function Name: FiltInt_ISR()
******************************************************************************
* Summary:
*   An interrupt service routine that is called on a filtered press or release
*	event of a switch.  Each time it is called it clears the interrupt source
*	then increments a filtered count variable.
*
* Parameters:
*   none
*
* Return:
*   None.  Filtered count is incremented.
*
*****************************************************************************/
CY_ISR(FiltInt_ISR)
{
	FiltReset_Write(1); /* clear interrupt source */
    if (buttonFlag == 0) {
        buttonFlag = 1;
        // Do some LED blinking to show the board's "mode" without having to look at the computer screen. Blue blinking light.
        PWM_BLUE_Start();
        PWM_RED_Sleep();
        ms_count = 0;
    } else if (buttonFlag == 1) { 
        buttonFlag = 0;
        // Do some LED blinking to show the board's "mode" without having to look at the computer screen. Red blinking light.
        PWM_RED_Start();
        PWM_BLUE_Sleep();
    } else {
        PWM_RED_Sleep();
        PWM_BLUE_Sleep();
    }
} /* end of FiltInt_ISR() */

// This interrupt is meant to increment a counter every Timer period. 
// When the ADC data is printed to screen, I send the counter value to screen as well.

CY_ISR(MY_ISR) {
    ms_count ++;
    ms_count_boot ++;
}

/*******************************************************************************
* Function Name: main()
********************************************************************************
* Summary:
*   Contains initialization for different components, and a main loop to
*   continually display the value in a global count variable.
*
* Parameters:
*   none
*
* Return:
*   none
*
*****************************************************************************/

int main(void)
{
    int i;
	uint32 resultsCounts[9];
    double resultsV[9];
    char uartLine[250];
    unsigned int IDAC_setCurrent = 0xD5;

    double setCurrent = IDAC_setCurrent * 1.2 /(1e6); // Current through DAQ in Amps.
    double resultsOhms[9];
        
    char *tmpSign[9];
    double tmpVal[9];
            
    int tmpInt1[9];
    double tmpFrac[9];
    int tmpInt2[9];
    
    /* Components should be initialized in the following order:
    *   1. interrupts
    *   2. sources of interrupts (clocks are auto-intialized).
    *   3. global interrupt enable
    */
    	
    Timer_1_Start(); //Configure and enable timer
    isr_1_StartEx(MY_ISR); // Point to MY_ISR to carry out interrupt sub-routine

   	FiltInt_StartEx(FiltInt_ISR); /* start filtered interrupt and set ISR function */
   	FiltReset_Write(1); /* source of interrupt (reset) */
	FiltInt_ClearPending(); /* in case an interrupt is still pending */
	CyGlobalIntEnable; /* Enable global interrupts. */

    /* Place your initialization/startup code here (e.g. MyInst_Start()) */

	//Make sure you start all the hardware blocks, these functions take all the settings from the configuration GUIs and puts them into the SFRs
	ADC_Start();
	IDAC_Start();
    
    /* Start SCB (UART mode) operation */
    UART_Start();
    UART_UartPutString("\r\n");
    
    for(;;)
    {
        /* Place your application code here. */
        
        CyGlobalIntDisable; /* macro */
        CyGlobalIntEnable; /* macro */
        
        for (i=0;i<9;i++) {
			
			AMux_Select(i); 	//Set the sensor to read
			IDAC_SetValue(IDAC_setCurrent); 	//Set current dac to the desired current (could be unique per sensor)
			ADC_StartConvert(); //Start the conversion
            
			ADC_IsEndConversion(ADC_WAIT_FOR_RESULT);	//Stall until complete
			resultsCounts[i] = ADC_GetResult16(0);
            resultsV[i] = ADC_CountsTo_Volts(0, resultsCounts[i]);
            resultsOhms[i] = resultsV[i] / setCurrent;
            
             // Display Results in Counts (Comment out the other two parts about Volts and kOHMS)
            
            tmpSign[i] = (resultsCounts[i] < 0) ? "-" : "";
            tmpVal[i] = (resultsCounts[i] < 0) ? -resultsCounts[i] : resultsCounts[i];
            
            tmpInt1[i] = tmpVal[i];                   // Get the Integer from the raw counts.
            tmpFrac[i] = tmpVal[i] - tmpInt1[i];       // Get fraction from the raw counts.
            tmpInt2[i] = (tmpFrac[i] * 1000000);   // Turn into and integer.
            
            
             // Display Results in Volts (Comment out the other two parts about COUNTS and kOHMS)
            
            /*
            tmpSign[i] = (resultsV[i] < 0) ? "-" : "";
            tmpVal[i] = (resultsV[i] < 0) ? -resultsV[i] : resultsV[i];
            
            tmpInt1[i] = tmpVal[i];                   // Get the Integer from the raw voltage.
            tmpFrac[i] = tmpVal[i] - tmpInt1[i];       // Get fraction from the raw voltage.
            tmpInt2[i] = (tmpFrac[i] * 1000000);   // Turn into and integer.
            */
            
            // Display Results in kOhms (Comment out the other two parts about COUNTS and Volts)
            
            /* tmpSign[i] = (resultsOhms[i] < 0) ? "-" : "";
            tmpVal[i] = (resultsOhms[i] < 0) ? -resultsOhms[i] : resultsOhms[i];
          
            tmpInt1[i] = tmpVal[i];                   // Get the Integer from the raw resistance.
            tmpFrac[i] = tmpVal[i] - tmpInt1[i];       // Get fraction from the raw resistance.
            tmpInt2[i] = (tmpFrac[i] * 1000000);   // Turn into and integer.
            */           
		}
        
        if (buttonFlag == 1) {
            
            sprintf(uartLine, "%d, %d, %s%d.%04d, %s%d.%0.4d, %s%d.%0.4d, %s%d.%0.4d, %s%d.%0.4d, %s%d.%0.4d, %s%d.%0.4d, %s%d.%0.4d, %s%d.%0.4d, ", \
                    ms_count_boot, ms_count, tmpSign[0], tmpInt1[0], tmpInt2[0], tmpSign[1], tmpInt1[1], tmpInt2[1], \
                                             tmpSign[2], tmpInt1[2], tmpInt2[2], tmpSign[3], tmpInt1[3], tmpInt2[3], \
                                             tmpSign[4], tmpInt1[4], tmpInt2[4], tmpSign[5], tmpInt1[5], tmpInt2[5], \
                                             tmpSign[6], tmpInt1[6], tmpInt2[6], tmpSign[7], tmpInt1[7], tmpInt2[7], \
                                             tmpSign[8], tmpInt1[8], tmpInt2[8]);
        } else {
        
            sprintf(uartLine, "Press button to collect data.");
        }
        
        // Send the text line out of UART.
        UART_UartPutString(uartLine);
        UART_UartPutString("\r\n");
		
		//Lots of conditioning you can do next: 
		
		//You can check to see if the ADC is railed out and then reduce the current to get the voltage accross the sensor to be within ADC range
		
		//You can convert the result (which is voltage) into resistance by dividing the current value (Ohm's Law)
		
		//You can send the data to a UART or other communication block
        
    }
}

/* [] END OF FILE */
 