#include "project.h"
#include "nRF24.h"

uint8 NRF_PIPE = 0u;

uint8 spiWrite0(uint8);
uint8 spiWrite1(uint8, uint8);   // Write register with value. Return status
uint8 spiRead1(uint8);           // Read register and return the value
uint8 nrfClearStatusInt(uint8);

int main(void)
{
    uint8 temp;
    
    CyGlobalIntEnable; /* Enable global interrupts. */
    SPIM_Start();

    SPIM_ClearTxBuffer();
    SPIM_ClearRxBuffer();

    // I do this in a loop so I can watch what happens in a logic analyzer
    for(;;) {
        temp = spiWrite1(NRF_PIPE + NRF_RX_PW_P0, RX_PAYLOAD_BYTES);  // Number of bytes in Rx payload (1-32).
        temp = spiWrite1(NRF_CONFIG, CFG_PRIM_RX | CFG_PWR_UP | CFG_CRCO);
        temp = spiWrite0(FLUSH_TX);     // Flush Tx command
        temp = spiWrite0(FLUSH_RX);     // Flush Rx command
        temp = nrfClearStatusInt(STAT_MAX_RT | STAT_RX_DR | STAT_TX_DS);
        temp = spiWrite0(NRF_NOP);      // Summy command to read status reg
        CyDelay(1u);
    }
}

// Write a command that requires zero additional bytes
uint8 spiWrite0(uint8 cmd) {
    uint8 ret;
    
    SPIM_WriteTxData(cmd);
    CyDelayUs(SPI_XFER_DELAY);
    while(!(SPIM_ReadRxStatus()) & SPIM_STS_RX_FIFO_FULL);  // Wait for Rx FIFO
    ret = SPIM_ReadRxData();
    
    return(ret);
}

// Do a write that requires one additioanl byte
uint8 spiWrite1(uint8 addr, uint8 val) {
    uint8 array[2], ret;
    
    addr |= W_REGISTER;
    array[0] = addr;
    array[1] = val;
    
    SPIM_PutArray(array, 2);  // Put 0x0F at 0x00
    CyDelayUs(SPI_XFER_DELAY);  
    while(!(SPIM_ReadRxStatus()) & SPIM_STS_RX_FIFO_FULL);  // Wait for Rx FIFO
    ret = SPIM_ReadRxData();
    
    return(ret);
}

// Do a read that expects a byte to be returned.
uint8 spiRead1(uint8 addr) {
    uint8 array[2], ret;
    
    array[0] = addr;
    array[1] = 0xFF;
    
    SPIM_PutArray(array, 2);  // Put 0x0F at 0x00
    CyDelayUs(SPI_XFER_DELAY);    
    while(!(SPIM_ReadRxStatus()) & SPIM_STS_RX_FIFO_FULL);  // Wait for Rx FIFO
    ret = SPIM_ReadRxData();
    
    return(ret);
}

uint8 nrfClearStatusInt(uint8 mask) {
    uint8 ret, stat, saved;
    
    stat = spiWrite0(NRF_NOP);          // NOP sends us the status register
    saved = stat;
    stat |= mask;
    
    if (stat != saved) { // If stat != saved then one of the INT bits is set, so write the new data
        ret = spiWrite1(NRF_STATUS, stat);
        return(ret);
    }
    return(saved);
}

/* [] END OF FILE */
