/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "project.h"

uint8_t UartRxFlag = 0;
uint8_t UartRxDat = 0;

uint32_t SysTickCnt = 0;

void ISR_UART(void)
{
	/* Check for "RX fifo not empty interrupt" */
    if((UART_HW->INTR_RX_MASKED & SCB_INTR_RX_MASKED_NOT_EMPTY_Msk ) != 0)
    {
    	/* Clear UART "RX fifo not empty interrupt" */
		UART_HW->INTR_RX = UART_HW->INTR_RX & SCB_INTR_RX_NOT_EMPTY_Msk; 

		UartRxDat = Cy_SCB_UART_Get(UART_HW);

		UartRxFlag = 1;
    }
}


void SysTickIsrHandler(void)
{
	SysTickCnt ++;
}


int main(void)
{
	uint16_t i = 0;
	
	Cy_SysTick_Init(CY_SYSTICK_CLOCK_SOURCE_CLK_IMO,7999);

	for (i = 0u; i < CY_SYS_SYST_NUM_OF_CALLBACKS; ++i)
    {
        if (Cy_SysTick_GetCallback(i) == NULL)
        {
            
            Cy_SysTick_SetCallback(i, SysTickIsrHandler);
            break;
        }
    }
	
	
	cy_en_scb_uart_status_t init_status;

	/* Start UART operation. */
    init_status = Cy_SCB_UART_Init(UART_HW, &UART_config, &UART_context);
    if(init_status!=CY_SCB_UART_SUCCESS)
    {
    	
    }

	Cy_SCB_UART_Enable(UART_HW); 

	/* Transmit header to the terminal. */
    Cy_SCB_UART_PutString(UART_HW, "\r\n**********************************************************************************\r\n");
    Cy_SCB_UART_PutString(UART_HW, "This is UART example, which uses User ISR to demonstrate UART operation\r\n");
    Cy_SCB_UART_PutString(UART_HW, "If you are able to read this text the terminal connection is configured correctly.\r\n");
    Cy_SCB_UART_PutString(UART_HW, "Start transmitting the characters to see an echo in the terminal.\r\n");
    Cy_SCB_UART_PutString(UART_HW, "\r\n"); 

	 /* Unmasking only the RX fifo not empty interrupt bit */
    UART_HW->INTR_RX_MASK = SCB_INTR_RX_MASK_NOT_EMPTY_Msk;

	/* Interrupt Settings for UART */    
    Cy_SysInt_Init(&UART_SCB_IRQ_cfg, ISR_UART);
	/* Enable the interrupt */
    NVIC_EnableIRQ(UART_SCB_IRQ_cfg.intrSrc);
	
	__enable_irq(); /* Enable global interrupts. */

    /* Place your initialization/startup code here (e.g. MyInst_Start()) */

    for(;;)
    {
        /* Place your application code here. */
		if(UartRxFlag == 1)
		{
			UartRxFlag = 0;
			Cy_SCB_UART_Put(UART_HW,UartRxDat);
		}
		
        if(SysTickCnt >= 500)
        {
        	SysTickCnt = 0;
			Cy_GPIO_Inv(LED_Green_P1_1_PORT,LED_Green_P1_1_NUM);
        }
		
    }
}

/* [] END OF FILE */
