#pragma NOIV               // Do not generate interrupt vectors
//-----------------------------------------------------------------------------
//   File:       video.c
//   Contents:   Hooks required to implement FX2 GPIF to external sync. FIFO
//               interface using CY4265-15AC
//
//   Copyright (c) 2003 Cypress Semiconductor, Inc. All rights reserved
//-----------------------------------------------------------------------------
//PC4 sensor scl PC3 sda PC0 reset sensor....


#include "fx2.h"
#include "fx2regs.h"
#include "fx2sdly.h"            // SYNCDELAY macro, see Section 15.14 of FX2 Tech.
                                // Ref. Manual for usage details.
#include "i2c.h"
#include "Serial.h"

#define SENSOR_ID (0x20 >> 1)
#define SENSOR_ID1 (0x30 >> 1)

#define EXTFIFONOTFULL   GPIFREADYSTAT & bmBIT1
#define EXTFIFONOTEMPTY  GPIFREADYSTAT & bmBIT0

#define GPIFTRIGRD 4

#define GPIF_EP2 0
#define GPIF_EP4 1
#define GPIF_EP6 2
#define GPIF_EP8 3
//////////////////////////////////////////////////////////////////////////////
//USB control code...
//CCD 204 communication
	#define FX2OFFSET        0x00

	#define I2CA16V8_WR      0x01+FX2OFFSET   //
	#define I2CA16V8_RD		 0x02+FX2OFFSET   //
	#define MCLK_SEL         0x03+FX2OFFSET   //
	#define SYSTEMINIT       0x04+FX2OFFSET
	#define IOOUTPUT         0x05+FX2OFFSET
	#define I2CINIT          0x06+FX2OFFSET
	#define UART_S 		     0x07+FX2OFFSET
	#define UART_R		     0x08+FX2OFFSET	
	#define DATAWIDE		 0x09+FX2OFFSET	
	#define UART_BAUDRATE	 0x0a+FX2OFFSET	

	#define I2CA16V16_WR     0x0b+FX2OFFSET   //
	#define I2CA16V16_RD	 0x0c+FX2OFFSET   //

	#define EEPROM_WR        0x10+FX2OFFSET   //
	#define EEPROM_RD        0x11+FX2OFFSET   //


#define CHECKNUM           0xf4


#define SP_1024 4
#define SP_512  2
#define SP_SIZE  SP_1024

//////////////////////////////////////////////////////////////////////////////
extern BOOL GotSUD;             // Received setup data flag
extern BOOL Sleep;
extern BOOL Rwuen;
extern BOOL Selfpwr;
extern BOOL m_bNoStop;
extern BOOL bNewFrame;

//////////////////////////////////////////////////////////////////////////////
BYTE Configuration;                 // Current configuration
BYTE AlternateSetting;              // Alternate settings
BYTE m_WorkState;
BOOL m_bIsMe;
WORD m_FreeData;
BYTE m_CheckNum;
BYTE m_SlaveID;

BOOL m_bNoStop;

BYTE xdata m_I2CData[66];
BYTE xdata m_uartRBuf[128];
BYTE m_ReceiveCount0;  

void SuspendCommand(void);
void GoOnWorkCommand(void);
void StartVideoCommand(void);
void StopVideoCommand(void);

void DelaySync(WORD time)
{
     while(time --)
	    SYNCDELAY;
}

//read i2c from sensor
BOOL bReadSensor(WORD reg, WORD* value)
{
	m_I2CData[0] = reg >> 8;//reg H
	m_I2CData[1] = reg & 0xff;//reg L
	m_bNoStop = TRUE;
	I2C0_Write(SENSOR_ID, 2, m_I2CData);
	m_bNoStop = FALSE;
	reg = I2C0_Read(SENSOR_ID, 2, m_I2CData);
	*value  = (m_I2CData[0] << 8) | m_I2CData[1];
	return (reg == I2C_OK);
}
//write i2c to sensor
BOOL bWriteSensor(WORD reg, WORD value)
{
	m_I2CData[0] = reg >> 8;//reg H
	m_I2CData[1] = reg & 0xff;//reg L
    m_I2CData[2] = value >> 8;//value H
    m_I2CData[3] = value & 0xff;//Value L
	reg = I2C0_Write(SENSOR_ID, 4, m_I2CData);
	return (reg == I2C_OK);
}

BOOL bReadEeprom(WORD reg, WORD* value)
{
	m_I2CData[0] = reg >> 8;//reg High
	m_I2CData[1] = reg  & 0xff;//reg Low
	
	m_bNoStop = TRUE;
	SensorWriteI2C(0x51, 2, m_I2CData);
	m_bNoStop = FALSE;
	
	reg = SensorReadI2C(0x51, 2, m_I2CData);
	*value = (m_I2CData[0] << 8) | m_I2CData[1];
	return (reg == I2C_OK); 
}

BOOL bWriteEeprom(WORD reg, WORD value)
{
	m_I2CData[0] = reg >> 8;//Index H
	m_I2CData[1] = reg & 0xff;//Index L
	m_I2CData[2] = value >> 8;//Value H
	m_I2CData[3] = value & 0xff;//Value L
	
	reg = SensorWriteI2C(0x51, 4, m_I2CData);
	FX2WaitForEEPRomFinishWrite(0x51);

	return (reg == I2C_OK);
}

#define MASK_ID_ADDR   0x0000
#define MASK_ID_VALUE  0x8011 
#define EEPROM_ID_ADDR 0x2350
#define FLAG_WR_ADDR   0x2340
#define FLAG_WR_VALUE  0x1973
#define FLAG_WR_VALUE1 0x1225

BOOL bCheckSensorGuidIsFitToMemory()
{
	WORD xdata tmp, tmp1;
	WORD xdata IDSensor[4];
	WORD xdata IDEeprom[4]; 
	WORD xdata IDMask[4];
	char i;
	//fuzzy code
	for(i = 32; i >=0; i--)
	{
		bReadSensor(0xf9-i, &tmp1);
	}
	
	bWriteSensor(0xf0, 0);
	if(!bReadSensor(0xf9, &tmp))
	{
		return FALSE;
	}

	//fuzzy code...
 	for(i = 32; i > 0; i--)
	{
		bReadEeprom(0x1200 + i, &tmp1);
	}
	//read mask code from eeprom...
	//read guid stored in eeprom...
	for(i = 0 ; i < 4 ; i++)
	{
		bReadEeprom(MASK_ID_ADDR + (i << 1), IDMask + i);
		bReadEeprom(EEPROM_ID_ADDR + (i << 1), IDEeprom + i);
	}
	//fuzzy code
	for(i = 15; i > 0; i--)
	{
		bReadEeprom(0x1200 + i, &tmp1);
	}
	//read sensor guid...
	bReadSensor(0x301A, &tmp);
	bWriteSensor(0x301A, tmp | 0x20);	//enable the guid read

	bReadSensor(0x31fa, IDSensor);
	bReadSensor(0x31f8, IDSensor+1);
	bReadSensor(0x31f6, IDSensor+2);
	bReadSensor(0x31f4, IDSensor+3);

	bWriteSensor(0x301A, tmp & ~0x20); //close the guid read

	//to check IDsensor is equal to IDMask and IDMask+4
	for(i = 0; i < 4; i++)
	{
		if((IDSensor[i] ^ IDMask[i] ^ MASK_ID_VALUE) != IDEeprom[i])
		{
			return FALSE;
		}
	}

	//fuzzy code
	for(i = 20; i > 0; i--)
	{
		bReadEeprom(0x500 + i, &tmp1);
	}

	//read guid stored in eeprom...
	for(i = 0 ; i < 4 ; i++)
	{
		bReadEeprom(MASK_ID_ADDR + 8 + (i << 1), IDMask + i);
		bReadEeprom(EEPROM_ID_ADDR + 8 + (i << 1), IDEeprom + i);
	}
	for(i = 0; i < 4; i++)
	{
		if((IDSensor[i] ^ IDMask[i] ^ MASK_ID_VALUE) != IDEeprom[i])
		{
			return FALSE;
		}
	}

	return TRUE;
}

BOOL bWriteSensorGuidToMemory(BYTE enable)
{
	WORD xdata tmp;
	WORD xdata IDSensor[4];
	WORD xdata IDEeprom[4]; 
	WORD xdata IDMask[8];
	char i;

	if(enable == 0xa5)
	{
		bReadEeprom(FLAG_WR_ADDR, IDMask);
		bReadEeprom(FLAG_WR_ADDR + 2, IDMask+1);
		if((IDMask[0] == FLAG_WR_VALUE) && (IDMask[1] == FLAG_WR_VALUE1))
		{
			return FALSE;
		}
	}
	if(!bReadSensor(0xf9, &tmp))
	{
		return FALSE;
	}

	
	//read sensor guid...
	bReadSensor(0x301A, &tmp);
	bWriteSensor(0x301A, tmp | 0x20);	//enable the guid read

	bReadSensor(0x31fa, IDSensor);
	bReadSensor(0x31f8, IDSensor+1);
	bReadSensor(0x31f6, IDSensor+2);
	bReadSensor(0x31f4, IDSensor+3);

	bWriteSensor(0x301A, tmp & ~0x20); //close the guid read


	//write guid stored in eeprom...
	for(i = 0 ; i < 4 ; i++)
	{
		//read mask code from eeprom...
		bReadEeprom(MASK_ID_ADDR + 8 + (i << 1), IDMask + i);	
		bWriteEeprom(EEPROM_ID_ADDR + 8+ (i << 1), IDSensor[i] ^ IDMask[i] ^ MASK_ID_VALUE);
	}

 	//write guid stored in eeprom...
	for(i = 0 ; i < 4 ; i++)
	{
		//read mask code from eeprom...
		bReadEeprom(MASK_ID_ADDR + (i << 1), IDMask + i);	
		bWriteEeprom(EEPROM_ID_ADDR + (i << 1), IDSensor[i] ^ IDMask[i] ^ MASK_ID_VALUE);
	}
	//read guid stored in eeprom...
	for(i = 0; i < 4; i++)
	{
		bReadEeprom(EEPROM_ID_ADDR + (i << 1), IDEeprom + i);
	}

	bWriteEeprom(FLAG_WR_ADDR, FLAG_WR_VALUE);
	bWriteEeprom(FLAG_WR_ADDR + 2, FLAG_WR_VALUE1);

	m_bIsMe = bCheckSensorGuidIsFitToMemory();
	return m_bIsMe;
}
void EraseSensorGuidInEeprom()
{
	char i;
	bWriteEeprom(FLAG_WR_ADDR, 0xff);
	bWriteEeprom(FLAG_WR_ADDR + 2, 0xff);

	for(i = 0; i < 8; i++)
	{
		bWriteEeprom(EEPROM_ID_ADDR + (i << 1), 0xff);
	}
}

void TD_Init(void)             // Called once at startup
{
	CPUCS = 0x0a;//24Mclk 
    
	SYNCDELAY;
    
	REVCTL = 0x03;   // REVCTL.0 and REVCTL.1 set to 1
	SYNCDELAY;
	FX2InitI2C();
    
    
	PINFLAGSAB = 0x00;//0xcc;
	SYNCDELAY;
	PINFLAGSCD = 0x00;//0xcc;
	SYNCDELAY;
    
    
	PORTACFG =  0x01;//P00 set to int0 mode
	OEA = 0x00; //
	IOA = 0xff; // 
  SYNCDELAY; 
  SYNCDELAY; 

	PORTECFG =  0x00;//all set to GPIO definition
  OEE = 0x00;  //all set to input...
	IOE = 0xff;  //output set to 0 .input set to 1
	SYNCDELAY;
  SYNCDELAY; 
    
	PORTCCFG =  0x00;//all set to GPIO definition
	OEC = ~0x20;  //PC 8 pin all set to output 
	IOC = ~0x01;  //PC0 reset sensor ... now set to 0:reset state... //20130729 added 
	SYNCDELAY;
  SYNCDELAY; 

//	EP1INCFG = 0xb0;
//	SYNCDELAY;


	FIFOPINPOLAR = 0x3c; //0x3c for ov or hynix
	SYNCDELAY;

	WAKEUPCS = 0x04;     //!!! should like this.others can't work when power on..
	SYNCDELAY;
    
	SerialPort_Init(BD_115200);
    
    //in order to provide synchronization for the internal
//endpoint FIFO logic, the external IFCLK source must be present before the firmware sets IFCONFIG.7 = 0.
    IFCONFIG = 0x03;//orignal is 0x03 
    SYNCDELAY;
    SYNCDELAY; 
    SYNCDELAY; 
    SYNCDELAY; 
    
    EP2CFG = 0xe8;
	SYNCDELAY;  
    SYNCDELAY; 
	FIFORESET = 0x80;
	SYNCDELAY;
    SYNCDELAY; 
	FIFORESET = 0x82;
    SYNCDELAY; 
    SYNCDELAY; 
    FIFORESET = 0x00;
	SYNCDELAY;   
    SYNCDELAY; 
    
    EP2FIFOCFG = 0x0c; //8bit autoin,ability to send zero length packets
	SYNCDELAY;
    SYNCDELAY; 
    
    EP2AUTOINLENH = 0x04;//1024
    SYNCDELAY;                 

    EP2AUTOINLENL = 0x01;
    SYNCDELAY;
 
    
//    INPKTEND = 0x82;                   //arming the IN transfer
//    SYNCDELAY;                         
//    INPKTEND = 0x82;                 
// /   SYNCDELAY;
//    INPKTEND = 0x82;                   //arming the IN transfer
//    SYNCDELAY;                         
//    INPKTEND = 0x82;                 
//    SYNCDELAY;
    
    // enable dual autopointer(s)
//    AUTOPTRSETUP |= 0x01;

 
//	_alpum_init();

	EX0 = 0;//disable interrupt..
	IT0 = 1;//edge effective interrupt.
	IE0 = 0;

	m_WorkState = 0;
	m_bIsMe = 0;
	m_CheckNum = 0;
	m_bNoStop = 0;

	m_SlaveID = SENSOR_ID;
	m_I2CData[0] = 0;
	m_I2CData[1] = 0;

	EZUSB_Delay(20);	  //20130729 added 
	P20 = 1;		      //20130729 added 
/*
	if(I2C_OK != I2C0_Write(m_SlaveID, 1, m_I2CData))
	{
		m_SlaveID = SENSOR_ID1;	
	}
*/
	Rwuen = TRUE;        // Enable remote wakeup
    
    dbg_str("EP2CFG=");
    dbg_int((i32)EP2CFG);

    dbg_str(",REVCTL=");
    dbg_int((i32)REVCTL);
    
    dbg_str(",EP2AUTOINLENH=");
    dbg_int((i32)EP2AUTOINLENH);
    
   	dbg_str("EP2AUTOINLENL=");
    dbg_int((i32)EP2AUTOINLENL);
}

BOOL TD_Suspend(void)          // Called before the device goes into suspend mode
{
   return(TRUE);
}

BOOL TD_Resume(void)          // Called after the device resumes
{
   return(TRUE);
}

//-----------------------------------------------------------------------------
// Device Request hooks
//   The following hooks are called by the end point 0 device request parser.
//-----------------------------------------------------------------------------

BOOL DR_GetDescriptor(void)
{
   return(TRUE);
}

BOOL DR_SetConfiguration(void)   // Called when a Set Configuration command is received
{
#if 1
  if( EZUSB_HIGHSPEED( ) )
  { // FX2 enumerated at high speed
    SYNCDELAY;                  // 
    EP2AUTOINLENH = 4;
    SYNCDELAY;                  // 
    EP2AUTOINLENL = 0x00;
    SYNCDELAY;   
    dbg_str("EP2AUTOINLENH=");
    dbg_int(EP2AUTOINLENH);
    dbg_str(",EP2AUTOINLENL=");
    dbg_int(EP2AUTOINLENL);
    
    //enum_high_speed = TRUE;
  }
  else
  { // FX2 enumerated at full speed
    SYNCDELAY;                   
    EP2AUTOINLENH = 0x00;       // set AUTOIN commit length to 64 bytes
    SYNCDELAY;                   
    EP2AUTOINLENL = 0x40;
    SYNCDELAY;                  
    //enum_high_speed = FALSE;
  }
#endif  
  Configuration = SETUPDAT[2];
  return(TRUE);            // Handled by user code
}

BOOL DR_GetConfiguration(void)   // Called when a Get Configuration command is received
{
   EP0BUF[0] = Configuration;
   EP0BCH = 0;
   EP0BCL = 1;
   return(TRUE);            // Handled by user code
}

BOOL DR_SetInterface(void)       // Called when a Set Interface command is received
{
   AlternateSetting = SETUPDAT[2];

   return(TRUE);            // Handled by user code
}

BOOL DR_GetInterface(void)       // Called when a Set Interface command is received
{
   EP0BUF[0] = AlternateSetting;
   EP0BCH = 0;
   EP0BCL = 1;
   return(TRUE);            // Handled by user code
}

BOOL DR_GetStatus(void)
{
   return(TRUE);
}

BOOL DR_ClearFeature(void)
{
   return(TRUE); 
}

BOOL DR_SetFeature(void)
{
   return(TRUE);
}

void TD_Poll()
{
  	m_FreeData++;  
    
}
void GoOnWorkCommand()
{
	CPUCS |= 0x02;
	DelaySync(10);
	if(!m_bIsMe)
	{
    	m_bIsMe = bCheckSensorGuidIsFitToMemory();
	}
	SYNCDELAY;
}

void SuspendCommand()
{
	CPUCS &= ~0x02;  //close mclk
	SYNCDELAY;
}
void StartVideoCommand()
{
	EX0 = 0;
	IE0 = 0;
	EX0 = m_bIsMe;
	IT0 = 1;
	IE0 = 0;
	SYNCDELAY;
	//EP2CFG |= 0x80; //20131019//0xe0;//0xe0;//0xe0 512 to 1024
	//SYNCDELAY;

}
void StopVideoCommand()
{
	 IE0 = 0;
	 bNewFrame = 0;
	 SYNCDELAY;
	 //EP2CFG &= 0x7f;
	 //SYNCDELAY;

}
/*
Byte    Field           Meaning
0       bmRequestType   Request Type, Direction, and Recipient.
1       bRequest        The actual request (see Table 2-2).
2       wValueL         16-bit value, varies according to bRequest.
3       wValueH
4       wIndexL         16-bit field, varies according to bRequest.
5       wIndexH
6       wLengthL        Number of bytes to transfer if there is a data phase.
7       wLengthH        
*/
void IOControl()
{
  	 if(SETUPDAT[5] == 1)
	 {
	 	OEE = SETUPDAT[2];
	 }
	 else if(SETUPDAT[5] == 2)
	 {
	 	IOE = SETUPDAT[2];
	 }
/*	 
	 else if(SETUPDAT[5] == 3)
	 {
	 	P23 = SETUPDAT[2] ? 1 : 0;
	 }
	 else if(SETUPDAT[5] == 4)
	 {
	 	P24 = SETUPDAT[2] ? 1 : 0;
	 }
*/
	 else if(SETUPDAT[5] == 5)
	 {
		EP0BUF[0] = P25 ? 1: 0; 
		EP0BCH = 0;
		EP0BCL = 1;		
	 }
	 else if(SETUPDAT[5] == 6)
	 {
		EP0BUF[0] = IOE; 
		EP0BCH = 0;
		EP0BCL = 1;	 	 	
	 }
}
void SystemInit()
{
   if(SETUPDAT[4] == 0x0f)
   {
      	if((SETUPDAT[2]&0x01) == 0x01)//work command
      	{
		   if( (m_WorkState&0x01) != 0x01) //now is sleeping state.
      	   {
      	   	 GoOnWorkCommand();   //set to work state.
      	   }
      	 }
		else if( (m_WorkState&0x01) != 0x00) //sleep command and now is working
  	   {
  	   	 SuspendCommand();   //set to suspend mode.
  	   }

      	if((SETUPDAT[2]&0x02) == 0x02)
      	 {
      	   if(( m_WorkState & 0x02) != 0x02)
      	   {
      	   	 StartVideoCommand();
      	   }
      	 }
		 else if(( m_WorkState &0x02) == 0x02)
      	 {
      	   	 StopVideoCommand(); 
      	 }
		 m_WorkState = SETUPDAT[2];
   }
}

BOOL DR_VendorCmnd(void)
{
  WORD i = 0;

  switch (SETUPDAT[1])
  {
	case SYSTEMINIT:
	{
	  SystemInit();
	  break;
	}
	
  case IOOUTPUT:
  	IOControl(); 
    break; 
	
  case I2CINIT:
  	FX2InitI2C();
    break;
    

	 case EEPROM_WR:
	 {
		m_I2CData[0] = SETUPDAT[5];//Index H
		m_I2CData[1] = SETUPDAT[4];//Index L
		m_I2CData[2] = SETUPDAT[3];//Value H
		m_I2CData[3] = SETUPDAT[2];//Value L
		
		if((m_I2CData[0] == 0xff) && (m_I2CData[1] == 0xff))
		{
			m_I2CData[2] ^= 0x18;
			m_I2CData[3] ^= 0x81;
		    if( (m_I2CData[2] == (0xf1 ^ 0x18)) && (m_I2CData[3] == (0xfa ^ 0x81)))
				EP0BUF[0] = (TRUE == bWriteSensorGuidToMemory(0xa5)) ? I2C_OK : I2C_BERROR ;
			else if((m_I2CData[2] == (0x1f ^ 0x18)) && (m_I2CData[3] == (0xaf ^ 0x81)))
				EP0BUF[0] = (TRUE == bWriteSensorGuidToMemory(0x5a)) ? I2C_OK : I2C_BERROR ;
			else if((m_I2CData[2] == (0x1f ^ 0x18)) && (m_I2CData[3] == (0x1f ^ 0x81)))
			{
				EraseSensorGuidInEeprom();
				EP0BUF[0] = I2C_BERROR;
			}
		}
		else
		{
			EP0BUF[0]= SensorWriteI2C(0x51, 4, m_I2CData);
			FX2WaitForEEPRomFinishWrite(0x51);
		}


	    EP0BCH = 0;
		EP0BCL = 1;
		break;

		break;
	}
 	case EEPROM_RD:   //read from eeprom
	{
	    m_I2CData[0] = SETUPDAT[5];//reg High
	    m_I2CData[1] = SETUPDAT[4];//reg Low
	    m_I2CData[2] = SETUPDAT[3];//Value H
	    m_I2CData[3] = SETUPDAT[2];//Value L

	    m_bNoStop = TRUE;
	    SensorWriteI2C(0x51,2,m_I2CData);
	    m_bNoStop = FALSE;

	    m_I2CData[0] = 0;
	    m_I2CData[1] = 0;
	    EP0BUF[2] = SensorReadI2C(0x51, 2, m_I2CData);
	    EP0BUF[0] = m_I2CData[0]; //High bit
	    EP0BUF[1] = m_I2CData[1]; //
	    EP0BCH = 0;
	    EP0BCL = 3;
        break;
    }
	case DATAWIDE:
		EP2FIFOCFG = SETUPDAT[2] ? 0x0d : 0x0c; //16/8bit autoin
		break;
	case I2CA16V8_WR:
		m_I2CData[0] = SETUPDAT[5] ^ 0x19 ^ (~m_bIsMe);//Index H
		m_I2CData[1] = SETUPDAT[4] ^ 0x73;//Index L
		m_I2CData[2] = SETUPDAT[2] ^ 0x13;//Value
		
		EP0BUF[0]= I2C0_Write(m_SlaveID, 3, m_I2CData);
		EP0BCH = 0;
		EP0BCL = 3; // Clear bytecount to allow new data in; also stops NAKing

		break;
	case I2CA16V8_RD:
	    m_I2CData[0] = SETUPDAT[5] ^ 0x19;//reg High
	    m_I2CData[1] = SETUPDAT[4] ^ 0x73;//reg Low

	    m_bNoStop = TRUE;
	    I2C0_Write(m_SlaveID,2,m_I2CData);
	    m_bNoStop = FALSE;
	    EP0BUF[0] = I2C0_Read(m_SlaveID, 1, m_I2CData);
	    EP0BUF[1] = m_I2CData[0] ^ 0x13; //High bit
		EP0BCH = 0;
		EP0BCL = 3; // Clear bytecount to allow new data in; also stops NAKing
		break;

 	case I2CA16V16_WR:
		m_I2CData[0] = SETUPDAT[5] ^ 0x19;//Index H
		m_I2CData[1] = SETUPDAT[4] ^ 0x73;//Index L
		m_I2CData[2] = SETUPDAT[3] ^ 0x20;//Value
		m_I2CData[3] = SETUPDAT[2] ^ 0x13;//Value
		
		EP0BUF[0]= I2C0_Write(m_SlaveID, 4, m_I2CData);
		EP0BCH = 0;
		EP0BCL = 3; // Clear bytecount to allow new data in; also stops NAKing

		break;
	case I2CA16V16_RD:
	    m_I2CData[0] = SETUPDAT[5] ^ 0x19;//reg High
	    m_I2CData[1] = SETUPDAT[4] ^ 0x73;//reg Low

	    m_bNoStop = TRUE;
	    I2C0_Write(m_SlaveID,2,m_I2CData);
	    m_bNoStop = FALSE;
	    EP0BUF[0] = I2C0_Read(m_SlaveID, 2, m_I2CData);
		EP0BUF[1] = m_I2CData[0] ^ 0x20; //High bit
	    EP0BUF[2] = m_I2CData[1] ^ 0x13; //Low bit
		EP0BCH = 0;
		EP0BCL = 3; // Clear bytecount to allow new data in; also stops NAKing
		break;
#if 0        
	case UART_S:
		EP0BCH = 0;
		EP0BCL = 0; // Clear bytecount to allow new data in; also stops NAKing
		while(EP0CS & bmEPBUSY);
		Serial_SendString(EP0BUF, EP0BCL, 0);
		break;
	case UART_R:
		ES0 = 0;
		EP0BUF[0] = m_ReceiveCount0;
		if(m_ReceiveCount0)
		{
			for(i = 0; i < m_ReceiveCount0; i++)
			{
				EP0BUF[i+1] = m_uartRBuf[i];	
			}
			m_ReceiveCount0 = 0;
		}
		ES0 = 1;
		EP0BCH = 0;
		EP0BCL = 64; // Clear bytecount to allow new data in; also stops NAKing
		break;
#endif

    case MCLK_SEL:
		CPUCS = (CPUCS&0xe7) | (SETUPDAT[2]); // 
		SYNCDELAY;
	  break;
      
//	case UART_BAUDRATE:
//		SerialPort_Init(SETUPDAT[2] > BD_230400 ? BD_230400 : SETUPDAT[2]);
		break;
	default:
	  break; 
  }
  return(FALSE);
}


//-----------------------------------------------------------------------------
// USB Interrupt Handlers
//   The following functions are called by the USB interrupt jump table.
//-----------------------------------------------------------------------------

// Setup Data Available Interrupt Handler
void ISR_Sudav(void) interrupt 0
{
   GotSUD = TRUE;            // Set flag
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSUDAV;         // Clear SUDAV IRQ
}

// Setup Token Interrupt Handler
void ISR_Sutok(void) interrupt 0
{
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSUTOK;         // Clear SUTOK IRQ
}

void ISR_Sof(void) interrupt 0
{
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSOF;            // Clear SOF IRQ
}

void ISR_Ures(void) interrupt 0
{
   // whenever we get a USB reset, we should revert to full speed mode
   pConfigDscr = pFullSpeedConfigDscr;
   ((CONFIGDSCR xdata *) pConfigDscr)->type = CONFIG_DSCR;
   pOtherConfigDscr = pHighSpeedConfigDscr;
   ((CONFIGDSCR xdata *) pOtherConfigDscr)->type = OTHERSPEED_DSCR;

   EZUSB_IRQ_CLEAR();
   USBIRQ = bmURES;         // Clear URES IRQ
}

void ISR_Susp(void) interrupt 0
{
   Sleep = TRUE;
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSUSP;
}

void ISR_Highspeed(void) interrupt 0
{
   if (EZUSB_HIGHSPEED())
   {
      pConfigDscr = pHighSpeedConfigDscr;
      ((CONFIGDSCR xdata *) pConfigDscr)->type = CONFIG_DSCR;
      pOtherConfigDscr = pFullSpeedConfigDscr;
      ((CONFIGDSCR xdata *) pOtherConfigDscr)->type = OTHERSPEED_DSCR;
   }

   EZUSB_IRQ_CLEAR();
   USBIRQ = bmHSGRANT;
}
void ISR_Ep0ack(void) interrupt 0
{
}
void ISR_Stub(void) interrupt 0
{
}
void ISR_Ep0in(void) interrupt 0
{
}
void ISR_Ep0out(void) interrupt 0
{
}
void ISR_Ep1in(void) interrupt 0
{
}
void ISR_Ep1out(void) interrupt 0
{
}
void ISR_Ep2inout(void) interrupt 0
{
}
void ISR_Ep4inout(void) interrupt 0
{
}
void ISR_Ep6inout(void) interrupt 0
{
	EZUSB_IRQ_CLEAR();
	EPIRQ = 0x40; 
}
void ISR_Ep8inout(void) interrupt 0
{
}
void ISR_Ibn(void) interrupt 0
{
}
void ISR_Ep0pingnak(void) interrupt 0
{
}
void ISR_Ep1pingnak(void) interrupt 0
{
}
void ISR_Ep2pingnak(void) interrupt 0
{
}
void ISR_Ep4pingnak(void) interrupt 0
{
}
void ISR_Ep6pingnak(void) interrupt 0
{
}
void ISR_Ep8pingnak(void) interrupt 0
{
}
void ISR_Errorlimit(void) interrupt 0
{
}
void ISR_Ep2piderror(void) interrupt 0
{
}
void ISR_Ep4piderror(void) interrupt 0
{
}
void ISR_Ep6piderror(void) interrupt 0
{
}
void ISR_Ep8piderror(void) interrupt 0
{
}
void ISR_Ep2pflag(void) interrupt 0
{
}
void ISR_Ep4pflag(void) interrupt 0
{
}
void ISR_Ep6pflag(void) interrupt 0
{
}
void ISR_Ep8pflag(void) interrupt 0
{
}
void ISR_Ep2eflag(void) interrupt 0
{
}
void ISR_Ep4eflag(void) interrupt 0
{
}
void ISR_Ep6eflag(void) interrupt 0
{
}
void ISR_Ep8eflag(void) interrupt 0
{
}
void ISR_Ep2fflag(void) interrupt 0
{
}
void ISR_Ep4fflag(void) interrupt 0
{
}
void ISR_Ep6fflag(void) interrupt 0
{
}
void ISR_Ep8fflag(void) interrupt 0
{
}
void ISR_GpifComplete(void) interrupt 0
{
}
void ISR_GpifWaveform(void) interrupt 0
{
}


