/*******************************************************************************
* File Name: Loopback.h
* Version 0.2
*
*  Description:
*    Header File for the USFS component. Contains prototypes and constant values. 
*
********************************************************************************
* Copyright (2008), Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction wit,a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*******************************************************************************/
#if !defined(Loopback_H)
#define Loopback_H

#include "cytypes.h"
/************************************************
 *  General defines 
 ************************************************/
#if defined(__C51__) || defined(__CX51__)
#ifndef Loopback_CODE
#define Loopback_CODE code
#define Loopback_DATA data
#define Loopback_XDATA xdata
#define Loopback_FAR far
#define Loopback_NULL  ((void *) 0)
#endif
#else
#ifndef Loopback_CODE
#define Loopback_CODE
#define Loopback_DATA
#define Loopback_XDATA
#define Loopback_FAR
#define Loopback_NULL  ((void *) 0)
#endif
#endif

/************************************************
 *  Customizer Defines 
 ************************************************/
#define Loopback_NUM_DEVICES   1
#define Loopback_ENABLE_STRINGS
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_BUF_SIZE   8
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_NUM_IN_RPTS   1
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_BUF_SIZE   8
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_NUM_OUT_RPTS   1
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_COUNT   1
#define Loopback_ENABLE_HID_CLASS
#define Loopback_HID_RPT_1_SIZE_LSB   0x28u
#define Loopback_HID_RPT_1_SIZE_MSB   0x00u

#define Loopback_MON_VBUS       0
#if (Loopback_MON_VBUS == 1)
#define Loopback_VBUS_DR        ((reg8 *) Loopback_VBUS__DR)
#define Loopback_VBUS_PS        ((reg8 *) Loopback_VBUS__PS)
#define Loopback_VBUS_MASK      Loopback_VBUS__MASK
#endif

/************************************************
 *  Constants for Loopback API. 
 ************************************************/
#define Loopback_TRUE                       1
#define Loopback_FALSE                      0

#define Loopback_NO_EVENT_ALLOWED           2
#define Loopback_EVENT_PENDING              1
#define Loopback_NO_EVENT_PENDING           0

#define Loopback_IN_BUFFER_FULL             Loopback_NO_EVENT_PENDING
#define Loopback_IN_BUFFER_EMPTY            Loopback_EVENT_PENDING
#define Loopback_OUT_BUFFER_FULL            Loopback_EVENT_PENDING
#define Loopback_OUT_BUFFER_EMPTY           Loopback_NO_EVENT_PENDING

#define Loopback_FORCE_J                    0xA0
#define Loopback_FORCE_K                    0x80
#define Loopback_FORCE_SE0                  0xC0
#define Loopback_FORCE_NONE                 0x00

#define Loopback_IDLE_TIMER_RUNNING         0x02
#define Loopback_IDLE_TIMER_EXPIRED         0x01
#define Loopback_IDLE_TIMER_INDEFINITE      0x00

#define Loopback_DEVICE_STATUS_BUS_POWERED  0x00
#define Loopback_DEVICE_STATUS_SELF_POWERED 0x01

#define Loopback_3V_OPERATION               0x02
#define Loopback_5V_OPERATION               0x03

#define Loopback_MODE_DISABLE               0x00
#define	Loopback_MODE_NAK_IN_OUT            0x01
#define	Loopback_MODE_STATUS_OUT_ONLY       0x02
#define	Loopback_MODE_STALL_IN_OUT          0x03
#define	Loopback_MODE_RESERVED_0100         0x04
#define	Loopback_MODE_ISO_OUT               0x05
#define	Loopback_MODE_STATUS_IN_ONLY        0x06
#define	Loopback_MODE_ISO_IN                0x07
#define	Loopback_MODE_NAK_OUT               0x08
#define	Loopback_MODE_ACK_OUT               0x09
#define	Loopback_MODE_RESERVED_1010         0x0A
#define	Loopback_MODE_ACK_OUT_STATUS_IN     0x0B
#define	Loopback_MODE_NAK_IN                0x0C
#define	Loopback_MODE_ACK_IN                0x0D
#define	Loopback_MODE_RESERVED_1110         0x0E
#define	Loopback_MODE_ACK_IN_STATUS_OUT     0x0F
#define	Loopback_MODE_STALL_DATA_EP         0x80

#define Loopback_MODE_ACKD                  0x10
#define Loopback_MODE_OUT_RCVD              0x20
#define Loopback_MODE_IN_RCVD               0x40
#define Loopback_MODE_SETUP_RCVD            0x80

#define Loopback_RQST_TYPE_MASK             0x60
#define Loopback_RQST_TYPE_STD              0x00
#define Loopback_RQST_TYPE_CLS              0x20
#define Loopback_RQST_TYPE_VND              0x40
#define Loopback_RQST_DIR_MASK              0x80
#define Loopback_RQST_DIR_D2H               0x80
#define Loopback_RQST_DIR_H2D               0x00
#define Loopback_RQST_RCPT_MASK             0x03
#define Loopback_RQST_RCPT_DEV              0x00
#define Loopback_RQST_RCPT_IFC              0x01
#define Loopback_RQST_RCPT_EP               0x02
#define Loopback_RQST_RCPT_OTHER            0x03

/************************************************
 *  Standard Request Types (Table 9-4) 
 ************************************************/
#define Loopback_GET_STATUS           0x00
#define Loopback_CLEAR_FEATURE        0x01
#define Loopback_SET_FEATURE          0x03
#define Loopback_SET_ADDRESS          0x05
#define Loopback_GET_DESCRIPTOR       0x06
#define Loopback_SET_DESCRIPTOR       0x07
#define Loopback_GET_CONFIGURATION    0x08
#define Loopback_SET_CONFIGURATION    0x09
#define Loopback_GET_INTERFACE        0x0A
#define Loopback_SET_INTERFACE        0x0B
#define Loopback_SYNCH_FRAME          0x0C

/************************************************
 *  Descriptor Types (Table 9-5) 
 ************************************************/

#define Loopback_DESCR_DEVICE           1
#define Loopback_DESCR_CONFIG           2
#define Loopback_DESCR_STRING           3
#define Loopback_DESCR_INTERFACE        4
#define Loopback_DESCR_ENDPOINT         5
#define Loopback_DESCR_DEVICE_QUALIFIER 6
#define Loopback_DESCR_OTHER_SPEED      7
#define Loopback_DESCR_INTERFACE_POWER  8

/************************************************
 *  Feature Selectors (Table 9-6)
 ************************************************/
#define Loopback_DEVICE_REMOTE_WAKEUP    0x01
#define Loopback_ENDPOINT_HALT           0x00
#define Loopback_TEST_MODE               0x02

/************************************************
 *  USB Device Status (Figure 9-4)
 ************************************************/
#define Loopback_DEVICE_STATUS_BUS_POWERED   0x00
#define Loopback_DEVICE_STATUS_SELF_POWERED  0x01
#define Loopback_DEVICE_STATUS_REMOTE_WAKEUP 0x02

/************************************************
 *  USB Endpoint Status (Figure 9-4)
 ************************************************/
#define Loopback_ENDPOINT_STATUS_HALT        0x01

/************************************************
 *  USB Endpoint Directions 
 ************************************************/
#define Loopback_DIR_IN                          0x80
#define Loopback_DIR_OUT                         0x00
#define Loopback_DIR_UNUSED                      0x7F
/************************************************
 *  USB Endpoint Attributes 
 ************************************************/
#define Loopback_EP_TYPE_CTRL                    0x00
#define Loopback_EP_TYPE_ISOC                    0x01
#define Loopback_EP_TYPE_BULK                    0x02
#define Loopback_EP_TYPE_INT                     0x03
#define Loopback_EP_TYPE_MASK                    0x03

#define Loopback_EP_SYNC_TYPE_NO_SYNC            0x00
#define Loopback_EP_SYNC_TYPE_ASYNC              0x04
#define Loopback_EP_SYNC_TYPE_ADAPTIVE           0x08
#define Loopback_EP_SYNC_TYPE_SYNCHRONOUS        0x0C
#define Loopback_EP_SYNC_TYPE_MASK               0x0C

#define Loopback_EP_USAGE_TYPE_DATA              0x00
#define Loopback_EP_USAGE_TYPE_FEEDBACK          0x10
#define Loopback_EP_USAGE_TYPE_IMPLICIT          0x20
#define Loopback_EP_USAGE_TYPE_RESERVED          0x30
#define Loopback_EP_USAGE_TYPE_MASK              0x30

/************************************************
 *  Transfer Completion Notification 
 ************************************************/
#define Loopback_XFER_IDLE                       0x00
#define Loopback_XFER_STATUS_ACK                 0x01
#define Loopback_XFER_PREMATURE                  0x02
#define Loopback_XFER_ERROR                      0x03

/*******************************************************************************
* Driver State defines
********************************************************************************/
#define Loopback_TRANS_STATE_IDLE             0x00
#define Loopback_TRANS_STATE_CONTROL_READ     0x02
#define Loopback_TRANS_STATE_CONTROL_WRITE    0x04
#define Loopback_TRANS_STATE_NO_DATA_CONTROL  0x06

/************************************************
 *  USB, ARB, SIE register definitions 
 ************************************************/
#define Loopback_ARB_CFG        ((reg8 *) Loopback_USB__ARB_CFG)

#define Loopback_ARB_EP1_CFG    ((reg8 *) Loopback_USB__ARB_EP1_CFG)
#define Loopback_ARB_EP1_INT_EN ((reg8 *) Loopback_USB__ARB_EP1_INT_EN)
#define Loopback_ARB_EP1_SR     ((reg8 *) Loopback_USB__ARB_EP1_SR)

#define Loopback_ARB_EP2_CFG    ((reg8 *) Loopback_USB__ARB_EP2_CFG)
#define Loopback_ARB_EP2_INT_EN ((reg8 *) Loopback_USB__ARB_EP2_INT_EN)
#define Loopback_ARB_EP2_SR     ((reg8 *) Loopback_USB__ARB_EP2_SR)

#define Loopback_ARB_EP3_CFG    ((reg8 *) Loopback_USB__ARB_EP3_CFG)
#define Loopback_ARB_EP3_INT_EN ((reg8 *) Loopback_USB__ARB_EP3_INT_EN)
#define Loopback_ARB_EP3_SR     ((reg8 *) Loopback_USB__ARB_EP3_SR)

#define Loopback_ARB_EP4_CFG    ((reg8 *) Loopback_USB__ARB_EP4_CFG)
#define Loopback_ARB_EP4_INT_EN ((reg8 *) Loopback_USB__ARB_EP4_INT_EN)
#define Loopback_ARB_EP4_SR     ((reg8 *) Loopback_USB__ARB_EP4_SR)

#define Loopback_ARB_EP5_CFG    ((reg8 *) Loopback_USB__ARB_EP5_CFG)
#define Loopback_ARB_EP5_INT_EN ((reg8 *) Loopback_USB__ARB_EP5_INT_EN)
#define Loopback_ARB_EP5_SR     ((reg8 *) Loopback_USB__ARB_EP5_SR)

#define Loopback_ARB_EP6_CFG    ((reg8 *) Loopback_USB__ARB_EP6_CFG)
#define Loopback_ARB_EP6_INT_EN ((reg8 *) Loopback_USB__ARB_EP6_INT_EN)
#define Loopback_ARB_EP6_SR     ((reg8 *) Loopback_USB__ARB_EP6_SR)

#define Loopback_ARB_EP7_CFG    ((reg8 *) Loopback_USB__ARB_EP7_CFG)
#define Loopback_ARB_EP7_INT_EN ((reg8 *) Loopback_USB__ARB_EP7_INT_EN)
#define Loopback_ARB_EP7_SR     ((reg8 *) Loopback_USB__ARB_EP7_SR)

#define Loopback_ARB_EP8_CFG    ((reg8 *) Loopback_USB__ARB_EP8_CFG)
#define Loopback_ARB_EP8_INT_EN ((reg8 *) Loopback_USB__ARB_EP8_INT_EN)
#define Loopback_ARB_EP8_SR     ((reg8 *) Loopback_USB__ARB_EP8_SR)

#define Loopback_ARB_INT_EN     ((reg8 *) Loopback_USB__ARB_INT_EN)
#define Loopback_ARB_INT_SR     ((reg8 *) Loopback_USB__ARB_INT_SR)

#define Loopback_ARB_RW1_DR     ((reg8 *) Loopback_USB__ARB_RW1_DR)
#define Loopback_ARB_RW1_RA     ((reg8 *) Loopback_USB__ARB_RW1_RA)
#define Loopback_ARB_RW1_RA_MSB ((reg8 *) Loopback_USB__ARB_RW1_RA_MSB)
#define Loopback_ARB_RW1_WA     ((reg8 *) Loopback_USB__ARB_RW1_WA)
#define Loopback_ARB_RW1_WA_MSB ((reg8 *) Loopback_USB__ARB_RW1_WA_MSB)

#define Loopback_ARB_RW2_DR     ((reg8 *) Loopback_USB__ARB_RW2_DR)
#define Loopback_ARB_RW2_RA     ((reg8 *) Loopback_USB__ARB_RW2_RA)
#define Loopback_ARB_RW2_RA_MSB ((reg8 *) Loopback_USB__ARB_RW2_RA_MSB)
#define Loopback_ARB_RW2_WA     ((reg8 *) Loopback_USB__ARB_RW2_WA)
#define Loopback_ARB_RW2_WA_MSB ((reg8 *) Loopback_USB__ARB_RW2_WA_MSB)

#define Loopback_ARB_RW3_DR     ((reg8 *) Loopback_USB__ARB_RW3_DR)
#define Loopback_ARB_RW3_RA     ((reg8 *) Loopback_USB__ARB_RW3_RA)
#define Loopback_ARB_RW3_RA_MSB ((reg8 *) Loopback_USB__ARB_RW3_RA_MSB)
#define Loopback_ARB_RW3_WA     ((reg8 *) Loopback_USB__ARB_RW3_WA)
#define Loopback_ARB_RW3_WA_MSB ((reg8 *) Loopback_USB__ARB_RW3_WA_MSB)

#define Loopback_ARB_RW4_DR     ((reg8 *) Loopback_USB__ARB_RW4_DR)
#define Loopback_ARB_RW4_RA     ((reg8 *) Loopback_USB__ARB_RW4_RA)
#define Loopback_ARB_RW4_RA_MSB ((reg8 *) Loopback_USB__ARB_RW4_RA_MSB)
#define Loopback_ARB_RW4_WA     ((reg8 *) Loopback_USB__ARB_RW4_WA)
#define Loopback_ARB_RW4_WA_MSB ((reg8 *) Loopback_USB__ARB_RW4_WA_MSB)

#define Loopback_ARB_RW5_DR     ((reg8 *) Loopback_USB__ARB_RW5_DR)
#define Loopback_ARB_RW5_RA     ((reg8 *) Loopback_USB__ARB_RW5_RA)
#define Loopback_ARB_RW5_RA_MSB ((reg8 *) Loopback_USB__ARB_RW5_RA_MSB)
#define Loopback_ARB_RW5_WA     ((reg8 *) Loopback_USB__ARB_RW5_WA)
#define Loopback_ARB_RW5_WA_MSB ((reg8 *) Loopback_USB__ARB_RW5_WA_MSB)

#define Loopback_ARB_RW6_DR     ((reg8 *) Loopback_USB__ARB_RW6_DR)
#define Loopback_ARB_RW6_RA     ((reg8 *) Loopback_USB__ARB_RW6_RA)
#define Loopback_ARB_RW6_RA_MSB ((reg8 *) Loopback_USB__ARB_RW6_RA_MSB)
#define Loopback_ARB_RW6_WA     ((reg8 *) Loopback_USB__ARB_RW6_WA)
#define Loopback_ARB_RW6_WA_MSB ((reg8 *) Loopback_USB__ARB_RW6_WA_MSB)

#define Loopback_ARB_RW7_DR     ((reg8 *) Loopback_USB__ARB_RW7_DR)
#define Loopback_ARB_RW7_RA     ((reg8 *) Loopback_USB__ARB_RW7_RA)
#define Loopback_ARB_RW7_RA_MSB ((reg8 *) Loopback_USB__ARB_RW7_RA_MSB)
#define Loopback_ARB_RW7_WA     ((reg8 *) Loopback_USB__ARB_RW7_WA)
#define Loopback_ARB_RW7_WA_MSB ((reg8 *) Loopback_USB__ARB_RW7_WA_MSB)

#define Loopback_ARB_RW8_DR     ((reg8 *) Loopback_USB__ARB_RW8_DR)
#define Loopback_ARB_RW8_RA     ((reg8 *) Loopback_USB__ARB_RW8_RA)
#define Loopback_ARB_RW8_RA_MSB ((reg8 *) Loopback_USB__ARB_RW8_RA_MSB)
#define Loopback_ARB_RW8_WA     ((reg8 *) Loopback_USB__ARB_RW8_WA)
#define Loopback_ARB_RW8_WA_MSB ((reg8 *) Loopback_USB__ARB_RW8_WA_MSB)

#define Loopback_BUF_SIZE       ((reg8 *) Loopback_USB__BUF_SIZE)
#define Loopback_BUS_RST_CNT    ((reg8 *) Loopback_USB__BUS_RST_CNT)
#define Loopback_CR0            ((reg8 *) Loopback_USB__CR0)
#define Loopback_CR1            ((reg8 *) Loopback_USB__CR1)
#define Loopback_CWA            ((reg8 *) Loopback_USB__CWA)
#define Loopback_CWA_MSB        ((reg8 *) Loopback_USB__CWA_MSB)

#define Loopback_DMA_THRES      ((reg8 *) Loopback_USB__DMA_THRES)
#define Loopback_DMA_THRES_MSB  ((reg8 *) Loopback_USB__DMA_THRES_MSB)

#define Loopback_EP_ACTIVE      ((reg8 *) Loopback_USB__EP_ACTIVE)
#define Loopback_EP_TYPE        ((reg8 *) Loopback_USB__EP_TYPE)

#define Loopback_EP0_CNT        ((reg8 *) Loopback_USB__EP0_CNT)
#define Loopback_EP0_CR         ((reg8 *) Loopback_USB__EP0_CR)
#define Loopback_EP0_DR0        ((reg8 *) Loopback_USB__EP0_DR0)
#define Loopback_EP0_DR1        ((reg8 *) Loopback_USB__EP0_DR1)
#define Loopback_EP0_DR2        ((reg8 *) Loopback_USB__EP0_DR2)
#define Loopback_EP0_DR3        ((reg8 *) Loopback_USB__EP0_DR3)
#define Loopback_EP0_DR4        ((reg8 *) Loopback_USB__EP0_DR4)
#define Loopback_EP0_DR5        ((reg8 *) Loopback_USB__EP0_DR5)
#define Loopback_EP0_DR6        ((reg8 *) Loopback_USB__EP0_DR6)
#define Loopback_EP0_DR7        ((reg8 *) Loopback_USB__EP0_DR7)

#define Loopback_OSCLK_DR0      ((reg8 *) Loopback_USB__OSCLK_DR0)
#define Loopback_OSCLK_DR1      ((reg8 *) Loopback_USB__OSCLK_DR1)

#define Loopback_PM_ACT_CFG     ((reg8 *) Loopback_USB__PM_ACT_CFG)
#define Loopback_PM_ACT_MSK     ((reg8 *) Loopback_USB__PM_ACT_MSK)
#define Loopback_PM_STBY_CFG    ((reg8 *) Loopback_USB__PM_STBY_CFG)
#define Loopback_PM_STBY_MSK    ((reg8 *) Loopback_USB__PM_STBY_MSK)

#define Loopback_SIE_EP_INT_EN  ((reg8 *) Loopback_USB__SIE_EP_INT_EN)
#define Loopback_SIE_EP_INT_SR  ((reg8 *) Loopback_USB__SIE_EP_INT_SR)

#define Loopback_SIE_EP1_CNT0   ((reg8 *) Loopback_USB__SIE_EP1_CNT0)
#define Loopback_SIE_EP1_CNT1   ((reg8 *) Loopback_USB__SIE_EP1_CNT1)
#define Loopback_SIE_EP1_CR0    ((reg8 *) Loopback_USB__SIE_EP1_CR0)

#define Loopback_SIE_EP2_CNT0   ((reg8 *) Loopback_USB__SIE_EP2_CNT0)
#define Loopback_SIE_EP2_CNT1   ((reg8 *) Loopback_USB__SIE_EP2_CNT1)
#define Loopback_SIE_EP2_CR0    ((reg8 *) Loopback_USB__SIE_EP2_CR0)

#define Loopback_SIE_EP3_CNT0   ((reg8 *) Loopback_USB__SIE_EP3_CNT0)
#define Loopback_SIE_EP3_CNT1   ((reg8 *) Loopback_USB__SIE_EP3_CNT1)
#define Loopback_SIE_EP3_CR0    ((reg8 *) Loopback_USB__SIE_EP3_CR0)

#define Loopback_SIE_EP4_CNT0   ((reg8 *) Loopback_USB__SIE_EP4_CNT0)
#define Loopback_SIE_EP4_CNT1   ((reg8 *) Loopback_USB__SIE_EP4_CNT1)
#define Loopback_SIE_EP4_CR0    ((reg8 *) Loopback_USB__SIE_EP4_CR0)

#define Loopback_SIE_EP5_CNT0   ((reg8 *) Loopback_USB__SIE_EP5_CNT0)
#define Loopback_SIE_EP5_CNT1   ((reg8 *) Loopback_USB__SIE_EP5_CNT1)
#define Loopback_SIE_EP5_CR0    ((reg8 *) Loopback_USB__SIE_EP5_CR0)

#define Loopback_SIE_EP6_CNT0   ((reg8 *) Loopback_USB__SIE_EP6_CNT0)
#define Loopback_SIE_EP6_CNT1   ((reg8 *) Loopback_USB__SIE_EP6_CNT1)
#define Loopback_SIE_EP6_CR0    ((reg8 *) Loopback_USB__SIE_EP6_CR0)

#define Loopback_SIE_EP7_CNT0   ((reg8 *) Loopback_USB__SIE_EP7_CNT0)
#define Loopback_SIE_EP7_CNT1   ((reg8 *) Loopback_USB__SIE_EP7_CNT1)
#define Loopback_SIE_EP7_CR0    ((reg8 *) Loopback_USB__SIE_EP7_CR0)

#define Loopback_SIE_EP8_CNT0   ((reg8 *) Loopback_USB__SIE_EP8_CNT0)
#define Loopback_SIE_EP8_CNT1   ((reg8 *) Loopback_USB__SIE_EP8_CNT1)
#define Loopback_SIE_EP8_CR0    ((reg8 *) Loopback_USB__SIE_EP8_CR0)

#define Loopback_SOF0           ((reg8 *) Loopback_USB__SOF0)
#define Loopback_SOF1           ((reg8 *) Loopback_USB__SOF1)

#define Loopback_USB_CLK_EN     ((reg8 *) Loopback_USB__USB_CLK_EN)

#define Loopback_USBIO_CR0      ((reg8 *) Loopback_USB__USBIO_CR0)
#define Loopback_USBIO_CR1      ((reg8 *) Loopback_USB__USBIO_CR1)
#define Loopback_USBIO_CR2      ((reg8 *) Loopback_USB__USBIO_CR2)

#define Loopback_USB_MEM        ((reg8 *) CYDEV_USB_MEM_BASE)

#define Loopback_USB_ISR_PRIOR  ((reg8 *) CYDEV_INTC_PRIOR0)
#define Loopback_USB_ISR_SET_EN ((reg8 *) CYDEV_INTC_SET_EN0)
#define Loopback_USB_ISR_CLR_EN ((reg8 *) CYDEV_INTC_CLR_EN0)
#define Loopback_USB_ISR_VECT   ((reg16 *) CYDEV_INTC_VECT_MBASE)

/************************************************
 *  Interrupt vectors, masks and priorities 
 ************************************************/
#define Loopback_BUS_RESET_PRIOR     (Loopback_bus_reset__INTC_PRIOR_NUM << 5)
#define Loopback_BUS_RESET_MASK      Loopback_bus_reset__INTC_MASK
#define Loopback_BUS_RESET_VECT_NUM  Loopback_bus_reset__INTC_NUMBER
 
#define Loopback_SOF_PRIOR     (Loopback_sof_int__INTC_PRIOR_NUM << 5)
#define Loopback_SOF_MASK      Loopback_sof_int__INTC_MASK
#define Loopback_SOF_VECT_NUM  Loopback_sof_int__INTC_NUMBER
 
#define Loopback_EP_0_PRIOR     (Loopback_ep_0__INTC_PRIOR_NUM << 5)
#define Loopback_EP_0_MASK      Loopback_ep_0__INTC_MASK
#define Loopback_EP_0_VECT_NUM  Loopback_ep_0__INTC_NUMBER
 
#define Loopback_EP_1_PRIOR     (Loopback_ep_1__INTC_PRIOR_NUM << 5)
#define Loopback_EP_1_MASK      Loopback_ep_1__INTC_MASK
#define Loopback_EP_1_VECT_NUM  Loopback_ep_1__INTC_NUMBER
 
#define Loopback_EP_2_PRIOR     (Loopback_ep_2__INTC_PRIOR_NUM << 5)
#define Loopback_EP_2_MASK      Loopback_ep_2__INTC_MASK
#define Loopback_EP_2_VECT_NUM  Loopback_ep_2__INTC_NUMBER
 
#define Loopback_EP_3_PRIOR     (Loopback_ep_3__INTC_PRIOR_NUM << 5)
#define Loopback_EP_3_MASK      Loopback_ep_3__INTC_MASK
#define Loopback_EP_3_VECT_NUM  Loopback_ep_3__INTC_NUMBER
 
#define Loopback_EP_4_PRIOR     (Loopback_ep_4__INTC_PRIOR_NUM << 5)
#define Loopback_EP_4_MASK      Loopback_ep_4__INTC_MASK
#define Loopback_EP_4_VECT_NUM  Loopback_ep_4__INTC_NUMBER
 
#define Loopback_EP_5_PRIOR     (Loopback_ep_5__INTC_PRIOR_NUM << 5)
#define Loopback_EP_5_MASK      Loopback_ep_5__INTC_MASK
#define Loopback_EP_5_VECT_NUM  Loopback_ep_5__INTC_NUMBER
 
#define Loopback_EP_6_PRIOR     (Loopback_ep_6__INTC_PRIOR_NUM << 5)
#define Loopback_EP_6_MASK      Loopback_ep_6__INTC_MASK
#define Loopback_EP_6_VECT_NUM  Loopback_ep_6__INTC_NUMBER
 
#define Loopback_EP_7_PRIOR     (Loopback_ep_7__INTC_PRIOR_NUM << 5)
#define Loopback_EP_7_MASK      Loopback_ep_7__INTC_MASK
#define Loopback_EP_7_VECT_NUM  Loopback_ep_7__INTC_NUMBER
 
#define Loopback_EP_8_PRIOR     (Loopback_ep_8__INTC_PRIOR_NUM << 5)
#define Loopback_EP_8_MASK      Loopback_ep_8__INTC_MASK
#define Loopback_EP_8_VECT_NUM  Loopback_ep_8__INTC_NUMBER
 
/************************************************
 *  Register Masks 
 ************************************************/
#define Loopback_CR1_REG_ENABLE             0x01u
#define Loopback_CR1_ENABLE_LOCK            0x02u
#define Loopback_CR1_BUS_ACTIVITY           0x04u
#define Loopback_EP0_CNT_DATA_TOGGLE        0x80u
#define Loopback_EPX_CNT_DATA_TOGGLE        0x80u
#define Loopback_CR0_ENABLE                 0x80u

#define Loopback_USBIO_CR1_IOMODE           0x80u
#define Loopback_USBIO_CR1_DRIVE_MODE       0x40u
#define Loopback_USBIO_CR1_DPI              0x20u
#define Loopback_USBIO_CR1_DMI              0x10u
#define Loopback_USBIO_CR1_P2PUEN           0x08u
#define Loopback_USBIO_CR1_USBPUEN          0x04u
#define Loopback_USBIO_CR1_DP0              0x02u
#define Loopback_USBIO_CR1_DM0              0x01u

#define Loopback_FASTCLK_IMO_CR_USBCLK_ON   0x40u
#define Loopback_FASTCLK_IMO_CR_XCLKEN      0x20u
#define Loopback_FASTCLK_IMO_CR_FX2ON       0x10u

#define Loopback_ARB_EPX_CFG_RESET_PTR      0x08u
#define Loopback_ARB_EPX_CFG_CRC_BYPASS     0x04u
#define Loopback_ARB_EPX_CFG_DMA_REQ        0x02u
#define Loopback_ARB_EPX_CFG_IN_DATA_RDY    0x01u

/************************************************
 *  Endpoint 0 offsets (Table 9-2) 
 ************************************************/

#define Loopback_bmRequestType   Loopback_EP0_DR0
#define Loopback_bRequest        Loopback_EP0_DR1
#define Loopback_wValue          Loopback_EP0_DR2
#define Loopback_wValueHi        Loopback_EP0_DR3
#define Loopback_wValueLo        Loopback_EP0_DR2
#define Loopback_wIndex          Loopback_EP0_DR4
#define Loopback_wIndexHi        Loopback_EP0_DR5
#define Loopback_wIndexLo        Loopback_EP0_DR4
#define Loopback_wLength         Loopback_EP0_DR6
#define Loopback_wLengthHi       Loopback_EP0_DR7
#define Loopback_wLengthLo       Loopback_EP0_DR6

#define TRUE  1
#define FALSE 0
/************************************************
 *  Optional Features 
 ************************************************/
#define Loopback_NUM_DEVICES   1
#define Loopback_ENABLE_STRINGS
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_BUF_SIZE   8
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_NUM_IN_RPTS   1
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_BUF_SIZE   8
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_NUM_OUT_RPTS   1
#define Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_COUNT   1
#define Loopback_ENABLE_HID_CLASS
#define Loopback_HID_RPT_1_SIZE_LSB   0x28u
#define Loopback_HID_RPT_1_SIZE_MSB   0x00u

#define Loopback_MON_VBUS       0
#if (Loopback_MON_VBUS == 1)
#define Loopback_VBUS_DR        ((reg8 *) Loopback_VBUS__DR)
#define Loopback_VBUS_PS        ((reg8 *) Loopback_VBUS__PS)
#define Loopback_VBUS_MASK      Loopback_VBUS__MASK
#endif

/*******************************************************************************
* typedefs
********************************************************************************/
typedef struct {
    uint8  bAttrib;
    uint8  bAPIEPState;
    uint8  bHWEPState;
    uint8  bEPToggle;
    uint8  bAddr;
    uint8  bEPMode;
    uint16 wBuffOffset;
    uint16 wBufferSize;
} T_Loopback_EP_CTL_BLOCK;

typedef struct {
    uint8  bInterface;
    uint8  bAltSetting;
    uint8  bAddr;
    uint8  bmAttributes;
    uint16 wBufferSize;
	uint8  bMisc;
} T_Loopback_EP_SETTINGS_BLOCK;

typedef struct {
    uint8  bStatus;
    uint16 wLength;
} T_Loopback_XFER_STATUS_BLOCK;

typedef struct {
    uint16  wCount;
    uint8   *pData;
    T_Loopback_XFER_STATUS_BLOCK *pStatusBlock;
} T_Loopback_TD;

typedef struct {
    uint8   c;
    void    *p_list;
} T_Loopback_LUT;

/************************************************
 *  Prototypes of the Loopback API. 
 ************************************************/
extern void   Loopback_Start(uint8 bDevice, uint8 bMode);
extern void   Loopback_Stop(void);
extern uint8  Loopback_bCheckActivity(void);
extern uint8  Loopback_bGetConfiguration(void);
extern uint8  Loopback_bGetEPState(uint8 bEPNumber);
extern uint16 Loopback_wGetEPCount(uint8 bEPNumber);
extern void   Loopback_LoadEP(uint8 bEPNumber, uint8 *pData, uint16 wLength);
extern uint16 Loopback_ReadOutEP(uint8 bEPNumber, uint8 *pData, uint16 wLength);
extern void   Loopback_EnableOutEP(uint8 bEPNumber);
extern void   Loopback_DisableOutEP(uint8 bEPNumber);
extern void   Loopback_Force(uint8 bState);
extern uint8  Loopback_bGetEPAckState(uint8 bEPNumber);
extern void   Loopback_SetPowerStatus(uint8 bPowerStaus);
extern uint8  Loopback_bRWUEnabled(void);
void Loopback_EnableInt(uint8 bVector, uint8 bMask);

#define Loopback_LoadInEP(e, p, l)        Loopback_LoadEP(e, p, l)
#define Loopback_LoadInISOCEP(e, p, l)    Loopback_LoadEP(e, p, l)
#define Loopback_EnableOutISOCEP(e)       Loopback_EnableOutEP(e)

#if (Loopback_MON_VBUS == 1)
extern uint8  Loopback_bVBusPresent(void);
#endif

#endif
