/*******************************************************************************
* File Name: Loopback_descr.c
* Version 0.2
*
*  Description:
*    USB descriptors and storage.
*
*   Note:
*
********************************************************************************
* Copyright (c) 2009, Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express, written permission of Cypress.
*******************************************************************************/

#include "cydevice.h"
#include "cyfitter.h"
#include "Loopback.h"

/*******************************************************************************
*  User supplied descriptors.  If you want to specify your own descriptors,
*  remove the comments around the define USER_SUPPLIED_DESCRIPTORS below and
*  add your descriptors.
********************************************************************************/
/* `#START USER_DESCRIPTORS_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
*  USB Customizer Generated Descriptors
********************************************************************************/
#if !defined(USER_SUPPLIED_DESCRIPTORS)
/*********************************************************************
 Device Descriptors
 *********************************************************************/
uint8 Loopback_CODE Loopback_DEVICE0_DESCR[] = {
/* Descriptor Length                       */ 0x12u,
/* DescriptorType: DEVICE                  */ 0x01u,
/* bcdUSB (ver 2.0)                        */ 0x00u, 0x02u,
/* bDeviceClass                            */ 0x00u,
/* bDeviceSubClass                         */ 0x00u,
/* bDeviceProtocol                         */ 0x00u,
/* bMaxPacketSize0                         */ 0x08u,
/* idVendor                                */ 0xB4u, 0x04u,
/* idProduct                               */ 0x00u, 0xF1u,
/* bcdDevice                               */ 0x00u, 0x00u,
/* iManufacturer                           */ 0x01u,
/* iProduct                                */ 0x03u,
/* iSerialNumber                           */ 0x00u,
/* bNumConfigurations                      */ 0x01u
};
/*********************************************************************
 Config Descriptor  
 *********************************************************************/
uint8 Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_DESCR[] = {
/*  Config Descriptor Length               */ 0x09u,
/*  DescriptorType: CONFIG                 */ 0x02u,
/*  wTotalLength                           */ 0x29u, 0x00u,
/*  bNumInterfaces                         */ 0x01u,
/*  bConfigurationValue                    */ 0x01u,
/*  iConfiguration                         */ 0x00u,
/*  bmAttributes                           */ 0xC0u,
/*  bMaxPower                              */ 0xC8u,
/*********************************************************************
 Interface Descriptor
 *********************************************************************/
/*  Interface Descriptor Length            */ 0x09u,
/*  DescriptorType: INTERFACE              */ 0x04u,
/*  bInterfaceNumber                       */ 0x00u,
/*  bAlternateSetting                      */ 0x00u,
/*  bNumEndpoints                          */ 0x02u,
/*  bInterfaceClass                        */ 0x03u,
/*  bInterfaceSubClass                     */ 0x00u,
/*  bInterfaceProtocol                     */ 0x00u,
/*  iInterface                             */ 0x04u,
/*********************************************************************
 HID Class Descriptor
 *********************************************************************/
/*  HID Class Descriptor Length            */ 0x09u,
/*  DescriptorType: HID_CLASS              */ 0x21u,
/*  bcdHID                                 */ 0x11u, 0x01u,
/*  bCountryCode                           */ 0x00u,
/*  bNumDescriptors                        */ 0x01u,
/*  bDescriptorType                        */ 0x22u,
/*  wDescriptorLength (LSB)                */ Loopback_HID_RPT_1_SIZE_LSB,
/*  wDescriptorLength (MSB)                */ Loopback_HID_RPT_1_SIZE_MSB,
/*********************************************************************
 Endpoint Descriptor
 *********************************************************************/
/*  Endpoint Descriptor Length             */ 0x07u,
/*  DescriptorType: ENDPOINT               */ 0x05u,
/*  bEndpointAddress                       */ 0x81u,
/*  bmAttributes                           */ 0x03u,
/*  wMaxPacketSize                         */ 0x08u, 0x00u,
/*  bInterval                              */ 0x0Au,
/*********************************************************************
 Endpoint Descriptor
 *********************************************************************/
/*  Endpoint Descriptor Length             */ 0x07u,
/*  DescriptorType: ENDPOINT               */ 0x05u,
/*  bEndpointAddress                       */ 0x02u,
/*  bmAttributes                           */ 0x03u,
/*  wMaxPacketSize                         */ 0x08u, 0x00u,
/*  bInterval                              */ 0x0Au
};

/*********************************************************************
 String Descriptor Table
 *********************************************************************/
uint8 Loopback_CODE Loopback_STRING_DESCRIPTORS[] = {
/*********************************************************************
 Language ID Descriptor
 *********************************************************************/
/* Descriptor Length                       */ 0x04u,
/* DescriptorType: STRING                  */ 0x03u,
/* Language Id                             */ 0x09u, 0x04u,
/*********************************************************************
 String Descriptor: "Cypress"
 *********************************************************************/
/* Descriptor Length                       */ 0x10u,
/* DescriptorType: STRING                  */ 0x03u,
 'C', 0,'y', 0,'p', 0,'r', 0,'e', 0,'s', 0,'s', 0,
/*********************************************************************
 String Descriptor: "Example"
 *********************************************************************/
/* Descriptor Length                       */ 0x10u,
/* DescriptorType: STRING                  */ 0x03u,
 'E', 0,'x', 0,'a', 0,'m', 0,'p', 0,'l', 0,'e', 0,
/*********************************************************************
 String Descriptor: "USB Loopback"
 *********************************************************************/
/* Descriptor Length                       */ 0x1Au,
/* DescriptorType: STRING                  */ 0x03u,
 'U', 0,'S', 0,'B', 0,' ', 0,'L', 0,'o', 0,'o', 0,'p', 0,'b', 0,'a', 0
,'c', 0,'k', 0,
/*********************************************************************
 String Descriptor: "Loopback Interface"
 *********************************************************************/
/* Descriptor Length                       */ 0x26u,
/* DescriptorType: STRING                  */ 0x03u,
 'L', 0,'o', 0,'o', 0,'p', 0,'b', 0,'a', 0,'c', 0,'k', 0,' ', 0,'I', 0
,'n', 0,'t', 0,'e', 0,'r', 0,'f', 0,'a', 0,'c', 0,'e', 0,
/*********************************************************************
/* Marks the end of the list.              */ 0x00u};
/*********************************************************************/



/*********************************************************************
 HID Report Descriptors
 *********************************************************************/
uint8 Loopback_CODE Loopback_HIDREPORT_DESCRIPTORS[] = {
/*********************************************************************
 HID Report Descriptor: LoopbackHIDReport
 *********************************************************************/
/* Descriptor Size (Not part of descriptor)*/ 0x28u, 0x00u,
/* USAGE_PAGE                              */ 0x05u, 0xFFu, 
/* USAGE                                   */ 0x09u, 0x01u, 
/* COLLECTION                              */ 0xA1u, 0x01u, 
/* USAGE                                   */ 0x09u, 0x02u, 
/* COLLECTION                              */ 0xA1u, 0x00u, 
/* USAGE_MINIMUM                           */ 0x19u, 0x00u, 
/* USAGE_MAXIMUM                           */ 0x29u, 0xFFu, 
/* LOGICAL_MINIMUM                         */ 0x15u, 0x00u, 
/* LOGICAL_MAXIMUM                         */ 0x25u, 0xFFu, 
/* REPORT_SIZE                             */ 0x75u, 0x08u, 
/* REPORT_COUNT                            */ 0x95u, 0x40u, 
/* OUTPUT                                  */ 0x91u, 0x02u, 
/* USAGE_MINIMUM                           */ 0x19u, 0x00u, 
/* USAGE_MAXIMUM                           */ 0x29u, 0xFFu, 
/* LOGICAL_MINIMUM                         */ 0x15u, 0x00u, 
/* LOGICAL_MAXIMUM                         */ 0x25u, 0xFFu, 
/* REPORT_SIZE                             */ 0x75u, 0x08u, 
/* REPORT_COUNT                            */ 0x95u, 0x40u, 
/* INPUT                                   */ 0x81u, 0x02u, 
/* END_COLLECTION                          */ 0xC0u, 
/* END_COLLECTION                          */ 0xC0u, 
/*********************************************************************/
/* End of the HID Report Descriptors       */ 0x00u, 0x00u};
/*********************************************************************/

#if !defined(USER_DEFINE_Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_HID_RPT_STORAGE)
/*********************************************************************
 HID Input Report Storage
 *********************************************************************/
uint8 Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_BUF[Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_BUF_SIZE];

/*********************************************************************
 HID Input Report TD Table
 *********************************************************************/
T_Loopback_TD Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_RPT_TABLE[] = {
    {Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_NUM_IN_RPTS,     &Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_BUF[0], Loopback_NULL}
};
/*********************************************************************
 HID Input Report Storage
 *********************************************************************/
uint8 Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_BUF[Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_BUF_SIZE];

/*********************************************************************
 HID Output Report TD Table
 *********************************************************************/
T_Loopback_TD Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_RPT_TABLE[] = {
    {Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_NUM_OUT_RPTS,     &Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_BUF[0], Loopback_NULL}
};
/*********************************************************************
 HID Report Look Up Table          This table has three entries:
                                         IN Report Table
                                         OUT Report Table
                                         Feature Report Table
 *********************************************************************/
T_Loopback_LUT Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_TABLE[] = {
    {0x01u,     &Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_IN_RPT_TABLE},
    {0x01u,     &Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_OUT_RPT_TABLE},
    {0x00u,    Loopback_NULL}
};
#endif /* USER_DEFINE_Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_HID_RPT_STORAGE */

/*********************************************************************
 Interface Dispatch Table -- Points to the Class Dispatch Tables
 *********************************************************************/
T_Loopback_LUT Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_TABLE[] = {
    {Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_COUNT,     &Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_HID1_TABLE}
};
/*********************************************************************
  Endpoint Setting Table -- This table contain the endpoint setting
                            for each endpoint in the configuration.  It
                            contains the necessary information to
                            configure the endpoint hardware for each
                            interface and alternate setting.
  *********************************************************************/
T_Loopback_EP_SETTINGS_BLOCK Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_EP_SETTINGS_TABLE[] = {
/* IFC  ALT    EPAddr bmAttr MaxPktSize BufferType ********************/
{0x00u, 0x00u, 0x81u, 0x03u, 0x0008u,   0x00u},
{0x00u, 0x00u, 0x02u, 0x03u, 0x0008u,   0x00u}
};
/*********************************************************************
 Config Dispatch Table -- Points to the Config Descriptor and each of
                          and endpoint setup table and to each interface 
                          table if it specifies a USB Class 
 *********************************************************************/
T_Loopback_LUT Loopback_CODE Loopback_DEVICE0_CONFIGURATION0_TABLE[] = {
    {0x01u,     &Loopback_DEVICE0_CONFIGURATION0_DESCR},
    {0x02u,     &Loopback_DEVICE0_CONFIGURATION0_EP_SETTINGS_TABLE},
    {0x01u,     &Loopback_DEVICE0_CONFIGURATION0_INTERFACE0_TABLE}
};
/*********************************************************************
 Device Dispatch Table -- Points to the Device Descriptor and each of
                          and Configuration Tables for this Device 
 *********************************************************************/
T_Loopback_LUT Loopback_CODE Loopback_DEVICE0_TABLE[] = {
    {0x01u,     &Loopback_DEVICE0_DESCR},
    {0x01u,     &Loopback_DEVICE0_CONFIGURATION0_TABLE}
};
/*********************************************************************
 Device Table -- Indexed by the device number.
 *********************************************************************/
T_Loopback_LUT Loopback_CODE Loopback_TABLE[] = {
    {0x01u,     &Loopback_DEVICE0_TABLE}
};

#endif
