/*******************************************************************************
* File Name: Loopback_hid.c
* Version 0.2
*
*  Description:
*    USB HID Class request handler.
*
*   Note:
*
********************************************************************************
* Copyright (c) 2009 Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express, written permission of Cypress.
*******************************************************************************/

#include "cydevice.h"
#include "cyfitter.h"
#include "Loopback.h"
#include "Loopback_hid.h"

#if defined(Loopback_ENABLE_HID_CLASS)
/*******************************************************************************
* Custom Declratations
********************************************************************************/
/* `#START CUSTOM_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
* Exxternal references
********************************************************************************/
uint8 Loopback_InitControlRead(void);
uint8 Loopback_InitControlWrite(void);
uint8 Loopback_InitNoDataControlTransfer(void);
T_Loopback_LUT *Loopback_GetConfigTablePtr(uint8 c);
T_Loopback_LUT *Loopback_GetDeviceTablePtr();
extern T_Loopback_TD CurrentTD;
extern uint8 Loopback_CODE Loopback_HIDREPORT_DESCRIPTORS[];
extern uint8 Loopback_bConfiguration;
/*******************************************************************************
* Exxternal references
********************************************************************************/
void Loopback_FindReport(void);

/*******************************************************************************
* Function Name: Loopback_UpdateHIDTimer
********************************************************************************
* Summary:
*   Updates the HID report timer and reloads it if it expires
*   
* Parameters:  
*   bInterface Interface Number
*******************************************************************************/
uint8 Loopback_UpdateHIDTimer(uint8 bInterface)
{
    uint8 ifc = bInterface;
    return Loopback_IDLE_TIMER_INDEFINITE;
}
/*******************************************************************************
* Function Name: Loopback_bGetProtocol
********************************************************************************
* Summary:
*   Returns the selected protocol value to the application
*   
* Parameters:  
*   bInterface Interface Number
*******************************************************************************/
uint8 Loopback_bGetProtocol(uint8 bInterface)
{
    uint8 ifc = bInterface;
    return Loopback_PROTOCOL_REPORT;
}
/*******************************************************************************
* Function Name: Loopback_DispatchHIDClassRqst
********************************************************************************
* Summary:
*   This routine dispatches class requests
*   
* Parameters:  
*   None
*******************************************************************************/
uint8 Loopback_DispatchHIDClassRqst()
{
    uint8 *pDescr;
    uint8 bRequestHandled = Loopback_FALSE;
    T_Loopback_LUT *pTmp = Loopback_GetConfigTablePtr(Loopback_bConfiguration - 1);

    if ((CY_GET_REG8(Loopback_bmRequestType) & Loopback_RQST_DIR_MASK) == Loopback_RQST_DIR_D2H)
    {   /* Control Read */
		switch (*Loopback_bRequest) 
		{
			case Loopback_GET_DESCRIPTOR:
                if (CY_GET_REG8(Loopback_wValueHi) == Loopback_DESCR_HID_CLASS)
                {
                    /* pTmp is pointing to the Config Table */
                    /* Next...                              */
				    /* Get the Config Descriptor            */
                    /*   The HID Class Descriptor resides   */
                    /*   inside the config descriptor       */
                    CurrentTD.pData     = &((uint8 *) pTmp->p_list)[18];
                    CurrentTD.wCount    = 9;
					bRequestHandled     = Loopback_InitControlRead();
                }
                else if (CY_GET_REG8(Loopback_wValueHi) == Loopback_DESCR_HID_REPORT)  
				{
                    pDescr = &Loopback_HIDREPORT_DESCRIPTORS[0];
                    CurrentTD.wCount    = (uint16) ((pDescr[1] << 8) | pDescr[0]);
                    CurrentTD.pData     = &pDescr[2];
    
                    if (CurrentTD.wCount != 0)
                    {
                        bRequestHandled     = Loopback_InitControlRead();
                    }
				}
                break;
            case Loopback_HID_GET_REPORT:
                /*******************************************************************************
                * Not Supported -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM_HID_GET_REPORT` Place your code */

                /* `#END` */
                Loopback_FindReport();
                bRequestHandled     = Loopback_InitControlRead();
                break;
            default:
                break;
        }
    }
    else if ((CY_GET_REG8(Loopback_bmRequestType) & Loopback_RQST_DIR_MASK) == Loopback_RQST_DIR_H2D)
    {   /* Control Write */
		switch (CY_GET_REG8(Loopback_bRequest)) 
		{
            case Loopback_HID_SET_REPORT:
                /*******************************************************************************
                * Not Supported -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM_HID_SET_REPORT` Place your code */

                /* `#END` */
                Loopback_FindReport();
                bRequestHandled     = Loopback_InitControlWrite();
                break;
            case Loopback_HID_SET_IDLE:
                /*******************************************************************************
                * Incomplete -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM__HID_SET_IDLE` Place your code */

                /* `#END` */
				bRequestHandled     = Loopback_InitNoDataControlTransfer();
                break;
            case Loopback_HID_SET_PROTOCOL:
                /*******************************************************************************
                * Incomplete -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM__HID_SET_PROTOCOL` Place your code */

                /* `#END` */
				bRequestHandled     = Loopback_InitNoDataControlTransfer();
                break;
            default:
                break;
        }
    }
    return bRequestHandled;   
}
/*******************************************************************************
* Function Name: Loopback_FindReport
********************************************************************************
* Summary:
*   This routine sets up a transfer based on the Interface number, Report Type
*   and Report ID, then loads the CurrentTD structure with the address of the
*   buffer and the size.  The caller has to decide if it is a control read or
*   control write.
*   
* Parameters:  
*   None
*******************************************************************************/
void Loopback_FindReport()
{
    T_Loopback_LUT *pTmp = Loopback_GetConfigTablePtr(Loopback_bConfiguration - 1);
    T_Loopback_TD *pTD;
    /* Third entry in the LUT starts the Interface Table pointers */
    pTmp++;
    pTmp++;
    /* Now use the request interface number */
    pTmp = &pTmp[CY_GET_REG8(Loopback_wIndexLo)];
	pTmp = (T_Loopback_LUT *) pTmp->p_list;
    pTmp = (T_Loopback_LUT *) pTmp->p_list;
    /* Get the entry proper TD */
    pTD = &((T_Loopback_TD *) pTmp->p_list)[CY_GET_REG8(Loopback_wValueHi) - 1];

    CurrentTD.pData     = pTD->pData;
    CurrentTD.wCount    = pTD->wCount;
    CurrentTD.pStatusBlock = pTD->pStatusBlock;
}
#endif
