/*******************************************************************************
* File Name: USBFS_1.h
* Version 0.2
*
*  Description:
*    Header File for the USFS component. Contains prototypes and constant values. 
*
********************************************************************************
* Copyright (2008), Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction wit,a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*******************************************************************************/
#if !defined(USBFS_1_H)
#define USBFS_1_H

#include "cytypes.h"
/************************************************
 *  General defines 
 ************************************************/
#if defined(__C51__) || defined(__CX51__)
#ifndef USBFS_1_CODE
#define USBFS_1_CODE code
#define USBFS_1_DATA data
#define USBFS_1_XDATA xdata
#define USBFS_1_FAR far
#define USBFS_1_NULL  ((void *) 0)
#endif
#else
#ifndef USBFS_1_CODE
#define USBFS_1_CODE
#define USBFS_1_DATA
#define USBFS_1_XDATA
#define USBFS_1_FAR
#define USBFS_1_NULL  ((void *) 0)
#endif
#endif

/************************************************
 *  Customizer Defines 
 ************************************************/
#define USBFS_1_NUM_DEVICES   1
#define USBFS_1_ENABLE_STRINGS

#define USBFS_1_MON_VBUS       0
#if (USBFS_1_MON_VBUS == 1)
#define USBFS_1_VBUS_DR        ((reg8 *) USBFS_1_VBUS__DR)
#define USBFS_1_VBUS_PS        ((reg8 *) USBFS_1_VBUS__PS)
#define USBFS_1_VBUS_MASK      USBFS_1_VBUS__MASK
#endif

/************************************************
 *  Constants for USBFS_1 API. 
 ************************************************/
#define USBFS_1_TRUE                       1
#define USBFS_1_FALSE                      0

#define USBFS_1_NO_EVENT_ALLOWED           2
#define USBFS_1_EVENT_PENDING              1
#define USBFS_1_NO_EVENT_PENDING           0

#define USBFS_1_IN_BUFFER_FULL             USBFS_1_NO_EVENT_PENDING
#define USBFS_1_IN_BUFFER_EMPTY            USBFS_1_EVENT_PENDING
#define USBFS_1_OUT_BUFFER_FULL            USBFS_1_EVENT_PENDING
#define USBFS_1_OUT_BUFFER_EMPTY           USBFS_1_NO_EVENT_PENDING

#define USBFS_1_FORCE_J                    0xA0
#define USBFS_1_FORCE_K                    0x80
#define USBFS_1_FORCE_SE0                  0xC0
#define USBFS_1_FORCE_NONE                 0x00

#define USBFS_1_IDLE_TIMER_RUNNING         0x02
#define USBFS_1_IDLE_TIMER_EXPIRED         0x01
#define USBFS_1_IDLE_TIMER_INDEFINITE      0x00

#define USBFS_1_DEVICE_STATUS_BUS_POWERED  0x00
#define USBFS_1_DEVICE_STATUS_SELF_POWERED 0x01

#define USBFS_1_3V_OPERATION               0x02
#define USBFS_1_5V_OPERATION               0x03

#define USBFS_1_MODE_DISABLE               0x00
#define	USBFS_1_MODE_NAK_IN_OUT            0x01
#define	USBFS_1_MODE_STATUS_OUT_ONLY       0x02
#define	USBFS_1_MODE_STALL_IN_OUT          0x03
#define	USBFS_1_MODE_RESERVED_0100         0x04
#define	USBFS_1_MODE_ISO_OUT               0x05
#define	USBFS_1_MODE_STATUS_IN_ONLY        0x06
#define	USBFS_1_MODE_ISO_IN                0x07
#define	USBFS_1_MODE_NAK_OUT               0x08
#define	USBFS_1_MODE_ACK_OUT               0x09
#define	USBFS_1_MODE_RESERVED_1010         0x0A
#define	USBFS_1_MODE_ACK_OUT_STATUS_IN     0x0B
#define	USBFS_1_MODE_NAK_IN                0x0C
#define	USBFS_1_MODE_ACK_IN                0x0D
#define	USBFS_1_MODE_RESERVED_1110         0x0E
#define	USBFS_1_MODE_ACK_IN_STATUS_OUT     0x0F
#define	USBFS_1_MODE_STALL_DATA_EP         0x80

#define USBFS_1_MODE_ACKD                  0x10
#define USBFS_1_MODE_OUT_RCVD              0x20
#define USBFS_1_MODE_IN_RCVD               0x40
#define USBFS_1_MODE_SETUP_RCVD            0x80

#define USBFS_1_RQST_TYPE_MASK             0x60
#define USBFS_1_RQST_TYPE_STD              0x00
#define USBFS_1_RQST_TYPE_CLS              0x20
#define USBFS_1_RQST_TYPE_VND              0x40
#define USBFS_1_RQST_DIR_MASK              0x80
#define USBFS_1_RQST_DIR_D2H               0x80
#define USBFS_1_RQST_DIR_H2D               0x00
#define USBFS_1_RQST_RCPT_MASK             0x03
#define USBFS_1_RQST_RCPT_DEV              0x00
#define USBFS_1_RQST_RCPT_IFC              0x01
#define USBFS_1_RQST_RCPT_EP               0x02
#define USBFS_1_RQST_RCPT_OTHER            0x03

/************************************************
 *  Standard Request Types (Table 9-4) 
 ************************************************/
#define USBFS_1_GET_STATUS           0x00
#define USBFS_1_CLEAR_FEATURE        0x01
#define USBFS_1_SET_FEATURE          0x03
#define USBFS_1_SET_ADDRESS          0x05
#define USBFS_1_GET_DESCRIPTOR       0x06
#define USBFS_1_SET_DESCRIPTOR       0x07
#define USBFS_1_GET_CONFIGURATION    0x08
#define USBFS_1_SET_CONFIGURATION    0x09
#define USBFS_1_GET_INTERFACE        0x0A
#define USBFS_1_SET_INTERFACE        0x0B
#define USBFS_1_SYNCH_FRAME          0x0C

/************************************************
 *  Descriptor Types (Table 9-5) 
 ************************************************/

#define USBFS_1_DESCR_DEVICE           1
#define USBFS_1_DESCR_CONFIG           2
#define USBFS_1_DESCR_STRING           3
#define USBFS_1_DESCR_INTERFACE        4
#define USBFS_1_DESCR_ENDPOINT         5
#define USBFS_1_DESCR_DEVICE_QUALIFIER 6
#define USBFS_1_DESCR_OTHER_SPEED      7
#define USBFS_1_DESCR_INTERFACE_POWER  8

/************************************************
 *  Feature Selectors (Table 9-6)
 ************************************************/
#define USBFS_1_DEVICE_REMOTE_WAKEUP    0x01
#define USBFS_1_ENDPOINT_HALT           0x00
#define USBFS_1_TEST_MODE               0x02

/************************************************
 *  USB Device Status (Figure 9-4)
 ************************************************/
#define USBFS_1_DEVICE_STATUS_BUS_POWERED   0x00
#define USBFS_1_DEVICE_STATUS_SELF_POWERED  0x01
#define USBFS_1_DEVICE_STATUS_REMOTE_WAKEUP 0x02

/************************************************
 *  USB Endpoint Status (Figure 9-4)
 ************************************************/
#define USBFS_1_ENDPOINT_STATUS_HALT        0x01

/************************************************
 *  USB Endpoint Directions 
 ************************************************/
#define USBFS_1_DIR_IN                          0x80
#define USBFS_1_DIR_OUT                         0x00
#define USBFS_1_DIR_UNUSED                      0x7F
/************************************************
 *  USB Endpoint Attributes 
 ************************************************/
#define USBFS_1_EP_TYPE_CTRL                    0x00
#define USBFS_1_EP_TYPE_ISOC                    0x01
#define USBFS_1_EP_TYPE_BULK                    0x02
#define USBFS_1_EP_TYPE_INT                     0x03
#define USBFS_1_EP_TYPE_MASK                    0x03

#define USBFS_1_EP_SYNC_TYPE_NO_SYNC            0x00
#define USBFS_1_EP_SYNC_TYPE_ASYNC              0x04
#define USBFS_1_EP_SYNC_TYPE_ADAPTIVE           0x08
#define USBFS_1_EP_SYNC_TYPE_SYNCHRONOUS        0x0C
#define USBFS_1_EP_SYNC_TYPE_MASK               0x0C

#define USBFS_1_EP_USAGE_TYPE_DATA              0x00
#define USBFS_1_EP_USAGE_TYPE_FEEDBACK          0x10
#define USBFS_1_EP_USAGE_TYPE_IMPLICIT          0x20
#define USBFS_1_EP_USAGE_TYPE_RESERVED          0x30
#define USBFS_1_EP_USAGE_TYPE_MASK              0x30

/************************************************
 *  Transfer Completion Notification 
 ************************************************/
#define USBFS_1_XFER_IDLE                       0x00
#define USBFS_1_XFER_STATUS_ACK                 0x01
#define USBFS_1_XFER_PREMATURE                  0x02
#define USBFS_1_XFER_ERROR                      0x03

/*******************************************************************************
* Driver State defines
********************************************************************************/
#define USBFS_1_TRANS_STATE_IDLE             0x00
#define USBFS_1_TRANS_STATE_CONTROL_READ     0x02
#define USBFS_1_TRANS_STATE_CONTROL_WRITE    0x04
#define USBFS_1_TRANS_STATE_NO_DATA_CONTROL  0x06

/************************************************
 *  USB, ARB, SIE register definitions 
 ************************************************/
#define USBFS_1_ARB_CFG        ((reg8 *) USBFS_1_USB__ARB_CFG)

#define USBFS_1_ARB_EP1_CFG    ((reg8 *) USBFS_1_USB__ARB_EP1_CFG)
#define USBFS_1_ARB_EP1_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP1_INT_EN)
#define USBFS_1_ARB_EP1_SR     ((reg8 *) USBFS_1_USB__ARB_EP1_SR)

#define USBFS_1_ARB_EP2_CFG    ((reg8 *) USBFS_1_USB__ARB_EP2_CFG)
#define USBFS_1_ARB_EP2_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP2_INT_EN)
#define USBFS_1_ARB_EP2_SR     ((reg8 *) USBFS_1_USB__ARB_EP2_SR)

#define USBFS_1_ARB_EP3_CFG    ((reg8 *) USBFS_1_USB__ARB_EP3_CFG)
#define USBFS_1_ARB_EP3_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP3_INT_EN)
#define USBFS_1_ARB_EP3_SR     ((reg8 *) USBFS_1_USB__ARB_EP3_SR)

#define USBFS_1_ARB_EP4_CFG    ((reg8 *) USBFS_1_USB__ARB_EP4_CFG)
#define USBFS_1_ARB_EP4_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP4_INT_EN)
#define USBFS_1_ARB_EP4_SR     ((reg8 *) USBFS_1_USB__ARB_EP4_SR)

#define USBFS_1_ARB_EP5_CFG    ((reg8 *) USBFS_1_USB__ARB_EP5_CFG)
#define USBFS_1_ARB_EP5_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP5_INT_EN)
#define USBFS_1_ARB_EP5_SR     ((reg8 *) USBFS_1_USB__ARB_EP5_SR)

#define USBFS_1_ARB_EP6_CFG    ((reg8 *) USBFS_1_USB__ARB_EP6_CFG)
#define USBFS_1_ARB_EP6_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP6_INT_EN)
#define USBFS_1_ARB_EP6_SR     ((reg8 *) USBFS_1_USB__ARB_EP6_SR)

#define USBFS_1_ARB_EP7_CFG    ((reg8 *) USBFS_1_USB__ARB_EP7_CFG)
#define USBFS_1_ARB_EP7_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP7_INT_EN)
#define USBFS_1_ARB_EP7_SR     ((reg8 *) USBFS_1_USB__ARB_EP7_SR)

#define USBFS_1_ARB_EP8_CFG    ((reg8 *) USBFS_1_USB__ARB_EP8_CFG)
#define USBFS_1_ARB_EP8_INT_EN ((reg8 *) USBFS_1_USB__ARB_EP8_INT_EN)
#define USBFS_1_ARB_EP8_SR     ((reg8 *) USBFS_1_USB__ARB_EP8_SR)

#define USBFS_1_ARB_INT_EN     ((reg8 *) USBFS_1_USB__ARB_INT_EN)
#define USBFS_1_ARB_INT_SR     ((reg8 *) USBFS_1_USB__ARB_INT_SR)

#define USBFS_1_ARB_RW1_DR     ((reg8 *) USBFS_1_USB__ARB_RW1_DR)
#define USBFS_1_ARB_RW1_RA     ((reg8 *) USBFS_1_USB__ARB_RW1_RA)
#define USBFS_1_ARB_RW1_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW1_RA_MSB)
#define USBFS_1_ARB_RW1_WA     ((reg8 *) USBFS_1_USB__ARB_RW1_WA)
#define USBFS_1_ARB_RW1_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW1_WA_MSB)

#define USBFS_1_ARB_RW2_DR     ((reg8 *) USBFS_1_USB__ARB_RW2_DR)
#define USBFS_1_ARB_RW2_RA     ((reg8 *) USBFS_1_USB__ARB_RW2_RA)
#define USBFS_1_ARB_RW2_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW2_RA_MSB)
#define USBFS_1_ARB_RW2_WA     ((reg8 *) USBFS_1_USB__ARB_RW2_WA)
#define USBFS_1_ARB_RW2_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW2_WA_MSB)

#define USBFS_1_ARB_RW3_DR     ((reg8 *) USBFS_1_USB__ARB_RW3_DR)
#define USBFS_1_ARB_RW3_RA     ((reg8 *) USBFS_1_USB__ARB_RW3_RA)
#define USBFS_1_ARB_RW3_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW3_RA_MSB)
#define USBFS_1_ARB_RW3_WA     ((reg8 *) USBFS_1_USB__ARB_RW3_WA)
#define USBFS_1_ARB_RW3_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW3_WA_MSB)

#define USBFS_1_ARB_RW4_DR     ((reg8 *) USBFS_1_USB__ARB_RW4_DR)
#define USBFS_1_ARB_RW4_RA     ((reg8 *) USBFS_1_USB__ARB_RW4_RA)
#define USBFS_1_ARB_RW4_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW4_RA_MSB)
#define USBFS_1_ARB_RW4_WA     ((reg8 *) USBFS_1_USB__ARB_RW4_WA)
#define USBFS_1_ARB_RW4_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW4_WA_MSB)

#define USBFS_1_ARB_RW5_DR     ((reg8 *) USBFS_1_USB__ARB_RW5_DR)
#define USBFS_1_ARB_RW5_RA     ((reg8 *) USBFS_1_USB__ARB_RW5_RA)
#define USBFS_1_ARB_RW5_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW5_RA_MSB)
#define USBFS_1_ARB_RW5_WA     ((reg8 *) USBFS_1_USB__ARB_RW5_WA)
#define USBFS_1_ARB_RW5_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW5_WA_MSB)

#define USBFS_1_ARB_RW6_DR     ((reg8 *) USBFS_1_USB__ARB_RW6_DR)
#define USBFS_1_ARB_RW6_RA     ((reg8 *) USBFS_1_USB__ARB_RW6_RA)
#define USBFS_1_ARB_RW6_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW6_RA_MSB)
#define USBFS_1_ARB_RW6_WA     ((reg8 *) USBFS_1_USB__ARB_RW6_WA)
#define USBFS_1_ARB_RW6_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW6_WA_MSB)

#define USBFS_1_ARB_RW7_DR     ((reg8 *) USBFS_1_USB__ARB_RW7_DR)
#define USBFS_1_ARB_RW7_RA     ((reg8 *) USBFS_1_USB__ARB_RW7_RA)
#define USBFS_1_ARB_RW7_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW7_RA_MSB)
#define USBFS_1_ARB_RW7_WA     ((reg8 *) USBFS_1_USB__ARB_RW7_WA)
#define USBFS_1_ARB_RW7_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW7_WA_MSB)

#define USBFS_1_ARB_RW8_DR     ((reg8 *) USBFS_1_USB__ARB_RW8_DR)
#define USBFS_1_ARB_RW8_RA     ((reg8 *) USBFS_1_USB__ARB_RW8_RA)
#define USBFS_1_ARB_RW8_RA_MSB ((reg8 *) USBFS_1_USB__ARB_RW8_RA_MSB)
#define USBFS_1_ARB_RW8_WA     ((reg8 *) USBFS_1_USB__ARB_RW8_WA)
#define USBFS_1_ARB_RW8_WA_MSB ((reg8 *) USBFS_1_USB__ARB_RW8_WA_MSB)

#define USBFS_1_BUF_SIZE       ((reg8 *) USBFS_1_USB__BUF_SIZE)
#define USBFS_1_BUS_RST_CNT    ((reg8 *) USBFS_1_USB__BUS_RST_CNT)
#define USBFS_1_CR0            ((reg8 *) USBFS_1_USB__CR0)
#define USBFS_1_CR1            ((reg8 *) USBFS_1_USB__CR1)
#define USBFS_1_CWA            ((reg8 *) USBFS_1_USB__CWA)
#define USBFS_1_CWA_MSB        ((reg8 *) USBFS_1_USB__CWA_MSB)

#define USBFS_1_DMA_THRES      ((reg8 *) USBFS_1_USB__DMA_THRES)
#define USBFS_1_DMA_THRES_MSB  ((reg8 *) USBFS_1_USB__DMA_THRES_MSB)

#define USBFS_1_EP_ACTIVE      ((reg8 *) USBFS_1_USB__EP_ACTIVE)
#define USBFS_1_EP_TYPE        ((reg8 *) USBFS_1_USB__EP_TYPE)

#define USBFS_1_EP0_CNT        ((reg8 *) USBFS_1_USB__EP0_CNT)
#define USBFS_1_EP0_CR         ((reg8 *) USBFS_1_USB__EP0_CR)
#define USBFS_1_EP0_DR0        ((reg8 *) USBFS_1_USB__EP0_DR0)
#define USBFS_1_EP0_DR1        ((reg8 *) USBFS_1_USB__EP0_DR1)
#define USBFS_1_EP0_DR2        ((reg8 *) USBFS_1_USB__EP0_DR2)
#define USBFS_1_EP0_DR3        ((reg8 *) USBFS_1_USB__EP0_DR3)
#define USBFS_1_EP0_DR4        ((reg8 *) USBFS_1_USB__EP0_DR4)
#define USBFS_1_EP0_DR5        ((reg8 *) USBFS_1_USB__EP0_DR5)
#define USBFS_1_EP0_DR6        ((reg8 *) USBFS_1_USB__EP0_DR6)
#define USBFS_1_EP0_DR7        ((reg8 *) USBFS_1_USB__EP0_DR7)

#define USBFS_1_OSCLK_DR0      ((reg8 *) USBFS_1_USB__OSCLK_DR0)
#define USBFS_1_OSCLK_DR1      ((reg8 *) USBFS_1_USB__OSCLK_DR1)

#define USBFS_1_PM_ACT_CFG     ((reg8 *) USBFS_1_USB__PM_ACT_CFG)
#define USBFS_1_PM_ACT_MSK     ((reg8 *) USBFS_1_USB__PM_ACT_MSK)
#define USBFS_1_PM_STBY_CFG    ((reg8 *) USBFS_1_USB__PM_STBY_CFG)
#define USBFS_1_PM_STBY_MSK    ((reg8 *) USBFS_1_USB__PM_STBY_MSK)

#define USBFS_1_SIE_EP_INT_EN  ((reg8 *) USBFS_1_USB__SIE_EP_INT_EN)
#define USBFS_1_SIE_EP_INT_SR  ((reg8 *) USBFS_1_USB__SIE_EP_INT_SR)

#define USBFS_1_SIE_EP1_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP1_CNT0)
#define USBFS_1_SIE_EP1_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP1_CNT1)
#define USBFS_1_SIE_EP1_CR0    ((reg8 *) USBFS_1_USB__SIE_EP1_CR0)

#define USBFS_1_SIE_EP2_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP2_CNT0)
#define USBFS_1_SIE_EP2_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP2_CNT1)
#define USBFS_1_SIE_EP2_CR0    ((reg8 *) USBFS_1_USB__SIE_EP2_CR0)

#define USBFS_1_SIE_EP3_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP3_CNT0)
#define USBFS_1_SIE_EP3_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP3_CNT1)
#define USBFS_1_SIE_EP3_CR0    ((reg8 *) USBFS_1_USB__SIE_EP3_CR0)

#define USBFS_1_SIE_EP4_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP4_CNT0)
#define USBFS_1_SIE_EP4_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP4_CNT1)
#define USBFS_1_SIE_EP4_CR0    ((reg8 *) USBFS_1_USB__SIE_EP4_CR0)

#define USBFS_1_SIE_EP5_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP5_CNT0)
#define USBFS_1_SIE_EP5_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP5_CNT1)
#define USBFS_1_SIE_EP5_CR0    ((reg8 *) USBFS_1_USB__SIE_EP5_CR0)

#define USBFS_1_SIE_EP6_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP6_CNT0)
#define USBFS_1_SIE_EP6_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP6_CNT1)
#define USBFS_1_SIE_EP6_CR0    ((reg8 *) USBFS_1_USB__SIE_EP6_CR0)

#define USBFS_1_SIE_EP7_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP7_CNT0)
#define USBFS_1_SIE_EP7_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP7_CNT1)
#define USBFS_1_SIE_EP7_CR0    ((reg8 *) USBFS_1_USB__SIE_EP7_CR0)

#define USBFS_1_SIE_EP8_CNT0   ((reg8 *) USBFS_1_USB__SIE_EP8_CNT0)
#define USBFS_1_SIE_EP8_CNT1   ((reg8 *) USBFS_1_USB__SIE_EP8_CNT1)
#define USBFS_1_SIE_EP8_CR0    ((reg8 *) USBFS_1_USB__SIE_EP8_CR0)

#define USBFS_1_SOF0           ((reg8 *) USBFS_1_USB__SOF0)
#define USBFS_1_SOF1           ((reg8 *) USBFS_1_USB__SOF1)

#define USBFS_1_USB_CLK_EN     ((reg8 *) USBFS_1_USB__USB_CLK_EN)

#define USBFS_1_USBIO_CR0      ((reg8 *) USBFS_1_USB__USBIO_CR0)
#define USBFS_1_USBIO_CR1      ((reg8 *) USBFS_1_USB__USBIO_CR1)
#define USBFS_1_USBIO_CR2      ((reg8 *) USBFS_1_USB__USBIO_CR2)

#define USBFS_1_USB_MEM        ((reg8 *) CYDEV_USB_MEM_BASE)

#define USBFS_1_USB_ISR_PRIOR  ((reg8 *) CYDEV_INTC_PRIOR0)
#define USBFS_1_USB_ISR_SET_EN ((reg8 *) CYDEV_INTC_SET_EN0)
#define USBFS_1_USB_ISR_CLR_EN ((reg8 *) CYDEV_INTC_CLR_EN0)
#define USBFS_1_USB_ISR_VECT   ((reg16 *) CYDEV_INTC_VECT_MBASE)

/************************************************
 *  Interrupt vectors, masks and priorities 
 ************************************************/
#define USBFS_1_BUS_RESET_PRIOR     (USBFS_1_bus_reset__INTC_PRIOR_NUM << 5)
#define USBFS_1_BUS_RESET_MASK      USBFS_1_bus_reset__INTC_MASK
#define USBFS_1_BUS_RESET_VECT_NUM  USBFS_1_bus_reset__INTC_NUMBER
 
#define USBFS_1_SOF_PRIOR     (USBFS_1_sof_int__INTC_PRIOR_NUM << 5)
#define USBFS_1_SOF_MASK      USBFS_1_sof_int__INTC_MASK
#define USBFS_1_SOF_VECT_NUM  USBFS_1_sof_int__INTC_NUMBER
 
#define USBFS_1_EP_0_PRIOR     (USBFS_1_ep_0__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_0_MASK      USBFS_1_ep_0__INTC_MASK
#define USBFS_1_EP_0_VECT_NUM  USBFS_1_ep_0__INTC_NUMBER
 
#define USBFS_1_EP_1_PRIOR     (USBFS_1_ep_1__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_1_MASK      USBFS_1_ep_1__INTC_MASK
#define USBFS_1_EP_1_VECT_NUM  USBFS_1_ep_1__INTC_NUMBER
 
#define USBFS_1_EP_2_PRIOR     (USBFS_1_ep_2__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_2_MASK      USBFS_1_ep_2__INTC_MASK
#define USBFS_1_EP_2_VECT_NUM  USBFS_1_ep_2__INTC_NUMBER
 
#define USBFS_1_EP_3_PRIOR     (USBFS_1_ep_3__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_3_MASK      USBFS_1_ep_3__INTC_MASK
#define USBFS_1_EP_3_VECT_NUM  USBFS_1_ep_3__INTC_NUMBER
 
#define USBFS_1_EP_4_PRIOR     (USBFS_1_ep_4__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_4_MASK      USBFS_1_ep_4__INTC_MASK
#define USBFS_1_EP_4_VECT_NUM  USBFS_1_ep_4__INTC_NUMBER
 
#define USBFS_1_EP_5_PRIOR     (USBFS_1_ep_5__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_5_MASK      USBFS_1_ep_5__INTC_MASK
#define USBFS_1_EP_5_VECT_NUM  USBFS_1_ep_5__INTC_NUMBER
 
#define USBFS_1_EP_6_PRIOR     (USBFS_1_ep_6__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_6_MASK      USBFS_1_ep_6__INTC_MASK
#define USBFS_1_EP_6_VECT_NUM  USBFS_1_ep_6__INTC_NUMBER
 
#define USBFS_1_EP_7_PRIOR     (USBFS_1_ep_7__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_7_MASK      USBFS_1_ep_7__INTC_MASK
#define USBFS_1_EP_7_VECT_NUM  USBFS_1_ep_7__INTC_NUMBER
 
#define USBFS_1_EP_8_PRIOR     (USBFS_1_ep_8__INTC_PRIOR_NUM << 5)
#define USBFS_1_EP_8_MASK      USBFS_1_ep_8__INTC_MASK
#define USBFS_1_EP_8_VECT_NUM  USBFS_1_ep_8__INTC_NUMBER
 
/************************************************
 *  Register Masks 
 ************************************************/
#define USBFS_1_CR1_REG_ENABLE             0x01u
#define USBFS_1_CR1_ENABLE_LOCK            0x02u
#define USBFS_1_CR1_BUS_ACTIVITY           0x04u
#define USBFS_1_EP0_CNT_DATA_TOGGLE        0x80u
#define USBFS_1_EPX_CNT_DATA_TOGGLE        0x80u
#define USBFS_1_CR0_ENABLE                 0x80u

#define USBFS_1_USBIO_CR1_IOMODE           0x80u
#define USBFS_1_USBIO_CR1_DRIVE_MODE       0x40u
#define USBFS_1_USBIO_CR1_DPI              0x20u
#define USBFS_1_USBIO_CR1_DMI              0x10u
#define USBFS_1_USBIO_CR1_P2PUEN           0x08u
#define USBFS_1_USBIO_CR1_USBPUEN          0x04u
#define USBFS_1_USBIO_CR1_DP0              0x02u
#define USBFS_1_USBIO_CR1_DM0              0x01u

#define USBFS_1_FASTCLK_IMO_CR_USBCLK_ON   0x40u
#define USBFS_1_FASTCLK_IMO_CR_XCLKEN      0x20u
#define USBFS_1_FASTCLK_IMO_CR_FX2ON       0x10u

#define USBFS_1_ARB_EPX_CFG_RESET_PTR      0x08u
#define USBFS_1_ARB_EPX_CFG_CRC_BYPASS     0x04u
#define USBFS_1_ARB_EPX_CFG_DMA_REQ        0x02u
#define USBFS_1_ARB_EPX_CFG_IN_DATA_RDY    0x01u

/************************************************
 *  Endpoint 0 offsets (Table 9-2) 
 ************************************************/

#define USBFS_1_bmRequestType   USBFS_1_EP0_DR0
#define USBFS_1_bRequest        USBFS_1_EP0_DR1
#define USBFS_1_wValue          USBFS_1_EP0_DR2
#define USBFS_1_wValueHi        USBFS_1_EP0_DR3
#define USBFS_1_wValueLo        USBFS_1_EP0_DR2
#define USBFS_1_wIndex          USBFS_1_EP0_DR4
#define USBFS_1_wIndexHi        USBFS_1_EP0_DR5
#define USBFS_1_wIndexLo        USBFS_1_EP0_DR4
#define USBFS_1_wLength         USBFS_1_EP0_DR6
#define USBFS_1_wLengthHi       USBFS_1_EP0_DR7
#define USBFS_1_wLengthLo       USBFS_1_EP0_DR6

#define TRUE  1
#define FALSE 0
/************************************************
 *  Optional Features 
 ************************************************/
#define USBFS_1_NUM_DEVICES   1
#define USBFS_1_ENABLE_STRINGS

#define USBFS_1_MON_VBUS       0
#if (USBFS_1_MON_VBUS == 1)
#define USBFS_1_VBUS_DR        ((reg8 *) USBFS_1_VBUS__DR)
#define USBFS_1_VBUS_PS        ((reg8 *) USBFS_1_VBUS__PS)
#define USBFS_1_VBUS_MASK      USBFS_1_VBUS__MASK
#endif

/*******************************************************************************
* typedefs
********************************************************************************/
typedef struct {
    uint8  bAttrib;
    uint8  bAPIEPState;
    uint8  bHWEPState;
    uint8  bEPToggle;
    uint8  bAddr;
    uint8  bEPMode;
    uint16 wBuffOffset;
    uint16 wBufferSize;
} T_USBFS_1_EP_CTL_BLOCK;

typedef struct {
    uint8  bInterface;
    uint8  bAltSetting;
    uint8  bAddr;
    uint8  bmAttributes;
    uint16 wBufferSize;
	uint8  bMisc;
} T_USBFS_1_EP_SETTINGS_BLOCK;

typedef struct {
    uint8  bStatus;
    uint16 wLength;
} T_USBFS_1_XFER_STATUS_BLOCK;

typedef struct {
    uint16  wCount;
    uint8   *pData;
    T_USBFS_1_XFER_STATUS_BLOCK *pStatusBlock;
} T_USBFS_1_TD;

typedef struct {
    uint8   c;
    void    *p_list;
} T_USBFS_1_LUT;

/************************************************
 *  Prototypes of the USBFS_1 API. 
 ************************************************/
extern void   USBFS_1_Start(uint8 bDevice, uint8 bMode);
extern void   USBFS_1_Stop(void);
extern uint8  USBFS_1_bCheckActivity(void);
extern uint8  USBFS_1_bGetConfiguration(void);
extern uint8  USBFS_1_bGetEPState(uint8 bEPNumber);
extern uint16 USBFS_1_wGetEPCount(uint8 bEPNumber);
extern void   USBFS_1_LoadEP(uint8 bEPNumber, uint8 *pData, uint16 wLength);
extern uint16 USBFS_1_ReadOutEP(uint8 bEPNumber, uint8 *pData, uint16 wLength);
extern void   USBFS_1_EnableOutEP(uint8 bEPNumber);
extern void   USBFS_1_DisableOutEP(uint8 bEPNumber);
extern void   USBFS_1_Force(uint8 bState);
extern uint8  USBFS_1_bGetEPAckState(uint8 bEPNumber);
extern void   USBFS_1_SetPowerStatus(uint8 bPowerStaus);
extern uint8  USBFS_1_bRWUEnabled(void);
void USBFS_1_EnableInt(uint8 bVector, uint8 bMask);

#define USBFS_1_LoadInEP(e, p, l)        USBFS_1_LoadEP(e, p, l)
#define USBFS_1_LoadInISOCEP(e, p, l)    USBFS_1_LoadEP(e, p, l)
#define USBFS_1_EnableOutISOCEP(e)       USBFS_1_EnableOutEP(e)

#if (USBFS_1_MON_VBUS == 1)
extern uint8  USBFS_1_bVBusPresent(void);
#endif

#endif
