/*******************************************************************************
* File Name: USBFS_1_descr.c
* Version 0.2
*
*  Description:
*    USB descriptors and storage.
*
*   Note:
*
********************************************************************************
* Copyright (c) 2009, Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express, written permission of Cypress.
*******************************************************************************/

#include "cydevice.h"
#include "cyfitter.h"
#include "USBFS_1.h"

/*******************************************************************************
*  User supplied descriptors.  If you want to specify your own descriptors,
*  remove the comments around the define USER_SUPPLIED_DESCRIPTORS below and
*  add your descriptors.
********************************************************************************/
/* `#START USER_DESCRIPTORS_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
*  USB Customizer Generated Descriptors
********************************************************************************/
#if !defined(USER_SUPPLIED_DESCRIPTORS)
/*********************************************************************
 Device Descriptors
 *********************************************************************/
uint8 USBFS_1_CODE USBFS_1_DEVICE0_DESCR[] = {
/* Descriptor Length                       */ 0x12u,
/* DescriptorType: DEVICE                  */ 0x01u,
/* bcdUSB (ver 2.0)                        */ 0x00u, 0x02u,
/* bDeviceClass                            */ 0x00u,
/* bDeviceSubClass                         */ 0x00u,
/* bDeviceProtocol                         */ 0x00u,
/* bMaxPacketSize0                         */ 0x08u,
/* idVendor                                */ 0xB4u, 0x04u,
/* idProduct                               */ 0x51u, 0x80u,
/* bcdDevice                               */ 0x00u, 0x00u,
/* iManufacturer                           */ 0x01u,
/* iProduct                                */ 0x02u,
/* iSerialNumber                           */ 0x00u,
/* bNumConfigurations                      */ 0x01u
};
/*********************************************************************
 Config Descriptor  
 *********************************************************************/
uint8 USBFS_1_CODE USBFS_1_DEVICE0_CONFIGURATION0_DESCR[] = {
/*  Config Descriptor Length               */ 0x09u,
/*  DescriptorType: CONFIG                 */ 0x02u,
/*  wTotalLength                           */ 0x22u, 0x00u,
/*  bNumInterfaces                         */ 0x02u,
/*  bConfigurationValue                    */ 0x01u,
/*  iConfiguration                         */ 0x00u,
/*  bmAttributes                           */ 0x80u,
/*  bMaxPower                              */ 0xC8u,
/*********************************************************************
 Interface Descriptor
 *********************************************************************/
/*  Interface Descriptor Length            */ 0x09u,
/*  DescriptorType: INTERFACE              */ 0x04u,
/*  bInterfaceNumber                       */ 0x00u,
/*  bAlternateSetting                      */ 0x00u,
/*  bNumEndpoints                          */ 0x00u,
/*  bInterfaceClass                        */ 0x00u,
/*  bInterfaceSubClass                     */ 0x00u,
/*  bInterfaceProtocol                     */ 0x00u,
/*  iInterface                             */ 0x00u,
/*********************************************************************
 Interface Descriptor
 *********************************************************************/
/*  Interface Descriptor Length            */ 0x09u,
/*  DescriptorType: INTERFACE              */ 0x04u,
/*  bInterfaceNumber                       */ 0x01u,
/*  bAlternateSetting                      */ 0x00u,
/*  bNumEndpoints                          */ 0x01u,
/*  bInterfaceClass                        */ 0x00u,
/*  bInterfaceSubClass                     */ 0x00u,
/*  bInterfaceProtocol                     */ 0x00u,
/*  iInterface                             */ 0x00u,
/*********************************************************************
 Endpoint Descriptor
 *********************************************************************/
/*  Endpoint Descriptor Length             */ 0x07u,
/*  DescriptorType: ENDPOINT               */ 0x05u,
/*  bEndpointAddress                       */ 0x81u,
/*  bmAttributes                           */ 0x03u,
/*  wMaxPacketSize                         */ 0x08u, 0x00u,
/*  bInterval                              */ 0x0Au
};

/*********************************************************************
 String Descriptor Table
 *********************************************************************/
uint8 USBFS_1_CODE USBFS_1_STRING_DESCRIPTORS[] = {
/*********************************************************************
 Language ID Descriptor
 *********************************************************************/
/* Descriptor Length                       */ 0x04u,
/* DescriptorType: STRING                  */ 0x03u,
/* Language Id                             */ 0x09u, 0x04u,
/*********************************************************************
 String Descriptor: "Cypress"
 *********************************************************************/
/* Descriptor Length                       */ 0x10u,
/* DescriptorType: STRING                  */ 0x03u,
 'C', 0,'y', 0,'p', 0,'r', 0,'e', 0,'s', 0,'s', 0,
/*********************************************************************
 String Descriptor: "Example"
 *********************************************************************/
/* Descriptor Length                       */ 0x10u,
/* DescriptorType: STRING                  */ 0x03u,
 'E', 0,'x', 0,'a', 0,'m', 0,'p', 0,'l', 0,'e', 0,
/*********************************************************************
/* Marks the end of the list.              */ 0x00u};
/*********************************************************************/





/*********************************************************************
  Endpoint Setting Table -- This table contain the endpoint setting
                            for each endpoint in the configuration.  It
                            contains the necessary information to
                            configure the endpoint hardware for each
                            interface and alternate setting.
  *********************************************************************/
T_USBFS_1_EP_SETTINGS_BLOCK USBFS_1_CODE USBFS_1_DEVICE0_CONFIGURATION0_EP_SETTINGS_TABLE[] = {
/* IFC  ALT    EPAddr bmAttr MaxPktSize BufferType ********************/
{0x01u, 0x00u, 0x81u, 0x03u, 0x0008u,   0x00u}
};
/*********************************************************************
 Config Dispatch Table -- Points to the Config Descriptor and each of
                          and endpoint setup table and to each interface 
                          table if it specifies a USB Class 
 *********************************************************************/
T_USBFS_1_LUT USBFS_1_CODE USBFS_1_DEVICE0_CONFIGURATION0_TABLE[] = {
    {0x01u,     &USBFS_1_DEVICE0_CONFIGURATION0_DESCR},
    {0x01u,     &USBFS_1_DEVICE0_CONFIGURATION0_EP_SETTINGS_TABLE},
    {0x00u,    USBFS_1_NULL},
    {0x00u,    USBFS_1_NULL}
};
/*********************************************************************
 Device Dispatch Table -- Points to the Device Descriptor and each of
                          and Configuration Tables for this Device 
 *********************************************************************/
T_USBFS_1_LUT USBFS_1_CODE USBFS_1_DEVICE0_TABLE[] = {
    {0x01u,     &USBFS_1_DEVICE0_DESCR},
    {0x01u,     &USBFS_1_DEVICE0_CONFIGURATION0_TABLE}
};
/*********************************************************************
 Device Table -- Indexed by the device number.
 *********************************************************************/
T_USBFS_1_LUT USBFS_1_CODE USBFS_1_TABLE[] = {
    {0x01u,     &USBFS_1_DEVICE0_TABLE}
};

#endif
