/*******************************************************************************
* File Name: USBFS_1_episr.c
* Version 0.2
*
*  Description:
*    Data endpoint Interrupt Service Routines
*
*   Note:
*
********************************************************************************
* Copyright (c) 2008, 2009 Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express, written permission of Cypress.
*******************************************************************************/

#include "cyfitter.h"
#include "USBFS_1.h"

/*******************************************************************************
* Custom Declratations
********************************************************************************/
/* `#START CUSTOM_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
* External function references
********************************************************************************/
void USBFS_1_InitComponent(uint8 bDevice, uint8 bMode);
/*******************************************************************************
* External references
********************************************************************************/
extern T_USBFS_1_EP_CTL_BLOCK USBFS_1_EP[];
extern uint8 USBFS_1_bDevice;
/*******************************************************************************
* Function Name: USBFS_1_EP_1_ISR
********************************************************************************
* Summary:
*   Endpoint 1 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_1_ISR)
{
/* `#START EP1_USER_CODE` Place your code here */

/* `#END` */
   CY_GET_REG8(USBFS_1_SIE_EP1_CR0); /* Must read the mode reg */
   USBFS_1_EP[1].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
   USBFS_1_EP[1].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x01);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_2_ISR
********************************************************************************
* Summary:
*   Endpoint 2 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_2_ISR)
{
/* `#START EP1_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP2_CR0); /* Must read the mode reg */
    USBFS_1_EP[2].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[2].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x02);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_3_ISR
********************************************************************************
* Summary:
*   Endpoint 3 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_3_ISR)
{
/* `#START EP3_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP3_CR0); /* Must read the mode reg */
    USBFS_1_EP[3].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[3].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x04);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_4_ISR
********************************************************************************
* Summary:
*   Endpoint 4 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_4_ISR)
{
/* `#START EP4_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP4_CR0); /* Must read the mode reg */
    USBFS_1_EP[4].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[4].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x08);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_5_ISR
********************************************************************************
* Summary:
*   Endpoint 5 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_5_ISR)
{
/* `#START EP5_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP5_CR0); /* Must read the mode reg */
    USBFS_1_EP[5].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[5].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x10);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_6_ISR
********************************************************************************
* Summary:
*   Endpoint 6 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_6_ISR)
{
/* `#START EP6_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP6_CR0); /* Must read the mode reg */
    USBFS_1_EP[6].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[6].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x20);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_7_ISR
********************************************************************************
* Summary:
*   Endpoint 7 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_7_ISR)
{
/* `#START EP7_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP7_CR0); /* Must read the mode reg */
    USBFS_1_EP[7].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[7].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x40);
}
/*******************************************************************************
* Function Name: USBFS_1_EP_8_ISR
********************************************************************************
* Summary:
*   Endpoint 8 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_EP_8_ISR)
{
/* `#START EP8_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_1_SIE_EP8_CR0); /* Must read the mode reg */
    USBFS_1_EP[8].bEPToggle ^= USBFS_1_EPX_CNT_DATA_TOGGLE;
    USBFS_1_EP[8].bAPIEPState = USBFS_1_EVENT_PENDING;
    CY_SET_REG8(USBFS_1_SIE_EP_INT_SR, CY_GET_REG8(USBFS_1_SIE_EP_INT_SR) & ~0x80);
}
/*******************************************************************************
* Function Name: USBFS_1_SOF_ISR
********************************************************************************
* Summary:
*   Start of Frame Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_SOF_ISR)
{
/* `#START SOF_USER_CODE` Place your code here */

/* `#END` */
}
/*******************************************************************************
* Function Name: USBFS_1_BUS_RESET_ISR
********************************************************************************
* Summary:
*   USB Bus Reset Interrupt Service Routine.  Calls _Start with the same 
*   parameters as the last USER call to _Start
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_1_BUS_RESET_ISR)
{
/* `#START BUS_RESET_USER_CODE` Place your code here */

/* `#END` */
	USBFS_1_InitComponent(USBFS_1_bDevice, CY_GET_REG8(USBFS_1_CR1));
}
