/*******************************************************************************
* File Name: USBFS_1_hid.c
* Version 0.2
*
*  Description:
*    USB HID Class request handler.
*
*   Note:
*
********************************************************************************
* Copyright (c) 2009 Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express, written permission of Cypress.
*******************************************************************************/

#include "cydevice.h"
#include "cyfitter.h"
#include "USBFS_1.h"
#include "USBFS_1_hid.h"

#if defined(USBFS_1_ENABLE_HID_CLASS)
/*******************************************************************************
* Custom Declratations
********************************************************************************/
/* `#START CUSTOM_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
* Exxternal references
********************************************************************************/
uint8 USBFS_1_InitControlRead(void);
uint8 USBFS_1_InitControlWrite(void);
uint8 USBFS_1_InitNoDataControlTransfer(void);
T_USBFS_1_LUT *USBFS_1_GetConfigTablePtr(uint8 c);
T_USBFS_1_LUT *USBFS_1_GetDeviceTablePtr();
extern T_USBFS_1_TD CurrentTD;
extern uint8 USBFS_1_CODE USBFS_1_HIDREPORT_DESCRIPTORS[];
extern uint8 USBFS_1_bConfiguration;
/*******************************************************************************
* Exxternal references
********************************************************************************/
void USBFS_1_FindReport(void);

/*******************************************************************************
* Function Name: USBFS_1_UpdateHIDTimer
********************************************************************************
* Summary:
*   Updates the HID report timer and reloads it if it expires
*   
* Parameters:  
*   bInterface Interface Number
*******************************************************************************/
uint8 USBFS_1_UpdateHIDTimer(uint8 bInterface)
{
    uint8 ifc = bInterface;
    return USBFS_1_IDLE_TIMER_INDEFINITE;
}
/*******************************************************************************
* Function Name: USBFS_1_bGetProtocol
********************************************************************************
* Summary:
*   Returns the selected protocol value to the application
*   
* Parameters:  
*   bInterface Interface Number
*******************************************************************************/
uint8 USBFS_1_bGetProtocol(uint8 bInterface)
{
    uint8 ifc = bInterface;
    return USBFS_1_PROTOCOL_REPORT;
}
/*******************************************************************************
* Function Name: USBFS_1_DispatchHIDClassRqst
********************************************************************************
* Summary:
*   This routine dispatches class requests
*   
* Parameters:  
*   None
*******************************************************************************/
uint8 USBFS_1_DispatchHIDClassRqst()
{
    uint8 *pDescr;
    uint8 bRequestHandled = USBFS_1_FALSE;
    T_USBFS_1_LUT *pTmp = USBFS_1_GetConfigTablePtr(USBFS_1_bConfiguration - 1);

    if ((CY_GET_REG8(USBFS_1_bmRequestType) & USBFS_1_RQST_DIR_MASK) == USBFS_1_RQST_DIR_D2H)
    {   /* Control Read */
		switch (*USBFS_1_bRequest) 
		{
			case USBFS_1_GET_DESCRIPTOR:
                if (CY_GET_REG8(USBFS_1_wValueHi) == USBFS_1_DESCR_HID_CLASS)
                {
                    /* pTmp is pointing to the Config Table */
                    /* Next...                              */
				    /* Get the Config Descriptor            */
                    /*   The HID Class Descriptor resides   */
                    /*   inside the config descriptor       */
                    CurrentTD.pData     = &((uint8 *) pTmp->p_list)[18];
                    CurrentTD.wCount    = 9;
					bRequestHandled     = USBFS_1_InitControlRead();
                }
                else if (CY_GET_REG8(USBFS_1_wValueHi) == USBFS_1_DESCR_HID_REPORT)  
				{
                    pDescr = &USBFS_1_HIDREPORT_DESCRIPTORS[0];
                    CurrentTD.wCount    = (uint16) ((pDescr[1] << 8) | pDescr[0]);
                    CurrentTD.pData     = &pDescr[2];
    
                    if (CurrentTD.wCount != 0)
                    {
                        bRequestHandled     = USBFS_1_InitControlRead();
                    }
				}
                break;
            case USBFS_1_HID_GET_REPORT:
                /*******************************************************************************
                * Not Supported -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM_HID_GET_REPORT` Place your code */

                /* `#END` */
                USBFS_1_FindReport();
                bRequestHandled     = USBFS_1_InitControlRead();
                break;
            default:
                break;
        }
    }
    else if ((CY_GET_REG8(USBFS_1_bmRequestType) & USBFS_1_RQST_DIR_MASK) == USBFS_1_RQST_DIR_H2D)
    {   /* Control Write */
		switch (CY_GET_REG8(USBFS_1_bRequest)) 
		{
            case USBFS_1_HID_SET_REPORT:
                /*******************************************************************************
                * Not Supported -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM_HID_SET_REPORT` Place your code */

                /* `#END` */
                USBFS_1_FindReport();
                bRequestHandled     = USBFS_1_InitControlWrite();
                break;
            case USBFS_1_HID_SET_IDLE:
                /*******************************************************************************
                * Incomplete -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM__HID_SET_IDLE` Place your code */

                /* `#END` */
				bRequestHandled     = USBFS_1_InitNoDataControlTransfer();
                break;
            case USBFS_1_HID_SET_PROTOCOL:
                /*******************************************************************************
                * Incomplete -- But leaving a place holder in case someone needs it
                ********************************************************************************/
                /* `#START CUSTOM__HID_SET_PROTOCOL` Place your code */

                /* `#END` */
				bRequestHandled     = USBFS_1_InitNoDataControlTransfer();
                break;
            default:
                break;
        }
    }
    return bRequestHandled;   
}
/*******************************************************************************
* Function Name: USBFS_1_FindReport
********************************************************************************
* Summary:
*   This routine sets up a transfer based on the Interface number, Report Type
*   and Report ID, then loads the CurrentTD structure with the address of the
*   buffer and the size.  The caller has to decide if it is a control read or
*   control write.
*   
* Parameters:  
*   None
*******************************************************************************/
void USBFS_1_FindReport()
{
    T_USBFS_1_LUT *pTmp = USBFS_1_GetConfigTablePtr(USBFS_1_bConfiguration - 1);
    T_USBFS_1_TD *pTD;
    /* Third entry in the LUT starts the Interface Table pointers */
    pTmp++;
    pTmp++;
    /* Now use the request interface number */
    pTmp = &pTmp[CY_GET_REG8(USBFS_1_wIndexLo)];
	pTmp = (T_USBFS_1_LUT *) pTmp->p_list;
    pTmp = (T_USBFS_1_LUT *) pTmp->p_list;
    /* Get the entry proper TD */
    pTD = &((T_USBFS_1_TD *) pTmp->p_list)[CY_GET_REG8(USBFS_1_wValueHi) - 1];

    CurrentTD.pData     = pTD->pData;
    CurrentTD.wCount    = pTD->wCount;
    CurrentTD.pStatusBlock = pTD->pStatusBlock;
}
#endif
