/*******************************************************************************
* File Name: USBFS_1.h
* Version 0.2
*
*  Description:
*    Header File for the USFS component. Contains prototypes and constant values. 
*
********************************************************************************
* Copyright (2008), Cypress Semiconductor Corporation.
********************************************************************************
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*******************************************************************************/
#if !defined(USBFS_1_hid_H)
#define USBFS_1_hid_H

#include "cytypes.h"
/************************************************
 *  Prototypes of the USBFS_1 API. 
 ************************************************/
extern uint8 USBFS_UpdateHIDTimer(uint8 bInterface);
extern uint8 USBFS_bGetProtocol(uint8 bInterface);

/************************************************
 *  Constants for USBFS_1 API. 
 ************************************************/

#define USBFS_1_IDLE_TIMER_RUNNING         0x02
#define USBFS_1_IDLE_TIMER_EXPIRED         0x01
#define USBFS_1_IDLE_TIMER_INDEFINITE      0x00

#define USBFS_1_PROTOCOL_BOOT              0x00
#define USBFS_1_PROTOCOL_REPORT            0x01

/************************************************
 *  Request Types (HID Chapter 7.2) 
 ************************************************/

#define USBFS_1_HID_GET_REPORT       0x01
#define USBFS_1_HID_GET_IDLE         0x02
#define USBFS_1_HID_GET_PROTOCOL     0x03
#define USBFS_1_HID_SET_REPORT       0x09
#define USBFS_1_HID_SET_IDLE         0x0A
#define USBFS_1_HID_SET_PROTOCOL     0x0B

/************************************************
 *  Descriptor Types (HID Chapter 7.1) 
 ************************************************/

#define USBFS_1_DESCR_HID_CLASS         0x21
#define USBFS_1_DESCR_HID_REPORT        0x22
#define USBFS_1_DESCR_HID_PHYSICAL      0x23

#endif
