/*******************************************************************************
* File Name: USBFS.h
* Version 1.30
*
*  Description:
*    Header File for the USFS component. Contains prototypes and constant values. 
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/


#if !defined(USBFS_H)
#define USBFS_H

#include "cytypes.h"

#if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)     
    #if(CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2)      
        #include <intrins.h>
        #define USBFS_ISR_PATCH() _nop_(); _nop_(); _nop_(); _nop_(); _nop_(); _nop_(); _nop_(); _nop_();
    #endif
#endif    

/************************************************
 *  General defines 
 ************************************************/
#if defined(__C51__) || defined(__CX51__)
#ifndef USBFS_CODE
#define USBFS_CODE code
#define USBFS_DATA data
#define USBFS_XDATA xdata
#define USBFS_FAR far
#define USBFS_NULL  ((void *) 0)
#endif
#else
#ifndef USBFS_CODE
#define USBFS_CODE
#define USBFS_DATA
#define USBFS_XDATA
#define USBFS_FAR
#define USBFS_NULL  ((void *) 0)
#endif
#endif

/************************************************
 *  Customizer Defines 
 ************************************************/
#define USBFS_NUM_DEVICES   1
#define USBFS_ENABLE_DESCRIPTOR_STRINGS
#define USBFS_ENABLE_MSOS_STRING
#define USBFS_ENABLE_SN_STRING
#define USBFS_ENABLE_STRINGS
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_BUF_SIZE   8
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_IN_RPTS   1
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_BUF_SIZE   8
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_OUT_RPTS   1
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_COUNT   1
#define USBFS_ENABLE_HID_CLASS
#define USBFS_HID_RPT_1_SIZE_LSB   0x28u
#define USBFS_HID_RPT_1_SIZE_MSB   0x00u

#define USBFS_MON_VBUS                   0
#define USBFS_EP0_ISR_REMOVE             0
#define USBFS_EP1_ISR_REMOVE             0
#define USBFS_EP2_ISR_REMOVE             0
#define USBFS_EP3_ISR_REMOVE             1
#define USBFS_EP4_ISR_REMOVE             1
#define USBFS_EP5_ISR_REMOVE             1
#define USBFS_EP6_ISR_REMOVE             1
#define USBFS_EP7_ISR_REMOVE             1
#define USBFS_EP8_ISR_REMOVE             1
#if (USBFS_MON_VBUS == 1)
#define USBFS_VBUS_DR                    ((reg8 *) USBFS_VBUS__DR)
#define USBFS_VBUS_PS                    ((reg8 *) USBFS_VBUS__PS)
#define USBFS_VBUS_MASK                  USBFS_VBUS__MASK
#endif

/************************************************
 *  Constants for USBFS API. 
 ************************************************/
#define USBFS_TRUE                       1
#define USBFS_FALSE                      0

#define USBFS_NO_EVENT_ALLOWED           2
#define USBFS_EVENT_PENDING              1
#define USBFS_NO_EVENT_PENDING           0

#define USBFS_IN_BUFFER_FULL             USBFS_NO_EVENT_PENDING
#define USBFS_IN_BUFFER_EMPTY            USBFS_EVENT_PENDING
#define USBFS_OUT_BUFFER_FULL            USBFS_EVENT_PENDING
#define USBFS_OUT_BUFFER_EMPTY           USBFS_NO_EVENT_PENDING

#define USBFS_FORCE_J                    0xA0
#define USBFS_FORCE_K                    0x80
#define USBFS_FORCE_SE0                  0xC0
#define USBFS_FORCE_NONE                 0x00

#define USBFS_IDLE_TIMER_RUNNING         0x02
#define USBFS_IDLE_TIMER_EXPIRED         0x01
#define USBFS_IDLE_TIMER_INDEFINITE      0x00

#define USBFS_DEVICE_STATUS_BUS_POWERED  0x00
#define USBFS_DEVICE_STATUS_SELF_POWERED 0x01

#define USBFS_3V_OPERATION               0x02
#define USBFS_5V_OPERATION               0x03

#define USBFS_MODE_DISABLE               0x00
#define	USBFS_MODE_NAK_IN_OUT            0x01
#define	USBFS_MODE_STATUS_OUT_ONLY       0x02
#define	USBFS_MODE_STALL_IN_OUT          0x03
#define	USBFS_MODE_RESERVED_0100         0x04
#define	USBFS_MODE_ISO_OUT               0x05
#define	USBFS_MODE_STATUS_IN_ONLY        0x06
#define	USBFS_MODE_ISO_IN                0x07
#define	USBFS_MODE_NAK_OUT               0x08
#define	USBFS_MODE_ACK_OUT               0x09
#define	USBFS_MODE_RESERVED_1010         0x0A
#define	USBFS_MODE_ACK_OUT_STATUS_IN     0x0B
#define	USBFS_MODE_NAK_IN                0x0C
#define	USBFS_MODE_ACK_IN                0x0D
#define	USBFS_MODE_RESERVED_1110         0x0E
#define	USBFS_MODE_ACK_IN_STATUS_OUT     0x0F
#define	USBFS_MODE_STALL_DATA_EP         0x80

#define USBFS_MODE_ACKD                  0x10
#define USBFS_MODE_OUT_RCVD              0x20
#define USBFS_MODE_IN_RCVD               0x40
#define USBFS_MODE_SETUP_RCVD            0x80

#define USBFS_RQST_TYPE_MASK             0x60
#define USBFS_RQST_TYPE_STD              0x00
#define USBFS_RQST_TYPE_CLS              0x20
#define USBFS_RQST_TYPE_VND              0x40
#define USBFS_RQST_DIR_MASK              0x80
#define USBFS_RQST_DIR_D2H               0x80
#define USBFS_RQST_DIR_H2D               0x00
#define USBFS_RQST_RCPT_MASK             0x03
#define USBFS_RQST_RCPT_DEV              0x00
#define USBFS_RQST_RCPT_IFC              0x01
#define USBFS_RQST_RCPT_EP               0x02
#define USBFS_RQST_RCPT_OTHER            0x03

/************************************************
 *  Standard Request Types (Table 9-4) 
 ************************************************/
#define USBFS_GET_STATUS           0x00
#define USBFS_CLEAR_FEATURE        0x01
#define USBFS_SET_FEATURE          0x03
#define USBFS_SET_ADDRESS          0x05
#define USBFS_GET_DESCRIPTOR       0x06
#define USBFS_SET_DESCRIPTOR       0x07
#define USBFS_GET_CONFIGURATION    0x08
#define USBFS_SET_CONFIGURATION    0x09
#define USBFS_GET_INTERFACE        0x0A
#define USBFS_SET_INTERFACE        0x0B
#define USBFS_SYNCH_FRAME          0x0C

/************************************************
 *  Vendor Specific Request Types 
 ************************************************/
 /*Request for Microsoft OS String Descriptor*/
#define USBFS_GET_CONFIG_DESCRIPTOR 0x01
/************************************************
 *  Descriptor Types (Table 9-5) 
 ************************************************/

#define USBFS_DESCR_DEVICE           1
#define USBFS_DESCR_CONFIG           2
#define USBFS_DESCR_STRING           3
#define USBFS_DESCR_INTERFACE        4
#define USBFS_DESCR_ENDPOINT         5
#define USBFS_DESCR_DEVICE_QUALIFIER 6
#define USBFS_DESCR_OTHER_SPEED      7
#define USBFS_DESCR_INTERFACE_POWER  8

/************************************************
 *  Device Descriptor Shifts 
 ************************************************/
#define USBFS_DEVICE_DESCR_SN_SHIFT	16

/************************************************
 *  Feature Selectors (Table 9-6)
 ************************************************/
#define USBFS_DEVICE_REMOTE_WAKEUP    0x01
#define USBFS_ENDPOINT_HALT           0x00
#define USBFS_TEST_MODE               0x02

/************************************************
 *  USB Device Status (Figure 9-4)
 ************************************************/
#define USBFS_DEVICE_STATUS_BUS_POWERED   0x00
#define USBFS_DEVICE_STATUS_SELF_POWERED  0x01
#define USBFS_DEVICE_STATUS_REMOTE_WAKEUP 0x02

/************************************************
 *  USB Endpoint Status (Figure 9-4)
 ************************************************/
#define USBFS_ENDPOINT_STATUS_HALT        0x01

/************************************************
 *  USB Endpoint Directions 
 ************************************************/
#define USBFS_DIR_IN                          0x80
#define USBFS_DIR_OUT                         0x00
#define USBFS_DIR_UNUSED                      0x7F
/************************************************
 *  USB Endpoint Attributes 
 ************************************************/
#define USBFS_EP_TYPE_CTRL                    0x00
#define USBFS_EP_TYPE_ISOC                    0x01
#define USBFS_EP_TYPE_BULK                    0x02
#define USBFS_EP_TYPE_INT                     0x03
#define USBFS_EP_TYPE_MASK                    0x03

#define USBFS_EP_SYNC_TYPE_NO_SYNC            0x00
#define USBFS_EP_SYNC_TYPE_ASYNC              0x04
#define USBFS_EP_SYNC_TYPE_ADAPTIVE           0x08
#define USBFS_EP_SYNC_TYPE_SYNCHRONOUS        0x0C
#define USBFS_EP_SYNC_TYPE_MASK               0x0C

#define USBFS_EP_USAGE_TYPE_DATA              0x00
#define USBFS_EP_USAGE_TYPE_FEEDBACK          0x10
#define USBFS_EP_USAGE_TYPE_IMPLICIT          0x20
#define USBFS_EP_USAGE_TYPE_RESERVED          0x30
#define USBFS_EP_USAGE_TYPE_MASK              0x30

/************************************************
 *  Transfer Completion Notification 
 ************************************************/
#define USBFS_XFER_IDLE                       0x00
#define USBFS_XFER_STATUS_ACK                 0x01
#define USBFS_XFER_PREMATURE                  0x02
#define USBFS_XFER_ERROR                      0x03

/*******************************************************************************
* Driver State defines
********************************************************************************/
#define USBFS_TRANS_STATE_IDLE             0x00
#define USBFS_TRANS_STATE_CONTROL_READ     0x02
#define USBFS_TRANS_STATE_CONTROL_WRITE    0x04
#define USBFS_TRANS_STATE_NO_DATA_CONTROL  0x06

/************************************************
 *  USB, ARB, SIE register definitions 
 ************************************************/
#define USBFS_ARB_CFG        ((reg8 *) USBFS_USB__ARB_CFG)

#define USBFS_ARB_EP1_CFG    ((reg8 *) USBFS_USB__ARB_EP1_CFG)
#define USBFS_ARB_EP1_INT_EN ((reg8 *) USBFS_USB__ARB_EP1_INT_EN)
#define USBFS_ARB_EP1_SR     ((reg8 *) USBFS_USB__ARB_EP1_SR)

#define USBFS_ARB_EP2_CFG    ((reg8 *) USBFS_USB__ARB_EP2_CFG)
#define USBFS_ARB_EP2_INT_EN ((reg8 *) USBFS_USB__ARB_EP2_INT_EN)
#define USBFS_ARB_EP2_SR     ((reg8 *) USBFS_USB__ARB_EP2_SR)

#define USBFS_ARB_EP3_CFG    ((reg8 *) USBFS_USB__ARB_EP3_CFG)
#define USBFS_ARB_EP3_INT_EN ((reg8 *) USBFS_USB__ARB_EP3_INT_EN)
#define USBFS_ARB_EP3_SR     ((reg8 *) USBFS_USB__ARB_EP3_SR)

#define USBFS_ARB_EP4_CFG    ((reg8 *) USBFS_USB__ARB_EP4_CFG)
#define USBFS_ARB_EP4_INT_EN ((reg8 *) USBFS_USB__ARB_EP4_INT_EN)
#define USBFS_ARB_EP4_SR     ((reg8 *) USBFS_USB__ARB_EP4_SR)

#define USBFS_ARB_EP5_CFG    ((reg8 *) USBFS_USB__ARB_EP5_CFG)
#define USBFS_ARB_EP5_INT_EN ((reg8 *) USBFS_USB__ARB_EP5_INT_EN)
#define USBFS_ARB_EP5_SR     ((reg8 *) USBFS_USB__ARB_EP5_SR)

#define USBFS_ARB_EP6_CFG    ((reg8 *) USBFS_USB__ARB_EP6_CFG)
#define USBFS_ARB_EP6_INT_EN ((reg8 *) USBFS_USB__ARB_EP6_INT_EN)
#define USBFS_ARB_EP6_SR     ((reg8 *) USBFS_USB__ARB_EP6_SR)

#define USBFS_ARB_EP7_CFG    ((reg8 *) USBFS_USB__ARB_EP7_CFG)
#define USBFS_ARB_EP7_INT_EN ((reg8 *) USBFS_USB__ARB_EP7_INT_EN)
#define USBFS_ARB_EP7_SR     ((reg8 *) USBFS_USB__ARB_EP7_SR)

#define USBFS_ARB_EP8_CFG    ((reg8 *) USBFS_USB__ARB_EP8_CFG)
#define USBFS_ARB_EP8_INT_EN ((reg8 *) USBFS_USB__ARB_EP8_INT_EN)
#define USBFS_ARB_EP8_SR     ((reg8 *) USBFS_USB__ARB_EP8_SR)

#define USBFS_ARB_INT_EN     ((reg8 *) USBFS_USB__ARB_INT_EN)
#define USBFS_ARB_INT_SR     ((reg8 *) USBFS_USB__ARB_INT_SR)

#define USBFS_ARB_RW1_DR     ((reg8 *) USBFS_USB__ARB_RW1_DR)
#define USBFS_ARB_RW1_RA     ((reg8 *) USBFS_USB__ARB_RW1_RA)
#define USBFS_ARB_RW1_RA_MSB ((reg8 *) USBFS_USB__ARB_RW1_RA_MSB)
#define USBFS_ARB_RW1_WA     ((reg8 *) USBFS_USB__ARB_RW1_WA)
#define USBFS_ARB_RW1_WA_MSB ((reg8 *) USBFS_USB__ARB_RW1_WA_MSB)

#define USBFS_ARB_RW2_DR     ((reg8 *) USBFS_USB__ARB_RW2_DR)
#define USBFS_ARB_RW2_RA     ((reg8 *) USBFS_USB__ARB_RW2_RA)
#define USBFS_ARB_RW2_RA_MSB ((reg8 *) USBFS_USB__ARB_RW2_RA_MSB)
#define USBFS_ARB_RW2_WA     ((reg8 *) USBFS_USB__ARB_RW2_WA)
#define USBFS_ARB_RW2_WA_MSB ((reg8 *) USBFS_USB__ARB_RW2_WA_MSB)

#define USBFS_ARB_RW3_DR     ((reg8 *) USBFS_USB__ARB_RW3_DR)
#define USBFS_ARB_RW3_RA     ((reg8 *) USBFS_USB__ARB_RW3_RA)
#define USBFS_ARB_RW3_RA_MSB ((reg8 *) USBFS_USB__ARB_RW3_RA_MSB)
#define USBFS_ARB_RW3_WA     ((reg8 *) USBFS_USB__ARB_RW3_WA)
#define USBFS_ARB_RW3_WA_MSB ((reg8 *) USBFS_USB__ARB_RW3_WA_MSB)

#define USBFS_ARB_RW4_DR     ((reg8 *) USBFS_USB__ARB_RW4_DR)
#define USBFS_ARB_RW4_RA     ((reg8 *) USBFS_USB__ARB_RW4_RA)
#define USBFS_ARB_RW4_RA_MSB ((reg8 *) USBFS_USB__ARB_RW4_RA_MSB)
#define USBFS_ARB_RW4_WA     ((reg8 *) USBFS_USB__ARB_RW4_WA)
#define USBFS_ARB_RW4_WA_MSB ((reg8 *) USBFS_USB__ARB_RW4_WA_MSB)

#define USBFS_ARB_RW5_DR     ((reg8 *) USBFS_USB__ARB_RW5_DR)
#define USBFS_ARB_RW5_RA     ((reg8 *) USBFS_USB__ARB_RW5_RA)
#define USBFS_ARB_RW5_RA_MSB ((reg8 *) USBFS_USB__ARB_RW5_RA_MSB)
#define USBFS_ARB_RW5_WA     ((reg8 *) USBFS_USB__ARB_RW5_WA)
#define USBFS_ARB_RW5_WA_MSB ((reg8 *) USBFS_USB__ARB_RW5_WA_MSB)

#define USBFS_ARB_RW6_DR     ((reg8 *) USBFS_USB__ARB_RW6_DR)
#define USBFS_ARB_RW6_RA     ((reg8 *) USBFS_USB__ARB_RW6_RA)
#define USBFS_ARB_RW6_RA_MSB ((reg8 *) USBFS_USB__ARB_RW6_RA_MSB)
#define USBFS_ARB_RW6_WA     ((reg8 *) USBFS_USB__ARB_RW6_WA)
#define USBFS_ARB_RW6_WA_MSB ((reg8 *) USBFS_USB__ARB_RW6_WA_MSB)

#define USBFS_ARB_RW7_DR     ((reg8 *) USBFS_USB__ARB_RW7_DR)
#define USBFS_ARB_RW7_RA     ((reg8 *) USBFS_USB__ARB_RW7_RA)
#define USBFS_ARB_RW7_RA_MSB ((reg8 *) USBFS_USB__ARB_RW7_RA_MSB)
#define USBFS_ARB_RW7_WA     ((reg8 *) USBFS_USB__ARB_RW7_WA)
#define USBFS_ARB_RW7_WA_MSB ((reg8 *) USBFS_USB__ARB_RW7_WA_MSB)

#define USBFS_ARB_RW8_DR     ((reg8 *) USBFS_USB__ARB_RW8_DR)
#define USBFS_ARB_RW8_RA     ((reg8 *) USBFS_USB__ARB_RW8_RA)
#define USBFS_ARB_RW8_RA_MSB ((reg8 *) USBFS_USB__ARB_RW8_RA_MSB)
#define USBFS_ARB_RW8_WA     ((reg8 *) USBFS_USB__ARB_RW8_WA)
#define USBFS_ARB_RW8_WA_MSB ((reg8 *) USBFS_USB__ARB_RW8_WA_MSB)

#define USBFS_BUF_SIZE       ((reg8 *) USBFS_USB__BUF_SIZE)
#define USBFS_BUS_RST_CNT    ((reg8 *) USBFS_USB__BUS_RST_CNT)
#define USBFS_CR0            ((reg8 *) USBFS_USB__CR0)
#define USBFS_CR1            ((reg8 *) USBFS_USB__CR1)
#define USBFS_CWA            ((reg8 *) USBFS_USB__CWA)
#define USBFS_CWA_MSB        ((reg8 *) USBFS_USB__CWA_MSB)

#define USBFS_DMA_THRES      ((reg8 *) USBFS_USB__DMA_THRES)
#define USBFS_DMA_THRES_MSB  ((reg8 *) USBFS_USB__DMA_THRES_MSB)

#define USBFS_EP_ACTIVE      ((reg8 *) USBFS_USB__EP_ACTIVE)
#define USBFS_EP_TYPE        ((reg8 *) USBFS_USB__EP_TYPE)

#define USBFS_EP0_CNT        ((reg8 *) USBFS_USB__EP0_CNT)
#define USBFS_EP0_CR         ((reg8 *) USBFS_USB__EP0_CR)
#define USBFS_EP0_DR0        ((reg8 *) USBFS_USB__EP0_DR0)
#define USBFS_EP0_DR1        ((reg8 *) USBFS_USB__EP0_DR1)
#define USBFS_EP0_DR2        ((reg8 *) USBFS_USB__EP0_DR2)
#define USBFS_EP0_DR3        ((reg8 *) USBFS_USB__EP0_DR3)
#define USBFS_EP0_DR4        ((reg8 *) USBFS_USB__EP0_DR4)
#define USBFS_EP0_DR5        ((reg8 *) USBFS_USB__EP0_DR5)
#define USBFS_EP0_DR6        ((reg8 *) USBFS_USB__EP0_DR6)
#define USBFS_EP0_DR7        ((reg8 *) USBFS_USB__EP0_DR7)

#define USBFS_OSCLK_DR0      ((reg8 *) USBFS_USB__OSCLK_DR0)
#define USBFS_OSCLK_DR1      ((reg8 *) USBFS_USB__OSCLK_DR1)

#define USBFS_PM_ACT_CFG     ((reg8 *) USBFS_USB__PM_ACT_CFG)
#define USBFS_PM_ACT_MSK     ((reg8 *) USBFS_USB__PM_ACT_MSK)
#define USBFS_PM_STBY_CFG    ((reg8 *) USBFS_USB__PM_STBY_CFG)
#define USBFS_PM_STBY_MSK    ((reg8 *) USBFS_USB__PM_STBY_MSK)

#define USBFS_SIE_EP_INT_EN  ((reg8 *) USBFS_USB__SIE_EP_INT_EN)
#define USBFS_SIE_EP_INT_SR  ((reg8 *) USBFS_USB__SIE_EP_INT_SR)

#define USBFS_SIE_EP1_CNT0   ((reg8 *) USBFS_USB__SIE_EP1_CNT0)
#define USBFS_SIE_EP1_CNT1   ((reg8 *) USBFS_USB__SIE_EP1_CNT1)
#define USBFS_SIE_EP1_CR0    ((reg8 *) USBFS_USB__SIE_EP1_CR0)

#define USBFS_SIE_EP2_CNT0   ((reg8 *) USBFS_USB__SIE_EP2_CNT0)
#define USBFS_SIE_EP2_CNT1   ((reg8 *) USBFS_USB__SIE_EP2_CNT1)
#define USBFS_SIE_EP2_CR0    ((reg8 *) USBFS_USB__SIE_EP2_CR0)

#define USBFS_SIE_EP3_CNT0   ((reg8 *) USBFS_USB__SIE_EP3_CNT0)
#define USBFS_SIE_EP3_CNT1   ((reg8 *) USBFS_USB__SIE_EP3_CNT1)
#define USBFS_SIE_EP3_CR0    ((reg8 *) USBFS_USB__SIE_EP3_CR0)

#define USBFS_SIE_EP4_CNT0   ((reg8 *) USBFS_USB__SIE_EP4_CNT0)
#define USBFS_SIE_EP4_CNT1   ((reg8 *) USBFS_USB__SIE_EP4_CNT1)
#define USBFS_SIE_EP4_CR0    ((reg8 *) USBFS_USB__SIE_EP4_CR0)

#define USBFS_SIE_EP5_CNT0   ((reg8 *) USBFS_USB__SIE_EP5_CNT0)
#define USBFS_SIE_EP5_CNT1   ((reg8 *) USBFS_USB__SIE_EP5_CNT1)
#define USBFS_SIE_EP5_CR0    ((reg8 *) USBFS_USB__SIE_EP5_CR0)

#define USBFS_SIE_EP6_CNT0   ((reg8 *) USBFS_USB__SIE_EP6_CNT0)
#define USBFS_SIE_EP6_CNT1   ((reg8 *) USBFS_USB__SIE_EP6_CNT1)
#define USBFS_SIE_EP6_CR0    ((reg8 *) USBFS_USB__SIE_EP6_CR0)

#define USBFS_SIE_EP7_CNT0   ((reg8 *) USBFS_USB__SIE_EP7_CNT0)
#define USBFS_SIE_EP7_CNT1   ((reg8 *) USBFS_USB__SIE_EP7_CNT1)
#define USBFS_SIE_EP7_CR0    ((reg8 *) USBFS_USB__SIE_EP7_CR0)

#define USBFS_SIE_EP8_CNT0   ((reg8 *) USBFS_USB__SIE_EP8_CNT0)
#define USBFS_SIE_EP8_CNT1   ((reg8 *) USBFS_USB__SIE_EP8_CNT1)
#define USBFS_SIE_EP8_CR0    ((reg8 *) USBFS_USB__SIE_EP8_CR0)

#define USBFS_SOF0           ((reg8 *) USBFS_USB__SOF0)
#define USBFS_SOF1           ((reg8 *) USBFS_USB__SOF1)

#define USBFS_USB_CLK_EN     ((reg8 *) USBFS_USB__USB_CLK_EN)

#define USBFS_USBIO_CR0      ((reg8 *) USBFS_USB__USBIO_CR0)
#define USBFS_USBIO_CR1      ((reg8 *) USBFS_USB__USBIO_CR1)
#define USBFS_USBIO_CR2      ((reg8 *) USBFS_USB__USBIO_CR2)

#define USBFS_USB_MEM        ((reg8 *) CYDEV_USB_MEM_BASE)

#if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
    /* PSoC3 interrupt registers*/
    #define USBFS_USB_ISR_PRIOR  ((reg8 *) CYDEV_INTC_PRIOR0)
    #define USBFS_USB_ISR_SET_EN ((reg8 *) CYDEV_INTC_SET_EN0)
    #define USBFS_USB_ISR_CLR_EN ((reg8 *) CYDEV_INTC_CLR_EN0)
    #define USBFS_USB_ISR_VECT   ((cyisraddress *) CYDEV_INTC_VECT_MBASE)
#else
#if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_PANTHER)
    /* PSoC5 interrupt registers*/ 
    #define USBFS_USB_ISR_PRIOR  ((reg8 *) CYDEV_NVIC_PRI_0)
    #define USBFS_USB_ISR_SET_EN ((reg8 *) CYDEV_NVIC_SETENA0)
    #define USBFS_USB_ISR_CLR_EN ((reg8 *) CYDEV_NVIC_CLRENA0)
    #define USBFS_USB_ISR_VECT   ((cyisraddress *) CYDEV_NVIC_VECT_OFFSET)
#endif
#endif

/************************************************
 *  Interrupt vectors, masks and priorities 
 ************************************************/
#define USBFS_BUS_RESET_PRIOR     USBFS_bus_reset__INTC_PRIOR_NUM
#define USBFS_BUS_RESET_MASK      USBFS_bus_reset__INTC_MASK
#define USBFS_BUS_RESET_VECT_NUM  USBFS_bus_reset__INTC_NUMBER
 
#define USBFS_SOF_PRIOR     USBFS_sof_int__INTC_PRIOR_NUM 
#define USBFS_SOF_MASK      USBFS_sof_int__INTC_MASK
#define USBFS_SOF_VECT_NUM  USBFS_sof_int__INTC_NUMBER
 
#define USBFS_EP_0_PRIOR     USBFS_ep_0__INTC_PRIOR_NUM
#define USBFS_EP_0_MASK      USBFS_ep_0__INTC_MASK
#define USBFS_EP_0_VECT_NUM  USBFS_ep_0__INTC_NUMBER
 
#define USBFS_EP_1_PRIOR     USBFS_ep_1__INTC_PRIOR_NUM 
#define USBFS_EP_1_MASK      USBFS_ep_1__INTC_MASK
#define USBFS_EP_1_VECT_NUM  USBFS_ep_1__INTC_NUMBER
 
#define USBFS_EP_2_PRIOR     USBFS_ep_2__INTC_PRIOR_NUM 
#define USBFS_EP_2_MASK      USBFS_ep_2__INTC_MASK
#define USBFS_EP_2_VECT_NUM  USBFS_ep_2__INTC_NUMBER
 
#define USBFS_EP_3_PRIOR     USBFS_ep_3__INTC_PRIOR_NUM
#define USBFS_EP_3_MASK      USBFS_ep_3__INTC_MASK
#define USBFS_EP_3_VECT_NUM  USBFS_ep_3__INTC_NUMBER
 
#define USBFS_EP_4_PRIOR     USBFS_ep_4__INTC_PRIOR_NUM 
#define USBFS_EP_4_MASK      USBFS_ep_4__INTC_MASK
#define USBFS_EP_4_VECT_NUM  USBFS_ep_4__INTC_NUMBER
 
#define USBFS_EP_5_PRIOR     USBFS_ep_5__INTC_PRIOR_NUM
#define USBFS_EP_5_MASK      USBFS_ep_5__INTC_MASK
#define USBFS_EP_5_VECT_NUM  USBFS_ep_5__INTC_NUMBER
 
#define USBFS_EP_6_PRIOR     USBFS_ep_6__INTC_PRIOR_NUM
#define USBFS_EP_6_MASK      USBFS_ep_6__INTC_MASK
#define USBFS_EP_6_VECT_NUM  USBFS_ep_6__INTC_NUMBER
 
#define USBFS_EP_7_PRIOR     USBFS_ep_7__INTC_PRIOR_NUM 
#define USBFS_EP_7_MASK      USBFS_ep_7__INTC_MASK
#define USBFS_EP_7_VECT_NUM  USBFS_ep_7__INTC_NUMBER
 
#define USBFS_EP_8_PRIOR     USBFS_ep_8__INTC_PRIOR_NUM
#define USBFS_EP_8_MASK      USBFS_ep_8__INTC_MASK
#define USBFS_EP_8_VECT_NUM  USBFS_ep_8__INTC_NUMBER
 
/************************************************
 *  Register Masks 
 ************************************************/
#define USBFS_CR1_REG_ENABLE             0x01u
#define USBFS_CR1_ENABLE_LOCK            0x02u
#define USBFS_CR1_BUS_ACTIVITY           0x04u
#define USBFS_EP0_CNT_DATA_TOGGLE        0x80u
#define USBFS_EPX_CNT_DATA_TOGGLE        0x80u
#define USBFS_EPX_CNT0_MASK              0x07u
#define USBFS_CR0_ENABLE                 0x80u

#define USBFS_USBIO_CR1_IOMODE           0x80u
#define USBFS_USBIO_CR1_DRIVE_MODE       0x40u
#define USBFS_USBIO_CR1_DPI              0x20u
#define USBFS_USBIO_CR1_DMI              0x10u
#define USBFS_USBIO_CR1_P2PUEN           0x08u
#define USBFS_USBIO_CR1_USBPUEN          0x04u
#define USBFS_USBIO_CR1_DP0              0x02u
#define USBFS_USBIO_CR1_DM0              0x01u

#define USBFS_FASTCLK_IMO_CR_USBCLK_ON   0x40u
#define USBFS_FASTCLK_IMO_CR_XCLKEN      0x20u
#define USBFS_FASTCLK_IMO_CR_FX2ON       0x10u

#define USBFS_ARB_EPX_CFG_RESET_PTR      0x08u
#define USBFS_ARB_EPX_CFG_CRC_BYPASS     0x04u
#define USBFS_ARB_EPX_CFG_DMA_REQ        0x02u
#define USBFS_ARB_EPX_CFG_IN_DATA_RDY    0x01u

/************************************************
 *  Endpoint 0 offsets (Table 9-2) 
 ************************************************/

#define USBFS_bmRequestType   USBFS_EP0_DR0
#define USBFS_bRequest        USBFS_EP0_DR1
#define USBFS_wValue          USBFS_EP0_DR2
#define USBFS_wValueHi        USBFS_EP0_DR3
#define USBFS_wValueLo        USBFS_EP0_DR2
#define USBFS_wIndex          USBFS_EP0_DR4
#define USBFS_wIndexHi        USBFS_EP0_DR5
#define USBFS_wIndexLo        USBFS_EP0_DR4
#define USBFS_wLength         USBFS_EP0_DR6
#define USBFS_wLengthHi       USBFS_EP0_DR7
#define USBFS_wLengthLo       USBFS_EP0_DR6

#define TRUE  1
#define FALSE 0
/************************************************
 *  Optional Features 
 ************************************************/
#define USBFS_NUM_DEVICES   1
#define USBFS_ENABLE_DESCRIPTOR_STRINGS
#define USBFS_ENABLE_MSOS_STRING
#define USBFS_ENABLE_SN_STRING
#define USBFS_ENABLE_STRINGS
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_BUF_SIZE   8
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_IN_RPTS   1
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_BUF_SIZE   8
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_OUT_RPTS   1
#define USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_COUNT   1
#define USBFS_ENABLE_HID_CLASS
#define USBFS_HID_RPT_1_SIZE_LSB   0x28u
#define USBFS_HID_RPT_1_SIZE_MSB   0x00u


#if (USBFS_MON_VBUS == 1)
#define USBFS_VBUS_DR        ((reg8 *) USBFS_VBUS__DR)
#define USBFS_VBUS_PS        ((reg8 *) USBFS_VBUS__PS)
#define USBFS_VBUS_MASK      USBFS_VBUS__MASK
#endif

/*******************************************************************************
* typedefs
********************************************************************************/
typedef struct {
    uint8  bAttrib;
    uint8  bAPIEPState;
    uint8  bHWEPState;
    uint8  bEPToggle;
    uint8  bAddr;
    uint8  bEPMode;
    uint16 wBuffOffset;
    uint16 wBufferSize;
} T_USBFS_EP_CTL_BLOCK;

typedef struct {
    uint8  bInterface;
    uint8  bAltSetting;
    uint8  bAddr;
    uint8  bmAttributes;
    uint16 wBufferSize;
	uint8  bMisc;
} T_USBFS_EP_SETTINGS_BLOCK;

typedef struct {
    uint8  bStatus;
    uint16 wLength;
} T_USBFS_XFER_STATUS_BLOCK;

typedef struct {
    uint16  wCount;
    uint8   *pData;
    T_USBFS_XFER_STATUS_BLOCK *pStatusBlock;
} T_USBFS_TD;

typedef struct {
    uint8   c;
    void    *p_list;
} T_USBFS_LUT;

/************************************************
 *  Prototypes of the USBFS API. 
 ************************************************/
extern void   USBFS_Start(uint8 bDevice, uint8 bMode);
extern void   USBFS_Stop(void);
extern uint8  USBFS_bCheckActivity(void);
extern uint8  USBFS_bGetConfiguration(void);
uint8  USBFS_bGetInterfaceSetting(uint8 ifc);
extern uint8  USBFS_bGetEPState(uint8 bEPNumber);
extern uint16 USBFS_wGetEPCount(uint8 bEPNumber);
extern void   USBFS_LoadEP(uint8 bEPNumber, uint8 *pData, uint16 wLength);
extern uint16 USBFS_ReadOutEP(uint8 bEPNumber, uint8 *pData, uint16 wLength);
extern void   USBFS_EnableOutEP(uint8 bEPNumber);
extern void   USBFS_DisableOutEP(uint8 bEPNumber);
extern void   USBFS_Force(uint8 bState);
extern uint8  USBFS_bGetEPAckState(uint8 bEPNumber);
extern void   USBFS_SetPowerStatus(uint8 bPowerStaus);
extern uint8  USBFS_bRWUEnabled(void);
extern void  USBFS_SerialNumString(uint8 *SNstring);


#define USBFS_LoadInEP(e, p, l)        USBFS_LoadEP(e, p, l)
#define USBFS_LoadInISOCEP(e, p, l)    USBFS_LoadEP(e, p, l)
#define USBFS_EnableOutISOCEP(e)       USBFS_EnableOutEP(e)

#if (USBFS_MON_VBUS == 1)
extern uint8  USBFS_bVBusPresent(void);
#endif

#endif
