/*******************************************************************************
* File Name: USBFS_descr.c
* Version 1.30
*
*  Description:
*    USB descriptors and storage.
*
*   Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/



#include "cydevice_trm.h"
#include "cyfitter.h"
#include "USBFS.h"

/*******************************************************************************
*  User supplied descriptors.  If you want to specify your own descriptors,
*  remove the comments around the define USER_SUPPLIED_DESCRIPTORS below and
*  add your descriptors.
********************************************************************************/
/* `#START USER_DESCRIPTORS_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
*  USB Customizer Generated Descriptors
********************************************************************************/

#if !defined(USER_SUPPLIED_DESCRIPTORS)
/*********************************************************************
 Device Descriptors
 *********************************************************************/
uint8 USBFS_CODE USBFS_DEVICE0_DESCR[] = {
/* Descriptor Length                       */ 0x12u,
/* DescriptorType: DEVICE                  */ 0x01u,
/* bcdUSB (ver 2.0)                        */ 0x00u, 0x02u,
/* bDeviceClass                            */ 0x00u,
/* bDeviceSubClass                         */ 0x00u,
/* bDeviceProtocol                         */ 0x00u,
/* bMaxPacketSize0                         */ 0x08u,
/* idVendor                                */ 0xB4u, 0x04u,
/* idProduct                               */ 0x00u, 0xF1u,
/* bcdDevice                               */ 0x00u, 0x00u,
/* iManufacturer                           */ 0x01u,
/* iProduct                                */ 0x02u,
/* iSerialNumber                           */ 0x00u,
/* bNumConfigurations                      */ 0x01u
};
/*********************************************************************
 Config Descriptor  
 *********************************************************************/
uint8 USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_DESCR[] = {
/*  Config Descriptor Length               */ 0x09u,
/*  DescriptorType: CONFIG                 */ 0x02u,
/*  wTotalLength                           */ 0x29u, 0x00u,
/*  bNumInterfaces                         */ 0x01u,
/*  bConfigurationValue                    */ 0x01u,
/*  iConfiguration                         */ 0x03u,
/*  bmAttributes                           */ 0xC0u,
/*  bMaxPower                              */ 0xC8u,
/*********************************************************************
 Interface Descriptor
 *********************************************************************/
/*  Interface Descriptor Length            */ 0x09u,
/*  DescriptorType: INTERFACE              */ 0x04u,
/*  bInterfaceNumber                       */ 0x00u,
/*  bAlternateSetting                      */ 0x00u,
/*  bNumEndpoints                          */ 0x02u,
/*  bInterfaceClass                        */ 0x03u,
/*  bInterfaceSubClass                     */ 0x00u,
/*  bInterfaceProtocol                     */ 0x00u,
/*  iInterface                             */ 0x04u,
/*********************************************************************
 HID Class Descriptor
 *********************************************************************/
/*  HID Class Descriptor Length            */ 0x09u,
/*  DescriptorType: HID_CLASS              */ 0x21u,
/*  bcdHID                                 */ 0x11u, 0x01u,
/*  bCountryCode                           */ 0x00u,
/*  bNumDescriptors                        */ 0x01u,
/*  bDescriptorType                        */ 0x22u,
/*  wDescriptorLength (LSB)                */ USBFS_HID_RPT_1_SIZE_LSB,
/*  wDescriptorLength (MSB)                */ USBFS_HID_RPT_1_SIZE_MSB,
/*********************************************************************
 Endpoint Descriptor
 *********************************************************************/
/*  Endpoint Descriptor Length             */ 0x07u,
/*  DescriptorType: ENDPOINT               */ 0x05u,
/*  bEndpointAddress                       */ 0x81u,
/*  bmAttributes                           */ 0x03u,
/*  wMaxPacketSize                         */ 0x40u, 0x00u,
/*  bInterval                              */ 0x0Au,
/*********************************************************************
 Endpoint Descriptor
 *********************************************************************/
/*  Endpoint Descriptor Length             */ 0x07u,
/*  DescriptorType: ENDPOINT               */ 0x05u,
/*  bEndpointAddress                       */ 0x02u,
/*  bmAttributes                           */ 0x03u,
/*  wMaxPacketSize                         */ 0x40u, 0x00u,
/*  bInterval                              */ 0x0Au
};

/*********************************************************************
 String Descriptor Table
 *********************************************************************/
uint8 USBFS_CODE USBFS_STRING_DESCRIPTORS[] = {
/*********************************************************************
 Language ID Descriptor
 *********************************************************************/
/* Descriptor Length                       */ 0x04u,
/* DescriptorType: STRING                  */ 0x03u,
/* Language Id                             */ 0x09u, 0x04u,
/*********************************************************************
 String Descriptor: "Cypress"
 *********************************************************************/
 /* Descriptor Length                       */ 0x10u,
/* DescriptorType: STRING                  */ 0x03u,
 'C', 0,'y', 0,'p', 0,'r', 0,'e', 0,'s', 0,'s', 0,
/*********************************************************************
 String Descriptor: "Example"
 *********************************************************************/
 /* Descriptor Length                       */ 0x10u,
/* DescriptorType: STRING                  */ 0x03u,
 'E', 0,'x', 0,'a', 0,'m', 0,'p', 0,'l', 0,'e', 0,
/*********************************************************************
 String Descriptor: "USB Loopback"
 *********************************************************************/
 /* Descriptor Length                       */ 0x1Au,
/* DescriptorType: STRING                  */ 0x03u,
 'U', 0,'S', 0,'B', 0,' ', 0,'L', 0,'o', 0,'o', 0,'p', 0,'b', 0,'a', 0
,'c', 0,'k', 0,
/*********************************************************************
 String Descriptor: "Loopback Interface"
 *********************************************************************/
 /* Descriptor Length                       */ 0x26u,
/* DescriptorType: STRING                  */ 0x03u,
 'L', 0,'o', 0,'o', 0,'p', 0,'b', 0,'a', 0,'c', 0,'k', 0,' ', 0,'I', 0
,'n', 0,'t', 0,'e', 0,'r', 0,'f', 0,'a', 0,'c', 0,'e', 0,
/*********************************************************************/
/* Marks the end of the list.              */ 0x00u};
/*********************************************************************/

/*********************************************************************
 Serial Number String Descriptor
 *********************************************************************/
uint8 USBFS_CODE USBFS_SN_STRING_DESCRIPTOR[] = {
/* Descriptor Length                       */ 0x02u,
/* DescriptorType: STRING                  */ 0x03u
};

/*********************************************************************
 HID Report Descriptor: LoopbackHIDReport
 *********************************************************************/
uint8 USBFS_CODE USBFS_HIDREPORT_DESCRIPTOR1[] = {
/*  Descriptor Size (Not part of descriptor)*/ USBFS_HID_RPT_1_SIZE_LSB,
USBFS_HID_RPT_1_SIZE_MSB,
/* USAGE_PAGE                              */ 0x05u, 0xFFu, 
/* USAGE                                   */ 0x09u, 0x00u, 
/* COLLECTION                              */ 0xA1u, 0x01u, 
/* USAGE                                   */ 0x09u, 0x00u, 
/* COLLECTION                              */ 0xA1u, 0x00u, 
/* USAGE_MINIMUM                           */ 0x19u, 0x00u, 
/* USAGE_MAXIMUM                           */ 0x29u, 0xFFu, 
/* LOGICAL_MINIMUM                         */ 0x15u, 0x00u, 
/* LOGICAL_MAXIMUM                         */ 0x25u, 0xFFu, 
/* REPORT_SIZE                             */ 0x75u, 0x08u, 
/* REPORT_COUNT                            */ 0x95u, 0x40u, 
/* OUTPUT                                  */ 0x91u, 0x02u, 
/* USAGE_MINIMUM                           */ 0x19u, 0x00u, 
/* USAGE_MAXIMUM                           */ 0x29u, 0xFFu, 
/* LOGICAL_MINIMUM                         */ 0x15u, 0x00u, 
/* LOGICAL_MAXIMUM                         */ 0x25u, 0xFFu, 
/* REPORT_SIZE                             */ 0x75u, 0x08u, 
/* REPORT_COUNT                            */ 0x95u, 0x40u, 
/* INPUT                                   */ 0x81u, 0x02u, 
/* END_COLLECTION                          */ 0xC0u, 
/* END_COLLECTION                          */ 0xC0u, 
/*********************************************************************/
/* End of the HID Report Descriptor        */ 0x00u, 0x00u};
/*********************************************************************/

#if !defined(USER_DEFINE_USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_HID_RPT_STORAGE)
/*********************************************************************
 HID Input Report Storage
 *********************************************************************/
uint8 USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_BUF[USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_BUF_SIZE];

/*********************************************************************
 HID Input Report TD Table
 *********************************************************************/
T_USBFS_TD USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_RPT_TABLE[] = {
    {USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_IN_RPTS,     &USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_BUF[0], USBFS_NULL}
};
/*********************************************************************
 HID Input Report Storage
 *********************************************************************/
uint8 USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_BUF[USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_BUF_SIZE];

/*********************************************************************
 HID Output Report TD Table
 *********************************************************************/
T_USBFS_TD USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_RPT_TABLE[] = {
    {USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_OUT_RPTS,     &USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_BUF[0], USBFS_NULL}
};
/*********************************************************************
 HID Report Look Up Table          This table has four entries:
                                         IN Report Table
                                         OUT Report Table
                                         Feature Report Table
                                         HID Report Descriptor
 *********************************************************************/
T_USBFS_LUT USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_TABLE[] = {
    {0x01u,     &USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_RPT_TABLE},
    {0x01u,     &USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_RPT_TABLE},
    {0x00u,    USBFS_NULL},
    {0x01u,     &USBFS_HIDREPORT_DESCRIPTOR1[0]}
};
#endif /* USER_DEFINE_USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_HID_RPT_STORAGE */

/*********************************************************************
 Interface Dispatch Table -- Points to the Class Dispatch Tables
 *********************************************************************/
T_USBFS_LUT USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_TABLE[] = {
    {USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_COUNT,     &USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_TABLE}
};
/*********************************************************************
  Endpoint Setting Table -- This table contain the endpoint setting
                            for each endpoint in the configuration.  It
                            contains the necessary information to
                            configure the endpoint hardware for each
                            interface and alternate setting.
  *********************************************************************/
T_USBFS_EP_SETTINGS_BLOCK USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_EP_SETTINGS_TABLE[] = {
/* IFC  ALT    EPAddr bmAttr MaxPktSize BufferType ********************/
{0x00u, 0x00u, 0x81u, 0x03u, 0x0040u,   0x00u},
{0x00u, 0x00u, 0x02u, 0x03u, 0x0040u,   0x00u}
};
/*********************************************************************
 Config Dispatch Table -- Points to the Config Descriptor and each of
                          and endpoint setup table and to each interface 
                          table if it specifies a USB Class 
 *********************************************************************/
T_USBFS_LUT USBFS_CODE USBFS_DEVICE0_CONFIGURATION0_TABLE[] = {
    {0x01u,     &USBFS_DEVICE0_CONFIGURATION0_DESCR},
    {0x02u,     &USBFS_DEVICE0_CONFIGURATION0_EP_SETTINGS_TABLE},
    {0x01u,     &USBFS_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_TABLE}
};
/*********************************************************************
 Device Dispatch Table -- Points to the Device Descriptor and each of
                          and Configuration Tables for this Device 
 *********************************************************************/
T_USBFS_LUT USBFS_CODE USBFS_DEVICE0_TABLE[] = {
    {0x01u,     &USBFS_DEVICE0_DESCR},
    {0x01u,     &USBFS_DEVICE0_CONFIGURATION0_TABLE}
};
/*********************************************************************
 Device Table -- Indexed by the device number.
 *********************************************************************/
T_USBFS_LUT USBFS_CODE USBFS_TABLE[] = {
    {0x01u,     &USBFS_DEVICE0_TABLE}
};

#endif

#if defined(USBFS_ENABLE_MSOS_STRING)
/*******************************************************************************
*  USB Microsoft OS String Descriptor
********************************************************************************/

uint8 USBFS_CODE USBFS_MSOS_DESCRIPTOR[] = {
/* Descriptor Length                       */ 0x12u,
/* DescriptorType: STRING                  */ 0x03u,
/* qwSignature */  'M', 0, 'S', 0, 'F', 0, 'T', 0, '1', 0, '0', 0, '0', 0,
/* bMS_VendorCode:                         */ USBFS_GET_CONFIG_DESCRIPTOR,
/* bPad                				   	   */ 0x00u
};

/* Extended Compat ID Descriptor */

uint8 USBFS_CODE USBFS_MSOS_CONFIGURATION_DESCR[] = {
/*  Length of the descriptor 4 bytes       */ 0x28u, 0x00u, 0x00u, 0x00u,
/*  Version of the descriptor 2 bytes      */ 0x00u, 0x01u,
/*  wIndex - Fixed:INDEX_CONFIG_DESCRIPTOR */ 0x04u, 0x00u,
/*  bCount - Count of device functions.    */ 0x01u,
/*  Reserved : 7 bytes                     */ 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
/*  bFirstInterfaceNumber                  */ 0x02u,  
/*  Reserved                           	   */ 0x01u,
/*  compatibleID    - "USBCIR\0\0"         */ 0x55u, 0x53u, 0x42u, 0x43u, 0x49u, 0x52u, 0x00u, 0x00u,
/*  subcompatibleID - "IR2CMPT\0"          */ 0x49u, 0x52u, 0x32u, 0x43u, 0x4Du, 0x50u, 0x54u, 0x00u,
/*  Reserved : 6 bytes                     */ 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u
}; 
#endif
