/*******************************************************************************
* File Name: USBFS_episr.c
* Version 1.30
*
*  Description:
*    Data endpoint Interrupt Service Routines
*
*   Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/



#include "cyfitter.h"
#include "USBFS.h"

/*******************************************************************************
* Custom Declratations
********************************************************************************/
/* `#START CUSTOM_DECLARATIONS` Place your declaration here */

/* This variable is declared in main.c. The variable is set to 1 when the USB EP interrupt occurs */
extern uint8  USB_interruptFlag;

/* `#END` */
/*******************************************************************************
* External function references
********************************************************************************/
void USBFS_InitComponent(uint8 bDevice, uint8 bMode);
/*******************************************************************************
* External references
********************************************************************************/
extern T_USBFS_EP_CTL_BLOCK USBFS_EP[];
extern uint8 USBFS_bDevice;


/*******************************************************************************
* Function Name: USBFS_EP_1_ISR
********************************************************************************
* Summary:
*   Endpoint 1 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP1_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_1_ISR)
{
/* `#START EP1_USER_CODE` Place your code here */
  
/* `#END` */
   CY_GET_REG8(USBFS_SIE_EP1_CR0); /* Must read the mode reg */
   USBFS_EP[1].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
   USBFS_EP[1].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x01);
   
   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_1__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP1_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_2_ISR
********************************************************************************
* Summary:
*   Endpoint 2 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP2_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_2_ISR)
{
/* `#START EP2_USER_CODE` Place your code here */

    /* Set the flag to indicate that the interrupt has occured */
	USB_interruptFlag = 1;
    
/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP2_CR0); /* Must read the mode reg */
    USBFS_EP[2].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[2].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x02);

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_2__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP2_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_3_ISR
********************************************************************************
* Summary:
*   Endpoint 3 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP3_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_3_ISR)
{
/* `#START EP3_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP3_CR0); /* Must read the mode reg */
    USBFS_EP[3].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[3].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x04);

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_3__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP3_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_4_ISR
********************************************************************************
* Summary:
*   Endpoint 4 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP4_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_4_ISR)
{
/* `#START EP4_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP4_CR0); /* Must read the mode reg */
    USBFS_EP[4].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[4].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x08);
   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 

	#if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_4__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP4_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_5_ISR
********************************************************************************
* Summary:
*   Endpoint 5 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP5_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_5_ISR)
{
/* `#START EP5_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP5_CR0); /* Must read the mode reg */
    USBFS_EP[5].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[5].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x10);

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_5__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP5_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_6_ISR
********************************************************************************
* Summary:
*   Endpoint 6 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP6_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_6_ISR)
{
/* `#START EP6_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP6_CR0); /* Must read the mode reg */
    USBFS_EP[6].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[6].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x20);

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_6__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP6_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_7_ISR
********************************************************************************
* Summary:
*   Endpoint 7 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP7_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_7_ISR)
{
/* `#START EP7_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP7_CR0); /* Must read the mode reg */
    USBFS_EP[7].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[7].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x40);

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_7__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP7_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_EP_8_ISR
********************************************************************************
* Summary:
*   Endpoint 8 Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
#if(USBFS_EP8_ISR_REMOVE == 0)
CY_ISR(USBFS_EP_8_ISR)
{
/* `#START EP8_USER_CODE` Place your code here */

/* `#END` */
    CY_GET_REG8(USBFS_SIE_EP8_CR0); /* Must read the mode reg */
    USBFS_EP[8].bEPToggle ^= USBFS_EPX_CNT_DATA_TOGGLE;
    USBFS_EP[8].bAPIEPState = USBFS_EVENT_PENDING;
    CY_SET_REG8(USBFS_SIE_EP_INT_SR, CY_GET_REG8(USBFS_SIE_EP_INT_SR) & ~0x80);

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_ep_8__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	
}
#endif   /* End USBFS_EP8_ISR_REMOVE */


/*******************************************************************************
* Function Name: USBFS_SOF_ISR
********************************************************************************
* Summary:
*   Start of Frame Interrupt Service Routine
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_SOF_ISR)
{
/* `#START SOF_USER_CODE` Place your code here */

/* `#END` */

   /* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_sof_int__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	

}
/*******************************************************************************
* Function Name: USBFS_BUS_RESET_ISR
********************************************************************************
* Summary:
*   USB Bus Reset Interrupt Service Routine.  Calls _Start with the same 
*   parameters as the last USER call to _Start
*   
* Parameters:  
*   None
*******************************************************************************/
CY_ISR(USBFS_BUS_RESET_ISR)
{
/* `#START BUS_RESET_USER_CODE` Place your code here */

/* `#END` */
	USBFS_InitComponent(USBFS_bDevice, CY_GET_REG8(USBFS_CR1));

	/* PSoC3 ES1, ES2 RTC ISR PATCH  */ 
    #if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
        #if((CYDEV_CHIP_REV_EXPECT <= CYDEV_CHIP_REV_LEOPARD_ES2) && (USBFS_bus_reset__ES2_PATCH))      
            USBFS_ISR_PATCH();
        #endif
    #endif	

}
