/*******************************************************************************
* File Name: USBFS_hid.c
* Version 1.30
*
*  Description:
*    USB HID Class request handler.
*
*   Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/



#include "cydevice_trm.h"
#include "cyfitter.h"
#include "USBFS.h"
#include "USBFS_hid.h"

#if defined(USBFS_ENABLE_HID_CLASS)

/*******************************************************************************
* HID Variables
********************************************************************************/
uint8	USBFS_bHID_Protocol;			/* HID device protocol status */
uint8	USBFS_bHID_IdleRate;			/* HID device idle rate value */
uint8	USBFS_bHID_ReportID;			/* HID device Report ID */

/*******************************************************************************
* Custom Declratations
********************************************************************************/
/* `#START CUSTOM_DECLARATIONS` Place your declaration here */

/* `#END` */
/*******************************************************************************
* External references
********************************************************************************/
uint8 USBFS_InitControlRead(void);
uint8 USBFS_InitControlWrite(void);
uint8 USBFS_InitNoDataControlTransfer(void);
T_USBFS_LUT *USBFS_GetConfigTablePtr(uint8 c);
T_USBFS_LUT *USBFS_GetDeviceTablePtr(void);
extern T_USBFS_TD CurrentTD;
extern uint8 USBFS_CODE USBFS_HIDREPORT_DESCRIPTORS[];
extern uint8 USBFS_bConfiguration;

/*******************************************************************************
* Internal references
********************************************************************************/
void USBFS_FindReport(void);
void USBFS_FindReportDecriptor(void);

/*******************************************************************************
* Function Name: USBFS_UpdateHIDTimer
********************************************************************************
* Summary:
*   Updates the HID report timer and reloads it if it expires
*   
* Parameters:  
*   bInterface Interface Number
*******************************************************************************/
uint8 USBFS_UpdateHIDTimer(uint8 bInterface)
{  
    bInterface = bInterface;
    return USBFS_IDLE_TIMER_INDEFINITE;
}
/*******************************************************************************
* Function Name: USBFS_bGetProtocol
********************************************************************************
* Summary:
*   Returns the selected protocol value to the application
*   
* Parameters:  
*   bInterface Interface Number
*******************************************************************************/
uint8 USBFS_bGetProtocol(uint8 bInterface)
{   
    bInterface = bInterface;
    return USBFS_PROTOCOL_REPORT;
}
/*******************************************************************************
* Function Name: USBFS_DispatchHIDClassRqst
********************************************************************************
* Summary:
*   This routine dispatches class requests
*   
* Parameters:  
*   None
*******************************************************************************/
uint8 USBFS_DispatchHIDClassRqst()
{
    uint8 bRequestHandled = USBFS_FALSE;
    T_USBFS_LUT *pTmp = USBFS_GetConfigTablePtr(USBFS_bConfiguration - 1);

    if ((CY_GET_REG8(USBFS_bmRequestType) & USBFS_RQST_DIR_MASK) == USBFS_RQST_DIR_D2H)
    {   /* Control Read */
		switch (*USBFS_bRequest) 
		{
			case USBFS_GET_DESCRIPTOR:
                if (CY_GET_REG8(USBFS_wValueHi) == USBFS_DESCR_HID_CLASS)
                {
                    /* pTmp is pointing to the Config Table */
                    /* Next...                              */
				    /* Get the Config Descriptor            */
                    /*   The HID Class Descriptor resides   */
                    /*   inside the config descriptor       */
                    CurrentTD.pData     = &((uint8 *) pTmp->p_list)[18];
                    CurrentTD.wCount    = 9;
					bRequestHandled     = USBFS_InitControlRead();
                }
                else if (CY_GET_REG8(USBFS_wValueHi) == USBFS_DESCR_HID_REPORT)  
				{
                    USBFS_FindReportDecriptor();
                    if (CurrentTD.wCount != 0)
                    {
                        bRequestHandled     = USBFS_InitControlRead();
                    }
				}
                break;
            case USBFS_HID_GET_REPORT:
                USBFS_FindReport();
                bRequestHandled     = USBFS_InitControlRead();
                break;

			case USBFS_HID_GET_IDLE:
				CurrentTD.wCount    = 1;
				CurrentTD.pData     = &USBFS_bHID_IdleRate;
				bRequestHandled     = USBFS_InitControlRead();
                break;
			case USBFS_HID_GET_PROTOCOL:
				CurrentTD.wCount    = 1;
				CurrentTD.pData     = &USBFS_bHID_Protocol;
				bRequestHandled     = USBFS_InitControlRead();
                break;
            default:
                break;
        }
    }
    else if ((CY_GET_REG8(USBFS_bmRequestType) & USBFS_RQST_DIR_MASK) == USBFS_RQST_DIR_H2D)
    {   /* Control Write */
		switch (CY_GET_REG8(USBFS_bRequest)) 
		{
            case USBFS_HID_SET_REPORT:
                USBFS_FindReport();
                bRequestHandled     = USBFS_InitControlWrite();
                break;
            case USBFS_HID_SET_IDLE:
				USBFS_bHID_IdleRate = CY_GET_REG8(USBFS_wValueHi);
				USBFS_bHID_ReportID = CY_GET_REG8(USBFS_wValueLo);
				bRequestHandled     = USBFS_InitNoDataControlTransfer();
                break;
            case USBFS_HID_SET_PROTOCOL:
			    USBFS_bHID_Protocol  = CY_GET_REG8(USBFS_wValueHi);
				bRequestHandled     = USBFS_InitNoDataControlTransfer();
                break;
            default:
                break;
        }
    }
    return bRequestHandled;   
}

/*******************************************************************************
* Function Name: USB_FindReportDescriptor
********************************************************************************
* Summary:
*   This routine find Hid Report Descriptor pointer based on the Interface number,
*   then loads the CurrentTD structure with the address of the buffer and the size.
*   Hid Report Descriptor is located after IN/OUT/FEATURE reports. 
*   
* Parameters:  
*   None
*******************************************************************************/
void USBFS_FindReportDecriptor()
{
    T_USBFS_LUT *pTmp = USBFS_GetConfigTablePtr(USBFS_bConfiguration - 1);
    uint8 *pDescr;
    /* Third entry in the LUT starts the Interface Table pointers */
    pTmp++;
    pTmp++;
    /* Now use the request interface number*/
    pTmp = &pTmp[CY_GET_REG8(USBFS_wIndexLo)];
    /*USB_DEVICEx_CONFIGURATIONy_INTERFACEz_ALTERNATEi_TABLE*/
	pTmp = (T_USBFS_LUT *) pTmp->p_list;
    /*USB_DEVICEx_CONFIGURATIONy_INTERFACEz_ALTERNATEi_HID_TABLE*/
	pTmp = (T_USBFS_LUT *) pTmp->p_list;
    /* Fourth entry in the LUT starts the Hid Report Descriptor */
    pTmp++;
    pTmp++;
    pTmp++;
    pDescr = (uint8 *)pTmp->p_list;
    CurrentTD.wCount    =  (((uint16)pDescr[1] << 8) | pDescr[0]);
    CurrentTD.pData     = &pDescr[2];
}
/*******************************************************************************
* Function Name: USBFS_FindReport
********************************************************************************
* Summary:
*   This routine sets up a transfer based on the Interface number, Report Type
*   and Report ID, then loads the CurrentTD structure with the address of the
*   buffer and the size.  The caller has to decide if it is a control read or
*   control write.
*   
* Parameters:  
*   None
*******************************************************************************/
void USBFS_FindReport()
{
    T_USBFS_LUT *pTmp = USBFS_GetConfigTablePtr(USBFS_bConfiguration - 1);
    T_USBFS_TD *pTD;
    /* Third entry in the LUT starts the Interface Table pointers */
    pTmp++;
    pTmp++;
    /* Now use the request interface number */
    pTmp = &pTmp[CY_GET_REG8(USBFS_wIndexLo)];
	pTmp = (T_USBFS_LUT *) pTmp->p_list;
    pTmp = (T_USBFS_LUT *) pTmp->p_list;
    /* Get the entry proper TD */
    pTD = &((T_USBFS_TD *) pTmp->p_list)[CY_GET_REG8(USBFS_wValueHi) - 1];

    CurrentTD.pData     = pTD->pData;
    CurrentTD.wCount    = pTD->wCount;
    CurrentTD.pStatusBlock = pTD->pStatusBlock;
}
#endif
