#pragma once
#using "C:\Cypress\Cypress Suite USB 3.4.7\CyUSB.NET\lib\CyUSB.dll" 
#using <mscorlib.dll>
#include <windows.h>

namespace Demo_HID_Application {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace CyUSB;

	/// <summary>
	/// Summary for Form1
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{

	private: System::Windows::Forms::StatusStrip^  statusStrip1;
	private: System::Windows::Forms::ToolStripStatusLabel^  DeviceStatus;
	private: System::Windows::Forms::Button^  Write;
	private: System::Windows::Forms::Button^  Read;
	private: System::Windows::Forms::TextBox^  DataBox;
	private: System::Windows::Forms::RadioButton^  SendRandomData;
	private: System::Windows::Forms::RadioButton^  SendCustomData;

	public:
	CyHidDevice^	myDevice;               // My HID device.
	USBDeviceList^	usbDevices;     // the list consists of all devices attached to Cysub.sys Mass storage and HID class device
		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: Add the constructor code here

			usbDevices = gcnew USBDeviceList(CyConst::DEVICES_HID); // All devices listed as HID devices are added to the list usbDevices

			usbDevices->DeviceAttached += gcnew System::EventHandler(this,&Form1::usbDevices_DeviceAttached);		   // Eventhandler assigned to DeviceAttached to handle the event when a device is attached
			usbDevices->DeviceRemoved += gcnew System::EventHandler(this,&Form1::usbDevices_DeviceRemoved);            // Eventhandler assigned to DeviceRemoved to handle the event when a device is removed
			RefreshDevice();

			//
		}

		/*
		 This is the event handler for Device Attachment event.
		*/
	       void usbDevices_DeviceAttached(Object^ sender, EventArgs^ e)													// Eventhandler assigned to DeviceAttached
	       {
		    RefreshDevice();		
	       }
	    /*
		This is the event handler for Device removal event.
	    */
	       void usbDevices_DeviceRemoved(Object^ sender, EventArgs^ e)													// Eventhandler assigned to DeviceRemoved
	      {
		    RefreshDevice();													
	      }

	       /*Summary
		 The function gets the device with VID=04b4 and PID=00F0; updates the Status label and Treeview
	       */
		void RefreshDevice()
	    {
		    myDevice = (static_cast<CyHidDevice^>(usbDevices[0x4b4, 0x2000]));	// Instantiating myDevice with handle to the device of interest: first HID device in my case.
		    if (!myDevice)																							// Bulkloop device if not found
		    {    DeviceStatus->Text = "No HID Device connected";
			 Write->Enabled = false;
			 Read->Enabled = false;
		    }
		    else																									// Bulkloop device if not found
		    {
			 DeviceStatus->Text = "HID Device connected";
			 Write->Enabled = true;
			 Read->Enabled = true;
		    }
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->statusStrip1 = (gcnew System::Windows::Forms::StatusStrip());
			this->DeviceStatus = (gcnew System::Windows::Forms::ToolStripStatusLabel());
			this->Write = (gcnew System::Windows::Forms::Button());
			this->Read = (gcnew System::Windows::Forms::Button());
			this->DataBox = (gcnew System::Windows::Forms::TextBox());
			this->SendRandomData = (gcnew System::Windows::Forms::RadioButton());
			this->SendCustomData = (gcnew System::Windows::Forms::RadioButton());
			this->statusStrip1->SuspendLayout();
			this->SuspendLayout();
			// 
			// statusStrip1
			// 
			this->statusStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->DeviceStatus});
			this->statusStrip1->Location = System::Drawing::Point(0, 276);
			this->statusStrip1->Name = L"statusStrip1";
			this->statusStrip1->Size = System::Drawing::Size(428, 22);
			this->statusStrip1->TabIndex = 0;
			this->statusStrip1->Text = L"statusStrip1";
			// 
			// DeviceStatus
			// 
			this->DeviceStatus->Name = L"DeviceStatus";
			this->DeviceStatus->Size = System::Drawing::Size(73, 17);
			this->DeviceStatus->Text = L"Device Status";
			// 
			// Write
			// 
			this->Write->Location = System::Drawing::Point(232, 227);
			this->Write->Name = L"Write";
			this->Write->Size = System::Drawing::Size(75, 23);
			this->Write->TabIndex = 1;
			this->Write->Text = L"Write";
			this->Write->UseVisualStyleBackColor = true;
			this->Write->Click += gcnew System::EventHandler(this, &Form1::Write_Click);
			// 
			// Read
			// 
			this->Read->Location = System::Drawing::Point(13, 227);
			this->Read->Name = L"Read";
			this->Read->Size = System::Drawing::Size(75, 23);
			this->Read->TabIndex = 2;
			this->Read->Text = L"Read";
			this->Read->UseVisualStyleBackColor = true;
			this->Read->Click += gcnew System::EventHandler(this, &Form1::Read_Click);
			// 
			// DataBox
			// 
			this->DataBox->Location = System::Drawing::Point(13, 13);
			this->DataBox->Multiline = true;
			this->DataBox->Name = L"DataBox";
			this->DataBox->Size = System::Drawing::Size(294, 188);
			this->DataBox->TabIndex = 3;
			// 
			// SendRandomData
			// 
			this->SendRandomData->AutoSize = true;
			this->SendRandomData->Location = System::Drawing::Point(313, 35);
			this->SendRandomData->Name = L"SendRandomData";
			this->SendRandomData->Size = System::Drawing::Size(113, 17);
			this->SendRandomData->TabIndex = 4;
			this->SendRandomData->TabStop = true;
			this->SendRandomData->Text = L"SendRandomData";
			this->SendRandomData->UseVisualStyleBackColor = true;
			this->SendRandomData->CheckedChanged += gcnew System::EventHandler(this, &Form1::SendRandomData_CheckedChanged);
			// 
			// SendCustomData
			// 
			this->SendCustomData->AutoSize = true;
			this->SendCustomData->Location = System::Drawing::Point(313, 79);
			this->SendCustomData->Checked  = true;
			this->SendCustomData->Name = L"SendCustomData";
			this->SendCustomData->Size = System::Drawing::Size(108, 17);
			this->SendCustomData->TabIndex = 5;
			this->SendCustomData->TabStop = true;
			this->SendCustomData->Text = L"SendCustomData";
			this->SendCustomData->UseVisualStyleBackColor = true;
			this->SendCustomData->CheckedChanged += gcnew System::EventHandler(this, &Form1::SendCustomData_CheckedChanged);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(428, 298);
			this->Controls->Add(this->SendCustomData);
			this->Controls->Add(this->SendRandomData);
			this->Controls->Add(this->DataBox);
			this->Controls->Add(this->Read);
			this->Controls->Add(this->Write);
			this->Controls->Add(this->statusStrip1);
			this->Name = L"Form1";
			this->Text = L"Form1";
			this->statusStrip1->ResumeLayout(false);
			this->statusStrip1->PerformLayout();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
	private: System::Void Read_Click(System::Object^  sender, System::EventArgs^  e) {
				 if(myDevice)
				 {
				 byte PSoCData[64];
				 String^ strData;
				 int i;
				 //static char PSoCData[65];
				 //Array::Clear(PSoCData, 0, 65);
					 if(myDevice->ReadInput() == true)
					 {
						 for(i=0;i<64;i++) // To ignore 1st byte. Actual 1-64.
						 {
							PSoCData[i] = myDevice->Inputs->DataBuf[i+1];
							strData += PSoCData[i].ToString("X") + " ";
						 }

						 //To display in the DataBox
						 DataBox->Clear();

						 DataBox->Text = strData;
						 //To debug
						 /*
						 strData = "Data read is : " + strData;
						 MessageBox::Show(strData);
						 */
					 }
					 

					 //MessageBox::Show("Data to be read"); // Used for debugging
				 }
			 }
private: System::Void Write_Click(System::Object^  sender, System::EventArgs^  e) {
			 int i;
			 	 if(myDevice)
				 {
					  //MessageBox::Show("Data to be written"); // Used for debugging

					 for(i=0; i<65; i++) // first byte is report id.
					 {
						 myDevice->Outputs->DataBuf[i]=i;
					 }

						  myDevice->WriteOutput();
						  MessageBox::Show("Data Sent");
				 }
		 }
private: System::Void SendRandomData_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {

			 DataBox->Text = "0 1 2 3 4 5 6 7 8 9 A B C D E F 10 11 12 13 14 15 16 17 18 19 1A 1B 1C 1D 1E 1F 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 30 31 32 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F";
		 }
private: System::Void SendCustomData_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {

			 DataBox->Text = "";
		 }

public: 
		int IsHexChar(char c)
        {   
			String^ hexnumber = "0123456789ABCDEFabcdef";
			array<wchar_t>^HexChars = hexnumber->ToCharArray();
            c = Char::ToUpper(c);
			//MessageBox::(c);
            //look-up the char in HexChars Array
           int isHexChar = Array::BinarySearch(HexChars,c);
            if (isHexChar >=0 )
                return 1;
            else
                return 0;
			return 1;
        }
};
}

