#include "includes.h"

static  OS_STK AppTaskUserIFStk[APP_TASK_USER_IF_STK_SIZE];
static  OS_STK AppTaskKbdStk[APP_TASK_KBD_STK_SIZE];

void Task_LED(void *p_arg)
{
    (void)p_arg;                		// 'p_arg' ûõֹʾ
		#if (OS_TASK_STAT_EN > 0)
		OSStatInit();                                               /* Determine CPU capacity.                              */
		#endif
	  App_TaskCreate();
	  while (1)
		 {  
			  LED1(ON); 
				OSTimeDlyHMSM(0, 0, 0, 500);
				LED1(OFF);
				OSTimeDlyHMSM(0, 0, 0, 500);
		 }
}
/*
*********************************************************************************************************
*                                            App_TaskCreate()
*
* Description : Create the application tasks.
*
* Argument : none.
*
* Return   : none.
*
* Caller   : App_TaskStart().
*
* Note     : none.
*********************************************************************************************************
*/

static  void App_TaskCreate(void)
{
   CPU_INT08U os_err;
   
   OSTaskCreateExt(AppTaskUserIF,(void *)0,(OS_STK *)&AppTaskUserIFStk[APP_TASK_USER_IF_STK_SIZE-1],APP_TASK_USER_IF_PRIO,APP_TASK_USER_IF_PRIO,(OS_STK *)&AppTaskUserIFStk[0],
                    APP_TASK_USER_IF_STK_SIZE,
                    (void *)0,
                    OS_TASK_OPT_STK_CHK|OS_TASK_OPT_STK_CLR);
                    
   OSTaskCreateExt(AppTaskKbd,(void *)0,(OS_STK *)&AppTaskKbdStk[APP_TASK_KBD_STK_SIZE-1],APP_TASK_KBD_PRIO,APP_TASK_KBD_PRIO,(OS_STK *)&AppTaskKbdStk[0],
                    APP_TASK_KBD_STK_SIZE,
                    (void *)0,
                    OS_TASK_OPT_STK_CHK|OS_TASK_OPT_STK_CLR);

}
/*
*********************************************************************************************************
*                                         USER INTERFACE TASK
*
* Description : This task updates the LCD screen based on messages passed to it by AppTaskKbd().
*
* Arguments   : p_arg   is the argument passed to 'AppStartUserIF()' by 'OSTaskCreate()'.
*
* Returns     : none
*********************************************************************************************************
*/
//extern void LCD_L0_FillRect(int x0, int y0, int x1, int y1);

static  void  AppTaskUserIF (void *p_arg)
{
 
 (void)p_arg;
  
  //GUI_Init();
  
 // LCD_L0_FillRect(16,64, 16+50,64+30);
  while(1) 
  {
	   //GUIDEMO_main();
  }
}


/*
*********************************************************************************************************
*                                    KEYBOARD RESPONSE TASK
*
* Description : This task monitors the state of the push buttons and passes messages to AppTaskUserIF()
*
* Arguments   : p_arg   is the argument passed to 'AppStartKbd()' by 'OSTaskCreate()'.
*
* Returns     : none
*********************************************************************************************************
*/

static  void  AppTaskKbd (void *p_arg)
{  
   (void)p_arg;
   
   while(1) 
   {
      OSTimeDlyHMSM(0,0,0,10); 
	    //GUI_TOUCH_Exec(); 

	 }
}


