#include "includes.h"
#include "bsp.h"
/**
  * @brief  Configures the FSMC and GPIOs to interface with the SRAM memory.
  *         This function must be called before any write/read operation
  *         on the SRAM.
  * @param  None 
  * @retval : None
  */
	
/*
 * BSP_Init
 *   ʱӳʼӲʼ
 *   
 *   
 */
void BSP_Init(void)
{
    SystemInit();		/* ϵͳʱΪ72M */	
	  SysTick_init();		/* ʼʹSysTickʱ */
    LED_GPIO_Config();  /* LED ˿ڳʼ */
	  TFT_GPIO_Config();
	  FSMC_LCD_Init();	 /* Configure FSMC */
}

/*
 * SysTick_init
 *   SysTickʱ
 *   
 *   
 */
void SysTick_init(void)
{
    SysTick_Config(SystemFrequency/OS_TICKS_PER_SEC);//ʼʹSysTickʱ
}
