/**
 ***********************************************
 * LCD?a?䣤?t?2.4?o????y?IC?aILI9325   *
 * 9325??o??1a??D9325?????D???    *
 * *********************************************
 */
#include "stm32f10x.h"
#include "ili9320.h"
#include "lcdconf.h"
#include "ili9320_font.h"


extern void LCD_WriteIndex(unsigned char index);
extern void LCD_WriteReg(unsigned int index);
extern unsigned int LCD_RD_data(void);
extern void LCD_WriteRAM(unsigned int val);
unsigned int LCD_RD_Data(void);
extern void LCD_clear(unsigned int p);
extern void LCD_9325_Init(void);
extern void lcd_wr_zf(unsigned int a, unsigned int b, unsigned int a1,unsigned int b1, unsigned int d,unsigned int e, unsigned char g, unsigned char *f); 
extern void lcd_wr_pixel(unsigned int a, unsigned int b, unsigned int e) ;
extern unsigned char *num_pub(unsigned int a);
extern  void LCD_WriteRAM_Prepare(void); 


/*
for stmfans-ev board
lcd:
PD0 -> nCS  PD1 -> RS  PD2 -> nWR  PD3 -> nRD  PD4 -> nRESET
touch:
PD5 -> TS_CLK  PD6 -> TS_nCS  PD7 -> TS_DIN  PD8 -> TS_BUSY  PD9 -> TS_nPENIRQ  PD10 -> TS_DOUT
*/
#define nCS     GPIO_Pin_0
#define RS      GPIO_Pin_1
#define nWR     GPIO_Pin_2
#define nRD     GPIO_Pin_3
#define nReset  GPIO_Pin_4
//#define LCD_BK  GPIO_Pin_0

/*
o??1???2? - ?T䣤?t?????
 1 - DB0      2 - DB1      3 - DB2      4 - DB3      5 - DB4      6 - DB5      7 - DB6      8 - DB7
 9 - DB8     10 - DB9     11 - DB10    12 - DB11    13 - DB12    14 - DB13    15 - DB14    16 - DB15
17 - nRD     18 - RS      19 - nWR     20 - nCS     21 - NC      22 - nReset  23 - VCC     24 - VCC
25 - VCC     26 - VCC     27 - NC      28 - NC      29 - GND     30 - GND     31 - BK1     32 - BK2
33 - BK3     34 - BK4     35 - GND     36 - GND     37 - X-      38 - Y-      39 - X+      40 - Y+


o??1???2? - D䣤?t?????
 1 - DB0      2 - DB1      3 - DB2      4 - DB3      5 - DB4      6 - DB5      7 - DB6      8 - DB7
 9 - DB8     10 - DB9     11 - DB10    12 - DB11    13 - DB12    14 - DB13    15 - DB14    16 - DB15
17 - nCS     18 - RS      19 - nWR     20 - NC      21 - nRD     22 - nReset  23 - VCC     24 - VCC
25 - VCC     26 - VCC     27 - NC      28 - BL      29 - GND     30 - GND     31 - GND     32 - GND
33 - TS_CLK  34 - TS_VBAT 35 - TS_nCS  36 - TS_AUX  37 - TS_DIN  38 - TS_DOUT 39 - TS_BUSY 40 - TS_nPENIRQ
*/


/****************************************************************************
* ??    3?ou16 CheckController(void)
* 1|    ?o???????¡䨲??
* ??2?yo?T
* 3??2?yo?????Do?
* ?    ?¡o̡¨?o????YDo???????Do?
* ̡¨??ocode=CheckController();
****************************************************************************/
u16 CheckController(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  u16 tmp=0;
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOE, ENABLE);
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_All;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOE, &GPIO_InitStructure);
  

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD,ENABLE);
  GPIO_InitStructure.GPIO_Pin = nReset|nCS|nWR|RS|nRD;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOD, &GPIO_InitStructure);
  GPIO_PinLockConfig(GPIOD,nReset|nCS|nWR|RS|nRD);
  
  GPIO_SetBits( GPIOD, nReset | nCS | nWR | RS | nRD );
  
  ili9320_Reset();

  //ili9320_WriteRegister(0x0000,0x0001);
  ili9320_Delay(50000);
  
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_All;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(GPIOE, &GPIO_InitStructure);
  
  GPIO_ResetBits(GPIOD,nCS);
  
  GPIO_SetBits(GPIOD,RS);
  
  GPIO_ResetBits(GPIOD,nRD);
  tmp=GPIO_ReadInputData(GPIOE);
  
  GPIO_SetBits(GPIOD,nRD);
  
  GPIO_SetBits(GPIOD,nCS);
  
  return tmp;
}

/****************************************************************************
* ??    3?ovoid ili9320_Initializtion()
* 1|    ?o3??? ILI9320 ?????
* ??2?yo?T
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_Initializtion();
****************************************************************************/
void ili9320_Initializtion()
{ 
   LCD_9325_Init();
}

/****************************************************************************
* ??    3?ovoid ili9320_SetCursor(u16 x,u16 y)
* 1|    ?o?????
* ??2?yox      DD
*           y      D
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_SetCursor(10,10);
****************************************************************************/
void ili9320_SetCursor(u16 Xpos,u16 Ypos)
{				
  //LCD_WriteReg(0,0x02,x);
  //LCD_WriteReg(1,0x03,y);  
	LCD_WriteReg(0x2B); 
	LCD_WriteRAM(Xpos>>8); 
	LCD_WriteRAM(Xpos&0XFF);	 
	LCD_WriteReg(0X2A); 
	LCD_WriteRAM(Ypos>>8); 
	LCD_WriteRAM(Ypos&0XFF);
 
  //LCD_WriteReg(32, y);
  //LCD_WriteReg(33, 319-x);
		//*(__IO uint16_t *) (Bank1_LCD_C)= 34;
  //LCD_WriteIndex(34);


}

/****************************************************************************
* ??    3?ovoid ili9320_SetWindows(u16 StartX,u16 StartY,u16 EndX,u16 EndY)
* 1|    ?o?????
* ??2?yoStartX     DD?e?
*           StartY     D?e?
*           EndX       DD??
*           EndY       D??
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_SetWindows(0,0,100,100)?
****************************************************************************/
void ili9320_SetWindows(u16 StartX,u16 StartY,u16 EndX,u16 EndY)
{
  //LCD_WriteReg(0x0050, StartY); // Horizontal GRAM Start Address
  //LCD_WriteReg(0x0051, EndX); // Horizontal GRAM End Address
  //LCD_WriteReg(0x0052, 319-StartX); // Vertical GRAM Start Address
  //LCD_WriteReg(0x0053, EndY); // Vertical GRAM Start Address	 

      LCD_WriteReg(0x002B);	   //Page
	  LCD_WriteRAM(StartX>>8);
	  LCD_WriteRAM(StartX&0XFF);
	  LCD_WriteRAM((EndX)>>8);
	  LCD_WriteRAM((EndX)&0XFF);

      LCD_WriteReg(0x002A);
      LCD_WriteRAM(StartY>>8);
	  LCD_WriteRAM(StartY&0XFF);
	  LCD_WriteRAM((EndY)>>8);
      LCD_WriteRAM((EndY)&0XFF);

      ili9320_SetCursor(StartX, StartY);

  
}

/****************************************************************************
* ??    3?ovoid ili9320_Clear(u16 dat)
* 1|    ?o??????3?3???????????????3? 0xffff
* ??2?yodat      ?3??
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_Clear(0xffff);
****************************************************************************/
void ili9320_Clear(u16 dat)
{
  u32 i;
  //LCD_WriteReg(0x0050, 0); // Horizontal GRAM Start Address
  //LCD_WriteReg(0x0051, 239); // Horizontal GRAM End Address
  //LCD_WriteReg(0x0052, 0); // Vertical GRAM Start Address
  //LCD_WriteReg(0x0053, 319); // Vertical GRAM Start Address	 
  ili9320_SetWindows(0,239,0,319);
  ili9320_SetCursor(0,0);
  LCD_WriteRAM_Prepare();
  //LCD_WriteReg(32, 0);
  //LCD_WriteReg(33, 0);
		//*(__IO uint16_t *) (Bank1_LCD_C)= 34;
  //LCD_WriteIndex(34);
  for(i=0;i<76800;i++) LCD_WriteRAM(dat);  
}

/****************************************************************************
* ??    3?ou16 ili9320_GetPoint(u16 x,u16 y)
* 1|    ?o???????????
* ??2?yox      DD
*           y      D
* 3??2?yo̡?????
* ?    ?¡o
* ̡¨??oi=ili9320_GetPoint(10,10);
****************************************************************************/
u16 ili9320_GetPoint(u16 x,u16 y)
{ 
	//u16 temp;
  	ili9320_SetCursor(x,y);
  	LCD_WriteIndex(0x2c);
  	return (ili9320_BGR2RGB(ili9320_ReadData()));

}

/****************************************************************************
* ??    3?ovoid ili9320_SetPoint(u16 x,u16 y,u16 point)
* 1|    ?o?????-?
* ??2?yox      DD
*           y      D
*           point  ?????
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_SetPoint(10,10,0x0fe0);
****************************************************************************/
void ili9320_SetPoint(u16 x,u16 y,u16 point)
{
  ili9320_SetCursor(x,y);
  //LCD_WriteReg(32, y);
  //LCD_WriteReg(33, 319-x);
  LCD_WriteIndex(0x2c);
  LCD_WriteRAM(point);  
}

/****************************************************************************
* ??    3?ovoid ili9320_DrawPicture(u16 StartX,u16 StartY,u16 EndX,u16 EndY,u16 *pic)
* 1|    ?o??????????????
* ??2?yoStartX     DD?e?
*           StartY     D?e?
*           EndX       DD??
*           EndY       D??
            pic        ???????
* 3??2?yo?T
* ?    ?¡o?????????a??????16??????꨺?
* ̡¨??oili9320_DrawPicture(0,0,100,100,(u16*)demo);
****************************************************************************/
void ili9320_DrawPicture(u16 StartX,u16 StartY,u16 EndX,u16 EndY,u16 *pic)
{
  u16  i;
  ili9320_SetWindows(StartX,StartY,EndX,EndY);
  ili9320_SetCursor(StartX,StartY);	    
  for (i=0;i<(EndX*EndY);i++) LCD_WriteRAM(*pic++);
}

/****************************************************************************
* ??    3?ovoid ili9320_PutChar(u16 x,u16 y,u8 c,u16 charColor,u16 bkColor)
* 1|    ?o??????????8x16???ascii??
* ??2?yox          DD
*           y          D
*           charColor  ??????
*           bkColor    ??3????
* 3??2?yo?T
* ?    ?¡o??????T??a?????ascii??
* ̡¨??oili9320_PutChar(10,10,'a',0x0000,0xffff);
****************************************************************************/
void ili9320_PutChar(u16 x,u16 y,u8 c,u16 charColor,u16 bkColor)
{
  u16 i=0;
  u16 j=0;
  
  u8 tmp_char=0;

  for (i=0;i<16;i++)
  {
    tmp_char=ascii_8x16[((c-0x20)*16)+i];
    for (j=0;j<8;j++)
    {
      if ( (tmp_char >> 7-j) & 0x01 == 0x01)
        {
          ili9320_SetPoint(x+j,y+i,charColor); // ?????
        }
        else
        {
          ili9320_SetPoint(x+j,y+i,bkColor); // 3????
        }
    }
  }
}

/****************************************************************************
* ??    3?ovoid ili9320_Test()
* 1|    ?o2a?o??
* ??2?yo?T
* 3??2?yo?T
* ?    ?¡o???2??2a?o?????y31
* ̡¨??oili9320_Test();
****************************************************************************/
void ili9320_Test()
{
  u16 i,j;
  ili9320_SetCursor(0,0);
  
  for(i=0;i<320;i++)
    for(j=0;j<240;j++)
    {
      if(i>279)LCD_WriteRAM(0x0000);
      else if(i>239)LCD_WriteRAM(0x001f);
      else if(i>199)LCD_WriteRAM(0x07e0);
      else if(i>159)LCD_WriteRAM(0x07ff);
      else if(i>119)LCD_WriteRAM(0xf800);
      else if(i>79)LCD_WriteRAM(0xf81f);
      else if(i>39)LCD_WriteRAM(0xffe0);
      else LCD_WriteRAM(0xffff);
    }
  
}

/****************************************************************************
* ??    3?ou16 ili9320_BGR2RGB(u16 c)
* 1|    ?oRRRRRGGGGGGBBBBB ???a BBBBBGGGGGGRRRRR ???
* ??2?yoc      BRG ????
* 3??2?yoRGB ????
* ?    ?¡o?2?oy̡¨?
* ̡¨??o
****************************************************************************/
u16 ili9320_BGR2RGB(u16 c)
{
  u16  r, g, b;

  b = (c>>0)  & 0x1f;
  g = (c>>5)  & 0x3f;
  r = (c>>11) & 0x1f;
  
  return( (b<<11) + (g<<5) + (r<<0) );
}

/****************************************************************************
* ??    3?ovoid ili9320_WriteIndex(u16 idx)
* 1|    ?oD ili9320 ?????????¦??
* ??2?yoidx   ????¦??
* 3??2?yo?T
* ?    ?¡o̡¨??D????D?????¡??2?oy
* ̡¨??oili9320_WriteIndex(0x0000);
****************************************************************************/
void ili9320_WriteIndex(u16 idx)
{
  LCD_WriteIndex(idx);
}

/****************************************************************************
* ??    3?ovoid ili9320_WriteData(u16 dat)
* 1|    ?oD ili9320 ????¨y?Y
* ??2?yodat     ????¨y?Y
* 3??2?yo?T
* ?    ?¡o???????????D䨨?y?Y?̡¨??D?D????¦????2?oy
* ̡¨??oili9320_WriteData(0x1030)
****************************************************************************/
void ili9320_WriteData(u16 dat)
{
  LCD_WriteRAM(dat);
}

/****************************************************************************
* ??    3?ou16 ili9320_ReadData(void)
* 1|    ?o???????¨y?Y
* ??2?yo?T
* 3??2?yo??????y?Y
* ?    ?¡o?2?oy
* ̡¨??oi=ili9320_ReadData();
****************************************************************************/
u16 ili9320_ReadData(void)
{
  u16 val=0;
  val=LCD_RD_Data();
  return val;
}

/****************************************************************************
* ??    3?ou16 ili9320_ReadRegister(u16 index)
* 1|    ?o???????????¦??
* ??2?yoindex    ????¦??
* 3??2?yo?????
* ?    ?¡o?2?oy
* ̡¨??oi=ili9320_ReadRegister(0x0022);
****************************************************************************/
u16 ili9320_ReadRegister(u16 index)
{
  u16 tmp;
  tmp= *(volatile unsigned int *)(0x60000000);
  
  return tmp;
}

/****************************************************************************
* ??    3?ovoid ili9320_WriteRegister(u16 index,u16 dat)
* 1|    ?oD?????????¦??
* ??2?yoindex    ????¦??
*         odat      ?????
* 3??2?yo?T
* ?    ?¡o?2?oy
* ̡¨??oili9320_WriteRegister(0x0000,0x0001);
****************************************************************************/
void ili9320_WriteRegister(u16 index)
{
 /************************************************************************
  **                                                                    **
  ** nCS       ----\__________________________________________/-------  **
  ** RS        ------\____________/-----------------------------------  **
  ** nRD       -------------------------------------------------------  **
  ** nWR       --------\_______/--------\_____/-----------------------  **
  ** DB[0:15]  ---------[index]----------[data]-----------------------  **
  **                                                                    **
  ************************************************************************/
  
  LCD_WriteReg(index);
}
/****************************************************************************
* ??    3?ovoid ili9320_Reset()
* 1|    ?o??? ili9320 ?????
* ??2?yo?T
* 3??2?yo?T
* ?    ?¡o????????¡??2?oy
* ̡¨??oili9320_Reset()
****************************************************************************/
void ili9320_Reset()
{
 	/* 1?CPU?reset??TD??? */
}

/****************************************************************************
* ??    3?ovoid ili9320_BackLight(u8 status)
* 1|    ?o?a?1?o?31a
* ??2?yostatus     1:31a?a  0:31a1?
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_BackLight(1);
****************************************************************************/
void ili9320_BackLight(u8 status)
{
  if ( status >= 1 )
  {
    //GPIO_SetBits(GPIOC,LCD_BK);
  }
  else
  {
    //GPIO_ResetBits(GPIOC,LCD_BK);
  }
}

/****************************************************************************
* ??    3?ovoid ili9320_Delay(vu32 nCount)
* 1|    ?o?
* ??2?yonCount   ??
* 3??2?yo?T
* ?    ?¡o
* ̡¨??oili9320_Delay(10000);
****************************************************************************/
void ili9320_Delay(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}

