
/**
 ***********************************************
 * LCD?a?䣤?t?2.4?o????y?IC?aILI9325   *
 * 9325??o????D9325?????D???    *
 * *********************************************
 */


#include "fsmc_sram.h"
#include "lcdconf.h"
#include "stm32f10x.h"														 
unsigned long color1=0;						
void LCD_9325_Init(void);
void LCD_WriteIndex(unsigned int index);
void LCD_WriteRAM_Prepare(void);
void LCD_WriteReg(unsigned int index);

void LCD_WriteRAM(unsigned int val);
void LCD_clear(unsigned int p);
void ini(void);
void Delay(volatile uint32_t nCount);
void lcd_wr_zf(unsigned int a, unsigned int b, unsigned int a1,unsigned int b1, unsigned int d,unsigned int e, unsigned char g, unsigned char *f); 
void lcd_wr_pixel(unsigned int a, unsigned int b, unsigned int e) ;
unsigned char *num_pub(unsigned int a);

unsigned int color[]={0xf800,0x07e0,0x001f,0xffe0,0x0000,0xffff,0x07ff,0xf81f};

unsigned int LCD_RD_Data(void);
extern void Delay(volatile uint32_t nCount);

/**
 * D????¦??
 */
void LCD_WriteIndex(unsigned int index)
{
	*(volatile uint16_t *) (LCD_Reg_Addr)= index;
}

/**
 * D䨺y?Y??
 */
void LCD_WriteRAM_Prepare(void)   
{
	LCD_WriteIndex(0x02c);
}

/**
 * D䨺y?Y3
 */
#define  LCD_WriteRAM_Ready() {LCD_CS;}


/**
 * D????oy
 */
void LCD_WriteReg(unsigned int LCD_Reg)
{	
	//LCD_nCS;
	*(volatile uint16_t *) (LCD_Reg_Addr) = LCD_Reg;
	//*(volatile uint16_t *) (LCD_Data_Addr) = LCD_RegValue;
	//LCD_CS;
}


/**
 * D䨺y?Yoy
 */
void LCD_WriteRAM(unsigned int val)
{   
	*(volatile uint16_t *) (LCD_Data_Addr)= val; 	
}

/**
 * ?y?Yoy
 */
unsigned int LCD_RD_Data(void)
{
	unsigned int temp,i=0;

	for(; i < 1; i++){
		temp = (*(volatile uint16_t *) (LCD_Data_Addr)); 
	}
	return( temp );	
}


/**
 * ?3oy
 */
void Delay(volatile uint32_t Count)
{
	int i;
  for(i = 0; i < Count; i++);
}


/**
 * LCD TFT 9325 Initoy
 */
void LCD_9325_Init(void)
{
    GPIO_SetBits(GPIOA, GPIO_Pin_4 );			 
	Delay(0xAFFF);
    GPIO_ResetBits(GPIOA, GPIO_Pin_4);
    Delay(0xAFFF);					   
    GPIO_SetBits(GPIOA, GPIO_Pin_4 );			 
	Delay(0xAFFF);
		
//************* Start Initial Sequence **********//   
		LCD_WriteReg(0xCF);		//Power control B 
		LCD_WriteRAM(0x00); 		//2????2?y
		LCD_WriteRAM(0x81); 
		LCD_WriteRAM(0X30); 

		LCD_WriteReg(0xED); 		//Power on sequence control 
		LCD_WriteRAM(0x64); 		
		LCD_WriteRAM(0x03); 
		LCD_WriteRAM(0X12); 
		LCD_WriteRAM(0X81);
		 
		LCD_WriteReg(0xE8); 		//Driver timing control A  
		LCD_WriteRAM(0x85); 
		LCD_WriteRAM(0x10); 
		LCD_WriteRAM(0x7A);
		 
		LCD_WriteReg(0xCB);  		//Power control A
		LCD_WriteRAM(0x39); 
		LCD_WriteRAM(0x2C); 
		LCD_WriteRAM(0x00); 
		LCD_WriteRAM(0x34); 
		LCD_WriteRAM(0x02);
		 
		LCD_WriteReg(0xF7);  		//Pump ratio control
		LCD_WriteRAM(0x20);
		 
		LCD_WriteReg(0xEA);  		//Driver timing control B
		LCD_WriteRAM(0x00); 
		LCD_WriteRAM(0x00);
		 
		LCD_WriteReg(0xC0);    //Power control 
		LCD_WriteRAM(0x1B);    //VRH[5:0] 

		LCD_WriteReg(0xC1);    //Power control 
		LCD_WriteRAM(0x01);    //BT[2:0]
		 
		LCD_WriteReg(0xC5);    //VCOM control 
		LCD_WriteRAM(0x30); 	 
		LCD_WriteRAM(0x30); 	 

		LCD_WriteReg(0xC7);    //VCOM control2 
		LCD_WriteRAM(0XB7); 

		LCD_WriteReg(0x36);    // Memory Access Control 	0x48
		LCD_WriteRAM(0x88);	   //MY = 0oRow Address Order,MY=1?䨨??ꡧo????3???2?????????䨮??
								//MX = 0oColumn Address Order,MX=0?䨨?o??䨮?????
								//MV = 0oRow / Column Exchange		===DDD2?????
								//ML = 0oVertical Refresh Order 	===  0 -> 319
								//BGR = 1o1?BGR color filter panel
								//MH = 0oHorizontal Refresh Order 	===  0 -> 239
		 
		LCD_WriteReg(0x3A);   
		LCD_WriteRAM(0x55);
		 
		LCD_WriteReg(0xB1);   
		LCD_WriteRAM(0x00);   
		LCD_WriteRAM(0x1A);
		 
		LCD_WriteReg(0xB6);    // Display Function Control 
		LCD_WriteRAM(0x0A); 
		LCD_WriteRAM(0xA2);
		 
		LCD_WriteReg(0xF2);    // 3Gamma Function Disable 
		LCD_WriteRAM(0x00); 
		LCD_WriteReg(0x26);    //Gamma curve selected 
		LCD_WriteRAM(0x01); 
		LCD_WriteReg(0xE0);    //Set Gamma 
		LCD_WriteRAM(0x0F); 
		LCD_WriteRAM(0x2A); 
		LCD_WriteRAM(0x28); 
		LCD_WriteRAM(0x08); 
		LCD_WriteRAM(0x0E); 
		LCD_WriteRAM(0x08); 
		LCD_WriteRAM(0x54); 
		LCD_WriteRAM(0XA9); 
		LCD_WriteRAM(0x43); 
		LCD_WriteRAM(0x0A); 
		LCD_WriteRAM(0x0F); 
		LCD_WriteRAM(0x00); 
		LCD_WriteRAM(0x00); 
		LCD_WriteRAM(0x00); 
		LCD_WriteRAM(0x00); 		 
		LCD_WriteReg(0XE1);    //Set Gamma 
		LCD_WriteRAM(0x00); 
		LCD_WriteRAM(0x15); 
		LCD_WriteRAM(0x17); 
		LCD_WriteRAM(0x07); 
		LCD_WriteRAM(0x11); 
		LCD_WriteRAM(0x06); 
		LCD_WriteRAM(0x2B); 
		LCD_WriteRAM(0x56); 
		LCD_WriteRAM(0x3C); 
		LCD_WriteRAM(0x05); 
		LCD_WriteRAM(0x10); 
		LCD_WriteRAM(0x0F); 
		LCD_WriteRAM(0x3F); 
		LCD_WriteRAM(0x3F); 
		LCD_WriteRAM(0x0F);
		 
		LCD_WriteReg(0x2B);		//騰a???2??? 0x2A?? 
		LCD_WriteRAM(0x00);
		LCD_WriteRAM(0x00);
		LCD_WriteRAM(0x01);
		LCD_WriteRAM(0x3f);

		LCD_WriteReg(0x2A);		//D??????e????a0??????aEFH??239
		LCD_WriteRAM(0x00);	    //騰a??e????D?  ???? D??
		LCD_WriteRAM(0x00);		//2????aD?239?319???䨮3??2?????o???
		LCD_WriteRAM(0x00);
		LCD_WriteRAM(0xef);
			 
		LCD_WriteReg(0x11); //Exit Sleep
		Delay(0XFFFFF);
		LCD_WriteReg(0x29); //display on	
}





/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
