/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F10_ASCII.c
Purpose     : ASCII character set
Height      : 10
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"


GUI_CONST_STORAGE unsigned char acFont10_ASCII_32[10] = { /* code 32 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_33[10] = { /* code 33 */
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_34[10] = { /* code 34 */
  ________,
  X_X_____,
  X_X_____,
  X_X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_35[10] = { /* code 35 */
  ________,
  __X_X___,
  __X_X___,
  XXXXX___,
  _X_X____,
  _X_X____,
  XXXXX___,
  X_X_____,
  X_X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_36[10] = { /* code 36 */
  ________,
  _XXX____,
  X_X_X___,
  X_X_____,
  _XXX____,
  __X_X___,
  __X_X___,
  X_X_X___,
  _XXX____,
  __X_____};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_37[20] = { /* code 37 */
  ________,________,
  _XX___X_,________,
  X__X_X__,________,
  X__X_X__,________,
  _XX_X___,________,
  ____X_XX,________,
  ___X_X__,X_______,
  ___X_X__,X_______,
  __X___XX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_38[10] = { /* code 38 */
  ________,
  __XX____,
  _X__X___,
  _X__X___,
  __XX____,
  _X_X____,
  X___XX__,
  X___X___,
  _XXX_X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_39[10] = { /* code 39 */
  ________,
  X_______,
  X_______,
  X_______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_40[10] = { /* code 40 */
  ________,
  __X_____,
  _X______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  _X______,
  __X_____};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_41[10] = { /* code 41 */
  ________,
  X_______,
  _X______,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  _X______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_42[10] = { /* code 42 */
  ________,
  _X______,
  XXX_____,
  _X______,
  X_X_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_43[10] = { /* code 43 */
  ________,
  ________,
  ________,
  __X_____,
  __X_____,
  XXXXX___,
  __X_____,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_44[10] = { /* code 44 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_45[10] = { /* code 45 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_46[10] = { /* code 46 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_47[10] = { /* code 47 */
  ________,
  __X_____,
  __X_____,
  _X______,
  _X______,
  _X______,
  _X______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_48[10] = { /* code 48 */
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_49[10] = { /* code 49 */
  ________,
  __X_____,
  _XX_____,
  X_X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_50[10] = { /* code 50 */
  ________,
  _XXX____,
  X___X___,
  ____X___,
  ____X___,
  ___X____,
  __X_____,
  _X______,
  XXXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_51[10] = { /* code 51 */
  ________,
  _XXX____,
  X___X___,
  ____X___,
  __XX____,
  ____X___,
  ____X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_52[10] = { /* code 52 */
  ________,
  ___X____,
  __XX____,
  _X_X____,
  _X_X____,
  X__X____,
  XXXXX___,
  ___X____,
  ___X____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_53[10] = { /* code 53 */
  ________,
  _XXXX___,
  _X______,
  X_______,
  XXXX____,
  ____X___,
  ____X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_54[10] = { /* code 54 */
  ________,
  _XXX____,
  X___X___,
  X_______,
  XXXX____,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_55[10] = { /* code 55 */
  ________,
  XXXXX___,
  ___X____,
  ___X____,
  __X_____,
  __X_____,
  _X______,
  _X______,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_56[10] = { /* code 56 */
  ________,
  _XXX____,
  X___X___,
  X___X___,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_57[10] = { /* code 57 */
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  _XXXX___,
  ____X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_58[10] = { /* code 58 */
  ________,
  ________,
  ________,
  X_______,
  ________,
  ________,
  ________,
  ________,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_59[10] = { /* code 59 */
  ________,
  ________,
  ________,
  X_______,
  ________,
  ________,
  ________,
  X_______,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_60[10] = { /* code 60 */
  ________,
  ________,
  ________,
  ____X___,
  _XXX____,
  X_______,
  _XXX____,
  ____X___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_61[10] = { /* code 61 */
  ________,
  ________,
  ________,
  ________,
  XXXXX___,
  ________,
  XXXXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_62[10] = { /* code 62 */
  ________,
  ________,
  ________,
  X_______,
  _XXX____,
  ____X___,
  _XXX____,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_63[10] = { /* code 63 */
  ________,
  _XXX____,
  X___X___,
  ____X___,
  ___X____,
  __X_____,
  __X_____,
  ________,
  __X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_64[20] = { /* code 64 */
  ________,________,
  ___XXXXX,________,
  _XX_____,X_______,
  _X__XX_X,_X______,
  X__X__XX,_X______,
  X_X___X_,_X______,
  X_X__XX_,X_______,
  X__XX_XX,________,
  _X______,_X______,
  __XXXXXX,X_______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_65[10] = { /* code 65 */
  ________,
  ___X____,
  __X_X___,
  __X_X___,
  __X_X___,
  _X___X__,
  _XXXXX__,
  X_____X_,
  X_____X_,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_66[10] = { /* code 66 */
  ________,
  XXXXX___,
  X____X__,
  X____X__,
  XXXXXX__,
  X____X__,
  X____X__,
  X____X__,
  XXXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_67[10] = { /* code 67 */
  ________,
  __XXX___,
  _X___X__,
  X_______,
  X_______,
  X_______,
  X_______,
  _X___X__,
  __XXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_68[10] = { /* code 68 */
  ________,
  XXXX____,
  X___X___,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X___X___,
  XXXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_69[10] = { /* code 69 */
  ________,
  XXXXX___,
  X_______,
  X_______,
  XXXXX___,
  X_______,
  X_______,
  X_______,
  XXXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_70[10] = { /* code 70 */
  ________,
  XXXXX___,
  X_______,
  X_______,
  XXXX____,
  X_______,
  X_______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_71[10] = { /* code 71 */
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_______,
  X___XXX_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_72[10] = { /* code 72 */
  ________,
  X____X__,
  X____X__,
  X____X__,
  XXXXXX__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_73[10] = { /* code 73 */
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_74[10] = { /* code 74 */
  ________,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  X__X____,
  X__X____,
  _XX_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_75[10] = { /* code 75 */
  ________,
  X____X__,
  X___X___,
  X__X____,
  X_XX____,
  XX_X____,
  X___X___,
  X___X___,
  X____X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_76[10] = { /* code 76 */
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  XXXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_77[10] = { /* code 77 */
  ________,
  X_____X_,
  XX___XX_,
  XX___XX_,
  X_X_X_X_,
  X_X_X_X_,
  X_X_X_X_,
  X__X__X_,
  X__X__X_,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_78[10] = { /* code 78 */
  ________,
  X____X__,
  XX___X__,
  X_X__X__,
  X_X__X__,
  X__X_X__,
  X__X_X__,
  X___XX__,
  X____X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_79[10] = { /* code 79 */
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_80[10] = { /* code 80 */
  ________,
  XXXX____,
  X___X___,
  X___X___,
  X___X___,
  XXXX____,
  X_______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_81[10] = { /* code 81 */
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X__XX_X_,
  _X___X__,
  __XXX_X_,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_82[10] = { /* code 82 */
  ________,
  XXXXX___,
  X____X__,
  X____X__,
  XXXXX___,
  X__X____,
  X___X___,
  X___X___,
  X____X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_83[10] = { /* code 83 */
  ________,
  _XXXX___,
  X____X__,
  X_______,
  _XX_____,
  ___XX___,
  _____X__,
  X____X__,
  _XXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_84[10] = { /* code 84 */
  ________,
  XXXXX___,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_85[10] = { /* code 85 */
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_86[10] = { /* code 86 */
  ________,
  X_____X_,
  X_____X_,
  _X___X__,
  _X___X__,
  __X_X___,
  __X_X___,
  ___X____,
  ___X____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_87[20] = { /* code 87 */
  ________,________,
  X____X__,__X_____,
  X___X_X_,__X_____,
  _X__X_X_,_X______,
  _X__X_X_,_X______,
  _X_X___X,_X______,
  _X_X___X,_X______,
  __X_____,X_______,
  __X_____,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_88[10] = { /* code 88 */
  ________,
  X____X__,
  _X__X___,
  _X__X___,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  X____X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_89[10] = { /* code 89 */
  ________,
  X_____X_,
  _X___X__,
  _X___X__,
  __X_X___,
  ___X____,
  ___X____,
  ___X____,
  ___X____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_90[10] = { /* code 90 */
  ________,
  _XXXXX__,
  ____X___,
  ___X____,
  ___X____,
  __X_____,
  __X_____,
  _X______,
  XXXXXX__,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_91[10] = { /* code 91 */
  ________,
  XX______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  XX______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_92[10] = { /* code 92 */
  ________,
  X_______,
  X_______,
  _X______,
  _X______,
  _X______,
  _X______,
  __X_____,
  __X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_93[10] = { /* code 93 */
  ________,
  XX______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XX______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_94[10] = { /* code 94 */
  ________,
  __X_____,
  _X_X____,
  _X_X____,
  X___X___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_95[10] = { /* code 95 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXXXX__};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_96[10] = { /* code 96 */
  ________,
  X_______,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_97[10] = { /* code 97 */
  ________,
  ________,
  ________,
  _XXX____,
  X___X___,
  _XXXX___,
  X___X___,
  X__XX___,
  _XX_X___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_98[10] = { /* code 98 */
  ________,
  X_______,
  X_______,
  X_XX____,
  XX__X___,
  X___X___,
  X___X___,
  XX__X___,
  X_XX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_99[10] = { /* code 99 */
  ________,
  ________,
  ________,
  _XXX____,
  X___X___,
  X_______,
  X_______,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_100[10] = { /* code 100 */
  ________,
  ____X___,
  ____X___,
  _XX_X___,
  X__XX___,
  X___X___,
  X___X___,
  X__XX___,
  _XX_X___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_101[10] = { /* code 101 */
  ________,
  ________,
  ________,
  _XXX____,
  X___X___,
  XXXXX___,
  X_______,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_102[10] = { /* code 102 */
  ________,
  __X_____,
  _X______,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_103[10] = { /* code 103 */
  ________,
  ________,
  ________,
  _XX_X___,
  X__XX___,
  X___X___,
  X__XX___,
  _XX_X___,
  ____X___,
  _XXX____};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_104[10] = { /* code 104 */
  ________,
  X_______,
  X_______,
  X_XX____,
  XX__X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_105[10] = { /* code 105 */
  ________,
  X_______,
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_106[10] = { /* code 106 */
  ________,
  X_______,
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_107[10] = { /* code 107 */
  ________,
  X_______,
  X_______,
  X__X____,
  X_X_____,
  XX______,
  X_X_____,
  X_X_____,
  X__X____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_108[10] = { /* code 108 */
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_109[10] = { /* code 109 */
  ________,
  ________,
  ________,
  X_XXXX__,
  XX_X__X_,
  X__X__X_,
  X__X__X_,
  X__X__X_,
  X__X__X_,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_110[10] = { /* code 110 */
  ________,
  ________,
  ________,
  XXXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_111[10] = { /* code 111 */
  ________,
  ________,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_112[10] = { /* code 112 */
  ________,
  ________,
  ________,
  X_XX____,
  XX__X___,
  X___X___,
  X___X___,
  XX__X___,
  X_XX____,
  X_______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_113[10] = { /* code 113 */
  ________,
  ________,
  ________,
  _XX_X___,
  X__XX___,
  X___X___,
  X___X___,
  X__XX___,
  _XX_X___,
  ____X___};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_114[10] = { /* code 114 */
  ________,
  ________,
  ________,
  X_X_____,
  XX______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_115[10] = { /* code 115 */
  ________,
  ________,
  ________,
  _XXX____,
  X___X___,
  _XX_____,
  ___X____,
  X___X___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_116[10] = { /* code 116 */
  ________,
  X_______,
  X_______,
  XX______,
  X_______,
  X_______,
  X_______,
  X_______,
  XX______,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_117[10] = { /* code 117 */
  ________,
  ________,
  ________,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X__XX___,
  _XX_X___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_118[10] = { /* code 118 */
  ________,
  ________,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_119[20] = { /* code 119 */
  ________,________,
  ________,________,
  ________,________,
  X___X___,X_______,
  X__X_X__,X_______,
  _X_X_X_X,________,
  _X_X_X_X,________,
  __X___X_,________,
  __X___X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_120[10] = { /* code 120 */
  ________,
  ________,
  ________,
  X___X___,
  _X_X____,
  __X_____,
  __X_____,
  _X_X____,
  X___X___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_121[10] = { /* code 121 */
  ________,
  ________,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  __X_____};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_122[10] = { /* code 122 */
  ________,
  ________,
  ________,
  XXXXX___,
  ___X____,
  __X_____,
  __X_____,
  _X______,
  XXXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_123[10] = { /* code 123 */
  ________,
  __X_____,
  _X______,
  _X______,
  _X______,
  X_______,
  _X______,
  _X______,
  _X______,
  __X_____};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_124[10] = { /* code 124 */
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_125[10] = { /* code 125 */
  ________,
  _X______,
  __X_____,
  __X_____,
  __X_____,
  ___X____,
  __X_____,
  __X_____,
  __X_____,
  _X______};

GUI_CONST_STORAGE unsigned char acFont10_ASCII_126[10] = { /* code 126 */
  ________,
  ________,
  ________,
  ________,
  XXX_X___,
  X_XX____,
  ________,
  ________,
  ________,
  ________};



GUI_CONST_STORAGE GUI_CHARINFO GUI_Font10_ASCII_CharInfo[96] = {
   {   3,   3,  1, acFont10_ASCII_32 } /* code  32 */
  ,{   2,   2,  1, acFont10_ASCII_33 } /* code  33 */
  ,{   4,   4,  1, acFont10_ASCII_34 } /* code  34 */
  ,{   6,   6,  1, acFont10_ASCII_35 } /* code  35 */
  ,{   6,   6,  1, acFont10_ASCII_36 } /* code  36 */
  ,{  10,  10,  2, acFont10_ASCII_37 } /* code  37 */
  ,{   7,   7,  1, acFont10_ASCII_38 } /* code  38 */
  ,{   2,   2,  1, acFont10_ASCII_39 } /* code  39 */
  ,{   4,   4,  1, acFont10_ASCII_40 } /* code  40 */
  ,{   4,   4,  1, acFont10_ASCII_41 } /* code  41 */
  ,{   4,   4,  1, acFont10_ASCII_42 } /* code  42 */
  ,{   6,   6,  1, acFont10_ASCII_43 } /* code  43 */
  ,{   3,   3,  1, acFont10_ASCII_44 } /* code  44 */
  ,{   4,   4,  1, acFont10_ASCII_45 } /* code  45 */
  ,{   3,   3,  1, acFont10_ASCII_46 } /* code  46 */
  ,{   3,   3,  1, acFont10_ASCII_47 } /* code  47 */
  ,{   6,   6,  1, acFont10_ASCII_48 } /* code  48 */
  ,{   6,   6,  1, acFont10_ASCII_49 } /* code  49 */
  ,{   6,   6,  1, acFont10_ASCII_50 } /* code  50 */
  ,{   6,   6,  1, acFont10_ASCII_51 } /* code  51 */
  ,{   6,   6,  1, acFont10_ASCII_52 } /* code  52 */
  ,{   6,   6,  1, acFont10_ASCII_53 } /* code  53 */
  ,{   6,   6,  1, acFont10_ASCII_54 } /* code  54 */
  ,{   6,   6,  1, acFont10_ASCII_55 } /* code  55 */
  ,{   6,   6,  1, acFont10_ASCII_56 } /* code  56 */
  ,{   6,   6,  1, acFont10_ASCII_57 } /* code  57 */
  ,{   3,   3,  1, acFont10_ASCII_58 } /* code  58 */
  ,{   3,   3,  1, acFont10_ASCII_59 } /* code  59 */
  ,{   6,   6,  1, acFont10_ASCII_60 } /* code  60 */
  ,{   6,   6,  1, acFont10_ASCII_61 } /* code  61 */
  ,{   6,   6,  1, acFont10_ASCII_62 } /* code  62 */
  ,{   6,   6,  1, acFont10_ASCII_63 } /* code  63 */
  ,{  11,  11,  2, acFont10_ASCII_64 } /* code  64 */
  ,{   8,   8,  1, acFont10_ASCII_65 } /* code  65 */
  ,{   7,   7,  1, acFont10_ASCII_66 } /* code  66 */
  ,{   7,   7,  1, acFont10_ASCII_67 } /* code  67 */
  ,{   7,   7,  1, acFont10_ASCII_68 } /* code  68 */
  ,{   6,   6,  1, acFont10_ASCII_69 } /* code  69 */
  ,{   6,   6,  1, acFont10_ASCII_70 } /* code  70 */
  ,{   8,   8,  1, acFont10_ASCII_71 } /* code  71 */
  ,{   7,   7,  1, acFont10_ASCII_72 } /* code  72 */
  ,{   2,   2,  1, acFont10_ASCII_73 } /* code  73 */
  ,{   5,   5,  1, acFont10_ASCII_74 } /* code  74 */
  ,{   7,   7,  1, acFont10_ASCII_75 } /* code  75 */
  ,{   6,   6,  1, acFont10_ASCII_76 } /* code  76 */
  ,{   8,   8,  1, acFont10_ASCII_77 } /* code  77 */
  ,{   7,   7,  1, acFont10_ASCII_78 } /* code  78 */
  ,{   8,   8,  1, acFont10_ASCII_79 } /* code  79 */
  ,{   6,   6,  1, acFont10_ASCII_80 } /* code  80 */
  ,{   8,   8,  1, acFont10_ASCII_81 } /* code  81 */
  ,{   7,   7,  1, acFont10_ASCII_82 } /* code  82 */
  ,{   7,   7,  1, acFont10_ASCII_83 } /* code  83 */
  ,{   6,   6,  1, acFont10_ASCII_84 } /* code  84 */
  ,{   7,   7,  1, acFont10_ASCII_85 } /* code  85 */
  ,{   8,   8,  1, acFont10_ASCII_86 } /* code  86 */
  ,{  11,  11,  2, acFont10_ASCII_87 } /* code  87 */
  ,{   7,   7,  1, acFont10_ASCII_88 } /* code  88 */
  ,{   8,   8,  1, acFont10_ASCII_89 } /* code  89 */
  ,{   7,   7,  1, acFont10_ASCII_90 } /* code  90 */
  ,{   3,   3,  1, acFont10_ASCII_91 } /* code  91 */
  ,{   3,   3,  1, acFont10_ASCII_92 } /* code  92 */
  ,{   3,   3,  1, acFont10_ASCII_93 } /* code  93 */
  ,{   5,   5,  1, acFont10_ASCII_94 } /* code  94 */
  ,{   6,   6,  1, acFont10_ASCII_95 } /* code  95 */
  ,{   4,   4,  1, acFont10_ASCII_96 } /* code  96 */
  ,{   6,   6,  1, acFont10_ASCII_97 } /* code  97 */
  ,{   6,   6,  1, acFont10_ASCII_98 } /* code  98 */
  ,{   6,   6,  1, acFont10_ASCII_99 } /* code  99 */
  ,{   6,   6,  1, acFont10_ASCII_100 } /* code 100 */
  ,{   6,   6,  1, acFont10_ASCII_101 } /* code 101 */
  ,{   4,   4,  1, acFont10_ASCII_102 } /* code 102 */
  ,{   6,   6,  1, acFont10_ASCII_103 } /* code 103 */
  ,{   6,   6,  1, acFont10_ASCII_104 } /* code 104 */
  ,{   2,   2,  1, acFont10_ASCII_105 } /* code 105 */
  ,{   2,   2,  1, acFont10_ASCII_106 } /* code 106 */
  ,{   5,   5,  1, acFont10_ASCII_107 } /* code 107 */
  ,{   2,   2,  1, acFont10_ASCII_108 } /* code 108 */
  ,{   8,   8,  1, acFont10_ASCII_109 } /* code 109 */
  ,{   6,   6,  1, acFont10_ASCII_110 } /* code 110 */
  ,{   6,   6,  1, acFont10_ASCII_111 } /* code 111 */
  ,{   6,   6,  1, acFont10_ASCII_112 } /* code 112 */
  ,{   6,   6,  1, acFont10_ASCII_113 } /* code 113 */
  ,{   4,   4,  1, acFont10_ASCII_114 } /* code 114 */
  ,{   6,   6,  1, acFont10_ASCII_115 } /* code 115 */
  ,{   3,   3,  1, acFont10_ASCII_116 } /* code 116 */
  ,{   6,   6,  1, acFont10_ASCII_117 } /* code 117 */
  ,{   6,   6,  1, acFont10_ASCII_118 } /* code 118 */
  ,{  10,  10,  2, acFont10_ASCII_119 } /* code 119 */
  ,{   6,   6,  1, acFont10_ASCII_120 } /* code 120 */
  ,{   6,   6,  1, acFont10_ASCII_121 } /* code 121 */
  ,{   6,   6,  1, acFont10_ASCII_122 } /* code 122 */
  ,{   4,   4,  1, acFont10_ASCII_123 } /* code 123 */
  ,{   2,   2,  1, acFont10_ASCII_124 } /* code 124 */
  ,{   4,   4,  1, acFont10_ASCII_125 } /* code 125 */
  ,{   6,   6,  1, acFont10_ASCII_126 } /* code 126 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font10ASCIIProp1 = {
   32                            /* first character               */
  ,126                           /* last character                */
  ,&GUI_Font10_ASCII_CharInfo[0] /* address of first character    */
  ,(const GUI_FONT_PROP*)0       /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font10_ASCII = {
   GUI_FONTTYPE_PROP             /* type of font    */
  ,10                            /* height of font  */
  ,10                            /* space of font y */
  ,1                             /* magnification x */
  ,1                             /* magnification y */
  ,{&GUI_Font10ASCIIProp1}
  , 9, 6, 8 
};

/*************************** End of file ****************************/
