/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F13_1.c
Purpose     : ISO 8859-1 West European Character Set similar to Swiss
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"


/* Start of unicode area <Latin-1 Supplement> */

GUI_CONST_STORAGE unsigned char acFont13_1_00A0[13] = { /* code 00A0 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00A1[13] = { /* code 00A1 */
  ________,
  ________,
  ________,
  _X______,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00A2[13] = { /* code 00A2 */
  ________,
  ________,
  ________,
  __X_____,
  __X_____,
  _XXXX___,
  X_X_____,
  X_X_____,
  X_X_____,
  X_X_____,
  _XXXX___,
  __X_____,
  __X_____};

GUI_CONST_STORAGE unsigned char acFont13_1_00A3[13] = { /* code 00A3 */
  ________,
  ________,
  ________,
  __XXX___,
  _X______,
  _X______,
  _X______,
  XXXX____,
  _X______,
  _X______,
  XXXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00A4[13] = { /* code 00A4 */
  ________,
  ________,
  ________,
  ________,
  ________,
  X___X___,
  _XXX____,
  _X_X____,
  _XXX____,
  X___X___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00A5[13] = { /* code 00A5 */
  ________,
  ________,
  ________,
  X___X___,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  XXXXX___,
  __X_____,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00A6[13] = { /* code 00A6 */
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont13_1_00A7[13] = { /* code 00A7 */
  ________,
  ________,
  ________,
  _XXXX___,
  X_______,
  X_______,
  _XXX____,
  X___X___,
  X___X___,
  _XXX____,
  ____X___,
  ____X___,
  XXXX____};

GUI_CONST_STORAGE unsigned char acFont13_1_00A8[13] = { /* code 00A8 */
  ________,
  ________,
  ________,
  _X_X____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00A9[26] = { /* code 00A9 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXX_,________,
  _X_____X,________,
  X__XXX__,X_______,
  X_X_____,X_______,
  X_X_____,X_______,
  X_X_____,X_______,
  X__XXX__,X_______,
  _X_____X,________,
  __XXXXX_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00AA[13] = { /* code 00AA */
  ________,
  ________,
  ________,
  XXX_____,
  ___X____,
  _XXX____,
  X__X____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00AB[13] = { /* code 00AB */
  ________,
  ________,
  ________,
  ________,
  ________,
  __X_X___,
  _X_X____,
  X_X_____,
  _X_X____,
  __X_X___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00AC[13] = { /* code 00AC */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXXX_,
  ______X_,
  ______X_,
  ______X_,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00AD[13] = { /* code 00AD */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00AE[26] = { /* code 00AE */
  ________,________,
  ________,________,
  ________,________,
  __XXXXX_,________,
  _X_____X,________,
  X__XXX__,X_______,
  X__X__X_,X_______,
  X__XXX__,X_______,
  X__X_X__,X_______,
  X__X__X_,X_______,
  _X_____X,________,
  __XXXXX_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00AF[13] = { /* code 00AF */
  ________,
  XXXXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B0[13] = { /* code 00B0 */
  ________,
  ________,
  ________,
  _XX_____,
  X__X____,
  X__X____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B1[13] = { /* code 00B1 */
  ________,
  ________,
  ________,
  ___X____,
  ___X____,
  ___X____,
  XXXXXXX_,
  ___X____,
  ___X____,
  XXXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B2[13] = { /* code 00B2 */
  ________,
  ________,
  ________,
  _XX_____,
  ___X____,
  ___X____,
  __X_____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B3[13] = { /* code 00B3 */
  ________,
  ________,
  ________,
  _XX_____,
  ___X____,
  __X_____,
  ___X____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B4[13] = { /* code 00B4 */
  ________,
  ________,
  ___X____,
  __X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B5[13] = { /* code 00B5 */
  ________,
  ________,
  ________,
  ________,
  ________,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X__XX___,
  XXX_X___,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont13_1_00B6[13] = { /* code 00B6 */
  ________,
  ________,
  ________,
  _XXXX___,
  XXX_X___,
  XXX_X___,
  XXX_X___,
  _XX_X___,
  __X_X___,
  __X_X___,
  __X_X___,
  __X_X___,
  __X_X___};

GUI_CONST_STORAGE unsigned char acFont13_1_00B7[13] = { /* code 00B7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X______,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00B8[13] = { /* code 00B8 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13_1_00B9[13] = { /* code 00B9 */
  ________,
  ________,
  ________,
  __X_____,
  _XX_____,
  __X_____,
  __X_____,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00BA[13] = { /* code 00BA */
  ________,
  ________,
  ________,
  _XX_____,
  X__X____,
  X__X____,
  X__X____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00BB[13] = { /* code 00BB */
  ________,
  ________,
  ________,
  ________,
  ________,
  X_X_____,
  _X_X____,
  __X_X___,
  _X_X____,
  X_X_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00BC[26] = { /* code 00BC */
  ________,________,
  ________,________,
  ________,________,
  __X____X,________,
  _XX___X_,________,
  __X___X_,________,
  __X__X__,X_______,
  __X__X_X,X_______,
  ____X_X_,X_______,
  ____X_XX,XX______,
  ___X____,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00BD[26] = { /* code 00BD */
  ________,________,
  ________,________,
  ________,________,
  __X____X,________,
  _XX___X_,________,
  __X___X_,________,
  __X__X_X,X_______,
  __X__X__,_X______,
  ____X___,_X______,
  ____X___,X_______,
  ___X___X,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00BE[26] = { /* code 00BE */
  ________,________,
  ________,________,
  ________,________,
  _XXX___X,________,
  ____X_X_,________,
  __XX__X_,________,
  ____XX__,X_______,
  _XXX_X_X,X_______,
  ____X_X_,X_______,
  ____X_XX,XX______,
  ___X____,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00BF[13] = { /* code 00BF */
  ________,
  ________,
  ________,
  __X_____,
  ________,
  __X_____,
  __X_____,
  _X______,
  X_______,
  X_______,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C0[13] = { /* code 00C0 */
  __X_____,
  ___X____,
  ________,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  XXXXXX__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C1[13] = { /* code 00C1 */
  ___X____,
  __X_____,
  ________,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  XXXXXX__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C2[13] = { /* code 00C2 */
  __XX____,
  _X__X___,
  ________,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  XXXXXX__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C3[13] = { /* code 00C3 */
  _XX_X___,
  _X_XX___,
  ________,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  XXXXXX__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C4[13] = { /* code 00C4 */
  ________,
  _X__X___,
  ________,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  XXXXXX__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C5[13] = { /* code 00C5 */
  __XX____,
  _X__X___,
  _X__X___,
  __XX____,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  XXXXXX__,
  X____X__,
  X____X__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C6[26] = { /* code 00C6 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,X_______,
  __X_X___,________,
  _X__X___,________,
  _X__XXXX,________,
  _XXXX___,________,
  X___X___,________,
  X___X___,________,
  X___XXXX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C7[13] = { /* code 00C7 */
  ________,
  ________,
  ________,
  __XXXX__,
  _X______,
  X_______,
  X_______,
  X_______,
  X_______,
  _X______,
  __XXXX__,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont13_1_00C8[13] = { /* code 00C8 */
  __X_____,
  ___X____,
  ________,
  XXXXX___,
  X_______,
  X_______,
  XXXX____,
  X_______,
  X_______,
  X_______,
  XXXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00C9[13] = { /* code 00C9 */
  ___X____,
  __X_____,
  ________,
  XXXXX___,
  X_______,
  X_______,
  XXXX____,
  X_______,
  X_______,
  X_______,
  XXXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00CA[13] = { /* code 00CA */
  __XX____,
  _X__X___,
  ________,
  XXXXX___,
  X_______,
  X_______,
  XXXX____,
  X_______,
  X_______,
  X_______,
  XXXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00CB[13] = { /* code 00CB */
  ________,
  _X_X____,
  ________,
  XXXXX___,
  X_______,
  X_______,
  XXXX____,
  X_______,
  X_______,
  X_______,
  XXXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00CC[13] = { /* code 00CC */
  X_______,
  _X______,
  ________,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00CD[13] = { /* code 00CD */
  __X_____,
  _X______,
  ________,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00CE[13] = { /* code 00CE */
  _XX_____,
  X__X____,
  ________,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00CF[13] = { /* code 00CF */
  ________,
  X_X_____,
  ________,
  XXX_____,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  XXX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D0[13] = { /* code 00D0 */
  ________,
  ________,
  ________,
  _XXXX___,
  _X___X__,
  _X____X_,
  XXXX__X_,
  _X____X_,
  _X____X_,
  _X___X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D1[13] = { /* code 00D1 */
  _XX_X___,
  _X_XX___,
  ________,
  XX___X__,
  XX___X__,
  X_X__X__,
  X_X__X__,
  X__X_X__,
  X__X_X__,
  X___XX__,
  X___XX__,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D2[13] = { /* code 00D2 */
  __X_____,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D3[13] = { /* code 00D3 */
  ____X___,
  ___X____,
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D4[13] = { /* code 00D4 */
  ___XX___,
  __X__X__,
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D5[13] = { /* code 00D5 */
  __XX_X__,
  __X_XX__,
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D6[13] = { /* code 00D6 */
  ________,
  __X_X___,
  ________,
  __XXX___,
  _X___X__,
  X_____X_,
  X_____X_,
  X_____X_,
  X_____X_,
  _X___X__,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D7[13] = { /* code 00D7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __X___X_,
  ___X_X__,
  ____X___,
  ___X_X__,
  __X___X_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D8[13] = { /* code 00D8 */
  ________,
  ________,
  ________,
  __XXX_X_,
  _X___X__,
  X___X_X_,
  X__X__X_,
  X__X__X_,
  X_X___X_,
  _X___X__,
  X_XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00D9[13] = { /* code 00D9 */
  __X_____,
  ___X____,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00DA[13] = { /* code 00DA */
  ___X____,
  __X_____,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00DB[13] = { /* code 00DB */
  __XX____,
  _X__X___,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00DC[13] = { /* code 00DC */
  ________,
  _X__X___,
  ________,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  X____X__,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00DD[13] = { /* code 00DD */
  ___X____,
  __X_____,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  __X_____,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00DE[13] = { /* code 00DE */
  ________,
  ________,
  ________,
  X_______,
  X_______,
  XXXX____,
  X___X___,
  X___X___,
  XXXX____,
  X_______,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00DF[13] = { /* code 00DF */
  ________,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X_XX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X_XX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E0[13] = { /* code 00E0 */
  ________,
  ________,
  __X_____,
  ___X____,
  ________,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E1[13] = { /* code 00E1 */
  ________,
  ________,
  ___X____,
  __X_____,
  ________,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E2[13] = { /* code 00E2 */
  ________,
  ________,
  __XX____,
  _X__X___,
  ________,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E3[13] = { /* code 00E3 */
  ________,
  ________,
  _XX_X___,
  _X_XX___,
  ________,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E4[13] = { /* code 00E4 */
  ________,
  ________,
  ________,
  _X_X____,
  ________,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E5[13] = { /* code 00E5 */
  ________,
  __XX____,
  _X__X___,
  _X__X___,
  __XX____,
  _XXX____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E6[26] = { /* code 00E6 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX_XXX,________,
  ____X___,X_______,
  _XXXXXXX,X_______,
  X___X___,________,
  X___XX__,X_______,
  _XXX__XX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E7[13] = { /* code 00E7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  X_______,
  X_______,
  X_______,
  X_______,
  _XXX____,
  __X_____,
  XX______};

GUI_CONST_STORAGE unsigned char acFont13_1_00E8[13] = { /* code 00E8 */
  ________,
  ________,
  _X______,
  __X_____,
  ________,
  _XXX____,
  X___X___,
  XXXXX___,
  X_______,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00E9[13] = { /* code 00E9 */
  ________,
  ________,
  ___X____,
  __X_____,
  ________,
  _XXX____,
  X___X___,
  XXXXX___,
  X_______,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00EA[13] = { /* code 00EA */
  ________,
  ________,
  __XX____,
  _X__X___,
  ________,
  _XXX____,
  X___X___,
  XXXXX___,
  X_______,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00EB[13] = { /* code 00EB */
  ________,
  ________,
  ________,
  _X_X____,
  ________,
  _XXX____,
  X___X___,
  XXXXX___,
  X_______,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00EC[13] = { /* code 00EC */
  ________,
  ________,
  ________,
  X_______,
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00ED[13] = { /* code 00ED */
  ________,
  ________,
  _X______,
  X_______,
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00EE[13] = { /* code 00EE */
  ________,
  ________,
  X_______,
  _X______,
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00EF[13] = { /* code 00EF */
  ________,
  ________,
  ________,
  _X______,
  ________,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F0[13] = { /* code 00F0 */
  ________,
  ________,
  ________,
  __XX____,
  _X_X____,
  ____X___,
  _XXXX___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F1[13] = { /* code 00F1 */
  ________,
  ________,
  _XX_X___,
  _X_XX___,
  ________,
  XXXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F2[13] = { /* code 00F2 */
  ________,
  ________,
  _X______,
  __X_____,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F3[13] = { /* code 00F3 */
  ________,
  ________,
  ___X____,
  __X_____,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F4[13] = { /* code 00F4 */
  ________,
  ________,
  __XX____,
  _X__X___,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F5[13] = { /* code 00F5 */
  ________,
  ________,
  _XX_X___,
  _X_XX___,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F6[13] = { /* code 00F6 */
  ________,
  ________,
  ________,
  _X_X____,
  ________,
  _XXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F7[13] = { /* code 00F7 */
  ________,
  ________,
  ________,
  ________,
  ___X____,
  ___X____,
  ________,
  XXXXXXX_,
  ________,
  ___X____,
  ___X____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F8[13] = { /* code 00F8 */
  ________,
  ________,
  ________,
  ________,
  ____X___,
  _XXX____,
  X__XX___,
  X_X_X___,
  X_X_X___,
  XX__X___,
  _XXX____,
  X_______,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00F9[13] = { /* code 00F9 */
  ________,
  ________,
  _X______,
  __X_____,
  ________,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00FA[13] = { /* code 00FA */
  ________,
  ________,
  ___X____,
  __X_____,
  ________,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00FB[13] = { /* code 00FB */
  ________,
  ________,
  __XX____,
  _X__X___,
  ________,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00FC[13] = { /* code 00FC */
  ________,
  ________,
  ________,
  _X_X____,
  ________,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  _XXXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont13_1_00FD[13] = { /* code 00FD */
  ________,
  ________,
  ___X____,
  __X_____,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont13_1_00FE[13] = { /* code 00FE */
  ________,
  ________,
  X_______,
  X_______,
  X_______,
  XXXX____,
  X___X___,
  X___X___,
  X___X___,
  X___X___,
  XXXX____,
  X_______,
  X_______};

GUI_CONST_STORAGE unsigned char acFont13_1_00FF[13] = { /* code 00FF */
  ________,
  ________,
  ________,
  _X_X____,
  ________,
  X___X___,
  X___X___,
  _X_X____,
  _X_X____,
  __X_____,
  __X_____,
  _X______,
  _X______};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font13_1_CharInfo[96] = {
   {   3,   3,  1, acFont13_1_00A0 } /* code 00A0 */
  ,{   4,   4,  1, acFont13_1_00A1 } /* code 00A1 */
  ,{   6,   6,  1, acFont13_1_00A2 } /* code 00A2 */
  ,{   6,   6,  1, acFont13_1_00A3 } /* code 00A3 */
  ,{   6,   6,  1, acFont13_1_00A4 } /* code 00A4 */
  ,{   6,   6,  1, acFont13_1_00A5 } /* code 00A5 */
  ,{   4,   4,  1, acFont13_1_00A6 } /* code 00A6 */
  ,{   6,   6,  1, acFont13_1_00A7 } /* code 00A7 */
  ,{   6,   6,  1, acFont13_1_00A8 } /* code 00A8 */
  ,{  10,  10,  2, acFont13_1_00A9 } /* code 00A9 */
  ,{   5,   5,  1, acFont13_1_00AA } /* code 00AA */
  ,{   6,   6,  1, acFont13_1_00AB } /* code 00AB */
  ,{   8,   8,  1, acFont13_1_00AC } /* code 00AC */
  ,{   4,   4,  1, acFont13_1_00AD } /* code 00AD */
  ,{  10,  10,  2, acFont13_1_00AE } /* code 00AE */
  ,{   6,   6,  1, acFont13_1_00AF } /* code 00AF */
  ,{   5,   5,  1, acFont13_1_00B0 } /* code 00B0 */
  ,{   8,   8,  1, acFont13_1_00B1 } /* code 00B1 */
  ,{   5,   5,  1, acFont13_1_00B2 } /* code 00B2 */
  ,{   5,   5,  1, acFont13_1_00B3 } /* code 00B3 */
  ,{   6,   6,  1, acFont13_1_00B4 } /* code 00B4 */
  ,{   6,   6,  1, acFont13_1_00B5 } /* code 00B5 */
  ,{   6,   6,  1, acFont13_1_00B6 } /* code 00B6 */
  ,{   3,   3,  1, acFont13_1_00B7 } /* code 00B7 */
  ,{   6,   6,  1, acFont13_1_00B8 } /* code 00B8 */
  ,{   5,   5,  1, acFont13_1_00B9 } /* code 00B9 */
  ,{   5,   5,  1, acFont13_1_00BA } /* code 00BA */
  ,{   6,   6,  1, acFont13_1_00BB } /* code 00BB */
  ,{  11,  11,  2, acFont13_1_00BC } /* code 00BC */
  ,{  11,  11,  2, acFont13_1_00BD } /* code 00BD */
  ,{  11,  11,  2, acFont13_1_00BE } /* code 00BE */
  ,{   5,   5,  1, acFont13_1_00BF } /* code 00BF */
  ,{   7,   7,  1, acFont13_1_00C0 } /* code 00C0 */
  ,{   7,   7,  1, acFont13_1_00C1 } /* code 00C1 */
  ,{   7,   7,  1, acFont13_1_00C2 } /* code 00C2 */
  ,{   7,   7,  1, acFont13_1_00C3 } /* code 00C3 */
  ,{   7,   7,  1, acFont13_1_00C4 } /* code 00C4 */
  ,{   7,   7,  1, acFont13_1_00C5 } /* code 00C5 */
  ,{  10,  10,  2, acFont13_1_00C6 } /* code 00C6 */
  ,{   7,   7,  1, acFont13_1_00C7 } /* code 00C7 */
  ,{   6,   6,  1, acFont13_1_00C8 } /* code 00C8 */
  ,{   6,   6,  1, acFont13_1_00C9 } /* code 00C9 */
  ,{   6,   6,  1, acFont13_1_00CA } /* code 00CA */
  ,{   6,   6,  1, acFont13_1_00CB } /* code 00CB */
  ,{   4,   4,  1, acFont13_1_00CC } /* code 00CC */
  ,{   4,   4,  1, acFont13_1_00CD } /* code 00CD */
  ,{   4,   4,  1, acFont13_1_00CE } /* code 00CE */
  ,{   4,   4,  1, acFont13_1_00CF } /* code 00CF */
  ,{   8,   8,  1, acFont13_1_00D0 } /* code 00D0 */
  ,{   7,   7,  1, acFont13_1_00D1 } /* code 00D1 */
  ,{   8,   8,  1, acFont13_1_00D2 } /* code 00D2 */
  ,{   8,   8,  1, acFont13_1_00D3 } /* code 00D3 */
  ,{   8,   8,  1, acFont13_1_00D4 } /* code 00D4 */
  ,{   8,   8,  1, acFont13_1_00D5 } /* code 00D5 */
  ,{   8,   8,  1, acFont13_1_00D6 } /* code 00D6 */
  ,{   8,   8,  1, acFont13_1_00D7 } /* code 00D7 */
  ,{   8,   8,  1, acFont13_1_00D8 } /* code 00D8 */
  ,{   7,   7,  1, acFont13_1_00D9 } /* code 00D9 */
  ,{   7,   7,  1, acFont13_1_00DA } /* code 00DA */
  ,{   7,   7,  1, acFont13_1_00DB } /* code 00DB */
  ,{   7,   7,  1, acFont13_1_00DC } /* code 00DC */
  ,{   6,   6,  1, acFont13_1_00DD } /* code 00DD */
  ,{   6,   6,  1, acFont13_1_00DE } /* code 00DE */
  ,{   6,   6,  1, acFont13_1_00DF } /* code 00DF */
  ,{   6,   6,  1, acFont13_1_00E0 } /* code 00E0 */
  ,{   6,   6,  1, acFont13_1_00E1 } /* code 00E1 */
  ,{   6,   6,  1, acFont13_1_00E2 } /* code 00E2 */
  ,{   6,   6,  1, acFont13_1_00E3 } /* code 00E3 */
  ,{   6,   6,  1, acFont13_1_00E4 } /* code 00E4 */
  ,{   6,   6,  1, acFont13_1_00E5 } /* code 00E5 */
  ,{  10,  10,  2, acFont13_1_00E6 } /* code 00E6 */
  ,{   5,   5,  1, acFont13_1_00E7 } /* code 00E7 */
  ,{   6,   6,  1, acFont13_1_00E8 } /* code 00E8 */
  ,{   6,   6,  1, acFont13_1_00E9 } /* code 00E9 */
  ,{   6,   6,  1, acFont13_1_00EA } /* code 00EA */
  ,{   6,   6,  1, acFont13_1_00EB } /* code 00EB */
  ,{   2,   2,  1, acFont13_1_00EC } /* code 00EC */
  ,{   2,   2,  1, acFont13_1_00ED } /* code 00ED */
  ,{   2,   2,  1, acFont13_1_00EE } /* code 00EE */
  ,{   2,   2,  1, acFont13_1_00EF } /* code 00EF */
  ,{   6,   6,  1, acFont13_1_00F0 } /* code 00F0 */
  ,{   6,   6,  1, acFont13_1_00F1 } /* code 00F1 */
  ,{   6,   6,  1, acFont13_1_00F2 } /* code 00F2 */
  ,{   6,   6,  1, acFont13_1_00F3 } /* code 00F3 */
  ,{   6,   6,  1, acFont13_1_00F4 } /* code 00F4 */
  ,{   6,   6,  1, acFont13_1_00F5 } /* code 00F5 */
  ,{   6,   6,  1, acFont13_1_00F6 } /* code 00F6 */
  ,{   8,   8,  1, acFont13_1_00F7 } /* code 00F7 */
  ,{   6,   6,  1, acFont13_1_00F8 } /* code 00F8 */
  ,{   6,   6,  1, acFont13_1_00F9 } /* code 00F9 */
  ,{   6,   6,  1, acFont13_1_00FA } /* code 00FA */
  ,{   6,   6,  1, acFont13_1_00FB } /* code 00FB */
  ,{   6,   6,  1, acFont13_1_00FC } /* code 00FC */
  ,{   6,   6,  1, acFont13_1_00FD } /* code 00FD */
  ,{   6,   6,  1, acFont13_1_00FE } /* code 00FE */
  ,{   6,   6,  1, acFont13_1_00FF } /* code 00FF */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font13_1_Prop1 = {
   160                         /* first character               */
  ,255                         /* last character                */
  ,&GUI_Font13_1_CharInfo[0] /* address of first character    */
  ,&GUI_Font13ASCII_Prop1                         /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font13_1 = {
   GUI_FONTTYPE_PROP /* type of font    */
  ,13                /* height of font  */
  ,13                /* space of font y */
  ,1                /* magnification x */
  ,1                /* magnification y */
  ,{&GUI_Font13_1_Prop1}
  , 11, 6, 8
};

