/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F16_1.C
Purpose     : ISO 8859-1 West European Character Set, bold
Height      : 16
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

/* Start of unicode area <Latin-1 Supplement> */
GUI_CONST_STORAGE unsigned char acFont16B_1_00A0[ 16] = { /* code 00A0 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A1[ 16] = { /* code 00A1 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A2[ 16] = { /* code 00A2 */
  ________,
  ________,
  ________,
  ____X___,
  ____X___,
  ___X____,
  _XXXX___,
  XX_XXX__,
  XX_X____,
  XX_X____,
  XX_X____,
  XXX__X__,
  _XXXX___,
  __X_____,
  _X______,
  _X______};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A3[ 16] = { /* code 00A3 */
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX_____,
  _XX_____,
  _XX_____,
  XXXXXX__,
  __XX____,
  _XXX____,
  XXXXX_X_,
  _X__XXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A4[ 16] = { /* code 00A4 */
  ________,
  ________,
  ________,
  ________,
  ________,
  X____X__,
  XXXXXXX_,
  XX__XX__,
  X____X__,
  X____X__,
  XX__XX__,
  XXXXXXX_,
  X____X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A5[ 16] = { /* code 00A5 */
  ________,
  ________,
  ________,
  XX__XX__,
  XX__XX__,
  _XXXX___,
  _XXXX___,
  XXXXXX__,
  __XX____,
  XXXXXX__,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A6[ 16] = { /* code 00A6 */
  ________,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________,
  ________,
  _X______,
  _X______,
  _X______,
  _X______,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A7[ 16] = { /* code 00A7 */
  ________,
  ________,
  ________,
  __XXX___,
  _XX_XX__,
  _XX_____,
  _XXX____,
  XXXXX___,
  XX_XXX__,
  XX__XX__,
  XXX_XX__,
  _XXXX___,
  __XXX___,
  ___XX___,
  XX_XX___,
  _XXX____};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A8[ 16] = { /* code 00A8 */
  ________,
  ________,
  ________,
  X__X____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00A9[ 32] = { /* code 00A9 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  _XX____X,X_______,
  _X__XX__,X_______,
  X__X__X_,_X______,
  X__X____,_X______,
  X__X____,_X______,
  X__X__X_,_X______,
  _X__XX__,X_______,
  _XX____X,X_______,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00AA[ 16] = { /* code 00AA */
  ________,
  ________,
  ________,
  _XXX____,
  X__X____,
  _XXX____,
  X__X____,
  XXXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00AB[ 16] = { /* code 00AB */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  _XX_XX__,
  XX_XX___,
  XX_XX___,
  _XX_XX__,
  __X__X__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00AC[ 16] = { /* code 00AC */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXXXXX_,
  _____XX_,
  _____XX_,
  _____XX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00AD[ 16] = { /* code 00AD */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00AE[ 32] = { /* code 00AE */
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  _XX____X,X_______,
  _X_XXX__,X_______,
  X__X__X_,_X______,
  X__X__X_,_X______,
  X__XXX__,_X______,
  X__X_X__,_X______,
  _X_X__X_,X_______,
  _XX____X,X_______,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00AF[ 16] = { /* code 00AF */
  ________,
  ________,
  XXXXXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B0[ 16] = { /* code 00B0 */
  ________,
  ________,
  ________,
  _XX_____,
  X__X____,
  X__X____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B1[ 16] = { /* code 00B1 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  XXXXXX__,
  __XX____,
  __XX____,
  ________,
  XXXXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B2[ 16] = { /* code 00B2 */
  ________,
  ________,
  ________,
  _XXX____,
  X__X____,
  __X_____,
  _X______,
  XXXX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B3[ 16] = { /* code 00B3 */
  ________,
  ________,
  ________,
  _XX_____,
  X__X____,
  __X_____,
  X__X____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B4[ 16] = { /* code 00B4 */
  ________,
  ________,
  ________,
  __XX____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B5[ 16] = { /* code 00B5 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  XX__XX__,
  XXXXXX__,
  XX______,
  XX______,
  XX______};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B6[ 16] = { /* code 00B6 */
  ________,
  ________,
  ________,
  _XXXXXX_,
  XXXX_X__,
  XXXX_X__,
  XXXX_X__,
  _XXX_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ___X_X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B7[ 16] = { /* code 00B7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B8[ 16] = { /* code 00B8 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  __X_____,
  XX______};

GUI_CONST_STORAGE unsigned char acFont16B_1_00B9[ 16] = { /* code 00B9 */
  ________,
  ________,
  ________,
  __X_____,
  _XX_____,
  __X_____,
  __X_____,
  __X_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00BA[ 16] = { /* code 00BA */
  ________,
  ________,
  ________,
  __XX____,
  _X__X___,
  _X__X___,
  _X__X___,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00BB[ 16] = { /* code 00BB */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X__X___,
  _XX_XX__,
  __XX_XX_,
  __XX_XX_,
  _XX_XX__,
  _X__X___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00BC[ 32] = { /* code 00BC */
  ________,________,
  ________,________,
  ________,________,
  _X_____X,________,
  XX____X_,________,
  _X___X__,________,
  _X___X__,________,
  _X__X___,________,
  ____X___,X_______,
  ___X___X,X_______,
  __X___X_,X_______,
  __X___XX,XX______,
  _X______,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00BD[ 32] = { /* code 00BD */
  ________,________,
  ________,________,
  ________,________,
  _X_____X,________,
  XX____X_,________,
  _X____X_,________,
  _X___X__,________,
  _X__X___,________,
  ____X__X,XX______,
  ___X__X_,_X______,
  ___X____,X_______,
  __X____X,________,
  _X____XX,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00BE[ 32] = { /* code 00BE */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,X_______,
  X__X___X,________,
  __X____X,________,
  X__X__X_,________,
  _XX___X_,________,
  _____X__,_X______,
  ____X___,XX______,
  ____X__X,_X______,
  ___X___X,XXX_____,
  ___X____,_X______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00BF[ 16] = { /* code 00BF */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ___XX___,
  __XX____,
  _XX_____,
  XX______,
  XX______,
  XX___XX_,
  _XXXXX__};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C0[ 32] = { /* code 00C0 */
  ___XX___,________,
  ____XX__,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C1[ 32] = { /* code 00C1 */
  _____XX_,________,
  ____XX__,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C2[ 32] = { /* code 00C2 */
  ____X___,________,
  ___X_X__,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C3[ 32] = { /* code 00C3 */
  ___XX_X_,________,
  ___X_XX_,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C4[ 32] = { /* code 00C4 */
  ________,________,
  ___X__X_,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C5[ 32] = { /* code 00C5 */
  ____XX__,________,
  ___X__X_,________,
  ___X__X_,________,
  ___XXX__,________,
  ___XXX__,________,
  __XX_XX_,________,
  __XX_XX_,________,
  __XX_XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  XX_____X,X_______,
  XX_____X,X_______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C6[ 32] = { /* code 00C6 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXXX____,
  ___XX_XX,________,
  ___XX_XX,________,
  ___XX_XX,________,
  __XX__XX,XXXX____,
  __XX__XX,________,
  _XX___XX,________,
  _XXXXXXX,________,
  _XX___XX,________,
  XX____XX,XXXX____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C7[ 32] = { /* code 00C7 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XX___X,X_______,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  __XX___X,X_______,
  ___XXXXX,________,
  ____XX__,________,
  _____X__,________,
  ___XX___,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C8[ 16] = { /* code 00C8 */
  __XX____,
  ___XX___,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00C9[ 16] = { /* code 00C9 */
  _____XX_,
  ____XX__,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00CA[ 16] = { /* code 00CA */
  ____X___,
  ___X_X__,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00CB[ 16] = { /* code 00CB */
  ________,
  __X__X__,
  ________,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00CC[ 16] = { /* code 00CC */
  XX______,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00CD[ 16] = { /* code 00CD */
  __XX____,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00CE[ 16] = { /* code 00CE */
  __X_____,
  _X_X____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00CF[ 16] = { /* code 00CF */
  ________,
  X__X____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D0[ 32] = { /* code 00D0 */
  ________,________,
  ________,________,
  ________,________,
  _XXXXX__,________,
  _XX__XX_,________,
  _XX___XX,________,
  _XX___XX,________,
  XXXXX_XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX__XX_,________,
  _XXXXX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D1[ 32] = { /* code 00D1 */
  ___XX_X_,________,
  ___X_XX_,________,
  ________,________,
  _XX___XX,________,
  _XXX__XX,________,
  _XXX__XX,________,
  _XXXX_XX,________,
  _XX_X_XX,________,
  _XX_XXXX,________,
  _XX__XXX,________,
  _XX__XXX,________,
  _XX___XX,________,
  _XX___XX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D2[ 32] = { /* code 00D2 */
  ___XX___,________,
  ____XX__,________,
  ________,________,
  ___XXXX_,________,
  __XX__XX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  __XX__XX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D3[ 32] = { /* code 00D3 */
  _____XX_,________,
  ____XX__,________,
  ________,________,
  ___XXXX_,________,
  __XX__XX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  __XX__XX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D4[ 32] = { /* code 00D4 */
  _____X__,________,
  ____X_X_,________,
  ________,________,
  ___XXXX_,________,
  __XX__XX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  __XX__XX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D5[ 32] = { /* code 00D5 */
  ___XX_X_,________,
  ___X_XX_,________,
  ________,________,
  ___XXXX_,________,
  __XX__XX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  __XX__XX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D6[ 32] = { /* code 00D6 */
  ________,________,
  ___X__X_,________,
  ________,________,
  ___XXXX_,________,
  __XX__XX,________,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  __XX__XX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D7[ 16] = { /* code 00D7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _X___X__,
  _XX_XX__,
  __XXX___,
  __XXX___,
  _XX_XX__,
  _X___X__,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D8[ 32] = { /* code 00D8 */
  ________,________,
  ________,________,
  ________,X_______,
  ___XXXX_,XX______,
  __XX__XX,X_______,
  _XX___XX,X_______,
  _XX__XXX,X_______,
  _XX__X_X,X_______,
  _XX_X__X,X_______,
  _XXXX__X,X_______,
  _XXX___X,X_______,
  _XXX__XX,________,
  XX_XXXX_,________,
  _X______,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00D9[ 32] = { /* code 00D9 */
  ___XX___,________,
  ____XX__,________,
  ________,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00DA[ 32] = { /* code 00DA */
  ____XX__,________,
  ___XX___,________,
  ________,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00DB[ 32] = { /* code 00DB */
  ____X___,________,
  ___X_X__,________,
  ________,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00DC[ 32] = { /* code 00DC */
  ________,________,
  ___X__X_,________,
  ________,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00DD[ 16] = { /* code 00DD */
  ____XX__,
  ___XX___,
  ________,
  XX____XX,
  XX____XX,
  _XX__XX_,
  __XXXX__,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00DE[ 32] = { /* code 00DE */
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXX_,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXX_,________,
  _XX_____,________,
  _XX_____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00DF[ 16] = { /* code 00DF */
  ________,
  ________,
  ________,
  __XXX___,
  _XX_XX__,
  _XX_XX__,
  _XX_X___,
  _XXXX___,
  _XXXXX__,
  _XX_XXX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E0[ 16] = { /* code 00E0 */
  ________,
  ________,
  ________,
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _X___XX_,
  ___XXXX_,
  __XX_XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E1[ 16] = { /* code 00E1 */
  ________,
  ________,
  ________,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _X___XX_,
  ___XXXX_,
  __XX_XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E2[ 16] = { /* code 00E2 */
  ________,
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXXX__,
  _X___XX_,
  ___XXXX_,
  __XX_XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E3[ 16] = { /* code 00E3 */
  ________,
  ________,
  ________,
  __XX_X__,
  __X_XX__,
  ________,
  __XXXX__,
  _X___XX_,
  ___XXXX_,
  __XX_XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E4[ 16] = { /* code 00E4 */
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  ________,
  __XXXX__,
  _X___XX_,
  ___XXXX_,
  __XX_XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E5[ 16] = { /* code 00E5 */
  ________,
  ___XX___,
  __X__X__,
  __X__X__,
  ___XX___,
  ________,
  __XXXX__,
  _X___XX_,
  ___XXXX_,
  __XX_XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E6[ 32] = { /* code 00E6 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXX_X,XX______,
  _X___XX_,_XX_____,
  ___XXXX_,_XX_____,
  __XX_XXX,XXX_____,
  _XX__XX_,________,
  _XX__XX_,_XX_____,
  __XXX_XX,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E7[ 16] = { /* code 00E7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ___XX___,
  ____X___,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E8[ 16] = { /* code 00E8 */
  ________,
  ________,
  ________,
  __XX____,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00E9[ 16] = { /* code 00E9 */
  ________,
  ________,
  ________,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00EA[ 16] = { /* code 00EA */
  ________,
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00EB[ 16] = { /* code 00EB */
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XXXXXX_,
  _XX_____,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00EC[ 16] = { /* code 00EC */
  ________,
  ________,
  ________,
  XX______,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00ED[ 16] = { /* code 00ED */
  ________,
  ________,
  ________,
  __XX____,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00EE[ 16] = { /* code 00EE */
  ________,
  ________,
  ________,
  __X_____,
  _X_X____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00EF[ 16] = { /* code 00EF */
  ________,
  ________,
  ________,
  ________,
  X__X____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F0[ 16] = { /* code 00F0 */
  ________,
  ________,
  ________,
  ___X_X__,
  ____X___,
  ___X_X__,
  __XXXXX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F1[ 16] = { /* code 00F1 */
  ________,
  ________,
  ________,
  __XX_X__,
  __X_XX__,
  ________,
  _XX_XX__,
  _XXX_XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F2[ 16] = { /* code 00F2 */
  ________,
  ________,
  ________,
  ___XX___,
  ____XX__,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F3[ 16] = { /* code 00F3 */
  ________,
  ________,
  ________,
  ____XX__,
  ___XX___,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F4[ 16] = { /* code 00F4 */
  ________,
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F5[ 16] = { /* code 00F5 */
  ________,
  ________,
  ________,
  __XX_X__,
  __X_XX__,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F6[ 16] = { /* code 00F6 */
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  ________,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F7[ 16] = { /* code 00F7 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  XXXXXX__,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F8[ 16] = { /* code 00F8 */
  ________,
  ________,
  ________,
  ________,
  ________,
  _____X__,
  __XXXXX_,
  _XX_XX__,
  _XX_XXX_,
  _XXXXXX_,
  _XXX_XX_,
  __XX_XX_,
  _XXXXX__,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00F9[ 16] = { /* code 00F9 */
  ________,
  ________,
  ________,
  __XX____,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XXX_,
  __XX_XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00FA[ 16] = { /* code 00FA */
  ________,
  ________,
  ________,
  ____XX__,
  ___XX___,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XXX_,
  __XX_XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00FB[ 16] = { /* code 00FB */
  ________,
  ________,
  ________,
  ____X___,
  ___X_X__,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XXX_,
  __XX_XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00FC[ 16] = { /* code 00FC */
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XXX_,
  __XX_XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont16B_1_00FD[ 16] = { /* code 00FD */
  ________,
  ________,
  ________,
  ____XX__,
  ___XX___,
  ________,
  XX___XX_,
  XX___XX_,
  _XX_XX__,
  _XX_XX__,
  _XX_XX__,
  __XXX___,
  __XXX___,
  __XXX___,
  __XX____,
  XXXX____};

GUI_CONST_STORAGE unsigned char acFont16B_1_00FE[ 16] = { /* code 00FE */
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XXXXX__,
  _XX_____,
  _XX_____,
  _XX_____};

GUI_CONST_STORAGE unsigned char acFont16B_1_00FF[ 16] = { /* code 00FF */
  ________,
  ________,
  ________,
  ________,
  __X__X__,
  ________,
  XX___XX_,
  XX___XX_,
  _XX_XX__,
  _XX_XX__,
  _XX_XX__,
  __XXX___,
  __XXX___,
  __XXX___,
  __XX____,
  XXXX____};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font16B_1_CharInfo[96] = {
   {   4,   4,  1, acFont16B_1_00A0 } /* code 00A0 */
  ,{   4,   4,  1, acFont16B_1_00A1 } /* code 00A1 */
  ,{   7,   7,  1, acFont16B_1_00A2 } /* code 00A2 */
  ,{   7,   7,  1, acFont16B_1_00A3 } /* code 00A3 */
  ,{   7,   7,  1, acFont16B_1_00A4 } /* code 00A4 */
  ,{   7,   7,  1, acFont16B_1_00A5 } /* code 00A5 */
  ,{   3,   3,  1, acFont16B_1_00A6 } /* code 00A6 */
  ,{   7,   7,  1, acFont16B_1_00A7 } /* code 00A7 */
  ,{   4,   4,  1, acFont16B_1_00A8 } /* code 00A8 */
  ,{  10,  10,  2, acFont16B_1_00A9 } /* code 00A9 */
  ,{   5,   5,  1, acFont16B_1_00AA } /* code 00AA */
  ,{   7,   7,  1, acFont16B_1_00AB } /* code 00AB */
  ,{   8,   8,  1, acFont16B_1_00AC } /* code 00AC */
  ,{   4,   4,  1, acFont16B_1_00AD } /* code 00AD */
  ,{  10,  10,  2, acFont16B_1_00AE } /* code 00AE */
  ,{   7,   7,  1, acFont16B_1_00AF } /* code 00AF */
  ,{   5,   5,  1, acFont16B_1_00B0 } /* code 00B0 */
  ,{   7,   7,  1, acFont16B_1_00B1 } /* code 00B1 */
  ,{   4,   4,  1, acFont16B_1_00B2 } /* code 00B2 */
  ,{   4,   4,  1, acFont16B_1_00B3 } /* code 00B3 */
  ,{   4,   4,  1, acFont16B_1_00B4 } /* code 00B4 */
  ,{   7,   7,  1, acFont16B_1_00B5 } /* code 00B5 */
  ,{   7,   7,  1, acFont16B_1_00B6 } /* code 00B6 */
  ,{   4,   4,  1, acFont16B_1_00B7 } /* code 00B7 */
  ,{   4,   4,  1, acFont16B_1_00B8 } /* code 00B8 */
  ,{   4,   4,  1, acFont16B_1_00B9 } /* code 00B9 */
  ,{   5,   5,  1, acFont16B_1_00BA } /* code 00BA */
  ,{   7,   7,  1, acFont16B_1_00BB } /* code 00BB */
  ,{  11,  11,  2, acFont16B_1_00BC } /* code 00BC */
  ,{  11,  11,  2, acFont16B_1_00BD } /* code 00BD */
  ,{  11,  11,  2, acFont16B_1_00BE } /* code 00BE */
  ,{   8,   8,  1, acFont16B_1_00BF } /* code 00BF */
  ,{   9,   9,  2, acFont16B_1_00C0 } /* code 00C0 */
  ,{   9,   9,  2, acFont16B_1_00C1 } /* code 00C1 */
  ,{   9,   9,  2, acFont16B_1_00C2 } /* code 00C2 */
  ,{   9,   9,  2, acFont16B_1_00C3 } /* code 00C3 */
  ,{   9,   9,  2, acFont16B_1_00C4 } /* code 00C4 */
  ,{   9,   9,  2, acFont16B_1_00C5 } /* code 00C5 */
  ,{  13,  13,  2, acFont16B_1_00C6 } /* code 00C6 */
  ,{   9,   9,  2, acFont16B_1_00C7 } /* code 00C7 */
  ,{   8,   8,  1, acFont16B_1_00C8 } /* code 00C8 */
  ,{   8,   8,  1, acFont16B_1_00C9 } /* code 00C9 */
  ,{   8,   8,  1, acFont16B_1_00CA } /* code 00CA */
  ,{   8,   8,  1, acFont16B_1_00CB } /* code 00CB */
  ,{   4,   4,  1, acFont16B_1_00CC } /* code 00CC */
  ,{   4,   4,  1, acFont16B_1_00CD } /* code 00CD */
  ,{   4,   4,  1, acFont16B_1_00CE } /* code 00CE */
  ,{   4,   4,  1, acFont16B_1_00CF } /* code 00CF */
  ,{   9,   9,  2, acFont16B_1_00D0 } /* code 00D0 */
  ,{   9,   9,  2, acFont16B_1_00D1 } /* code 00D1 */
  ,{  10,  10,  2, acFont16B_1_00D2 } /* code 00D2 */
  ,{  10,  10,  2, acFont16B_1_00D3 } /* code 00D3 */
  ,{  10,  10,  2, acFont16B_1_00D4 } /* code 00D4 */
  ,{  10,  10,  2, acFont16B_1_00D5 } /* code 00D5 */
  ,{  10,  10,  2, acFont16B_1_00D6 } /* code 00D6 */
  ,{   8,   8,  1, acFont16B_1_00D7 } /* code 00D7 */
  ,{  10,  10,  2, acFont16B_1_00D8 } /* code 00D8 */
  ,{   9,   9,  2, acFont16B_1_00D9 } /* code 00D9 */
  ,{   9,   9,  2, acFont16B_1_00DA } /* code 00DA */
  ,{   9,   9,  2, acFont16B_1_00DB } /* code 00DB */
  ,{   9,   9,  2, acFont16B_1_00DC } /* code 00DC */
  ,{   8,   8,  1, acFont16B_1_00DD } /* code 00DD */
  ,{   9,   9,  2, acFont16B_1_00DE } /* code 00DE */
  ,{   8,   8,  1, acFont16B_1_00DF } /* code 00DF */
  ,{   8,   8,  1, acFont16B_1_00E0 } /* code 00E0 */
  ,{   8,   8,  1, acFont16B_1_00E1 } /* code 00E1 */
  ,{   8,   8,  1, acFont16B_1_00E2 } /* code 00E2 */
  ,{   8,   8,  1, acFont16B_1_00E3 } /* code 00E3 */
  ,{   8,   8,  1, acFont16B_1_00E4 } /* code 00E4 */
  ,{   8,   8,  1, acFont16B_1_00E5 } /* code 00E5 */
  ,{  12,  12,  2, acFont16B_1_00E6 } /* code 00E6 */
  ,{   7,   7,  1, acFont16B_1_00E7 } /* code 00E7 */
  ,{   8,   8,  1, acFont16B_1_00E8 } /* code 00E8 */
  ,{   8,   8,  1, acFont16B_1_00E9 } /* code 00E9 */
  ,{   8,   8,  1, acFont16B_1_00EA } /* code 00EA */
  ,{   8,   8,  1, acFont16B_1_00EB } /* code 00EB */
  ,{   4,   4,  1, acFont16B_1_00EC } /* code 00EC */
  ,{   4,   4,  1, acFont16B_1_00ED } /* code 00ED */
  ,{   4,   4,  1, acFont16B_1_00EE } /* code 00EE */
  ,{   4,   4,  1, acFont16B_1_00EF } /* code 00EF */
  ,{   8,   8,  1, acFont16B_1_00F0 } /* code 00F0 */
  ,{   8,   8,  1, acFont16B_1_00F1 } /* code 00F1 */
  ,{   8,   8,  1, acFont16B_1_00F2 } /* code 00F2 */
  ,{   8,   8,  1, acFont16B_1_00F3 } /* code 00F3 */
  ,{   8,   8,  1, acFont16B_1_00F4 } /* code 00F4 */
  ,{   8,   8,  1, acFont16B_1_00F5 } /* code 00F5 */
  ,{   8,   8,  1, acFont16B_1_00F6 } /* code 00F6 */
  ,{   7,   7,  1, acFont16B_1_00F7 } /* code 00F7 */
  ,{   8,   8,  1, acFont16B_1_00F8 } /* code 00F8 */
  ,{   8,   8,  1, acFont16B_1_00F9 } /* code 00F9 */
  ,{   8,   8,  1, acFont16B_1_00FA } /* code 00FA */
  ,{   8,   8,  1, acFont16B_1_00FB } /* code 00FB */
  ,{   8,   8,  1, acFont16B_1_00FC } /* code 00FC */
  ,{   7,   7,  1, acFont16B_1_00FD } /* code 00FD */
  ,{   8,   8,  1, acFont16B_1_00FE } /* code 00FE */
  ,{   7,   7,  1, acFont16B_1_00FF } /* code 00FF */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font16B_1_Prop2 = {
   0x00A0                     /* first character */
  ,0x00FF                     /* last character  */
  ,&GUI_Font16B_1_CharInfo[0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP*)0    /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font16B_1_Prop1 = {
   0x0020                         /* first character */
  ,0x007E                         /* last character  */
  ,&GUI_Font16B_ASCII_CharInfo[0] /* address of first character */
  ,&GUI_Font16B_1_Prop2           /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font16B_1 = {
   GUI_FONTTYPE_PROP    /* type of font    */
  ,16                   /* height of font  */
  ,16                   /* space of font y */
  ,1                    /* magnification x */
  ,1                    /* magnification y */
  ,{&GUI_Font16B_1_Prop1}
  ,13 ,7 ,10
};
