/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F16_HK.C
Purpose     : Hiragana & Katakana characters
Height      : 16
---------------------------END-OF-HEADER------------------------------
*/

#include "stdio.h"
#include "GUI_FontIntern.h"

/* Start of unicode area <Hiragana> */

GUI_CONST_STORAGE unsigned char acFont16_HK_3041[32] = { /* code 3041 */
  ________,________,
  ________,________,
  ________,________,
  ______X_,________,
  _______X,________,
  _______X,_XX_____,
  ____XXXX,X_______,
  _______X,________,
  ______XX,XXX_____,
  _____X_X,___X____,
  ____X__X,_X__X___,
  ____X__X,X___X___,
  _____XXX,____X___,
  _______X,___X____,
  ________,_XX_____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3042[32] = { /* code 3042 */
  ________,________,
  ______X_,________,
  _______X,________,
  _______X,__X_____,
  ____XXXX,XX______,
  _______X,________,
  _______X,XXX_____,
  _____XXX,___X____,
  ____X__X,____X___,
  ___X___X,_X___X__,
  __X____X,X____X__,
  __X___XX,_____X__,
  ___XXX__,X____X__,
  ________,____X___,
  ________,_XXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3043[32] = { /* code 3043 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X____,________,
  ____X___,________,
  ____X___,__X_____,
  ____X___,___X____,
  ____X___,____X___,
  ____X___,____X___,
  ____X__X,________,
  _____XX_,________,
  ______X_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3044[32] = { /* code 3044 */
  ________,________,
  ________,________,
  __X_____,________,
  ___X____,________,
  ___X____,________,
  ___X____,________,
  ___X____,__X_____,
  ___X____,___X____,
  ___X____,____X___,
  ___X____,____X___,
  ___X___X,____X___,
  ____XXX_,________,
  _____X__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3045[32] = { /* code 3045 */
  ________,________,
  ________,________,
  ________,________,
  ______X_,________,
  _______X,XX______,
  ________,________,
  ________,________,
  _______X,XX______,
  _____XX_,__X_____,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3046[32] = { /* code 3046 */
  ________,________,
  ______X_,________,
  _______X,XX______,
  ________,________,
  ________,________,
  _______X,XX______,
  ____XXX_,__X_____,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  ______XX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3047[32] = { /* code 3047 */
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  ________,XX______,
  ________,_X______,
  ________,________,
  _____X__,XXX_____,
  ______XX,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______XX,X_______,
  _____X__,_XXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3048[32] = { /* code 3048 */
  ________,________,
  _______X,________,
  ________,XX______,
  ________,_X______,
  ________,________,
  ________,__X_____,
  ____X_XX,XXX_____,
  _____X__,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ____X_XX,________,
  ___X____,X_______,
  ________,_XXXX___,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3049[32] = { /* code 3049 */
  ________,________,
  ________,________,
  ________,________,
  _____X__,________,
  ______X_,________,
  ______XX,X__X____,
  ___X_XX_,____X___,
  ____X_X_,________,
  ______XX,XXX_____,
  _____XX_,___X____,
  ____X_X_,___X____,
  ___X__X_,X_X_____,
  ____XX__,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_304A[32] = { /* code 304A */
  ________,________,
  _____X__,________,
  ______X_,________,
  ______X_,____X___,
  ______X_,XX___X__,
  __X__XXX,_____X__,
  ___XX_X_,________,
  ______X_,________,
  ______XX,XXXX____,
  _____XX_,____X___,
  ____X_X_,_____X__,
  ___X__X_,_____X__,
  ___X__X_,_X__X___,
  ____XX__,_XXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_304B[32] = { /* code 304B */
  ________,________,
  ______X_,________,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,XX__X___,
  ___XXXX_,__X__X__,
  ______X_,__X___X_,
  _____X__,__X__XX_,
  _____X__,__X_____,
  ____X___,__X_____,
  ____X___,_X______,
  ___X___X,XX______,
  __X_____,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_304C[32] = { /* code 304C */
  ________,________,
  ______X_,________,
  _______X,______X_,
  _______X,_____X_X,
  _______X,______X_,
  _______X,XX__X___,
  ___XXXX_,__X__X__,
  ______X_,__X___X_,
  _____X__,__X__XX_,
  _____X__,__X_____,
  ____X___,__X_____,
  ____X___,_X______,
  ___X___X,XX______,
  __X_____,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_304D[32] = { /* code 304D */
  ________,________,
  ______X_,________,
  ______X_,________,
  _______X,XXX_____,
  ____XXXX,________,
  ________,X_______,
  ________,XXXX____,
  ____XXXX,_X______,
  ________,_X______,
  _____XXX,X_X_____,
  ____X___,__X_____,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_304E[32] = { /* code 304E */
  ________,________,
  ______X_,________,
  ______X_,______X_,
  _______X,XXX_X__X,
  ____XXXX,_____X__,
  ________,X_______,
  ________,XXXX____,
  ____XXXX,_X______,
  ________,_X______,
  _____XXX,X_X_____,
  ____X___,__X_____,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_304F[32] = { /* code 304F */
  ________,________,
  ________,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  _____X__,________,
  ______X_,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  ________,_X______,
  ________,_X______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3050[32] = { /* code 3050 */
  ________,________,
  ________,_X______,
  ________,_X___X__,
  ________,X__X__X_,
  _______X,____X___,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  _____X__,________,
  ______X_,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  ________,_X______,
  ________,_X______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3051[32] = { /* code 3051 */
  ________,________,
  ___X____,_X______,
  ____X___,__X_____,
  ____X___,__X_____,
  ___X____,__XXXX__,
  ___X__XX,XXX_____,
  ___X____,__X_____,
  ___X____,__X_____,
  ___X____,__X_____,
  ___X_X__,__X_____,
  ___X_X__,__X_____,
  ___XX___,__X_____,
  ___XX___,_X______,
  ___X____,_X______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3052[32] = { /* code 3052 */
  ________,________,
  ___X____,_X____X_,
  ____X___,__X_X__X,
  ____X___,__X__X__,
  ___X____,__XXXX__,
  ___X__XX,XXX_____,
  ___X____,__X_____,
  ___X____,__X_____,
  ___X____,__X_____,
  ___X_X__,__X_____,
  ___X_X__,__X_____,
  ___XX___,__X_____,
  ___XX___,_X______,
  ___X____,_X______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3053[32] = { /* code 3053 */
  ________,________,
  ________,________,
  ________,________,
  _____X__,________,
  ______XX,XXXX____,
  ________,_XX_____,
  ________,X_______,
  _______X,________,
  ________,________,
  ________,________,
  ________,________,
  ___X____,________,
  ____XX__,___XX___,
  ______XX,XXXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3054[32] = { /* code 3054 */
  ________,________,
  ________,________,
  ________,______X_,
  ____X___,____X__X,
  _____XXX,XXX__X__,
  ________,XX______,
  _______X,________,
  ______X_,________,
  ________,________,
  ________,________,
  ________,________,
  __X_____,________,
  ___XX___,__XX____,
  _____XXX,XXX_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3055[32] = { /* code 3055 */
  ________,________,
  ______X_,________,
  ______X_,________,
  _______X,___XX___,
  ________,XXX_____,
  ____XXXX,_X______,
  ________,_X______,
  ________,__X_____,
  ______XX,XXXX____,
  _____X__,___X____,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXX_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3056[32] = { /* code 3056 */
  ________,________,
  ______X_,______X_,
  ______X_,____X__X,
  _______X,___X_X__,
  ________,XXX_____,
  ____XXXX,_X______,
  ________,_X______,
  ________,__X_____,
  ______XX,XXXX____,
  _____X__,___X____,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXX_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3057[32] = { /* code 3057 */
  ________,________,
  ____X___,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,_____X__,
  _____X__,____X___,
  _____X__,__XX____,
  ______XX,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3058[32] = { /* code 3058 */
  ________,________,
  ____X___,________,
  _____X__,________,
  _____X__,___X____,
  _____X__,_X__X___,
  _____X__,__X_____,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____X__,_____X__,
  _____X__,____X___,
  _____X__,__XX____,
  ______XX,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3059[32] = { /* code 3059 */
  ________,________,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  __X__XXX,XXXXX___,
  ___XX___,X_______,
  ________,X_______,
  ______XX,X_______,
  _____X__,X_______,
  _____X__,X_______,
  ______XX,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_305A[32] = { /* code 305A */
  ________,________,
  ________,X____X__,
  ________,X__X__X_,
  ________,X___X___,
  __X__XXX,XXXX____,
  ___XX___,X_______,
  ________,X_______,
  ______XX,X_______,
  _____X__,X_______,
  _____X__,X_______,
  ______XX,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_305B[32] = { /* code 305B */
  ________,________,
  ________,________,
  ________,_XX_____,
  ____XX__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____XXX,XXXXXX__,
  ___XXX__,__X_____,
  __X__X__,X_X_____,
  _____X__,_XX_____,
  _____X__,__X_____,
  _____X__,________,
  ______X_,________,
  _______X,XXXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_305C[32] = { /* code 305C */
  ________,________,
  ________,______X_,
  ________,_XX_X__X,
  ____XX__,__X__X__,
  _____X__,__X_____,
  _____X__,__X_____,
  _____XXX,XXXXXX__,
  ___XXX__,__X_____,
  __X__X__,X_X_____,
  _____X__,_XX_____,
  _____X__,__X_____,
  _____X__,________,
  ______X_,________,
  _______X,XXXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_305D[32] = { /* code 305D */
  ________,________,
  ________,________,
  ______XX,XXX_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,__XXX___,
  _____XXX,XX______,
  ___XX___,X_______,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ________,XX______,
  ________,__XX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_305E[32] = { /* code 305E */
  ________,________,
  ________,______X_,
  ______XX,XXX_X__X,
  ________,_X___X__,
  ________,X_______,
  _______X,________,
  ______X_,__XXX___,
  _____XXX,XX______,
  ___XX___,X_______,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ________,XX______,
  ________,__XX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_305F[32] = { /* code 305F */
  ________,________,
  ________,________,
  _____XX_,________,
  ______X_,________,
  ______XX,X_______,
  __XXXX__,__XXXX__,
  _____X__,XX__X___,
  _____X__,___X____,
  ____X___,________,
  ____X___,________,
  ___X___X,________,
  ___X___X,________,
  __X_____,XX______,
  ________,__XXXX__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3060[32] = { /* code 3060 */
  ________,________,
  ________,_____X__,
  _____XX_,___X__X_,
  ______X_,____X___,
  ______XX,X_______,
  __XXXX__,__XXXX__,
  _____X__,XX__X___,
  _____X__,___X____,
  ____X___,________,
  ____X___,________,
  ___X___X,________,
  ___X___X,________,
  __X_____,XX______,
  ________,__XXXX__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3061[32] = { /* code 3061 */
  ________,________,
  _____X__,________,
  ______X_,________,
  ______X_,XX______,
  ___X__XX,________,
  ____X_X_,________,
  _____X__,________,
  _____X__,________,
  _____X__,XXXX____,
  ____X_XX,____X___,
  ____XX__,_____X__,
  ____X___,_____X__,
  ________,____X___,
  ________,__XX____,
  ________,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3062[32] = { /* code 3062 */
  ________,________,
  _____X__,_____X__,
  ______X_,___X__X_,
  ______X_,XX__X___,
  ___X__XX,________,
  ____X_X_,________,
  _____X__,________,
  _____X__,________,
  _____X__,XXXX____,
  ____X_XX,____X___,
  ____XX__,_____X__,
  ____X___,_____X__,
  ________,____X___,
  ________,__XX____,
  ________,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3063[32] = { /* code 3063 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XXX_____,
  ___X__XX,___X____,
  ____XX__,____X___,
  ________,____X___,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3064[32] = { /* code 3064 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XXXX____,
  ______XX,____X___,
  _X__XX__,_____X__,
  __XX____,_____X__,
  ________,_____X__,
  ________,_____X__,
  ________,____X___,
  ________,__XX____,
  ________,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3065[32] = { /* code 3065 */
  ________,________,
  ________,______X_,
  ________,____X__X,
  ________,_____X__,
  ________,XXXX____,
  ______XX,____X___,
  _X__XX__,_____X__,
  __XX____,_____X__,
  ________,_____X__,
  ________,_____X__,
  ________,____X___,
  ________,__XX____,
  ________,XX______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3066[32] = { /* code 3066 */
  ________,________,
  ________,________,
  ________,___XXX__,
  _______X,XXX_____,
  _X__XXX_,_X______,
  __XX____,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  _______X,________,
  ________,X_______,
  ________,_XXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3067[32] = { /* code 3067 */
  ________,________,
  ________,______X_,
  ________,__X_X__X,
  _______X,XX___X__,
  _X__XXX_,_X______,
  __XX____,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  _______X,________,
  ________,X_______,
  ________,_XXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3068[32] = { /* code 3068 */
  ________,________,
  ________,________,
  ______XX,________,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,_XXX____,
  _______X,X_______,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  _____XXX,XXXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3069[32] = { /* code 3069 */
  ________,________,
  ________,________,
  ______XX,________,
  _______X,______X_,
  _______X,____X__X,
  _______X,_____X__,
  _______X,_XXX____,
  _______X,X_______,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  _____XXX,XXXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_306A[32] = { /* code 306A */
  ________,________,
  ______X_,________,
  _______X,________,
  ______X_,XX______,
  __XXXXXX,________,
  _____X__,__XX____,
  ____X___,___XX___,
  ____X___,__X_____,
  ___X____,_X______,
  ___X____,_X______,
  ________,_X______,
  ________,_X______,
  ______XX,XXXX____,
  _____X__,_X__X___,
  ______XX,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_306B[32] = { /* code 306B */
  ________,________,
  ________,________,
  ___X____,________,
  ___X____,________,
  ___X___X,XXXXX___,
  ___X____,__XX____,
  ___X____,_X______,
  __X_____,________,
  __X_____,________,
  __X___X_,________,
  __X_X_X_,________,
  __XX___X,________,
  __XX____,XXXXXX__,
  ___X____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_306C[32] = { /* code 306C */
  ________,________,
  ________,________,
  ______X_,________,
  _______X,________,
  _______X,XX______,
  __X__XXX,__XX____,
  __X_X__X,____X___,
  ___X___X,_____X__,
  ___X__X_,______X_,
  __X_X_X_,______X_,
  _X___X__,______X_,
  _X__XX__,_XXX_X__,
  __XX__X_,X___XX__,
  ________,_XXX__X_,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_306D[32] = { /* code 306D */
  ________,________,
  ________,________,
  _____X__,________,
  _____X__,________,
  _____X__,________,
  _____XX_,________,
  __XXXX__,XXXX____,
  _____X_X,____X___,
  _____XX_,_____X__,
  ____XX__,_____X__,
  ____XX__,_____X__,
  ___X_X__,_XXX_X__,
  __XX_X__,X___XX__,
  ____XX__,_XXXX_X_,
  _____X__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_306E[32] = { /* code 306E */
  ________,________,
  ________,________,
  ________,________,
  _______X,XXX_____,
  _____XX_,__XX____,
  ____X___,_X__X___,
  ___X____,X___X___,
  __X____X,_____X__,
  __X___X_,_____X__,
  __X__X__,_____X__,
  __X_X___,____X___,
  __XX____,____X___,
  ________,___X____,
  ________,__X_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_306F[32] = { /* code 306F */
  ________,________,
  ________,________,
  ___X____,__XX____,
  ___X____,___X____,
  ___X____,___X____,
  __X___X_,___XXX__,
  __X____X,XXXX____,
  __X_____,___X____,
  __X_____,___X____,
  __X_____,___X____,
  __X_____,___X____,
  __XX___X,XXXXX___,
  __XX__X_,__X__X__,
  __X____X,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3070[32] = { /* code 3070 */
  ________,________,
  ________,______X_,
  ___X____,_XX_X__X,
  ___X____,__X__X__,
  ___X____,__X_____,
  __X__X__,__XXX___,
  __X___XX,XXX_____,
  __X_____,__X_____,
  __X_____,__X_____,
  __X_____,__X_____,
  __X_____,__X_____,
  __XX__XX,XXXX____,
  __XX_X__,_X__X___,
  __X___XX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3071[32] = { /* code 3071 */
  ________,________,
  ________,_____X__,
  ___X____,_XX_X_X_,
  ___X____,__X__X__,
  ___X____,__X_____,
  __X__X__,__XXX___,
  __X___XX,XXX_____,
  __X_____,__X_____,
  __X_____,__X_____,
  __X_____,__X_____,
  __X_____,__X_____,
  __XX__XX,XXXX____,
  __XX_X__,_X__X___,
  __X___XX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3072[32] = { /* code 3072 */
  ________,________,
  ________,________,
  ________,________,
  _____XX_,___X____,
  ___XXX__,___X____,
  _____X__,___X____,
  ____X___,__X_X___,
  ____X___,__X__X__,
  ___X____,__X___X_,
  ___X____,__X_____,
  ___X____,_X______,
  ___X____,_X______,
  ____X___,X_______,
  _____XXX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3073[32] = { /* code 3073 */
  ________,________,
  ________,______X_,
  ________,____X__X,
  _____XX_,___X_X__,
  ___XXX__,___X____,
  _____X__,___X____,
  ____X___,___XX___,
  ____X___,__X__X__,
  ___X____,__X___X_,
  ___X____,__X_____,
  ___X____,_X______,
  ___X____,_X______,
  ____X___,X_______,
  _____XXX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3074[32] = { /* code 3074 */
  ________,________,
  ________,______X_,
  ________,_____X_X,
  _____XX_,___X__X_,
  ___XXX__,___X____,
  _____X__,___X____,
  ____X___,___XX___,
  ____X___,__X__X__,
  ___X____,__X___X_,
  ___X____,__X_____,
  ___X____,_X______,
  ___X____,_X______,
  ____X___,X_______,
  _____XXX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3075[32] = { /* code 3075 */
  ________,________,
  ________,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,XXXXX___,
  _____XX_,X____X__,
  _X__X___,_X____X_,
  __XX__X_,_X___XX_,
  __X____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3076[32] = { /* code 3076 */
  ________,________,
  ________,________,
  _______X,_____X__,
  ________,X__X__X_,
  ________,X___X___,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,XXXXX___,
  _____XX_,X____X__,
  _X__X___,_X____X_,
  __XX__X_,_X___XX_,
  __X____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3077[32] = { /* code 3077 */
  ________,________,
  ________,________,
  _______X,____X___,
  ________,X__X_X__,
  ________,X___X___,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,XXXXX___,
  _____XX_,X____X__,
  _X__X___,_X____X_,
  __XX__X_,_X___XX_,
  __X____X,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3078[32] = { /* code 3078 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  ____X__X,________,
  _X_X____,X_______,
  __X_____,_X______,
  ________,__X_____,
  ________,___XX___,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3079[32] = { /* code 3079 */
  ________,________,
  ________,________,
  ________,_____X__,
  ________,___X__X_,
  ________,____X___,
  _____XX_,________,
  ____X__X,________,
  _X_X____,X_______,
  __X_____,_X______,
  ________,__X_____,
  ________,___XX___,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_307A[32] = { /* code 307A */
  ________,________,
  ________,________,
  ________,____X___,
  ________,___X_X__,
  ________,____X___,
  _____XX_,________,
  ____X__X,________,
  _X_X____,X_______,
  __X_____,_X______,
  ________,__X_____,
  ________,___XX___,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_307B[32] = { /* code 307B */
  ________,________,
  ________,________,
  __X_____,___XX___,
  ___X___X,XXX_____,
  ___X____,__X_____,
  __X_____,___XXX__,
  __X____X,XXXX____,
  __X_____,___X____,
  __X_X___,___X____,
  __X_X___,___X____,
  __XX____,___X____,
  __XX____,XXXXX___,
  __XX___X,___X_X__,
  ___X____,XXX___X_,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_307C[32] = { /* code 307C */
  ________,______X_,
  ________,____X__X,
  __X_____,__XX_X__,
  ___X__XX,XX______,
  ___X____,_X______,
  __X_____,__XXX___,
  __X___XX,XXX_____,
  __X_____,__X_____,
  __X_X___,__X_____,
  __X_X___,__X_____,
  __XX____,__X_____,
  __XX___X,XXXX____,
  __XX__X_,__X_X___,
  ___X___X,XX___X__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_307D[32] = { /* code 307D */
  ________,_____X__,
  ________,____X_X_,
  __X_____,__XX_X__,
  ___X__XX,XX______,
  ___X____,_X______,
  __X_____,__XXX___,
  __X___XX,XXX_____,
  __X_____,__X_____,
  __X_X___,__X_____,
  __X_X___,__X_____,
  __XX____,__X_____,
  __XX___X,XXXX____,
  __XX__X_,__X_X___,
  ___X___X,XX___X__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_307E[32] = { /* code 307E */
  ________,________,
  _______X,________,
  ________,XX______,
  ________,X_______,
  ___X____,XXXXX___,
  ____XXXX,X_______,
  ________,X__X____,
  ____X___,XXXXX___,
  _____XXX,X_______,
  ________,X_______,
  ________,X_______,
  ____XXXX,XXX_____,
  ___X____,X__XX___,
  ___X___X,_____X__,
  ____XXX_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_307F[32] = { /* code 307F */
  ________,________,
  ________,________,
  ____X__X,XX______,
  _____XX_,X_______,
  ________,X_______,
  _______X,________,
  _______X,___XX___,
  ______X_,____X___,
  ____XXXX,XX__X___,
  ___X_X__,__XXX___,
  __X_X___,___X_XX_,
  __X_X___,__X___X_,
  ___X____,__X_____,
  ________,_X______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3080[32] = { /* code 3080 */
  ________,________,
  ________,________,
  ____XX__,________,
  _____X_X,________,
  _X__XXX_,________,
  __XX_X__,____XX__,
  _____X__,___X__X_,
  ___XXX__,___X_XX_,
  __X__X__,___X____,
  __X__X__,___X____,
  ___XX___,____X___,
  ____X___,____X___,
  ____X___,____X___,
  _____XXX,XXXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3081[32] = { /* code 3081 */
  ________,________,
  ________,________,
  ________,XX______,
  ________,_X______,
  ___X____,_X______,
  ___X__XX,X_XX____,
  ____XX__,X___X___,
  ___XX__X,_____X__,
  __X_X__X,______X_,
  _X___XX_,______X_,
  _X___X__,______X_,
  _X__X_X_,_____X__,
  _X_X___X,____X___,
  __X_____,___X____,
  ________,__X_____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3082[32] = { /* code 3082 */
  ________,________,
  _______X,X_______,
  ________,X_______,
  ____X___,X_______,
  _____X_X,________,
  ______XX,XX______,
  _____XX_,________,
  ____X_X_,________,
  ____X_X_,___X____,
  _____XXX,XX__X___,
  ______X_,____X___,
  ______X_,____X___,
  ______X_,____X___,
  _______X,___X____,
  ________,XXX_____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3083[32] = { /* code 3083 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  _____X__,X_______,
  ____X___,XXXX____,
  _____XXX,_X__X___,
  ___X_X__,____X___,
  ____X_X_,___X____,
  _______X,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3084[32] = { /* code 3084 */
  ________,________,
  ________,________,
  ____X___,X_______,
  ___X____,_X______,
  ___X____,_XXXX___,
  ____X_XX,X_X__X__,
  _X__XX__,____X___,
  __XX_X__,__XX____,
  ______X_,________,
  ______X_,________,
  _______X,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3085[32] = { /* code 3085 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  __X_____,X_______,
  ___XX___,_XX_____,
  ___X__XX,XX_X____,
  ___X_X__,_X__X___,
  ___XX___,_X__X___,
  ___XX___,_X_X____,
  ___X___X,XXX_____,
  ___X____,X_______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3086[32] = { /* code 3086 */
  ________,________,
  ________,________,
  _______X,X_______,
  _X____X_,_X______,
  __X__X__,XXXX____,
  __X__X_X,_X__X___,
  __X__XX_,_X___X__,
  __X__X__,_X___X__,
  __X_XX__,_X___X__,
  __XX__X_,_X___X__,
  __XX___X,_X__X___,
  __X_____,XXXX____,
  __X_____,X_______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3087[32] = { /* code 3087 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  ________,X_______,
  ________,X__X____,
  ________,XXX_____,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  _____XXX,X_______,
  ____X___,XXX_____,
  _____XXX,___X____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3088[32] = { /* code 3088 */
  ________,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  ________,X__X____,
  ________,XXX_____,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ____XXXX,XX______,
  ___X____,X_XX____,
  ___X____,X___X___,
  ____XXXX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3089[32] = { /* code 3089 */
  ________,________,
  ______X_,________,
  _______X,________,
  ________,X_______,
  _____X_X,X_______,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,XXX_____,
  ____X_XX,___X____,
  ____XX__,____X___,
  ____X___,____X___,
  ________,____X___,
  ________,__XX____,
  ________,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_308A[32] = { /* code 308A */
  ________,________,
  ____X___,XX______,
  _____X_X,__X_____,
  _____XX_,__X_____,
  _____XX_,__X_____,
  _____X__,__X_____,
  ____XX__,__X_____,
  ____X___,__X_____,
  ____X___,__X_____,
  ____X___,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_308B[32] = { /* code 308B */
  ________,________,
  ________,________,
  ____X__X,XXX_____,
  _____XX_,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X_X,XXX_____,
  _____XX_,___X____,
  ____X___,____X___,
  ___X____,____X___,
  ______XX,X__X____,
  _____X__,_X_X____,
  _____X__,_XX_____,
  ______XX,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_308C[32] = { /* code 308C */
  ________,________,
  ___X____,________,
  ____XX__,________,
  _____X__,________,
  _____X__,XXX_____,
  ____XX_X,___X____,
  __XX_XX_,___X____,
  _____X__,___X____,
  ____X___,___X____,
  ____X___,___X____,
  ___XX___,__X_____,
  __X_X___,__X_____,
  _X__X___,__X_____,
  ___XX___,___XXX__,
  ____X___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_308D[32] = { /* code 308D */
  ________,________,
  ________,_X______,
  _____XXX,XX______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____XXX,XXXX____,
  ____XX__,____X___,
  ___X____,_____X__,
  __X_____,_____X__,
  ________,____X___,
  ________,___X____,
  ________,_XX_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_308E[32] = { /* code 308E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______XX,________,
  ____XXX_,XXXX____,
  ___X__XX,____X___,
  ______X_,_____X__,
  _____XX_,_____X__,
  ____X_X_,____X___,
  ___X_XX_,___X____,
  ______X_,__X_____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_308F[32] = { /* code 308F */
  ________,________,
  _____X__,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  _____XX_,________,
  ___XXXX_,XXXXX___,
  _____X_X,_____X__,
  _____XX_,______X_,
  ____XX__,______X_,
  ___X_X__,______X_,
  __X__X__,_____X__,
  ____XX__,___XX___,
  _____X__,_XX_____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3090[32] = { /* code 3090 */
  ________,________,
  ________,________,
  _____X_X,XX______,
  ______X_,X_______,
  ________,X_______,
  _______X,________,
  _______X,XXXX____,
  _____XX_,____X___,
  ____X_X_,_____X__,
  ___X__X_,_____X__,
  ___X_X__,_____X__,
  ___X_X__,_XXX_X__,
  ___XX___,X___X___,
  ________,_XXX____,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3091[32] = { /* code 3091 */
  ________,________,
  _____X__,_X______,
  ______XX,XX______,
  ________,X_______,
  _______X,________,
  _______X,XXX_____,
  ______X_,___X____,
  _____X__,___X____,
  ____X__X,___X____,
  ______X_,XXX_____,
  _______X,________,
  _____XX_,________,
  ____XX__,__XXXX__,
  __XX__XX,XX___XX_,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3092[32] = { /* code 3092 */
  ________,________,
  ______X_,________,
  _______X,________,
  _______X,XXX_____,
  ___XXXX_,________,
  ______X_,________,
  _____XXX,____X___,
  _____X__,X_XXXX__,
  ____X___,XX______,
  ___X___X,X_______,
  ______X_,X_______,
  _____X__,X_______,
  _____X__,________,
  _____X__,________,
  ______XX,XXXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_3093[32] = { /* code 3093 */
  ________,________,
  ________,________,
  ______X_,________,
  _______X,________,
  _______X,________,
  ______X_,________,
  ______X_,________,
  _____X__,________,
  _____XXX,________,
  ____X___,X_______,
  ____X___,X_______,
  ___X____,X_______,
  __X_____,X____X__,
  __X_____,_XXXX___,
  ________,________,
  ________,________};

/* Start of unicode area <Katakana> */

GUI_CONST_STORAGE unsigned char acFont16_HK_30A1[32] = { /* code 30A1 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X_XXX,XXXXX___,
  ____X___,___X____,
  _______X,X_X_____,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A2[32] = { /* code 30A2 */
  ________,________,
  ________,________,
  ____XXXX,XXXXXXX_,
  ________,_____X__,
  _______X,___XX___,
  ________,X_X_____,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ______X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A3[32] = { /* code 30A3 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XX______,
  ________,_X______,
  ________,X_______,
  _______X,X_______,
  ______X_,X_______,
  _____X__,X_______,
  ____X___,X_______,
  ___X____,X_______,
  ________,X_______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A4[32] = { /* code 30A4 */
  ________,________,
  ________,_X______,
  ________,__XX____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,X_______,
  ______X_,X_______,
  _____X__,X_______,
  ____X___,X_______,
  ___X____,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A5[32] = { /* code 30A5 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,X_______,
  ________,X_______,
  ________,X__X____,
  ____XXXX,XXXXX___,
  _____X__,___X____,
  _____X__,___X____,
  _____X__,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  ______XX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A6[32] = { /* code 30A6 */
  ________,________,
  ________,________,
  ______XX,________,
  ________,X_______,
  ________,X___X___,
  ___XXXXX,XXXXXX__,
  ____X___,____X___,
  ____X___,____X___,
  ____X___,____X___,
  ____X___,___X____,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  ______XX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A7[32] = { /* code 30A7 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____X___,_XX_____,
  _____XXX,X_______,
  ________,X_______,
  ________,X_______,
  ___X____,X_______,
  ____XXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A8[32] = { /* code 30A8 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X____,_XXX____,
  ____XXXX,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  __X_____,X_______,
  ___XXXXX,XXXXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30A9[32] = { /* code 30A9 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  ________,X_______,
  ________,XXXX____,
  ____XXXX,X_______,
  _______X,X_______,
  ______X_,X_______,
  _____X__,X_______,
  ____X___,X_______,
  ___X___X,X_______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30AA[32] = { /* code 30AA */
  ________,________,
  ________,________,
  ________,XX______,
  ________,_X______,
  ________,_XXXXX__,
  ___XXXXX,XX______,
  ________,XX______,
  _______X,_X______,
  ______X_,_X______,
  _____X__,_X______,
  ____X___,_X______,
  ___X____,_X______,
  ________,XX______,
  ________,_X______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30AB[32] = { /* code 30AB */
  ________,________,
  ________,________,
  ________,XX______,
  ________,_X______,
  ________,X_______,
  ___X____,XXXXX___,
  ____XXXX,____X___,
  _______X,____X___,
  ______X_,____X___,
  ______X_,____X___,
  _____X__,___X____,
  ____X___,___X____,
  ___X___X,X_X_____,
  __X_____,_X______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30AC[32] = { /* code 30AC */
  ________,________,
  ________,________,
  _______X,X_____X_,
  ________,X___X__X,
  _______X,_____X__,
  __X____X,XXXX____,
  ___XXXX_,___X____,
  ______X_,___X____,
  _____X__,___X____,
  ____X___,___X____,
  ___X____,__X_____,
  __X_____,__X_____,
  _X____XX,_X______,
  ________,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30AD[32] = { /* code 30AD */
  ________,________,
  ______X_,________,
  ______X_,________,
  _______X,________,
  _______X,XXXX____,
  ___X_XXX,________,
  ____X__X,________,
  ________,XXXXXX__,
  __X__XXX,X_______,
  ___XX___,X_______,
  ________,X_______,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30AE[32] = { /* code 30AE */
  ________,________,
  ______X_,______X_,
  ______X_,____X__X,
  _______X,_____X__,
  _______X,XXXX____,
  ___X_XXX,________,
  ____X__X,________,
  ________,XXXXXX__,
  __X__XXX,X_______,
  ___XX___,X_______,
  ________,X_______,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30AF[32] = { /* code 30AF */
  ________,________,
  ________,________,
  _______X,X_______,
  ________,XXXXX___,
  _______X,____X___,
  ______X_,___X____,
  _____X__,___X____,
  ____X___,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ___XX___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B0[32] = { /* code 30B0 */
  ________,________,
  ________,______X_,
  ______XX,____X__X,
  _______X,XXXX_X__,
  ______X_,___X____,
  _____X__,__X_____,
  ____X___,__X_____,
  ___X____,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  __XX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B1[32] = { /* code 30B1 */
  ________,________,
  ________,________,
  ______X_,________,
  ______XX,________,
  ______X_,________,
  _____X_X,XXXXXX__,
  ____X___,_X______,
  ___X____,_X______,
  ________,_X______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B2[32] = { /* code 30B2 */
  ________,________,
  ________,________,
  ______X_,______X_,
  ______XX,____X__X,
  ______X_,_____X__,
  _____X_X,XXXXX___,
  ____X___,_X______,
  ___X____,_X______,
  ________,_X______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B3[32] = { /* code 30B3 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X_XXX,XXXXX___,
  ____X___,____X___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,___X____,
  ________,___X____,
  ____XXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B4[32] = { /* code 30B4 */
  ________,________,
  ________,________,
  ________,______X_,
  ________,____X__X,
  ________,_____X__,
  ___X_XXX,XXXXX___,
  ____X___,____X___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,___X____,
  ________,___X____,
  ____XXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B5[32] = { /* code 30B5 */
  ________,________,
  ________,_X______,
  ____X___,__X_____,
  _____X__,__X_____,
  _____X__,__XXXXX_,
  _X___XXX,XXX_____,
  __XXXX__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  ________,_X______,
  ________,_X______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B6[32] = { /* code 30B6 */
  ________,________,
  ________,_X____X_,
  ____X___,__X_X__X,
  _____X__,__X__X__,
  _____X__,__XXX___,
  _X___XXX,XXX_____,
  __XXXX__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  ________,_X______,
  ________,_X______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B7[32] = { /* code 30B7 */
  ________,________,
  ________,________,
  ____X___,________,
  _____XX_,________,
  ________,______X_,
  ________,_____X__,
  ___X____,____X___,
  ____XX__,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ___XX_X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B8[32] = { /* code 30B8 */
  ________,________,
  ________,_____X__,
  ____X___,___X__X_,
  _____XX_,____X___,
  ________,________,
  ________,_____X__,
  ___X____,____X___,
  ____XX__,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ___XX_X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30B9[32] = { /* code 30B9 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____X___,XXXX____,
  _____XXX,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,X_______,
  ______X_,_X______,
  _____X__,__X_____,
  ____X___,___XX___,
  ___X____,____X___,
  _XX_____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30BA[32] = { /* code 30BA */
  ________,________,
  ________,______X_,
  ________,____X__X,
  ________,_____X__,
  ____X___,XXXX____,
  _____XXX,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,X_______,
  ______X_,_X______,
  _____X__,__X_____,
  ____X___,___XX___,
  ___X____,____X___,
  _XX_____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30BB[32] = { /* code 30BB */
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  _______X,________,
  _______X,___XXX__,
  _______X,XXX__X__,
  ______XX,____X___,
  __XXXX_X,___X____,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ________,XXXXXX__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30BC[32] = { /* code 30BC */
  ________,________,
  ________,______X_,
  ________,____X__X,
  ______XX,_____X__,
  _______X,________,
  _______X,___XXX__,
  _______X,XXX__X__,
  ______XX,____X___,
  __XXXX_X,___X____,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ________,XXXXXX__,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30BD[32] = { /* code 30BD */
  ________,________,
  ________,________,
  ________,________,
  ________,___X____,
  ____X___,____X___,
  _____X__,____X___,
  ______X_,___X____,
  ______X_,___X____,
  ________,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30BE[32] = { /* code 30BE */
  ________,________,
  ________,______X_,
  ________,____X__X,
  ________,_____X__,
  ________,__X_____,
  ___X____,___X____,
  ____X___,__X_____,
  _____X__,__X_____,
  _____X__,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30BF[32] = { /* code 30BF */
  ________,________,
  ________,________,
  ________,X_______,
  ________,XXXXX___,
  _______X,____X___,
  ______X_,___X____,
  _____X_X,___X____,
  ____X___,X_X_____,
  ________,_X______,
  ________,_XX_____,
  ________,X__X____,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ___XX___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C0[32] = { /* code 30C0 */
  ________,________,
  ________,______X_,
  _______X,____X__X,
  _______X,XXXX_X__,
  ______X_,___X____,
  _____X__,__X_____,
  ____X_X_,__X_____,
  ___X___X,_X______,
  ________,X_______,
  ________,XX______,
  _______X,__X_____,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  __XX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C1[32] = { /* code 30C1 */
  ________,________,
  ________,________,
  ________,_X______,
  ________,_XX_____,
  _______X,X_______,
  _____XX_,X_______,
  ________,X_______,
  ________,XXXXXX__,
  __XXXXXX,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C2[32] = { /* code 30C2 */
  ________,________,
  ________,______X_,
  ________,_X__X__X,
  ________,_XX__X__,
  _______X,X_______,
  _____XX_,X_______,
  ________,X_______,
  ________,XXXXXX__,
  __XXXXXX,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C3[32] = { /* code 30C3 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,___XX___,
  _______X,____X___,
  ____X___,X___X___,
  _____X__,___X____,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C4[32] = { /* code 30C4 */
  ________,________,
  ________,________,
  ________,________,
  ______X_,___XX___,
  __X____X,____X___,
  ___X___X,____X___,
  ___X____,___X____,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C5[32] = { /* code 30C5 */
  ________,________,
  ________,______X_,
  ________,____X__X,
  _____X__,_XX__X__,
  _X____X_,__X_____,
  __X___X_,__X_____,
  __X_____,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  ___X____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C6[32] = { /* code 30C6 */
  ________,________,
  ________,________,
  ____X___,________,
  _____XXX,XXXX____,
  ________,________,
  ________,________,
  __X_XXXX,XXXXXX__,
  ___X____,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C7[32] = { /* code 30C7 */
  ________,________,
  ________,______X_,
  ___X____,____X__X,
  ____XXXX,XXX__X__,
  ________,________,
  ________,________,
  _X_XXXXX,XXXXX___,
  __X____X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ______X_,________,
  ______X_,________,
  _____X__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C8[32] = { /* code 30C8 */
  ________,________,
  _____X__,________,
  ______XX,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______XX,________,
  ______X_,XX______,
  ______X_,__X_____,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30C9[32] = { /* code 30C9 */
  ________,________,
  _____X__,_____X__,
  ______XX,___X__X_,
  ______X_,____X___,
  ______X_,________,
  ______X_,________,
  ______XX,________,
  ______X_,XX______,
  ______X_,__X_____,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ______X_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30CA[32] = { /* code 30CA */
  ________,________,
  _______X,________,
  ________,XX______,
  ________,X_______,
  ________,X_______,
  ________,XXXXXX__,
  __XXXXXX,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30CB[32] = { /* code 30CB */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X____,________,
  ____XXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X_XXXXX,XXXXXX__,
  __X_____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30CC[32] = { /* code 30CC */
  ________,________,
  ________,________,
  ________,___X____,
  _____XXX,XXXXX___,
  ________,___X____,
  ________,__X_____,
  ________,__X_____,
  ______X_,_X______,
  _______X,_X______,
  ________,X_______,
  _______X,_X______,
  ______X_,__X_____,
  _____X__,________,
  ____X___,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30CD[32] = { /* code 30CD */
  ________,________,
  _______X,________,
  ________,XX______,
  ________,________,
  ________,XXX_____,
  ____XXXX,_X______,
  ________,X_______,
  _______X,________,
  ______XX,XX______,
  _____X_X,__XX____,
  ____X__X,____XX__,
  __XX___X,________,
  _______X,________,
  _______X,________,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30CE[32] = { /* code 30CE */
  ________,________,
  ________,________,
  ________,___XX___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ___XX___,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30CF[32] = { /* code 30CF */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____X___,_X______,
  _____XX_,__X_____,
  _____X__,___X____,
  ____X___,____X___,
  ___X____,_____X__,
  __X_____,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D0[32] = { /* code 30D0 */
  ________,________,
  ________,________,
  ________,_____X__,
  ________,___X__X_,
  ________,____X___,
  ____X___,_X______,
  _____XX_,__X_____,
  _____X__,___X____,
  ____X___,____X___,
  ___X____,_____X__,
  __X_____,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D1[32] = { /* code 30D1 */
  ________,________,
  ________,________,
  ________,____X___,
  ________,___X_X__,
  ________,____X___,
  ____X___,_X______,
  _____XX_,__X_____,
  _____X__,___X____,
  ____X___,____X___,
  ___X____,_____X__,
  __X_____,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D2[32] = { /* code 30D2 */
  ________,________,
  ________,________,
  ___X____,________,
  ____XX__,________,
  ____X___,________,
  ____X___,___X____,
  ____X___,_XX_____,
  ____XXXX,X_______,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D3[32] = { /* code 30D3 */
  ________,________,
  ________,________,
  ___X____,_____X__,
  ____XX__,___X__X_,
  ____X___,____X___,
  ____X___,__X_____,
  ____X___,XX______,
  ____XXXX,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D4[32] = { /* code 30D4 */
  ________,________,
  ________,________,
  ___X____,_____X__,
  ____XX__,____X_X_,
  ____X___,_____X__,
  ____X___,__X_____,
  ____X___,XX______,
  ____XXXX,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  ____X___,________,
  _____X__,________,
  ______XX,XXXXX___,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D5[32] = { /* code 30D5 */
  ________,________,
  ________,________,
  ________,________,
  ________,____X___,
  __X_XXXX,XXXXX___,
  ___X____,____X___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D6[32] = { /* code 30D6 */
  ________,________,
  ________,______X_,
  ________,____X__X,
  ________,_____X__,
  __X_XXXX,XXXXX___,
  ___X____,____X___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D7[32] = { /* code 30D7 */
  ________,________,
  ________,_____X__,
  ________,____X_X_,
  ________,_____X__,
  __X_XXXX,XXXXX___,
  ___X____,____X___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D8[32] = { /* code 30D8 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,________,
  ____X___,X_______,
  _XXX____,_XX_____,
  ________,___X____,
  ________,____X___,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30D9[32] = { /* code 30D9 */
  ________,________,
  ________,________,
  ________,________,
  ________,_____X__,
  ________,___X__X_,
  ________,____X___,
  _____XXX,________,
  ____X___,X_______,
  _XXX____,_XX_____,
  ________,___X____,
  ________,____X___,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30DA[32] = { /* code 30DA */
  ________,________,
  ________,________,
  ________,________,
  ________,____X___,
  ________,___X_X__,
  ________,____X___,
  _____XXX,________,
  ____X___,X_______,
  _XXX____,_XX_____,
  ________,___X____,
  ________,____X___,
  ________,_____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30DB[32] = { /* code 30DB */
  ________,________,
  ________,________,
  _______X,________,
  ________,X_______,
  ________,X_______,
  __X_XXXX,XXXXXX__,
  ___X____,X_______,
  ________,X_______,
  ____X___,X__X____,
  ____X___,X___X___,
  ___X____,X____X__,
  __X___X_,X____X__,
  _______X,X_______,
  ________,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30DC[32] = { /* code 30DC */
  ________,________,
  ________,______X_,
  _______X,____X__X,
  ________,X____X__,
  ________,X_______,
  __X_XXXX,XXXXXX__,
  ___X____,X_______,
  ________,X_______,
  ____X___,X__X____,
  ____X___,X___X___,
  ___X____,X____X__,
  __X___X_,X____X__,
  _______X,X_______,
  ________,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30DD[32] = { /* code 30DD */
  ________,________,
  ________,_____X__,
  _______X,____X_X_,
  ________,X____X__,
  ________,X_______,
  __X_XXXX,XXXXXX__,
  ___X____,X_______,
  ________,X_______,
  ____X___,X__X____,
  ____X___,X___X___,
  ___X____,X____X__,
  __X___X_,X____X__,
  _______X,X_______,
  ________,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30DE[32] = { /* code 30DE */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X__XXXX,XXXXXX__,
  __XX____,____X___,
  ________,___X____,
  ______X_,__X_____,
  _______X,_X______,
  ________,X_______,
  ________,_X______,
  ________,_X______,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30DF[32] = { /* code 30DF */
  ________,________,
  ________,________,
  ______X_,________,
  _______X,X_______,
  ________,_XX_____,
  ________,________,
  _____X__,________,
  ______XX,________,
  ________,XX______,
  ________,________,
  ________,________,
  _____X__,________,
  ______XX,________,
  ________,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E0[32] = { /* code 30E0 */
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  ________,XX______,
  ________,X_______,
  _______X,________,
  _______X,________,
  ______X_,__X_____,
  ______X_,___X____,
  _____X__,____X___,
  ____X___,_XXXXX__,
  __XXXXXX,X____X__,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E1[32] = { /* code 30E1 */
  ________,________,
  ________,________,
  ________,__XX____,
  ________,___X____,
  ________,__X_____,
  ______X_,__X_____,
  _______X,_X______,
  ________,XX______,
  ________,X_X_____,
  _______X,___X____,
  ______X_,________,
  _____X__,________,
  ____X___,________,
  ___X____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E2[32] = { /* code 30E2 */
  ________,________,
  ________,________,
  ________,________,
  _______X,XXXX____,
  ___X_XXX,________,
  ____X__X,________,
  _______X,________,
  _______X,XXXXX___,
  __X_XXXX,________,
  ___X___X,________,
  _______X,________,
  _______X,________,
  ________,XXXXXX__,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E3[32] = { /* code 30E3 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______X_,________,
  _______X,__XXX___,
  _______X,XX__XX__,
  ___XXXXX,___X____,
  ________,X_X_____,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E4[32] = { /* code 30E4 */
  ________,________,
  ________,________,
  _____X__,________,
  ______X_,________,
  ______X_,___XXX__,
  ______X_,XXX___X_,
  ______XX,_____X__,
  __XXXX_X,____X___,
  _______X,________,
  ________,X_______,
  ________,X_______,
  ________,X_______,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E5[32] = { /* code 30E5 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  __X_XXXX,XXXXX___,
  ___X____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E6[32] = { /* code 30E6 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXXX____,
  ________,__X_____,
  ________,__X_____,
  ________,__X_____,
  ________,__X_____,
  ________,__X_____,
  __X_XXXX,XXXXXXX_,
  ___X____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E7[32] = { /* code 30E7 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____X___,________,
  _____XXX,XXXX____,
  ________,__X_____,
  ____X___,__X_____,
  _____XXX,XXX_____,
  ________,__X_____,
  ________,__X_____,
  _____XXX,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E8[32] = { /* code 30E8 */
  ________,________,
  ________,________,
  ________,________,
  ____X___,________,
  _____XXX,XXXXX___,
  ________,___X____,
  ________,___X____,
  ____X___,___X____,
  _____XXX,XXXX____,
  ________,___X____,
  ________,___X____,
  ________,___X____,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30E9[32] = { /* code 30E9 */
  ________,________,
  ____X___,________,
  _____XXX,XXXX____,
  ________,________,
  ___X____,________,
  ____XXXX,XXXXX___,
  ________,____X___,
  ________,___X____,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  ____XX__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30EA[32] = { /* code 30EA */
  ________,________,
  ____X___,_X______,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  _____X__,__X_____,
  ________,_X______,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30EB[32] = { /* code 30EB */
  ________,________,
  ________,________,
  ________,________,
  ________,X_______,
  ____X___,_X______,
  _____X__,_X______,
  _____X__,_X______,
  _____X__,_X______,
  _____X__,_X____X_,
  ____X___,_X___X__,
  ____X___,_X_XX___,
  ___X____,_XX_____,
  __X_____,_X______,
  _X______,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30EC[32] = { /* code 30EC */
  ________,________,
  ________,________,
  ___X____,________,
  ____XX__,________,
  ____X___,________,
  ____X___,________,
  ____X___,_____X__,
  ____X___,____X___,
  ____X___,__XX____,
  ____X___,_X______,
  ____X__X,X_______,
  ____XXX_,________,
  ____X___,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30ED[32] = { /* code 30ED */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XX___,________,
  ____XXXX,XXXXX___,
  _____X__,____X___,
  _____X__,____X___,
  _____X__,____X___,
  _____X__,___X____,
  _____X__,___X____,
  _____XXX,XXXXX___,
  _____X__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30EE[32] = { /* code 30EE */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,___X____,
  ____XXXX,XXXXX___,
  _____X__,___X____,
  _____X__,___X____,
  _____X__,___X____,
  _____X__,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30EF[32] = { /* code 30EF */
  ________,________,
  ________,________,
  ________,____X___,
  ___XXXXX,XXXXXX__,
  ____X___,____X___,
  ____X___,____X___,
  ____X___,___X____,
  ____X___,___X____,
  ________,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F0[32] = { /* code 30F0 */
  ________,________,
  ________,XX______,
  ________,_XX_____,
  ________,_X______,
  ___X____,_X______,
  ____XXXX,XXXXX___,
  ________,_X______,
  _____X__,_X______,
  __X__X__,_X______,
  ___XXXXX,XXXXXX__,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  ________,_X______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F1[32] = { /* code 30F1 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X_XXX,XXXX____,
  ____X___,__X_____,
  ______X_,_X______,
  _______X,X_______,
  _______X,________,
  _______X,________,
  _______X,________,
  __XXXXXX,XXXXXXX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F2[32] = { /* code 30F2 */
  ________,________,
  ________,________,
  ____X___,____X___,
  _____XXX,XXXXXX__,
  ________,____X___,
  ________,____X___,
  ___X____,___X____,
  ____XXXX,XXXX____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F3[32] = { /* code 30F3 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___X____,________,
  ____XXX_,_____X__,
  ________,____X___,
  ________,___X____,
  ________,__X_____,
  ________,_X______,
  _______X,X_______,
  __X__XX_,________,
  ___XX___,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F4[32] = { /* code 30F4 */
  ________,________,
  ________,______X_,
  _____XX_,____X__X,
  _______X,_____X__,
  _______X,___X____,
  __XXXXXX,XXXXX___,
  ___X____,___X____,
  ___X____,___X____,
  ___X____,___X____,
  ___X____,__X_____,
  ________,__X_____,
  ________,_X______,
  ________,X_______,
  _______X,________,
  _____XX_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F5[32] = { /* code 30F5 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,X_______,
  ________,X_______,
  ____X_XX,XXXX____,
  _____X__,X__X____,
  ________,X__X____,
  _______X,___X____,
  _______X,___X____,
  ______X_,___X____,
  _____X__,X_X_____,
  ___XX___,_X______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont16_HK_30F6[32] = { /* code 30F6 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XX__,________,
  _____X__,________,
  _____XXX,XXXX____,
  _____X__,X_______,
  ____X___,X_______,
  ___X____,X_______,
  _______X,________,
  _______X,________,
  ______X_,________,
  _____X__,________,
  ________,________};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font16_HK_CharInfo[169] = {
   {  16,  16,  2, acFont16_HK_3041 } /* code 3041 */
  ,{  16,  16,  2, acFont16_HK_3042 } /* code 3042 */
  ,{  16,  16,  2, acFont16_HK_3043 } /* code 3043 */
  ,{  16,  16,  2, acFont16_HK_3044 } /* code 3044 */
  ,{  16,  16,  2, acFont16_HK_3045 } /* code 3045 */
  ,{  16,  16,  2, acFont16_HK_3046 } /* code 3046 */
  ,{  16,  16,  2, acFont16_HK_3047 } /* code 3047 */
  ,{  16,  16,  2, acFont16_HK_3048 } /* code 3048 */
  ,{  16,  16,  2, acFont16_HK_3049 } /* code 3049 */
  ,{  16,  16,  2, acFont16_HK_304A } /* code 304A */
  ,{  16,  16,  2, acFont16_HK_304B } /* code 304B */
  ,{  16,  16,  2, acFont16_HK_304C } /* code 304C */
  ,{  16,  16,  2, acFont16_HK_304D } /* code 304D */
  ,{  16,  16,  2, acFont16_HK_304E } /* code 304E */
  ,{  16,  16,  2, acFont16_HK_304F } /* code 304F */
  ,{  16,  16,  2, acFont16_HK_3050 } /* code 3050 */
  ,{  16,  16,  2, acFont16_HK_3051 } /* code 3051 */
  ,{  16,  16,  2, acFont16_HK_3052 } /* code 3052 */
  ,{  16,  16,  2, acFont16_HK_3053 } /* code 3053 */
  ,{  16,  16,  2, acFont16_HK_3054 } /* code 3054 */
  ,{  16,  16,  2, acFont16_HK_3055 } /* code 3055 */
  ,{  16,  16,  2, acFont16_HK_3056 } /* code 3056 */
  ,{  16,  16,  2, acFont16_HK_3057 } /* code 3057 */
  ,{  16,  16,  2, acFont16_HK_3058 } /* code 3058 */
  ,{  16,  16,  2, acFont16_HK_3059 } /* code 3059 */
  ,{  16,  16,  2, acFont16_HK_305A } /* code 305A */
  ,{  16,  16,  2, acFont16_HK_305B } /* code 305B */
  ,{  16,  16,  2, acFont16_HK_305C } /* code 305C */
  ,{  16,  16,  2, acFont16_HK_305D } /* code 305D */
  ,{  16,  16,  2, acFont16_HK_305E } /* code 305E */
  ,{  16,  16,  2, acFont16_HK_305F } /* code 305F */
  ,{  16,  16,  2, acFont16_HK_3060 } /* code 3060 */
  ,{  16,  16,  2, acFont16_HK_3061 } /* code 3061 */
  ,{  16,  16,  2, acFont16_HK_3062 } /* code 3062 */
  ,{  16,  16,  2, acFont16_HK_3063 } /* code 3063 */
  ,{  16,  16,  2, acFont16_HK_3064 } /* code 3064 */
  ,{  16,  16,  2, acFont16_HK_3065 } /* code 3065 */
  ,{  16,  16,  2, acFont16_HK_3066 } /* code 3066 */
  ,{  16,  16,  2, acFont16_HK_3067 } /* code 3067 */
  ,{  16,  16,  2, acFont16_HK_3068 } /* code 3068 */
  ,{  16,  16,  2, acFont16_HK_3069 } /* code 3069 */
  ,{  16,  16,  2, acFont16_HK_306A } /* code 306A */
  ,{  16,  16,  2, acFont16_HK_306B } /* code 306B */
  ,{  16,  16,  2, acFont16_HK_306C } /* code 306C */
  ,{  16,  16,  2, acFont16_HK_306D } /* code 306D */
  ,{  16,  16,  2, acFont16_HK_306E } /* code 306E */
  ,{  16,  16,  2, acFont16_HK_306F } /* code 306F */
  ,{  16,  16,  2, acFont16_HK_3070 } /* code 3070 */
  ,{  16,  16,  2, acFont16_HK_3071 } /* code 3071 */
  ,{  16,  16,  2, acFont16_HK_3072 } /* code 3072 */
  ,{  16,  16,  2, acFont16_HK_3073 } /* code 3073 */
  ,{  16,  16,  2, acFont16_HK_3074 } /* code 3074 */
  ,{  16,  16,  2, acFont16_HK_3075 } /* code 3075 */
  ,{  16,  16,  2, acFont16_HK_3076 } /* code 3076 */
  ,{  16,  16,  2, acFont16_HK_3077 } /* code 3077 */
  ,{  16,  16,  2, acFont16_HK_3078 } /* code 3078 */
  ,{  16,  16,  2, acFont16_HK_3079 } /* code 3079 */
  ,{  16,  16,  2, acFont16_HK_307A } /* code 307A */
  ,{  16,  16,  2, acFont16_HK_307B } /* code 307B */
  ,{  16,  16,  2, acFont16_HK_307C } /* code 307C */
  ,{  16,  16,  2, acFont16_HK_307D } /* code 307D */
  ,{  16,  16,  2, acFont16_HK_307E } /* code 307E */
  ,{  16,  16,  2, acFont16_HK_307F } /* code 307F */
  ,{  16,  16,  2, acFont16_HK_3080 } /* code 3080 */
  ,{  16,  16,  2, acFont16_HK_3081 } /* code 3081 */
  ,{  16,  16,  2, acFont16_HK_3082 } /* code 3082 */
  ,{  16,  16,  2, acFont16_HK_3083 } /* code 3083 */
  ,{  16,  16,  2, acFont16_HK_3084 } /* code 3084 */
  ,{  16,  16,  2, acFont16_HK_3085 } /* code 3085 */
  ,{  16,  16,  2, acFont16_HK_3086 } /* code 3086 */
  ,{  16,  16,  2, acFont16_HK_3087 } /* code 3087 */
  ,{  16,  16,  2, acFont16_HK_3088 } /* code 3088 */
  ,{  16,  16,  2, acFont16_HK_3089 } /* code 3089 */
  ,{  16,  16,  2, acFont16_HK_308A } /* code 308A */
  ,{  16,  16,  2, acFont16_HK_308B } /* code 308B */
  ,{  16,  16,  2, acFont16_HK_308C } /* code 308C */
  ,{  16,  16,  2, acFont16_HK_308D } /* code 308D */
  ,{  16,  16,  2, acFont16_HK_308E } /* code 308E */
  ,{  16,  16,  2, acFont16_HK_308F } /* code 308F */
  ,{  16,  16,  2, acFont16_HK_3090 } /* code 3090 */
  ,{  16,  16,  2, acFont16_HK_3091 } /* code 3091 */
  ,{  16,  16,  2, acFont16_HK_3092 } /* code 3092 */
  ,{  16,  16,  2, acFont16_HK_3093 } /* code 3093 */
  ,{  16,  16,  2, acFont16_HK_30A1 } /* code 30A1 */
  ,{  16,  16,  2, acFont16_HK_30A2 } /* code 30A2 */
  ,{  16,  16,  2, acFont16_HK_30A3 } /* code 30A3 */
  ,{  16,  16,  2, acFont16_HK_30A4 } /* code 30A4 */
  ,{  16,  16,  2, acFont16_HK_30A5 } /* code 30A5 */
  ,{  16,  16,  2, acFont16_HK_30A6 } /* code 30A6 */
  ,{  16,  16,  2, acFont16_HK_30A7 } /* code 30A7 */
  ,{  16,  16,  2, acFont16_HK_30A8 } /* code 30A8 */
  ,{  16,  16,  2, acFont16_HK_30A9 } /* code 30A9 */
  ,{  16,  16,  2, acFont16_HK_30AA } /* code 30AA */
  ,{  16,  16,  2, acFont16_HK_30AB } /* code 30AB */
  ,{  16,  16,  2, acFont16_HK_30AC } /* code 30AC */
  ,{  16,  16,  2, acFont16_HK_30AD } /* code 30AD */
  ,{  16,  16,  2, acFont16_HK_30AE } /* code 30AE */
  ,{  16,  16,  2, acFont16_HK_30AF } /* code 30AF */
  ,{  16,  16,  2, acFont16_HK_30B0 } /* code 30B0 */
  ,{  16,  16,  2, acFont16_HK_30B1 } /* code 30B1 */
  ,{  16,  16,  2, acFont16_HK_30B2 } /* code 30B2 */
  ,{  16,  16,  2, acFont16_HK_30B3 } /* code 30B3 */
  ,{  16,  16,  2, acFont16_HK_30B4 } /* code 30B4 */
  ,{  16,  16,  2, acFont16_HK_30B5 } /* code 30B5 */
  ,{  16,  16,  2, acFont16_HK_30B6 } /* code 30B6 */
  ,{  16,  16,  2, acFont16_HK_30B7 } /* code 30B7 */
  ,{  16,  16,  2, acFont16_HK_30B8 } /* code 30B8 */
  ,{  16,  16,  2, acFont16_HK_30B9 } /* code 30B9 */
  ,{  16,  16,  2, acFont16_HK_30BA } /* code 30BA */
  ,{  16,  16,  2, acFont16_HK_30BB } /* code 30BB */
  ,{  16,  16,  2, acFont16_HK_30BC } /* code 30BC */
  ,{  16,  16,  2, acFont16_HK_30BD } /* code 30BD */
  ,{  16,  16,  2, acFont16_HK_30BE } /* code 30BE */
  ,{  16,  16,  2, acFont16_HK_30BF } /* code 30BF */
  ,{  16,  16,  2, acFont16_HK_30C0 } /* code 30C0 */
  ,{  16,  16,  2, acFont16_HK_30C1 } /* code 30C1 */
  ,{  16,  16,  2, acFont16_HK_30C2 } /* code 30C2 */
  ,{  16,  16,  2, acFont16_HK_30C3 } /* code 30C3 */
  ,{  16,  16,  2, acFont16_HK_30C4 } /* code 30C4 */
  ,{  16,  16,  2, acFont16_HK_30C5 } /* code 30C5 */
  ,{  16,  16,  2, acFont16_HK_30C6 } /* code 30C6 */
  ,{  16,  16,  2, acFont16_HK_30C7 } /* code 30C7 */
  ,{  16,  16,  2, acFont16_HK_30C8 } /* code 30C8 */
  ,{  16,  16,  2, acFont16_HK_30C9 } /* code 30C9 */
  ,{  16,  16,  2, acFont16_HK_30CA } /* code 30CA */
  ,{  16,  16,  2, acFont16_HK_30CB } /* code 30CB */
  ,{  16,  16,  2, acFont16_HK_30CC } /* code 30CC */
  ,{  16,  16,  2, acFont16_HK_30CD } /* code 30CD */
  ,{  16,  16,  2, acFont16_HK_30CE } /* code 30CE */
  ,{  16,  16,  2, acFont16_HK_30CF } /* code 30CF */
  ,{  16,  16,  2, acFont16_HK_30D0 } /* code 30D0 */
  ,{  16,  16,  2, acFont16_HK_30D1 } /* code 30D1 */
  ,{  16,  16,  2, acFont16_HK_30D2 } /* code 30D2 */
  ,{  16,  16,  2, acFont16_HK_30D3 } /* code 30D3 */
  ,{  16,  16,  2, acFont16_HK_30D4 } /* code 30D4 */
  ,{  16,  16,  2, acFont16_HK_30D5 } /* code 30D5 */
  ,{  16,  16,  2, acFont16_HK_30D6 } /* code 30D6 */
  ,{  16,  16,  2, acFont16_HK_30D7 } /* code 30D7 */
  ,{  16,  16,  2, acFont16_HK_30D8 } /* code 30D8 */
  ,{  16,  16,  2, acFont16_HK_30D9 } /* code 30D9 */
  ,{  16,  16,  2, acFont16_HK_30DA } /* code 30DA */
  ,{  16,  16,  2, acFont16_HK_30DB } /* code 30DB */
  ,{  16,  16,  2, acFont16_HK_30DC } /* code 30DC */
  ,{  16,  16,  2, acFont16_HK_30DD } /* code 30DD */
  ,{  16,  16,  2, acFont16_HK_30DE } /* code 30DE */
  ,{  16,  16,  2, acFont16_HK_30DF } /* code 30DF */
  ,{  16,  16,  2, acFont16_HK_30E0 } /* code 30E0 */
  ,{  16,  16,  2, acFont16_HK_30E1 } /* code 30E1 */
  ,{  16,  16,  2, acFont16_HK_30E2 } /* code 30E2 */
  ,{  16,  16,  2, acFont16_HK_30E3 } /* code 30E3 */
  ,{  16,  16,  2, acFont16_HK_30E4 } /* code 30E4 */
  ,{  16,  16,  2, acFont16_HK_30E5 } /* code 30E5 */
  ,{  16,  16,  2, acFont16_HK_30E6 } /* code 30E6 */
  ,{  16,  16,  2, acFont16_HK_30E7 } /* code 30E7 */
  ,{  16,  16,  2, acFont16_HK_30E8 } /* code 30E8 */
  ,{  16,  16,  2, acFont16_HK_30E9 } /* code 30E9 */
  ,{  16,  16,  2, acFont16_HK_30EA } /* code 30EA */
  ,{  16,  16,  2, acFont16_HK_30EB } /* code 30EB */
  ,{  16,  16,  2, acFont16_HK_30EC } /* code 30EC */
  ,{  16,  16,  2, acFont16_HK_30ED } /* code 30ED */
  ,{  16,  16,  2, acFont16_HK_30EE } /* code 30EE */
  ,{  16,  16,  2, acFont16_HK_30EF } /* code 30EF */
  ,{  16,  16,  2, acFont16_HK_30F0 } /* code 30F0 */
  ,{  16,  16,  2, acFont16_HK_30F1 } /* code 30F1 */
  ,{  16,  16,  2, acFont16_HK_30F2 } /* code 30F2 */
  ,{  16,  16,  2, acFont16_HK_30F3 } /* code 30F3 */
  ,{  16,  16,  2, acFont16_HK_30F4 } /* code 30F4 */
  ,{  16,  16,  2, acFont16_HK_30F5 } /* code 30F5 */
  ,{  16,  16,  2, acFont16_HK_30F6 } /* code 30F6 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font16_HK_Prop2 = {
   0x30A1                         /* first character               */
  ,0x30F6                         /* last character                */
  ,&GUI_Font16_HK_CharInfo[83]    /* address of first character    */
  ,(const GUI_FONT_PROP*)0        /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font16_HK_Prop1 = {
   0x3041                       /* first character               */
  ,0x3093                       /* last character                */
  ,&GUI_Font16_HK_CharInfo[0]   /* address of first character    */
  ,&GUI_Font16_HK_Prop2         /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font16_HK = {
   GUI_FONTTYPE_PROP    /* type of font    */
  ,16                   /* height of font  */
  ,16                   /* space of font y */
  ,1                    /* magnification x */
  ,1                    /* magnification y */
  ,{&GUI_Font16_HK_Prop1}
  , 13, 7, 10
};


