/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F24_ASCII.C
Purpose     : ASCII character set, bold, high
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acFont24_ASCII_0020[ 24] = { /* code 0020 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0021[ 24] = { /* code 0021 */
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0022[ 24] = { /* code 0022 */
  ________,
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0023[ 48] = { /* code 0023 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XX__,_XX_____,
  ____XX__,_XX_____,
  ____XX__,XXX_____,
  ___XX___,XX______,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ___XX___,XX______,
  __XX___X,X_______,
  __XX___X,X_______,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  __XX___X,X_______,
  _XXX__XX,________,
  _XX___XX,________,
  _XX___XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0024[ 48] = { /* code 0024 */
  ________,________,
  ________,________,
  ________,________,
  _____X__,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXX_X_X,XX______,
  _XX__X__,XX______,
  _XX__X__,________,
  _XXX_X__,________,
  __XXXXX_,________,
  ____XXXX,X_______,
  _____X_X,XX______,
  _____X__,XX______,
  _____X__,XX______,
  _XX__X__,XX______,
  _XXX_X_X,XX______,
  __XXXXXX,X_______,
  ___XXXXX,________,
  _____X__,________,
  _____X__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0025[ 72] = { /* code 0025 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ___XXX__,_____XX_,________,
  __XX_XX_,____XX__,________,
  _XX___XX,____XX__,________,
  _XX___XX,___XX___,________,
  _XX___XX,___XX___,________,
  _XX___XX,__XX____,________,
  __XX_XX_,_XX_____,________,
  ___XXX__,_XX__XXX,________,
  ________,XX__XX_X,X_______,
  ________,XX_XX___,XX______,
  _______X,X__XX___,XX______,
  _______X,X__XX___,XX______,
  ______XX,___XX___,XX______,
  _____XX_,____XX_X,X_______,
  _____XX_,_____XXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0026[ 48] = { /* code 0026 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  ____XXXX,XX______,
  ___XX___,_XX_____,
  ___XX___,_XX_____,
  ___XX___,XX______,
  ____XX_X,X_______,
  ____XXXX,________,
  ___XXXXX,________,
  __XX__XX,X__XX___,
  _XX____X,XX_XX___,
  _XX_____,XXXX____,
  _XX_____,_XX_____,
  _XXX____,XXXX____,
  __XXXXXX,XX_XX___,
  ___XXXXX,____X___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0027[ 24] = { /* code 0027 */
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0028[ 24] = { /* code 0028 */
  ________,
  ________,
  ________,
  ________,
  _____X__,
  ____X___,
  ___XX___,
  ___X____,
  __XX____,
  __XX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  __XX____,
  __XX____,
  ___X____,
  ___XX___,
  ____X___,
  _____X__,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0029[ 24] = { /* code 0029 */
  ________,
  ________,
  ________,
  ________,
  _X______,
  __X_____,
  __XX____,
  ___X____,
  ___XX___,
  ___XX___,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ___XX___,
  ___XX___,
  ___X____,
  __XX____,
  __X_____,
  _X______,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_002A[ 24] = { /* code 002A */
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  XXXXXXXX,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_002B[ 48] = { /* code 002B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_002C[ 24] = { /* code 002C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ___X____,
  ___X____,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_002D[ 24] = { /* code 002D */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XXXXXX__,
  XXXXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_002E[ 24] = { /* code 002E */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_002F[ 24] = { /* code 002F */
  ________,
  ________,
  ________,
  ________,
  ____XX__,
  ____XX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  __XX____,
  __XX____,
  __XX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XX______,
  XX______,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0030[ 48] = { /* code 0030 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,XX______,
  __XX____,XX______,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  __XX____,XX______,
  __XXXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0031[ 48] = { /* code 0031 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  ______XX,________,
  ____XXXX,________,
  ___XXXXX,________,
  __XX__XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0032[ 48] = { /* code 0032 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXX____,XXX_____,
  _XX_____,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,XX______,
  ________,XX______,
  _______X,X_______,
  _____XXX,________,
  ____XXX_,________,
  ___XX___,________,
  __XX____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0033[ 48] = { /* code 0033 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXX___X,XX______,
  _XX_____,XX______,
  ________,XX______,
  _______X,X_______,
  _____XXX,________,
  _____XXX,XX______,
  ________,XXX_____,
  ________,_XX_____,
  ________,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0034[ 48] = { /* code 0034 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XXX,X_______,
  ____XX_X,X_______,
  ____XX_X,X_______,
  ___XX__X,X_______,
  __XX___X,X_______,
  _XX____X,X_______,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0035[ 48] = { /* code 0035 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX_XXX,X_______,
  _XXXXXXX,XX______,
  _XX_____,XXX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0036[ 48] = { /* code 0036 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,________,
  _XX__XXX,X_______,
  _XXXXXXX,XX______,
  _XXX____,XXX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  __XX____,XX______,
  ___XXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0037[ 48] = { /* code 0037 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,XX______,
  _______X,X_______,
  _______X,X_______,
  ______XX,________,
  ______XX,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0038[ 48] = { /* code 0038 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,X_______,
  __XX____,XX______,
  __XX____,XX______,
  __XX____,XX______,
  __XX____,XX______,
  ___XXXXX,X_______,
  ___XXXXX,X_______,
  __XX____,XX______,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0039[ 48] = { /* code 0039 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  __XX____,XX______,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,_XX_____,
  _XX_____,XX______,
  _XXX____,XX______,
  __XXXXXX,X_______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_003A[ 24] = { /* code 003A */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_003B[ 24] = { /* code 003B */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ___X____,
  ___X____,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_003C[ 48] = { /* code 003C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,__X_____,
  ________,XXX_____,
  ______XX,XX______,
  ____XXXX,________,
  __XXX___,________,
  _XX_____,________,
  __XXX___,________,
  ____XXXX,________,
  ______XX,XX______,
  ________,XXX_____,
  ________,__X_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_003D[ 48] = { /* code 003D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_003E[ 48] = { /* code 003E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X______,________,
  _XXX____,________,
  __XXXX__,________,
  ____XXXX,________,
  _______X,XX______,
  ________,_XX_____,
  _______X,XX______,
  ____XXXX,________,
  __XXXX__,________,
  _XXX____,________,
  _X______,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_003F[ 48] = { /* code 003F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXX____,XXX_____,
  _XX_____,_XX_____,
  ________,_XX_____,
  ________,XX______,
  _______X,XX______,
  ______XX,X_______,
  _____XXX,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0040[ 72] = { /* code 0040 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,XXXXXXX_,________,
  _____XXX,XXXXXXXX,X_______,
  ____XXXX,______XX,XX______,
  ___XXX__,________,XXX_____,
  ___XX___,_XXX__XX,_XX_____,
  __XX___X,XXXXX_XX,_XXX____,
  __XX__XX,X___XXX_,__XX____,
  _XX___XX,_____XX_,__XX____,
  _XX__XX_,_____XX_,__XX____,
  _XX__XX_,_____XX_,__XX____,
  _XX__XX_,_____X__,_XXX____,
  _XX__XX_,____XX__,_XX_____,
  _XX__XXX,___XXX__,XX______,
  __XX__XX,XXXXXXXX,X_______,
  __XXX__X,XXX_XXXX,__XX____,
  ___XXX__,________,_XX_____,
  ____XXXX,_______X,XX______,
  _____XXX,XXXXXXXX,X_______,
  _______X,XXXXXXX_,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0041[ 48] = { /* code 0041 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,________,
  _____XXX,________,
  ____XX_X,X_______,
  ____XX_X,X_______,
  ____XX_X,X_______,
  ___XX___,XX______,
  ___XX___,XX______,
  ___XX___,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  XX______,___XX___,
  XX______,___XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0042[ 48] = { /* code 0042 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XX______,
  __XXXXXX,XXX_____,
  __XX____,_XXX____,
  __XX____,__XX____,
  __XX____,__XX____,
  __XX____,_XXX____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XX____,__XX____,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,__XXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0043[ 48] = { /* code 0043 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ___XXXXX,XXXX____,
  ___XXX__,__XXX___,
  __XX____,___XXX__,
  _XXX____,____XX__,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXX____,____XX__,
  __XX____,___XX___,
  __XXXX__,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0044[ 48] = { /* code 0044 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XX______,
  __XXXXXX,XXXX____,
  __XX____,__XXX___,
  __XX____,___XX___,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,___XX___,
  __XX____,__XXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0045[ 48] = { /* code 0045 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0046[ 48] = { /* code 0046 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0047[ 48] = { /* code 0047 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXXX____,
  ____XXXX,XXXXX___,
  ___XXX__,___XXX__,
  __XX____,____XXX_,
  __XX____,_____X__,
  _XX_____,________,
  _XX_____,________,
  _XX_____,XXXXXXX_,
  _XX_____,XXXXXXX_,
  _XX_____,_____XX_,
  __XX____,_____XX_,
  __XX____,_____XX_,
  ___XXX__,___XXXX_,
  ____XXXX,XXXXXX__,
  ______XX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0048[ 48] = { /* code 0048 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0049[ 24] = { /* code 0049 */
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_004A[ 48] = { /* code 004A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _XX____X,X_______,
  _XX____X,X_______,
  _XXX__XX,X_______,
  __XXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_004B[ 48] = { /* code 004B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,__XXX___,
  __XX____,_XXX____,
  __XX____,XXX_____,
  __XX___X,XX______,
  __XX__XX,X_______,
  __XX_XXX,________,
  __XX_XXX,________,
  __XXXXXX,________,
  __XXX_XX,X_______,
  __XX___X,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  __XX____,_XXX____,
  __XX____,__XXX___,
  __XX____,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_004C[ 48] = { /* code 004C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_004D[ 72] = { /* code 004D */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXX____,_____XXX,________,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  _XX_X___,____X_XX,________,
  _XX_XX__,___XX_XX,________,
  _XX_XX__,___XX_XX,________,
  _XX__X__,___X__XX,________,
  _XX__XX_,__XX__XX,________,
  _XX__XX_,__XX__XX,________,
  _XX___X_,__X___XX,________,
  _XX___XX,_XX___XX,________,
  _XX___XX,_XX___XX,________,
  _XX____X,_X____XX,________,
  _XX____X,XX____XX,________,
  _XX____X,XX____XX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_004E[ 48] = { /* code 004E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,___XX___,
  _XXX____,___XX___,
  _XXXX___,___XX___,
  _XXXX___,___XX___,
  _XX_XX__,___XX___,
  _XX__XX_,___XX___,
  _XX__XX_,___XX___,
  _XX___XX,___XX___,
  _XX____X,X__XX___,
  _XX____X,X__XX___,
  _XX_____,XX_XX___,
  _XX_____,_XXXX___,
  _XX_____,_XXXX___,
  _XX_____,__XXX___,
  _XX_____,___XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_004F[ 48] = { /* code 004F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ____XXXX,XXXX____,
  ___XXX__,__XXX___,
  __XX____,____XX__,
  _XXX____,____XXX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XXX____,____XXX_,
  __XX____,____XX__,
  ___XXX__,__XXX___,
  ____XXXX,XXXX____,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0050[ 48] = { /* code 0050 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XX____,__XXX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,__XXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0051[ 48] = { /* code 0051 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ____XXXX,XXXXX___,
  ___XXX__,__XXXX__,
  __XX____,____XX__,
  _XXX____,____XXX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XX_____,_____XX_,
  _XXX____,____XX__,
  __XX____,XXX_XX__,
  ___XXX__,__XXX___,
  ____XXXX,XXXXXX__,
  _____XXX,XXX_XXX_,
  ________,______X_,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0052[ 48] = { /* code 0052 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XX____,__XXX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,__XXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  __XX____,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  __XX____,_XXX____,
  __XX____,__XXX___,
  __XX____,___XX___,
  __XX____,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0053[ 48] = { /* code 0053 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXX___,__XXX___,
  __XX____,___XX___,
  __XX____,________,
  __XXX___,________,
  ___XXXXX,X_______,
  _____XXX,XXX_____,
  ________,_XXX____,
  ________,___XX___,
  _XX_____,___XX___,
  _XXX____,___XX___,
  __XXX___,__XXX___,
  ___XXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0054[ 48] = { /* code 0054 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0055[ 48] = { /* code 0055 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XXX____,__XXX___,
  __XXX___,_XXX____,
  ___XXXXX,XXX_____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0056[ 48] = { /* code 0056 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX______,___XX___,
  XXX_____,__XXX___,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XXX____,_XXX____,
  __XX____,_XX_____,
  __XX____,_XX_____,
  __XXX___,XXX_____,
  ___XX___,XX______,
  ___XX___,XX______,
  ___XXX_X,XX______,
  ____XX_X,X_______,
  ____XX_X,X_______,
  ____XXXX,X_______,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0057[ 72] = { /* code 0057 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XX______,_XXX____,___XX___,
  XX______,_XXX____,___XX___,
  _XX_____,XX_XX___,__XX____,
  _XX_____,XX_XX___,__XX____,
  _XX_____,XX_XX___,__XX____,
  _XXX____,XX__X___,_XXX____,
  __XX___X,X___XX__,_XX_____,
  __XX___X,X___XX__,_XX_____,
  __XX___X,X___XX__,_XX_____,
  ___XX_XX,_____XX_,XX______,
  ___XX_XX,_____XX_,XX______,
  ___XX_XX,_____XX_,XX______,
  ___XX_XX,_____XX_,XX______,
  ____XXX_,______XX,X_______,
  ____XXX_,______XX,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0058[ 48] = { /* code 0058 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,__XXX___,
  __XXX___,_XXX____,
  ___XX___,_XX_____,
  ____XX__,XX______,
  ____XX__,XX______,
  _____XXX,X_______,
  ______XX,________,
  _____XXX,X_______,
  _____XXX,X_______,
  ____XX_X,XX______,
  ___XXX__,XXX_____,
  ___XX___,_XX_____,
  __XX____,__XX____,
  _XXX____,__XXX___,
  XXX_____,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0059[ 48] = { /* code 0059 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,___XXX__,
  _XX_____,___XX___,
  __XX____,__XX____,
  __XXX___,_XXX____,
  ___XXX__,XXX_____,
  ____XX__,XX______,
  _____XXX,X_______,
  _____XXX,X_______,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_005A[ 48] = { /* code 005A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  ________,_XX_____,
  ________,XX______,
  _______X,X_______,
  _______X,X_______,
  ______XX,________,
  _____XX_,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  _XX_____,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_005B[ 24] = { /* code 005B */
  ________,
  ________,
  ________,
  ________,
  _XXXX___,
  _XXXX___,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXX___,
  _XXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_005C[ 24] = { /* code 005C */
  ________,
  ________,
  ________,
  ________,
  XX______,
  XX______,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  __XX____,
  __XX____,
  __XX____,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ____XX__,
  ____XX__,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_005D[ 24] = { /* code 005D */
  ________,
  ________,
  ________,
  ________,
  _XXXX___,
  _XXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXX___,
  _XXXX___,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_005E[ 24] = { /* code 005E */
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  XX____XX,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_005F[ 48] = { /* code 005F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0060[ 24] = { /* code 0060 */
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  __XX____,
  ___X____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0061[ 48] = { /* code 0061 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  _XXXXXXX,XX______,
  _XX_____,XX______,
  ________,XX______,
  _____XXX,XX______,
  __XXXXXX,XX______,
  _XXXX___,XX______,
  _XX_____,XX______,
  _XX____X,XX______,
  _XXXXXXX,XX______,
  __XXXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0062[ 48] = { /* code 0062 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_XXXX,________,
  _XXXXXXX,X_______,
  _XXX___X,X_______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XXX___X,X_______,
  _XXXXXXX,X_______,
  _XX_XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0063[ 48] = { /* code 0063 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  __XX___X,XX______,
  _XX_____,XX______,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,XX______,
  __XX___X,XX______,
  __XXXXXX,X_______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0064[ 48] = { /* code 0064 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ___XXXX_,XX______,
  __XXXXXX,XX______,
  __XX___X,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,XX______,
  __XXXXXX,XX______,
  ___XXXX_,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0065[ 48] = { /* code 0065 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XX____,XX______,
  _XX_____,_XX_____,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _XX_____,________,
  _XX_____,________,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0066[ 24] = { /* code 0066 */
  ________,
  ________,
  ________,
  ________,
  ___XXX__,
  __XXXX__,
  __XX____,
  __XX____,
  XXXXXX__,
  XXXXXX__,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0067[ 48] = { /* code 0067 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,XX______,
  __XXXXXX,XX______,
  __XX___X,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,XX______,
  __XXXXXX,XX______,
  ___XXXX_,XX______,
  ________,XX______,
  _XX____X,XX______,
  _XXXXXXX,X_______,
  ___XXXXX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0068[ 48] = { /* code 0068 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_XXXX,________,
  _XXXXXXX,X_______,
  _XXX___X,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0069[ 24] = { /* code 0069 */
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_006A[ 24] = { /* code 006A */
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXX_____,
  XX______,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_006B[ 48] = { /* code 006B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX____X,XX______,
  _XX___XX,X_______,
  _XX__XXX,________,
  _XX_XXX_,________,
  _XXXXX__,________,
  _XXXXXX_,________,
  _XX__XX_,________,
  _XX___XX,________,
  _XX___XX,X_______,
  _XX____X,X_______,
  _XX____X,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_006C[ 24] = { /* code 006C */
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_006D[ 48] = { /* code 006D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_XXXX,__XXXX__,
  _XXXXXXX,_XXXXXX_,
  _XXX___X,XX___XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  _XX____X,X____XX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_006E[ 48] = { /* code 006E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_XXXX,________,
  _XXXXXXX,X_______,
  _XXX___X,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_006F[ 48] = { /* code 006F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  __XX____,XX______,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  __XX____,XX______,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0070[ 48] = { /* code 0070 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_XXXX,________,
  _XXXXXXX,X_______,
  _XXX___X,X_______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XXX___X,X_______,
  _XXXXXXX,X_______,
  _XX_XXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0071[ 48] = { /* code 0071 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,XX______,
  __XXXXXX,XX______,
  __XX___X,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,XX______,
  __XXXXXX,XX______,
  ___XXXX_,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0072[ 24] = { /* code 0072 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_XXX_,
  _XXXXXX_,
  _XXX____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0073[ 48] = { /* code 0073 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XX_____,XX______,
  _XX_____,________,
  _XXXXX__,________,
  __XXXXXX,X_______,
  ______XX,XX______,
  ________,XX______,
  _XX_____,XX______,
  __XXXXXX,X_______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0074[ 24] = { /* code 0074 */
  ________,
  ________,
  ________,
  ________,
  __X_____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXXXX___,
  XXXXX___,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XXXX___,
  __XXX___,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0075[ 48] = { /* code 0075 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XX_____,XX______,
  _XXX___X,XX______,
  __XXXXXX,XX______,
  ___XXXX_,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0076[ 48] = { /* code 0076 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX______,_XX_____,
  XX______,_XX_____,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,X_______,
  __XX___X,X_______,
  ___XX_XX,________,
  ___XX_XX,________,
  ____XXX_,________,
  ____XXX_,________,
  _____X__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0077[ 48] = { /* code 0077 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX_____X,_____XX_,
  XX____XX,X____XX_,
  _X____XX,X____X__,
  _XX___X_,X___XX__,
  _XX__XX_,XX__XX__,
  __XX_XX_,XX_XX___,
  __XX_XX_,XX_XX___,
  ___X_X__,_X_X____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ____XX__,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0078[ 48] = { /* code 0078 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX____X,XX______,
  _XX____X,X_______,
  __XX__XX,________,
  __XX__XX,________,
  ___XXXX_,________,
  ____XX__,________,
  ___XXXX_,________,
  __XX__XX,________,
  __XX__XX,________,
  _XX____X,X_______,
  XXX____X,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_0079[ 48] = { /* code 0079 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,X_______,
  __XX___X,X_______,
  __XXX__X,X_______,
  ___XX__X,X_______,
  ___XX_XX,________,
  ____XXXX,________,
  ____XXXX,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  _XXXXX__,________,
  _XXXX___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_007A[ 48] = { /* code 007A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  ______XX,X_______,
  _____XXX,________,
  ____XXX_,________,
  ___XXX__,________,
  __XXX___,________,
  _XXX____,________,
  XXX_____,________,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_007B[ 24] = { /* code 007B */
  ________,
  ________,
  ________,
  ________,
  ___XXX__,
  __XXXX__,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  _XXX____,
  XXX_____,
  XXX_____,
  _XX_____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XXXX__,
  ___XXX__,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_007C[ 24] = { /* code 007C */
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_007D[ 24] = { /* code 007D */
  ________,
  ________,
  ________,
  ________,
  _XXX____,
  _XXXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XXX__,
  ____XXX_,
  ____XXX_,
  ___XXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  _XXXX___,
  _XXX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont24_ASCII_007E[ 48] = { /* code 007E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXX___,________,
  _XXXXXX_,__X_____,
  _X___XXX,XXX_____,
  _______X,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font24_ASCII_CharInfo[95] = {
   {   6,   6,  1, acFont24_ASCII_0020 } /* code 0020 */
  ,{   6,   6,  1, acFont24_ASCII_0021 } /* code 0021 */
  ,{   7,   7,  1, acFont24_ASCII_0022 } /* code 0022 */
  ,{  12,  12,  2, acFont24_ASCII_0023 } /* code 0023 */
  ,{  12,  12,  2, acFont24_ASCII_0024 } /* code 0024 */
  ,{  19,  19,  3, acFont24_ASCII_0025 } /* code 0025 */
  ,{  14,  14,  2, acFont24_ASCII_0026 } /* code 0026 */
  ,{   4,   4,  1, acFont24_ASCII_0027 } /* code 0027 */
  ,{   7,   7,  1, acFont24_ASCII_0028 } /* code 0028 */
  ,{   7,   7,  1, acFont24_ASCII_0029 } /* code 0029 */
  ,{   8,   8,  1, acFont24_ASCII_002A } /* code 002A */
  ,{  12,  12,  2, acFont24_ASCII_002B } /* code 002B */
  ,{   6,   6,  1, acFont24_ASCII_002C } /* code 002C */
  ,{   7,   7,  1, acFont24_ASCII_002D } /* code 002D */
  ,{   6,   6,  1, acFont24_ASCII_002E } /* code 002E */
  ,{   6,   6,  1, acFont24_ASCII_002F } /* code 002F */
  ,{  12,  12,  2, acFont24_ASCII_0030 } /* code 0030 */
  ,{  12,  12,  2, acFont24_ASCII_0031 } /* code 0031 */
  ,{  12,  12,  2, acFont24_ASCII_0032 } /* code 0032 */
  ,{  12,  12,  2, acFont24_ASCII_0033 } /* code 0033 */
  ,{  12,  12,  2, acFont24_ASCII_0034 } /* code 0034 */
  ,{  12,  12,  2, acFont24_ASCII_0035 } /* code 0035 */
  ,{  12,  12,  2, acFont24_ASCII_0036 } /* code 0036 */
  ,{  12,  12,  2, acFont24_ASCII_0037 } /* code 0037 */
  ,{  12,  12,  2, acFont24_ASCII_0038 } /* code 0038 */
  ,{  12,  12,  2, acFont24_ASCII_0039 } /* code 0039 */
  ,{   6,   6,  1, acFont24_ASCII_003A } /* code 003A */
  ,{   6,   6,  1, acFont24_ASCII_003B } /* code 003B */
  ,{  12,  12,  2, acFont24_ASCII_003C } /* code 003C */
  ,{  12,  12,  2, acFont24_ASCII_003D } /* code 003D */
  ,{  12,  12,  2, acFont24_ASCII_003E } /* code 003E */
  ,{  12,  12,  2, acFont24_ASCII_003F } /* code 003F */
  ,{  21,  21,  3, acFont24_ASCII_0040 } /* code 0040 */
  ,{  13,  13,  2, acFont24_ASCII_0041 } /* code 0041 */
  ,{  14,  14,  2, acFont24_ASCII_0042 } /* code 0042 */
  ,{  15,  15,  2, acFont24_ASCII_0043 } /* code 0043 */
  ,{  15,  15,  2, acFont24_ASCII_0044 } /* code 0044 */
  ,{  14,  14,  2, acFont24_ASCII_0045 } /* code 0045 */
  ,{  13,  13,  2, acFont24_ASCII_0046 } /* code 0046 */
  ,{  16,  16,  2, acFont24_ASCII_0047 } /* code 0047 */
  ,{  14,  14,  2, acFont24_ASCII_0048 } /* code 0048 */
  ,{   6,   6,  1, acFont24_ASCII_0049 } /* code 0049 */
  ,{  11,  11,  2, acFont24_ASCII_004A } /* code 004A */
  ,{  14,  14,  2, acFont24_ASCII_004B } /* code 004B */
  ,{  12,  12,  2, acFont24_ASCII_004C } /* code 004C */
  ,{  17,  17,  3, acFont24_ASCII_004D } /* code 004D */
  ,{  14,  14,  2, acFont24_ASCII_004E } /* code 004E */
  ,{  16,  16,  2, acFont24_ASCII_004F } /* code 004F */
  ,{  14,  14,  2, acFont24_ASCII_0050 } /* code 0050 */
  ,{  16,  16,  2, acFont24_ASCII_0051 } /* code 0051 */
  ,{  15,  15,  2, acFont24_ASCII_0052 } /* code 0052 */
  ,{  14,  14,  2, acFont24_ASCII_0053 } /* code 0053 */
  ,{  12,  12,  2, acFont24_ASCII_0054 } /* code 0054 */
  ,{  14,  14,  2, acFont24_ASCII_0055 } /* code 0055 */
  ,{  13,  13,  2, acFont24_ASCII_0056 } /* code 0056 */
  ,{  21,  21,  3, acFont24_ASCII_0057 } /* code 0057 */
  ,{  14,  14,  2, acFont24_ASCII_0058 } /* code 0058 */
  ,{  14,  14,  2, acFont24_ASCII_0059 } /* code 0059 */
  ,{  13,  13,  2, acFont24_ASCII_005A } /* code 005A */
  ,{   6,   6,  1, acFont24_ASCII_005B } /* code 005B */
  ,{   6,   6,  1, acFont24_ASCII_005C } /* code 005C */
  ,{   6,   6,  1, acFont24_ASCII_005D } /* code 005D */
  ,{   8,   8,  1, acFont24_ASCII_005E } /* code 005E */
  ,{  12,  12,  2, acFont24_ASCII_005F } /* code 005F */
  ,{   7,   7,  1, acFont24_ASCII_0060 } /* code 0060 */
  ,{  12,  12,  2, acFont24_ASCII_0061 } /* code 0061 */
  ,{  11,  11,  2, acFont24_ASCII_0062 } /* code 0062 */
  ,{  11,  11,  2, acFont24_ASCII_0063 } /* code 0063 */
  ,{  11,  11,  2, acFont24_ASCII_0064 } /* code 0064 */
  ,{  12,  12,  2, acFont24_ASCII_0065 } /* code 0065 */
  ,{   6,   6,  1, acFont24_ASCII_0066 } /* code 0066 */
  ,{  11,  11,  2, acFont24_ASCII_0067 } /* code 0067 */
  ,{  11,  11,  2, acFont24_ASCII_0068 } /* code 0068 */
  ,{   5,   5,  1, acFont24_ASCII_0069 } /* code 0069 */
  ,{   4,   4,  1, acFont24_ASCII_006A } /* code 006A */
  ,{  10,  10,  2, acFont24_ASCII_006B } /* code 006B */
  ,{   4,   4,  1, acFont24_ASCII_006C } /* code 006C */
  ,{  16,  16,  2, acFont24_ASCII_006D } /* code 006D */
  ,{  11,  11,  2, acFont24_ASCII_006E } /* code 006E */
  ,{  12,  12,  2, acFont24_ASCII_006F } /* code 006F */
  ,{  11,  11,  2, acFont24_ASCII_0070 } /* code 0070 */
  ,{  11,  11,  2, acFont24_ASCII_0071 } /* code 0071 */
  ,{   7,   7,  1, acFont24_ASCII_0072 } /* code 0072 */
  ,{  11,  11,  2, acFont24_ASCII_0073 } /* code 0073 */
  ,{   6,   6,  1, acFont24_ASCII_0074 } /* code 0074 */
  ,{  11,  11,  2, acFont24_ASCII_0075 } /* code 0075 */
  ,{  11,  11,  2, acFont24_ASCII_0076 } /* code 0076 */
  ,{  15,  15,  2, acFont24_ASCII_0077 } /* code 0077 */
  ,{  10,  10,  2, acFont24_ASCII_0078 } /* code 0078 */
  ,{  11,  11,  2, acFont24_ASCII_0079 } /* code 0079 */
  ,{   9,   9,  2, acFont24_ASCII_007A } /* code 007A */
  ,{   7,   7,  1, acFont24_ASCII_007B } /* code 007B */
  ,{   6,   6,  1, acFont24_ASCII_007C } /* code 007C */
  ,{   7,   7,  1, acFont24_ASCII_007D } /* code 007D */
  ,{  12,  12,  2, acFont24_ASCII_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font24_ASCII_Prop1 = {
   0x0020                         /* first character */
  ,0x007E                         /* last character  */
  ,&GUI_Font24_ASCII_CharInfo[0]  /* address of first character */
  ,(const GUI_FONT_PROP*)0        /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font24_ASCII = {
   GUI_FONTTYPE_PROP        /* type of font    */
  ,24                       /* height of font  */
  ,24                       /* space of font y */
  ,1                        /* magnification x */
  ,1                        /* magnification y */
  ,{&GUI_Font24_ASCII_Prop1}
  ,19, 11, 15
};

