/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F32B_ASCII.C
Purpose     : ASCII character set, bold, high
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0020[ 32] = { /* code 0020 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0021[ 32] = { /* code 0021 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0022[ 64] = { /* code 0022 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXX__X,XXX_____,
  _XXXX__X,XXX_____,
  _XXXX__X,XXX_____,
  _XXXX__X,XXX_____,
  _XXXX__X,XXX_____,
  _XXXX__X,XXX_____,
  __XX____,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0023[ 64] = { /* code 0023 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,___XXX__,
  _____XXX,___XXX__,
  ____XXXX,__XXXX__,
  ____XXX_,__XXX___,
  ____XXX_,__XXX___,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  _XXXX__X,XXX_____,
  _XXX___X,XX______,
  _XXX___X,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0024[ 64] = { /* code 0024 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,X_______,
  _____XXX,XXX_____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXX_X,X_XXXX__,
  __XXX__X,X__XXX__,
  __XXX__X,X_______,
  __XXX__X,X_______,
  __XXXXXX,X_______,
  ___XXXXX,XX______,
  ____XXXX,XXXX____,
  _____XXX,XXXXX___,
  _______X,XXXXXX__,
  _______X,X_XXXX__,
  _______X,X__XXX__,
  __XXX__X,X__XXX__,
  __XXXX_X,X__XXX__,
  ___XXX_X,X_XXXX__,
  ___XXXXX,XXXXX___,
  ____XXXX,XXXX____,
  _____XXX,XXX_____,
  _______X,X_______,
  _______X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0025[ 96] = { /* code 0025 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ___XXXXX,_______X,XX______,
  __XXXXXX,X______X,XX______,
  _XXX___X,XX____XX,X_______,
  _XXX___X,XX____XX,X_______,
  _XXX___X,XX___XXX,X_______,
  _XXX___X,XX___XXX,________,
  _XXX___X,XX___XXX,________,
  _XXX___X,XX__XXX_,________,
  __XXXXXX,X___XXX_,________,
  ___XXXXX,___XXX__,________,
  ________,___XXX__,________,
  ________,__XXX___,XXXXX___,
  ________,__XXX__X,XXXXXX__,
  ________,_XXX__XX,X___XXX_,
  ________,_XXX__XX,X___XXX_,
  ________,XXX___XX,X___XXX_,
  ________,XXX___XX,X___XXX_,
  _______X,XX____XX,X___XXX_,
  _______X,XX____XX,X___XXX_,
  ______XX,X______X,XXXXXX__,
  ______XX,X_______,XXXXX___,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0026[ 96] = { /* code 0026 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXX_____,________,
  ____XXXX,XXXXX___,________,
  ___XXXXX,XXXXXX__,________,
  ___XXXX_,__XXXX__,________,
  ___XXXX_,__XXXX__,________,
  ___XXXX_,__XXXX__,________,
  ____XXXX,_XXXX___,________,
  ____XXXX,XXXXX___,________,
  _____XXX,XXX_____,________,
  ____XXXX,XXX_____,________,
  ___XXXXX,XXX_____,________,
  __XXXXXX,XXXX__XX,X_______,
  _XXXXX__,XXXXXXXX,X_______,
  _XXXX___,_XXXXXXX,X_______,
  _XXXX___,__XXXXXX,________,
  _XXXX___,__XXXXXX,________,
  _XXXXX__,_XXXXXXX,XX______,
  __XXXXXX,XXXXXXXX,XXX_____,
  ___XXXXX,XXXXX_XX,XX______,
  _____XXX,XXX_____,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0027[ 32] = { /* code 0027 */
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXX___,
  _XXXX___,
  _XXXX___,
  _XXXX___,
  _XXXX___,
  _XXXX___,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0028[ 64] = { /* code 0028 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  __XXX___,________,
  __XXXX__,________,
  __XXXX__,________,
  ___XXX__,________,
  ___XXXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _____XXX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0029[ 64] = { /* code 0029 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  __XXX___,________,
  __XXX___,________,
  __XXXX__,________,
  ___XXX__,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ____XXX_,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXX__,________,
  __XXXX__,________,
  __XXX___,________,
  __XXX___,________,
  _XXX____,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_002A[ 64] = { /* code 002A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XX__,________,
  ____XX__,________,
  XX__XX__,XX______,
  XXXXXXXX,XX______,
  ___XXXX_,________,
  ___XXXX_,________,
  __XX__XX,________,
  _XXX__XX,X_______,
  __X____X,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_002B[ 64] = { /* code 002B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,XX______,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,XX______,
  ______XX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_002C[ 32] = { /* code 002C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ____XX__,
  ___XXX__,
  __XXX___,
  ___X____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_002D[ 64] = { /* code 002D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_002E[ 32] = { /* code 002E */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_002F[ 32] = { /* code 002F */
  ________,
  ________,
  ________,
  ________,
  ________,
  _____XXX,
  _____XXX,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  XXX_____,
  XXX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0030[ 64] = { /* code 0030 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  ___XXXXX,XXXX____,
  __XXXX__,_XXXX___,
  __XXXX__,_XXXX___,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXXX__,_XXXX___,
  __XXXX__,_XXXX___,
  ___XXXXX,XXXX____,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0031[ 64] = { /* code 0031 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXX_____,
  _____XXX,XXX_____,
  ___XXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  __X____X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  _______X,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0032[ 64] = { /* code 0032 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXXX__,_XXXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  ________,__XXXX__,
  ________,__XXXX__,
  ________,_XXXX___,
  ________,XXXXX___,
  _______X,XXXX____,
  ______XX,XXX_____,
  _____XXX,XX______,
  ____XXXX,X_______,
  ___XXXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  __XXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0033[ 64] = { /* code 0033 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XX______,
  ___XXXXX,XXX_____,
  __XXXXXX,XXXX____,
  _XXXXX__,XXXXX___,
  _XXXX___,_XXXX___,
  ________,_XXXX___,
  ________,XXXX____,
  ______XX,XXXX____,
  ______XX,XX______,
  ______XX,XXXX____,
  ________,_XXXX___,
  ________,__XXXX__,
  ________,__XXXX__,
  ________,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXXX__,_XXXX___,
  __XXXXXX,XXXXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0034[ 64] = { /* code 0034 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XXXX____,
  ________,XXXX____,
  _______X,XXXX____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,XXXX____,
  ____XXX_,XXXX____,
  ____XXX_,XXXX____,
  ___XXX__,XXXX____,
  __XXX___,XXXX____,
  __XXX___,XXXX____,
  _XXX____,XXXX____,
  XXX_____,XXXX____,
  XXXXXXXX,XXXXXX__,
  XXXXXXXX,XXXXXX__,
  XXXXXXXX,XXXXXX__,
  ________,XXXX____,
  ________,XXXX____,
  ________,XXXX____,
  ________,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0035[ 64] = { /* code 0035 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXXX__,________,
  __XXX___,________,
  __XXX___,________,
  __XXX_XX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXXX___,
  _XXXX___,_XXXX___,
  ________,__XXXX__,
  ________,__XXXX__,
  ________,__XXXX__,
  ________,__XXXX__,
  ________,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXXX__,_XXXX___,
  __XXXXXX,XXXX____,
  ___XXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0036[ 64] = { /* code 0036 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,XXX_____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXX__,_XXXXX__,
  __XXXX__,__XXXX__,
  __XXX___,________,
  _XXXX___,________,
  _XXXX_XX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXXX___,
  _XXXXX__,_XXXX___,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXX___,__XXXX__,
  __XXXX__,_XXXX___,
  ___XXXXX,XXXXX___,
  ____XXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0037[ 64] = { /* code 0037 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  ________,_XXXXX__,
  ________,XXXXX___,
  ________,XXXX____,
  _______X,XXX_____,
  ______XX,XXX_____,
  ______XX,XX______,
  _____XXX,XX______,
  _____XXX,X_______,
  _____XXX,X_______,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0038[ 64] = { /* code 0038 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  _XXXXX__,_XXXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXXX__,_XXXX___,
  ___XXXXX,XXXX____,
  ____XXXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXX__,_XXXX___,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXXX__,_XXXXX__,
  __XXXXXX,XXXXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0039[ 64] = { /* code 0039 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXX__,_XXXX___,
  _XXXX___,__XXX___,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXXX__,_XXXXX__,
  __XXXXXX,XXXXXX__,
  ___XXXXX,XXXXXX__,
  ____XXXX,X_XXXX__,
  ________,__XXXX__,
  ________,__XXX___,
  _XXXX___,_XXXX___,
  _XXXXX__,_XXXX___,
  __XXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_003A[ 64] = { /* code 003A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_003B[ 64] = { /* code 003B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  _____XX_,________,
  ____XXX_,________,
  ___XXX__,________,
  ____X___,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_003C[ 64] = { /* code 003C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,_____X__,
  ________,___XXX__,
  ________,XXXXXX__,
  ______XX,XXXXXX__,
  ____XXXX,XXXXX___,
  __XXXXXX,XX______,
  _XXXXXX_,________,
  _XXXX___,________,
  _XXXXXX_,________,
  __XXXXXX,XX______,
  ____XXXX,XXXXX___,
  ______XX,XXXXXX__,
  ________,XXXXXX__,
  ________,___XXX__,
  ________,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_003D[ 64] = { /* code 003D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_003E[ 64] = { /* code 003E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _X______,________,
  _XXX____,________,
  _XXXXXX_,________,
  _XXXXXXX,X_______,
  __XXXXXX,XXX_____,
  _____XXX,XXXXX___,
  ________,XXXXXX__,
  ________,__XXXX__,
  ________,XXXXXX__,
  _____XXX,XXXXX___,
  __XXXXXX,XXX_____,
  _XXXXXXX,X_______,
  _XXXXXX_,________,
  _XXX____,________,
  _X______,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_003F[ 96] = { /* code 003F */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _____XXX,XXX_____,________,
  ___XXXXX,XXXXX___,________,
  __XXXXXX,XXXXXX__,________,
  __XXXX__,__XXXXX_,________,
  _XXXXX__,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  ________,___XXXX_,________,
  ________,__XXXXX_,________,
  ________,_XXXXX__,________,
  _______X,XXXXX___,________,
  _______X,XXXX____,________,
  ______XX,XXX_____,________,
  ______XX,XX______,________,
  ______XX,XX______,________,
  ________,________,________,
  ________,________,________,
  ______XX,XX______,________,
  ______XX,XX______,________,
  ______XX,XX______,________,
  ______XX,XX______,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0040[128] = { /* code 0040 */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,__XXXXXX,XX______,________,
  ________,XXXXXXXX,XXXX____,________,
  ______XX,XXXXXXXX,XXXXXX__,________,
  _____XXX,XXX_____,_XXXXXX_,________,
  ____XXXX,________,___XXXX_,________,
  ___XXXX_,__XXXX_X,XXX_XXXX,________,
  ___XXX__,_XXXXXXX,XXX__XXX,________,
  __XXXX__,XXXXXXXX,XXX__XXX,X_______,
  __XXX__X,XXX__XXX,XX____XX,X_______,
  __XXX__X,XX____XX,XX____XX,X_______,
  _XXXX__X,XX____XX,XX____XX,X_______,
  _XXX__XX,X_____XX,XX____XX,X_______,
  _XXX__XX,X_____XX,XX____XX,X_______,
  _XXX__XX,X_____XX,X____XXX,________,
  _XXX__XX,X____XXX,X____XXX,________,
  _XXX__XX,X____XXX,X___XXXX,________,
  _XXX__XX,XX__XXXX,X__XXXX_,________,
  _XXX___X,XXXXXXXX,XXXXXX__,________,
  __XXX__X,XXXXXXXX,XXXXX___,________,
  __XXX___,XXXX__XX,XXX_____,________,
  __XXXX__,________,______XX,XX______,
  ___XXXX_,________,_____XXX,X_______,
  ____XXXX,________,____XXXX,X_______,
  ____XXXX,XX______,__XXXXXX,________,
  ______XX,XXXXXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXXXX___,________,
  ________,__XXXXXX,XXX_____,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0041[ 96] = { /* code 0041 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXX____,________,
  ______XX,XXXXX___,________,
  ______XX,XXXXX___,________,
  ______XX,XXXXX___,________,
  _____XXX,X_XXXX__,________,
  _____XXX,X_XXXX__,________,
  _____XXX,X_XXXX__,________,
  ____XXXX,___XXXX_,________,
  ____XXXX,___XXXX_,________,
  ____XXXX,___XXXX_,________,
  ___XXXX_,____XXXX,________,
  ___XXXX_,____XXXX,________,
  ___XXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXX__,_____XXX,X_______,
  _XXXX___,______XX,XX______,
  _XXXX___,______XX,XX______,
  _XXXX___,______XX,XX______,
  XXXX____,_______X,XXX_____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0042[ 96] = { /* code 0042 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXX__,_____XXX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,_____XXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXX__,______XX,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,______XX,XXX_____,
  __XXXXXX,XXXXXXXX,XXX_____,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0043[ 96] = { /* code 0043 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,XX______,
  __XXXXXX,_____XXX,XX______,
  __XXXX__,______XX,XXX_____,
  _XXXXX__,_______X,X_______,
  _XXXX___,________,________,
  _XXXX___,________,________,
  _XXXX___,________,________,
  _XXXX___,________,________,
  _XXXX___,________,________,
  _XXXX___,_______X,X_______,
  _XXXXX__,______XX,XXX_____,
  __XXXX__,______XX,XXX_____,
  __XXXXXX,____XXXX,XX______,
  ___XXXXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,________,
  _______X,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0044[ 96] = { /* code 0044 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXX__,_____XXX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXX__,______XX,XXX_____,
  __XXXX__,______XX,XX______,
  __XXXX__,_____XXX,XX______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0045[ 96] = { /* code 0045 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0046[ 96] = { /* code 0046 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0047[ 96] = { /* code 0047 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,XX______,
  __XXXXXX,_____XXX,XXX_____,
  __XXXX__,______XX,XXX_____,
  _XXXXX__,_______X,X_______,
  _XXXX___,________,________,
  _XXXX___,________,________,
  _XXXX___,___XXXXX,XXX_____,
  _XXXX___,___XXXXX,XXX_____,
  _XXXX___,___XXXXX,XXX_____,
  _XXXX___,___XXXXX,XXX_____,
  __XXXX__,_______X,XXX_____,
  __XXXXX_,_______X,XXX_____,
  __XXXXXX,_____XXX,XXX_____,
  ___XXXXX,XXXXXXXX,XXX_____,
  ____XXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,________,
  _______X,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0048[ 96] = { /* code 0048 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0049[ 32] = { /* code 0049 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_004A[ 64] = { /* code 004A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  ________,_XXXX___,
  XXXX____,_XXXX___,
  XXXX____,_XXXX___,
  XXXXX___,XXXXX___,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_004B[ 96] = { /* code 004B */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,______XX,XXX_____,
  __XXXX__,_____XXX,XX______,
  __XXXX__,____XXXX,X_______,
  __XXXX__,___XXXXX,________,
  __XXXX__,__XXXXX_,________,
  __XXXX__,_XXXXX__,________,
  __XXXX__,XXXXX___,________,
  __XXXX_X,XXXX____,________,
  __XXXXXX,XXXX____,________,
  __XXXXXX,XXXXX___,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,__XXXX__,________,
  __XXXXX_,__XXXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,X_______,
  __XXXX__,_____XXX,X_______,
  __XXXX__,_____XXX,XX______,
  __XXXX__,______XX,XXX_____,
  __XXXX__,_______X,XXX_____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_004C[ 96] = { /* code 004C */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_004D[ 96] = { /* code 004D */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXXXXX_,______XX,XXXX____,
  _XXXXXXX,_____XXX,XXXX____,
  _XXXXXXX,_____XXX,XXXX____,
  _XXXXXXX,_____XXX,XXXX____,
  _XXXX_XX,_____XX_,XXXX____,
  _XXXX_XX,X___XXX_,XXXX____,
  _XXXX_XX,X___XXX_,XXXX____,
  _XXXX_XX,X___XXX_,XXXX____,
  _XXXX_XX,X___XXX_,XXXX____,
  _XXXX__X,XX_XXX__,XXXX____,
  _XXXX__X,XX_XXX__,XXXX____,
  _XXXX__X,XX_XXX__,XXXX____,
  _XXXX__X,XX_XXX__,XXXX____,
  _XXXX___,XX_XX___,XXXX____,
  _XXXX___,XXXXX___,XXXX____,
  _XXXX___,XXXXX___,XXXX____,
  _XXXX___,XXXXX___,XXXX____,
  _XXXX___,XXXXX___,XXXX____,
  _XXXX___,_XXX____,XXXX____,
  _XXXX___,_XXX____,XXXX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_004E[ 96] = { /* code 004E */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,______XX,XX______,
  __XXXXX_,______XX,XX______,
  __XXXXXX,______XX,XX______,
  __XXXXXX,______XX,XX______,
  __XXXXXX,X_____XX,XX______,
  __XXXXXX,X_____XX,XX______,
  __XXXXXX,XX____XX,XX______,
  __XXXX_X,XX____XX,XX______,
  __XXXX_X,XXX___XX,XX______,
  __XXXX__,XXXX__XX,XX______,
  __XXXX__,XXXX__XX,XX______,
  __XXXX__,_XXXX_XX,XX______,
  __XXXX__,__XXX_XX,XX______,
  __XXXX__,__XXXXXX,XX______,
  __XXXX__,___XXXXX,XX______,
  __XXXX__,___XXXXX,XX______,
  __XXXX__,____XXXX,XX______,
  __XXXX__,____XXXX,XX______,
  __XXXX__,_____XXX,XX______,
  __XXXX__,_____XXX,XX______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_004F[ 96] = { /* code 004F */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,XX______,
  __XXXXXX,_____XXX,XXX_____,
  __XXXX__,______XX,XXX_____,
  _XXXXX__,_______X,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXXX__,_______X,XXXX____,
  __XXXXX_,______XX,XXX_____,
  __XXXXXX,_____XXX,XXX_____,
  ___XXXXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,________,
  _______X,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0050[ 96] = { /* code 0050 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXX__,____XXXX,X_______,
  __XXXX__,_____XXX,X_______,
  __XXXX__,_____XXX,X_______,
  __XXXX__,____XXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXX___,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0051[ 96] = { /* code 0051 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,XX______,
  __XXXXXX,_____XXX,XXX_____,
  __XXXXX_,______XX,XXX_____,
  _XXXXX__,_______X,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXX___,________,XXXX____,
  _XXXXX__,___XX__X,XXXX____,
  __XXXXX_,__XXXXXX,XXX_____,
  __XXXXXX,____XXXX,XXX_____,
  ___XXXXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XXXX____,
  _______X,XXXXXX__,XXXXX___,
  ________,________,_XXX____,
  ________,________,__XX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0052[ 96] = { /* code 0052 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,XX______,
  __XXXX__,_____XXX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,_____XXX,XX______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXX___,________,
  __XXXX__,__XXXXX_,________,
  __XXXX__,___XXXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,X_______,
  __XXXX__,_____XXX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XXX_____,
  __XXXX__,_______X,XXXX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0053[ 96] = { /* code 0053 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXX____,________,
  ____XXXX,XXXXXX__,________,
  ___XXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXX_,___XXXXX,________,
  __XXXX__,____XXXX,________,
  __XXXXX_,________,________,
  __XXXXXX,XX______,________,
  ___XXXXX,XXXXX___,________,
  ____XXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,________,
  ________,_XXXXXXX,X_______,
  ________,____XXXX,X_______,
  _XXXX___,_____XXX,X_______,
  _XXXXX__,_____XXX,X_______,
  __XXXXX_,____XXXX,X_______,
  __XXXXXX,XXXXXXXX,________,
  ___XXXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXX_,________,
  ______XX,XXXXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0054[ 96] = { /* code 0054 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXXXXXX,XXXXXXXX,X_______,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0055[ 96] = { /* code 0055 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXX__,______XX,XX______,
  __XXXXX_,______XX,XX______,
  __XXXXXX,____XXXX,XX______,
  ___XXXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,________,
  ______XX,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0056[ 96] = { /* code 0056 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XXXX____,_____XXX,X_______,
  XXXXX___,____XXXX,X_______,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  ___XXX__,___XXX__,________,
  ___XXXX_,__XXXX__,________,
  ___XXXX_,__XXXX__,________,
  ___XXXX_,__XXXX__,________,
  ____XXX_,__XXX___,________,
  ____XXXX,_XXXX___,________,
  ____XXXX,_XXXX___,________,
  _____XXX,_XXX____,________,
  _____XXX,_XXX____,________,
  _____XXX,XXXX____,________,
  ______XX,XXX_____,________,
  ______XX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0057[128] = { /* code 0057 */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  XXXX____,__XXXXX_,_____XXX,X_______,
  XXXX____,__XXXXX_,_____XXX,X_______,
  _XXX____,__XXXXX_,_____XXX,________,
  _XXXX___,_XXXXXXX,____XXXX,________,
  _XXXX___,_XXX_XXX,____XXXX,________,
  _XXXX___,_XXX_XXX,____XXXX,________,
  _XXXX___,_XXX_XXX,____XXXX,________,
  __XXX___,XXXX_XXX,X___XXX_,________,
  __XXX___,XXX___XX,X___XXX_,________,
  __XXXX__,XXX___XX,X__XXXX_,________,
  __XXXX__,XXX___XX,X__XXXX_,________,
  __XXXX__,XXX___XX,X__XXXX_,________,
  ___XXX_X,XX_____X,XX_XXX__,________,
  ___XXX_X,XX_____X,XX_XXX__,________,
  ___XXX_X,XX_____X,XX_XXX__,________,
  ___XXX_X,XX_____X,XX_XXX__,________,
  ___XXXXX,X_______,XXXXXX__,________,
  ____XXXX,X_______,XXXXX___,________,
  ____XXXX,X_______,XXXXX___,________,
  ____XXXX,X_______,XXXXX___,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0058[ 96] = { /* code 0058 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,____XXXX,________,
  __XXXXX_,___XXXXX,________,
  ___XXXX_,___XXXX_,________,
  ____XXXX,__XXXX__,________,
  ____XXXX,__XXXX__,________,
  _____XXX,XXXXX___,________,
  _____XXX,XXXXX___,________,
  ______XX,XXXX____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  ______XX,XXXX____,________,
  _____XXX,XXXX____,________,
  _____XXX,XXXXX___,________,
  ____XXXX,__XXXX__,________,
  ____XXXX,__XXXX__,________,
  ___XXXX_,___XXXX_,________,
  ___XXXX_,___XXXX_,________,
  __XXXX__,____XXXX,________,
  _XXXXX__,____XXXX,X_______,
  _XXXX___,_____XXX,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0059[ 96] = { /* code 0059 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XXXX____,______XX,XX______,
  XXXXX___,_____XXX,XX______,
  _XXXXX__,____XXXX,X_______,
  __XXXX__,____XXXX,________,
  __XXXXX_,___XXXXX,________,
  ___XXXX_,___XXXX_,________,
  ____XXXX,__XXXX__,________,
  ____XXXX,XXXXXX__,________,
  _____XXX,XXXXX___,________,
  ______XX,XXXX____,________,
  ______XX,XXXX____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_005A[ 96] = { /* code 005A */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXXXXXX,XXXXXXXX,________,
  _XXXXXXX,XXXXXXXX,________,
  _XXXXXXX,XXXXXXXX,________,
  _XXXXXXX,XXXXXXXX,________,
  ________,___XXXX_,________,
  ________,__XXXX__,________,
  ________,_XXXX___,________,
  ________,XXXX____,________,
  _______X,XXX_____,________,
  ______XX,XX______,________,
  _____XXX,XX______,________,
  _____XXX,X_______,________,
  ____XXXX,________,________,
  ___XXXX_,________,________,
  __XXXX__,________,________,
  _XXXX___,________,________,
  XXXXXXXX,XXXXXXXX,________,
  XXXXXXXX,XXXXXXXX,________,
  XXXXXXXX,XXXXXXXX,________,
  XXXXXXXX,XXXXXXXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_005B[ 64] = { /* code 005B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_005C[ 32] = { /* code 005C */
  ________,
  ________,
  ________,
  ________,
  ________,
  XXX_____,
  XXX_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ___XXX__,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  ____XXX_,
  _____XXX,
  _____XXX,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_005D[ 64] = { /* code 005D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  XXXXXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_005E[ 64] = { /* code 005E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  _____XXX,X_______,
  ____XXXX,XX______,
  ____XXXX,XX______,
  ____XXXX,XX______,
  ___XXX__,XXX_____,
  ___XXX__,XXX_____,
  __XXXX__,XXXX____,
  __XXX___,_XXX____,
  _XXXX___,_XXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_005F[ 64] = { /* code 005F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0060[ 64] = { /* code 0060 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXX____,________,
  _XXXX___,________,
  __XXX___,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0061[ 64] = { /* code 0061 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  _XXXX___,XXXXX___,
  _XXX____,_XXXX___,
  ________,_XXXX___,
  _______X,XXXXX___,
  ___XXXXX,XXXXX___,
  __XXXXX_,_XXXX___,
  _XXXX___,_XXXX___,
  _XXXX___,_XXXX___,
  _XXXX___,XXXXX___,
  _XXXXXXX,XXXXX___,
  __XXXXXX,X_XXX___,
  ___XXXXX,__XXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0062[ 96] = { /* code 0062 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,XXXX____,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXX_,___XXXX_,________,
  __XXXXX_,___XXXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXXX_,___XXXXX,________,
  __XXXXXX,___XXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXX__,________,
  __XXXX__,XXXX____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0063[ 64] = { /* code 0063 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXXX__,_XXXXX__,
  _XXXX___,__XX____,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,________,
  _XXXX___,__XX____,
  __XXXX__,_XXXXX__,
  __XXXXXX,XXXXX___,
  ___XXXXX,XXXXX___,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0064[ 96] = { /* code 0064 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  _____XXX,X__XXXX_,________,
  ___XXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXX__,__XXXXX_,________,
  _XXXXX__,__XXXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXXX__,__XXXXX_,________,
  __XXXX__,__XXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  ___XXXXX,XXXXXXX_,________,
  _____XXX,X__XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0065[ 64] = { /* code 0065 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXXX___,
  __XXXX__,_XXXX___,
  _XXXX___,__XXX___,
  _XXXX___,__XXXX__,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  _XXXX___,________,
  _XXXX___,________,
  __XXXX__,__XX____,
  __XXXXXX,XXXXXX__,
  ___XXXXX,XXXXX___,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0066[ 64] = { /* code 0066 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  ___XXXXX,X_______,
  __XXXXXX,X_______,
  __XXXX__,________,
  __XXXX__,________,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0067[ 96] = { /* code 0067 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _____XXX,X__XXXX_,________,
  ___XXXXX,XX_XXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXX__,__XXXXX_,________,
  _XXXXX__,__XXXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXXX__,__XXXXX_,________,
  __XXXX__,_XXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  ___XXXXX,XX_XXXX_,________,
  ____XXXX,X__XXXX_,________,
  ________,___XXXX_,________,
  _XX_____,__XXXXX_,________,
  _XXXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXX___,________,
  ____XXXX,XXXX____,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0068[ 96] = { /* code 0068 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,XXXXX___,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXX_,__XXXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0069[ 32] = { /* code 0069 */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_006A[ 32] = { /* code 006A */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  XXXXXX__,
  XXXXX___,
  XXXX____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_006B[ 64] = { /* code 006B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,__XXXX__,
  __XXXX__,_XXXX___,
  __XXXX__,_XXX____,
  __XXXX__,XXXX____,
  __XXXX_X,XXX_____,
  __XXXX_X,XX______,
  __XXXXXX,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXX_,XXXX____,
  __XXXX__,XXXX____,
  __XXXX__,_XXXX___,
  __XXXX__,_XXXX___,
  __XXXX__,__XXXX__,
  __XXXX__,__XXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_006C[ 32] = { /* code 006C */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_006D[128] = { /* code 006D */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  __XXXX__,XXXXX___,_XXXXX__,________,
  __XXXXXX,XXXXXX_X,XXXXXXX_,________,
  __XXXXXX,XXXXXXXX,XXXXXXXX,________,
  __XXXXX_,__XXXXXX,___XXXXX,________,
  __XXXX__,___XXXXX,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  __XXXX__,___XXXX_,____XXXX,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_006E[ 96] = { /* code 006E */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,XXXXX___,________,
  __XXXX_X,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXX_,__XXXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_006F[ 96] = { /* code 006F */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXX_____,________,
  ____XXXX,XXXXX___,________,
  ___XXXXX,XXXXXX__,________,
  __XXXXX_,__XXXXX_,________,
  __XXXX__,___XXXX_,________,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  _XXXX___,____XXXX,________,
  __XXXX__,___XXXX_,________,
  __XXXXX_,__XXXXX_,________,
  ___XXXXX,XXXXXX__,________,
  ____XXXX,XXXXX___,________,
  ______XX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0070[ 96] = { /* code 0070 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,XXXXX___,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXX_,___XXXX_,________,
  __XXXXX_,___XXXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXX__,____XXXX,________,
  __XXXXX_,___XXXXX,________,
  __XXXXXX,___XXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXX_X,XXXXXX__,________,
  __XXXX__,XXXX____,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  __XXXX__,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0071[ 96] = { /* code 0071 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _____XXX,X__XXXX_,________,
  ___XXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXX__,__XXXXX_,________,
  _XXXXX__,__XXXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXX___,___XXXX_,________,
  _XXXXX__,__XXXXX_,________,
  __XXXX__,_XXXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  ___XXXXX,XXXXXXX_,________,
  _____XXX,X__XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,___XXXX_,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0072[ 64] = { /* code 0072 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXX_X,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXX_,________,
  __XXXXX_,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0073[ 64] = { /* code 0073 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXX_____,
  __XXXXXX,XXXXX___,
  _XXXXXXX,XXXXXX__,
  _XXXX___,__XX____,
  _XXXX___,________,
  _XXXXXX_,________,
  __XXXXXX,XX______,
  ___XXXXX,XXXX____,
  _____XXX,XXXXX___,
  ________,XXXXXX__,
  ________,__XXXX__,
  ___XX___,__XXXX__,
  _XXXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  ____XXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0074[ 64] = { /* code 0074 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____X__,________,
  ___XXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  XXXXXXXX,X_______,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXX__,________,
  __XXXXXX,X_______,
  ___XXXXX,X_______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0075[ 96] = { /* code 0075 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXX__,___XXXX_,________,
  __XXXXX_,__XXXXX_,________,
  __XXXXXX,XXXXXXX_,________,
  ___XXXXX,XXXXXXX_,________,
  ____XXXX,X__XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0076[ 64] = { /* code 0076 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXX___,__XXX___,
  __XXXX__,_XXXX___,
  __XXXX__,_XXXX___,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXXX_,_XXX____,
  ____XXX_,XXX_____,
  ____XXX_,XXX_____,
  ____XXXX,XXX_____,
  _____XXX,XX______,
  _____XXX,XX______,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0077[ 96] = { /* code 0077 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XXXX____,_XXX____,_XXXX___,
  _XXX____,_XXX____,_XXX____,
  _XXX____,_XXX____,_XXX____,
  _XXXX___,XXXXX___,XXXX____,
  __XXX___,XX_XX___,XXX_____,
  __XXX___,XX_XX___,XXX_____,
  __XXX___,XX_XX___,XXX_____,
  ___XXX_X,XX_XXX_X,XX______,
  ___XXX_X,X___XX_X,XX______,
  ___XXX_X,X___XX_X,XX______,
  ____XX_X,X___XX_X,X_______,
  ____XXXX,X___XXXX,X_______,
  ____XXXX,_____XXX,X_______,
  _____XXX,_____XXX,________,
  _____XXX,_____XXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0078[ 64] = { /* code 0078 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  __XXXX__,_XXXX___,
  ___XXXX_,XXXX____,
  ___XXXX_,XXX_____,
  ____XXXX,XXX_____,
  _____XXX,XX______,
  _____XXX,XX______,
  _____XXX,XX______,
  ____XXXX,XXX_____,
  ___XXXX_,XXXX____,
  ___XXXX_,XXXX____,
  __XXXX__,_XXXX___,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_0079[ 64] = { /* code 0079 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXX____,___XXXX_,
  XXXX____,___XXXX_,
  _XXXX___,__XXXX__,
  _XXXX___,__XXXX__,
  _XXXX___,__XXX___,
  __XXXX__,_XXXX___,
  __XXXX__,_XXXX___,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXXX_,XXXX____,
  ____XXX_,XXX_____,
  ____XXX_,XXX_____,
  _____XXX,XX______,
  _____XXX,XX______,
  _____XXX,XX______,
  _____XXX,X_______,
  ____XXXX,X_______,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XXXXX__,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_007A[ 64] = { /* code 007A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ________,_XXXX___,
  ________,XXXX____,
  _______X,XXX_____,
  ______XX,XX______,
  _____XXX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  _XXXX___,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_007B[ 64] = { /* code 007B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,XX______,
  _____XXX,XX______,
  ____XXXX,XX______,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  _XXXXX__,________,
  _XXXX___,________,
  _XXXXX__,________,
  ___XXXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXXX,XX______,
  _____XXX,XX______,
  ______XX,XX______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_007C[ 32] = { /* code 007C */
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  __XXX___,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_007D[ 64] = { /* code 007D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXX___,________,
  _XXXXX__,________,
  _XXXXXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXXX,________,
  _____XXX,XX______,
  ______XX,XX______,
  _____XXX,XX______,
  ____XXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _XXXXXX_,________,
  _XXXXX__,________,
  _XXXX___,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32B_ASCII_007E[ 64] = { /* code 007E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  _XXXXXXX,XX___XX_,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _XX____X,XXXXXXX_,
  ________,_XXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font32B_ASCII_CharInfo[95] = {
   {   8,   8,  1, acFont32B_ASCII_0020 } /* code 0020 */
  ,{   8,   8,  1, acFont32B_ASCII_0021 } /* code 0021 */
  ,{  13,  13,  2, acFont32B_ASCII_0022 } /* code 0022 */
  ,{  15,  15,  2, acFont32B_ASCII_0023 } /* code 0023 */
  ,{  15,  15,  2, acFont32B_ASCII_0024 } /* code 0024 */
  ,{  24,  24,  3, acFont32B_ASCII_0025 } /* code 0025 */
  ,{  20,  20,  3, acFont32B_ASCII_0026 } /* code 0026 */
  ,{   6,   6,  1, acFont32B_ASCII_0027 } /* code 0027 */
  ,{   9,   9,  2, acFont32B_ASCII_0028 } /* code 0028 */
  ,{   9,   9,  2, acFont32B_ASCII_0029 } /* code 0029 */
  ,{  11,  11,  2, acFont32B_ASCII_002A } /* code 002A */
  ,{  16,  16,  2, acFont32B_ASCII_002B } /* code 002B */
  ,{   8,   8,  1, acFont32B_ASCII_002C } /* code 002C */
  ,{   9,   9,  2, acFont32B_ASCII_002D } /* code 002D */
  ,{   8,   8,  1, acFont32B_ASCII_002E } /* code 002E */
  ,{   8,   8,  1, acFont32B_ASCII_002F } /* code 002F */
  ,{  15,  15,  2, acFont32B_ASCII_0030 } /* code 0030 */
  ,{  15,  15,  2, acFont32B_ASCII_0031 } /* code 0031 */
  ,{  15,  15,  2, acFont32B_ASCII_0032 } /* code 0032 */
  ,{  15,  15,  2, acFont32B_ASCII_0033 } /* code 0033 */
  ,{  15,  15,  2, acFont32B_ASCII_0034 } /* code 0034 */
  ,{  15,  15,  2, acFont32B_ASCII_0035 } /* code 0035 */
  ,{  15,  15,  2, acFont32B_ASCII_0036 } /* code 0036 */
  ,{  15,  15,  2, acFont32B_ASCII_0037 } /* code 0037 */
  ,{  15,  15,  2, acFont32B_ASCII_0038 } /* code 0038 */
  ,{  15,  15,  2, acFont32B_ASCII_0039 } /* code 0039 */
  ,{  10,  10,  2, acFont32B_ASCII_003A } /* code 003A */
  ,{  10,  10,  2, acFont32B_ASCII_003B } /* code 003B */
  ,{  16,  16,  2, acFont32B_ASCII_003C } /* code 003C */
  ,{  16,  16,  2, acFont32B_ASCII_003D } /* code 003D */
  ,{  16,  16,  2, acFont32B_ASCII_003E } /* code 003E */
  ,{  17,  17,  3, acFont32B_ASCII_003F } /* code 003F */
  ,{  26,  26,  4, acFont32B_ASCII_0040 } /* code 0040 */
  ,{  19,  19,  3, acFont32B_ASCII_0041 } /* code 0041 */
  ,{  20,  20,  3, acFont32B_ASCII_0042 } /* code 0042 */
  ,{  20,  20,  3, acFont32B_ASCII_0043 } /* code 0043 */
  ,{  20,  20,  3, acFont32B_ASCII_0044 } /* code 0044 */
  ,{  18,  18,  3, acFont32B_ASCII_0045 } /* code 0045 */
  ,{  17,  17,  3, acFont32B_ASCII_0046 } /* code 0046 */
  ,{  21,  21,  3, acFont32B_ASCII_0047 } /* code 0047 */
  ,{  20,  20,  3, acFont32B_ASCII_0048 } /* code 0048 */
  ,{   8,   8,  1, acFont32B_ASCII_0049 } /* code 0049 */
  ,{  15,  15,  2, acFont32B_ASCII_004A } /* code 004A */
  ,{  20,  20,  3, acFont32B_ASCII_004B } /* code 004B */
  ,{  17,  17,  3, acFont32B_ASCII_004C } /* code 004C */
  ,{  21,  21,  3, acFont32B_ASCII_004D } /* code 004D */
  ,{  20,  20,  3, acFont32B_ASCII_004E } /* code 004E */
  ,{  21,  21,  3, acFont32B_ASCII_004F } /* code 004F */
  ,{  18,  18,  3, acFont32B_ASCII_0050 } /* code 0050 */
  ,{  21,  21,  3, acFont32B_ASCII_0051 } /* code 0051 */
  ,{  20,  20,  3, acFont32B_ASCII_0052 } /* code 0052 */
  ,{  18,  18,  3, acFont32B_ASCII_0053 } /* code 0053 */
  ,{  18,  18,  3, acFont32B_ASCII_0054 } /* code 0054 */
  ,{  20,  20,  3, acFont32B_ASCII_0055 } /* code 0055 */
  ,{  18,  18,  3, acFont32B_ASCII_0056 } /* code 0056 */
  ,{  25,  25,  4, acFont32B_ASCII_0057 } /* code 0057 */
  ,{  18,  18,  3, acFont32B_ASCII_0058 } /* code 0058 */
  ,{  18,  18,  3, acFont32B_ASCII_0059 } /* code 0059 */
  ,{  17,  17,  3, acFont32B_ASCII_005A } /* code 005A */
  ,{   9,   9,  2, acFont32B_ASCII_005B } /* code 005B */
  ,{   8,   8,  1, acFont32B_ASCII_005C } /* code 005C */
  ,{   9,   9,  2, acFont32B_ASCII_005D } /* code 005D */
  ,{  16,  16,  2, acFont32B_ASCII_005E } /* code 005E */
  ,{  15,  15,  2, acFont32B_ASCII_005F } /* code 005F */
  ,{   9,   9,  2, acFont32B_ASCII_0060 } /* code 0060 */
  ,{  15,  15,  2, acFont32B_ASCII_0061 } /* code 0061 */
  ,{  17,  17,  3, acFont32B_ASCII_0062 } /* code 0062 */
  ,{  15,  15,  2, acFont32B_ASCII_0063 } /* code 0063 */
  ,{  17,  17,  3, acFont32B_ASCII_0064 } /* code 0064 */
  ,{  15,  15,  2, acFont32B_ASCII_0065 } /* code 0065 */
  ,{   9,   9,  2, acFont32B_ASCII_0066 } /* code 0066 */
  ,{  17,  17,  3, acFont32B_ASCII_0067 } /* code 0067 */
  ,{  17,  17,  3, acFont32B_ASCII_0068 } /* code 0068 */
  ,{   8,   8,  1, acFont32B_ASCII_0069 } /* code 0069 */
  ,{   8,   8,  1, acFont32B_ASCII_006A } /* code 006A */
  ,{  15,  15,  2, acFont32B_ASCII_006B } /* code 006B */
  ,{   8,   8,  1, acFont32B_ASCII_006C } /* code 006C */
  ,{  26,  26,  4, acFont32B_ASCII_006D } /* code 006D */
  ,{  17,  17,  3, acFont32B_ASCII_006E } /* code 006E */
  ,{  17,  17,  3, acFont32B_ASCII_006F } /* code 006F */
  ,{  17,  17,  3, acFont32B_ASCII_0070 } /* code 0070 */
  ,{  17,  17,  3, acFont32B_ASCII_0071 } /* code 0071 */
  ,{  11,  11,  2, acFont32B_ASCII_0072 } /* code 0072 */
  ,{  15,  15,  2, acFont32B_ASCII_0073 } /* code 0073 */
  ,{   9,   9,  2, acFont32B_ASCII_0074 } /* code 0074 */
  ,{  17,  17,  3, acFont32B_ASCII_0075 } /* code 0075 */
  ,{  15,  15,  2, acFont32B_ASCII_0076 } /* code 0076 */
  ,{  21,  21,  3, acFont32B_ASCII_0077 } /* code 0077 */
  ,{  15,  15,  2, acFont32B_ASCII_0078 } /* code 0078 */
  ,{  15,  15,  2, acFont32B_ASCII_0079 } /* code 0079 */
  ,{  14,  14,  2, acFont32B_ASCII_007A } /* code 007A */
  ,{  11,  11,  2, acFont32B_ASCII_007B } /* code 007B */
  ,{   7,   7,  1, acFont32B_ASCII_007C } /* code 007C */
  ,{  11,  11,  2, acFont32B_ASCII_007D } /* code 007D */
  ,{  16,  16,  2, acFont32B_ASCII_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font32B_ASCII_Prop1 = {
   0x0020                         /* first character */
  ,0x007E                         /* last character  */
  ,GUI_Font32B_ASCII_CharInfo     /* address of first character */
  ,(const GUI_FONT_PROP*)0        /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font32B_ASCII = {
   GUI_FONTTYPE_PROP        /* type of font    */
  ,32                       /* height of font  */
  ,32                       /* space of font y */
  ,1                        /* magnification x */
  ,1                        /* magnification y */
  ,{&GUI_Font32B_ASCII_Prop1}
  ,25, 15, 20
};

