/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F32_ASCII.C
Purpose     : ASCII character set, bold, high
Height      : 13
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acFont32_ASCII_0020[ 32] = { /* code 0020 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0021[ 32] = { /* code 0021 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0022[ 64] = { /* code 0022 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0023[ 64] = { /* code 0023 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,___XX___,
  _____XX_,___XX___,
  ____XXX_,__XX____,
  ____XX__,__XX____,
  ____XX__,__XX____,
  ____XX__,__XX____,
  XXXXXXXX,XXXXXX__,
  XXXXXXXX,XXXXXX__,
  ___XX___,_XX_____,
  ___XX___,_XX_____,
  ___XX___,_XX_____,
  ___XX___,_XX_____,
  ___XX___,_XX_____,
  XXXXXXXX,XXXXXX__,
  XXXXXXXX,XXXXXX__,
  __XX____,XX______,
  __XX____,XX______,
  _XXX___X,XX______,
  _XX____X,X_______,
  _XX____X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0024[ 64] = { /* code 0024 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _______X,________,
  ____XXXX,XX______,
  ___XXXXX,XXXX____,
  __XXX__X,__XXX___,
  _XXX___X,___XXX__,
  _XX____X,____XX__,
  _XX____X,________,
  _XX____X,________,
  __XX___X,________,
  __XXXXXX,________,
  ____XXXX,XXX_____,
  ______XX,XXXX____,
  _______X,__XXX___,
  _______X,___XXX__,
  _______X,____XX__,
  _XX____X,____XX__,
  _XX____X,____XX__,
  __XX___X,___XXX__,
  __XXX__X,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  _______X,________,
  _______X,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0025[ 96] = { /* code 0025 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ____XXXX,________,XX______,
  ___XXXXX,X______X,XX______,
  __XXX__X,XX_____X,X_______,
  __XX____,XX____XX,X_______,
  __XX____,XX____XX,________,
  __XX____,XX___XXX,________,
  __XX____,XX___XX_,________,
  __XXX__X,XX__XX__,________,
  ___XXXXX,X___XX__,________,
  ____XXXX,___XX___,________,
  ________,___XX___,XXXX____,
  ________,__XX___X,XXXXX___,
  ________,__XX__XX,X__XXX__,
  ________,_XX___XX,____XX__,
  ________,_XX___XX,____XX__,
  ________,XX____XX,____XX__,
  ________,XX____XX,____XX__,
  _______X,X_____XX,X__XXX__,
  _______X,X______X,XXXXX___,
  ______XX,________,XXXX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0026[ 96] = { /* code 0026 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXX_____,________,
  ____XXXX,XXXX____,________,
  ____XX__,__XXX___,________,
  ___XX___,___XX___,________,
  ___XX___,___XX___,________,
  ___XX___,___XX___,________,
  ____XX__,__XX____,________,
  ____XXX_,_XXX____,________,
  _____XXX,XXX_____,________,
  _____XXX,X_______,________,
  ___XXXXX,X_______,________,
  __XXX___,XX____X_,________,
  _XXX____,_XX__XXX,________,
  _XX_____,_XXX_XX_,________,
  _XX_____,__XXXXX_,________,
  _XX_____,___XXX__,________,
  _XXX____,___XXXX_,________,
  __XXX___,_XXXXXXX,________,
  ___XXXXX,XXXX__XX,X_______,
  ____XXXX,XX____XX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0027[ 32] = { /* code 0027 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0028[ 64] = { /* code 0028 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ____XX__,________,
  ____XX__,________,
  _____XX_,________,
  _____XX_,________,
  ______XX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0029[ 64] = { /* code 0029 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,________,
  __XX____,________,
  __XX____,________,
  ___XX___,________,
  ___XX___,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  __XX____,________,
  _XX_____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_002A[ 64] = { /* code 002A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  __X__XX_,_X______,
  _XXXXXXX,XXX_____,
  ____XXXX,X_______,
  ____XXXX,________,
  ___XX__X,X_______,
  ___XX___,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_002B[ 64] = { /* code 002B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_002C[ 32] = { /* code 002C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ___X____,
  ___X____,
  __XX____,
  __X_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_002D[ 64] = { /* code 002D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_002E[ 32] = { /* code 002E */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_002F[ 32] = { /* code 002F */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ______XX,
  ______XX,
  _____XX_,
  _____XX_,
  _____XX_,
  ____XX__,
  ____XX__,
  ____XX__,
  ___XXX__,
  ___XX___,
  ___XX___,
  ___XX___,
  __XX____,
  __XX____,
  __XX____,
  _XX_____,
  _XX_____,
  _XX_____,
  XXX_____,
  XX______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0030[ 64] = { /* code 0030 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXX___,__XXX___,
  __XX____,___XX___,
  __XX____,___XX___,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  __XX____,___XX___,
  __XX____,___XX___,
  __XXX___,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0031[ 64] = { /* code 0031 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,XX______,
  ________,XX______,
  _______X,XX______,
  ______XX,XX______,
  ____XXXX,XX______,
  ___XXXX_,XX______,
  ___XX___,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0032[ 64] = { /* code 0032 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  _XX_____,__XXX___,
  _XX_____,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,__XX____,
  ________,__XX____,
  ________,_XX_____,
  ________,XX______,
  _______X,X_______,
  ______XX,________,
  _____XX_,________,
  ____XX__,________,
  ___XX___,________,
  __XX____,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0033[ 64] = { /* code 0033 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  _XXX____,___XX___,
  _XX_____,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,_XXX____,
  ______XX,XXX_____,
  ______XX,XXXX____,
  ________,__XXX___,
  ________,___XXX__,
  ________,____XX__,
  ________,____XX__,
  ________,____XX__,
  _XX_____,____XX__,
  _XXX____,___XX___,
  __XXX___,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0034[ 64] = { /* code 0034 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,__XX____,
  ________,_XXX____,
  ________,XXXX____,
  ________,XXXX____,
  _______X,X_XX____,
  ______XX,__XX____,
  _____XXX,__XX____,
  _____XX_,__XX____,
  ____XX__,__XX____,
  ___XXX__,__XX____,
  ___XX___,__XX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  ________,__XX____,
  ________,__XX____,
  ________,__XX____,
  ________,__XX____,
  ________,__XX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0035[ 64] = { /* code 0035 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,
  __XXX___,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __X__XXX,XX______,
  _XXXXXXX,XXXX____,
  _XXXX___,__XXX___,
  _XX_____,___XX___,
  ________,____XX__,
  ________,____XX__,
  ________,____XX__,
  ________,____XX__,
  ________,____XX__,
  _XX_____,____XX__,
  _XXX____,___XX___,
  __XXX___,__XXX___,
  ___XXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0036[ 64] = { /* code 0036 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,XXX_____,
  ____XXXX,XXXX____,
  ___XXX__,__XXX___,
  __XXX___,___XXX__,
  __XX____,____XX__,
  __XX____,________,
  _XX_____,________,
  _XX__XXX,XX______,
  _XX_XXXX,XXXX____,
  _XXXX___,__XXX___,
  _XXX____,___XX___,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  __XX____,____XX__,
  __XX____,___XX___,
  ___XX___,__XXX___,
  ____XXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0037[ 64] = { /* code 0037 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ________,___X____,
  ________,__XX____,
  ________,_XX_____,
  ________,_X______,
  ________,XX______,
  _______X,X_______,
  _______X,X_______,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0038[ 64] = { /* code 0038 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  ___XX___,__XX____,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  ___XX___,__XX____,
  ____XXXX,XXX_____,
  ___XXXXX,XXXX____,
  __XXX___,__XXX___,
  __XX____,___XX___,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  __XX____,___XX___,
  __XXX___,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0039[ 64] = { /* code 0039 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,__XX____,
  __XX____,___XX___,
  _XX_____,____X___,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  __XX____,___XXX__,
  __XXX___,__XXXX__,
  ___XXXXX,XXX_XX__,
  _____XXX,X___XX__,
  ________,____XX__,
  ________,___XX___,
  _XX_____,___XX___,
  _XXX____,___XX___,
  __XXX___,_XXX____,
  ___XXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_003A[ 32] = { /* code 003A */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_003B[ 32] = { /* code 003B */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ____X___,
  ____X___,
  ___XX___,
  ___X____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_003C[ 64] = { /* code 003C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,_____X__,
  ________,___XXX__,
  ________,_XXXX___,
  _______X,XXX_____,
  _____XXX,________,
  ___XXX__,________,
  __XX____,________,
  ___XXX__,________,
  _____XXX,________,
  _______X,XXX_____,
  ________,_XXXX___,
  ________,___XXX__,
  ________,_____X__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_003D[ 64] = { /* code 003D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_003E[ 64] = { /* code 003E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __X_____,________,
  __XXX___,________,
  ___XXXX_,________,
  _____XXX,X_______,
  ________,XXX_____,
  ________,__XXX___,
  ________,____XX__,
  ________,__XXX___,
  ________,XXX_____,
  _____XXX,X_______,
  ___XXXX_,________,
  __XXX___,________,
  __X_____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_003F[ 64] = { /* code 003F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXX___,__XXX___,
  __XX____,___XXX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  ________,____XX__,
  ________,___XXX__,
  ________,___XX___,
  ________,__XX____,
  ________,_XX_____,
  ________,XX______,
  _______X,XX______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  ________,________,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0040[128] = { /* code 0040 */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,__XXXXXX,XX______,________,
  ________,XXXXXXXX,XXXX____,________,
  ______XX,XX______,_XXXX___,________,
  _____XXX,________,___XXX__,________,
  ____XXX_,________,____XXX_,________,
  ___XXX__,__XXXX__,_XX__XXX,________,
  ___XX___,XXXXXXXX,_XX___XX,________,
  __XX___X,XX____XX,XXX___XX,X_______,
  __XX___X,X______X,XX_____X,X_______,
  __XX__XX,________,XX_____X,X_______,
  _XX___XX,________,XX_____X,X_______,
  _XX__XX_,________,XX_____X,X_______,
  _XX__XX_,________,XX_____X,X_______,
  _XX__XX_,________,XX____XX,X_______,
  _XX__XX_,_______X,X_____XX,________,
  _XX__XX_,_______X,X____XXX,________,
  _XX___XX,______XX,X____XX_,________,
  _XXX__XX,X___XXXX,X__XXX__,________,
  __XX___X,XXXXXX_X,XXXXX___,________,
  __XXX___,XXXXX___,XXXX____,________,
  ___XX___,________,________,XX______,
  ___XXX__,________,_______X,X_______,
  ____XXXX,________,_____XXX,________,
  _____XXX,XX______,___XXXX_,________,
  _______X,XXXXXXXX,XXXXX___,________,
  ________,__XXXXXX,XXX_____,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0041[ 96] = { /* code 0041 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XX______,________,
  _______X,XX______,________,
  ______XX,_XX_____,________,
  ______XX,_XX_____,________,
  _____XXX,_XXX____,________,
  _____XX_,__XX____,________,
  _____XX_,__XX____,________,
  ____XXX_,__XXX___,________,
  ____XX__,___XX___,________,
  ____XX__,___XX___,________,
  ___XX___,____XX__,________,
  ___XX___,____XX__,________,
  ___XXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XX____,_____XX_,________,
  _XXX____,_____XXX,________,
  _XX_____,______XX,________,
  _XX_____,______XX,________,
  XX______,_______X,X_______,
  XX______,_______X,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0042[ 96] = { /* code 0042 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXX___,________,
  __XXXXXX,XXXXXX__,________,
  __XX____,____XXX_,________,
  __XX____,_____XXX,________,
  __XX____,______XX,________,
  __XX____,______XX,________,
  __XX____,______XX,________,
  __XX____,_____XXX,________,
  __XX____,____XXX_,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XX____,_____XXX,________,
  __XX____,______XX,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,______XX,X_______,
  __XX____,_____XXX,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0043[ 96] = { /* code 0043 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,______XX,X_______,
  ___XXX__,_______X,XX______,
  __XXX___,________,XXX_____,
  __XX____,________,_XX_____,
  _XXX____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  __XX____,________,_XX_____,
  __XX____,________,XXX_____,
  __XXX___,________,XX______,
  ___XXX__,_______X,XX______,
  ____XXX_,_____XXX,X_______,
  _____XXX,XXXXXXXX,________,
  _______X,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0044[ 96] = { /* code 0044 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXXX_,________,
  __XX____,_____XXX,X_______,
  __XX____,_______X,X_______,
  __XX____,________,XX______,
  __XX____,________,XX______,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XX____,________,XX______,
  __XX____,________,XX______,
  __XX____,_______X,X_______,
  __XX____,_____XXX,X_______,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0045[ 96] = { /* code 0045 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0046[ 96] = { /* code 0046 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXXX,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXXXX__,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0047[ 96] = { /* code 0047 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,______XX,X_______,
  ___XXX__,_______X,XX______,
  __XXX___,________,XX______,
  __XX____,________,_XX_____,
  __XX____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  _XX_____,________,________,
  _XX_____,___XXXXX,XXX_____,
  _XX_____,___XXXXX,XXX_____,
  _XX_____,________,_XX_____,
  _XXX____,________,_XX_____,
  __XX____,________,_XX_____,
  __XXX___,________,_XX_____,
  ___XXX__,________,XXX_____,
  ____XXXX,______XX,XX______,
  _____XXX,XXXXXXXX,X_______,
  _______X,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0048[ 96] = { /* code 0048 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XXXXXX,XXXXXXXX,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0049[ 32] = { /* code 0049 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_004A[ 64] = { /* code 004A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  __XX____,XX______,
  __XXXXXX,XX______,
  ___XXXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_004B[ 96] = { /* code 004B */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XX____,______XX,X_______,
  __XX____,_____XXX,________,
  __XX____,____XXX_,________,
  __XX____,___XXX__,________,
  __XX____,__XXX___,________,
  __XX____,_XXX____,________,
  __XX____,XXX_____,________,
  __XX___X,XX______,________,
  __XX__XX,XX______,________,
  __XX_XXX,XX______,________,
  __XXXXX_,XXX_____,________,
  __XXXX__,_XXX____,________,
  __XXX___,_XXX____,________,
  __XX____,__XXX___,________,
  __XX____,___XXX__,________,
  __XX____,____XXX_,________,
  __XX____,_____XX_,________,
  __XX____,_____XXX,________,
  __XX____,______XX,X_______,
  __XX____,_______X,XX______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_004C[ 64] = { /* code 004C */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XXXXXX,XXXXXX__,
  __XXXXXX,XXXXXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_004D[ 96] = { /* code 004D */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ___XXX__,________,_XXX____,
  ___XXXX_,________,XXXX____,
  ___XXXX_,________,XXXX____,
  ___XXXX_,________,XXXX____,
  ___XX_XX,_______X,X_XX____,
  ___XX_XX,_______X,X_XX____,
  ___XX_XX,_______X,X_XX____,
  ___XX__X,X_____XX,__XX____,
  ___XX__X,X_____XX,__XX____,
  ___XX__X,X_____XX,__XX____,
  ___XX___,XX___XX_,__XX____,
  ___XX___,XX___XX_,__XX____,
  ___XX___,XX___XX_,__XX____,
  ___XX___,XXX_XXX_,__XX____,
  ___XX___,_XX_XX__,__XX____,
  ___XX___,_XX_XX__,__XX____,
  ___XX___,_XX_XX__,__XX____,
  ___XX___,__XXX___,__XX____,
  ___XX___,__XXX___,__XX____,
  ___XX___,__XXX___,__XX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_004E[ 96] = { /* code 004E */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXX___,_______X,X_______,
  __XXX___,_______X,X_______,
  __XXXX__,_______X,X_______,
  __XXXX__,_______X,X_______,
  __XX_XX_,_______X,X_______,
  __XX__XX,_______X,X_______,
  __XX__XX,_______X,X_______,
  __XX___X,X______X,X_______,
  __XX____,XX_____X,X_______,
  __XX____,XX_____X,X_______,
  __XX____,_XX____X,X_______,
  __XX____,_XX____X,X_______,
  __XX____,__XX___X,X_______,
  __XX____,___XX__X,X_______,
  __XX____,___XX__X,X_______,
  __XX____,____XX_X,X_______,
  __XX____,_____XXX,X_______,
  __XX____,_____XXX,X_______,
  __XX____,______XX,X_______,
  __XX____,______XX,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_004F[ 96] = { /* code 004F */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,_____XXX,X_______,
  ___XXX__,_______X,XX______,
  __XXX___,________,XXX_____,
  __XX____,________,_XX_____,
  _XXX____,________,_XXX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XXX____,________,_XXX____,
  __XX____,________,_XX_____,
  __XXX___,________,XXX_____,
  ___XXX__,_______X,XX______,
  ____XXXX,_____XXX,X_______,
  _____XXX,XXXXXXXX,________,
  _______X,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0050[ 96] = { /* code 0050 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXX___,________,
  __XXXXXX,XXXXXX__,________,
  __XX____,____XXX_,________,
  __XX____,_____XXX,________,
  __XX____,______XX,________,
  __XX____,______XX,________,
  __XX____,______XX,________,
  __XX____,______XX,________,
  __XX____,_____XXX,________,
  __XX____,____XXX_,________,
  __XXXXXX,XXXXXX__,________,
  __XXXXXX,XXXX____,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  __XX____,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0051[ 96] = { /* code 0051 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXXXX__,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,_____XXX,X_______,
  ___XXX__,_______X,XX______,
  __XXX___,________,XXX_____,
  __XX____,________,_XX_____,
  __XX____,________,_XX_____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  _XX_____,________,__XX____,
  __XX____,________,_XXX____,
  __XX____,________,_XX_____,
  __XXX___,___XXX__,XXX_____,
  ___XXX__,___XXXXX,XX______,
  ____XXXX,_____XXX,XX______,
  _____XXX,XXXXXXXX,XXX_____,
  _______X,XXXXXX__,_XXX____,
  ________,________,__XX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0052[ 96] = { /* code 0052 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XXXXXX,XXXXXXX_,________,
  __XXXXXX,XXXXXXXX,________,
  __XX____,______XX,X_______,
  __XX____,_______X,XX______,
  __XX____,________,XX______,
  __XX____,________,XX______,
  __XX____,________,XX______,
  __XX____,_______X,XX______,
  __XX____,______XX,X_______,
  __XXXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXX__,________,
  __XX____,__XXX___,________,
  __XX____,___XX___,________,
  __XX____,____XX__,________,
  __XX____,____XXX_,________,
  __XX____,_____XXX,________,
  __XX____,______XX,________,
  __XX____,_______X,X_______,
  __XX____,_______X,XX______,
  __XX____,________,XX______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0053[ 96] = { /* code 0053 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXXX___,________,
  ____XXXX,XXXXXXX_,________,
  ___XXX__,____XXXX,________,
  __XXX___,______XX,________,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XXX___,________,________,
  ___XXX__,________,________,
  ___XXXXX,XXX_____,________,
  ____XXXX,XXXXXX__,________,
  ________,XXXXXXXX,________,
  ________,____XXXX,________,
  ________,______XX,X_______,
  _XX_____,_______X,X_______,
  _XX_____,_______X,X_______,
  _XXX____,_______X,X_______,
  __XXX___,______XX,________,
  ___XXX__,_____XXX,________,
  ____XXXX,XXXXXXX_,________,
  ______XX,XXXXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0054[ 64] = { /* code 0054 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXXXXX_,
  _XXXXXXX,XXXXXXX_,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  _______X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0055[ 96] = { /* code 0055 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XX____,_______X,X_______,
  __XXX___,______XX,X_______,
  ___XX___,______XX,________,
  ___XXXX_,____XXXX,________,
  ____XXXX,XXXXXXX_,________,
  ______XX,XXXXX___,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0056[ 96] = { /* code 0056 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XX______,_______X,X_______,
  XXX_____,______XX,X_______,
  _XX_____,______XX,________,
  _XX_____,______XX,________,
  _XXX____,_____XXX,________,
  __XX____,_____XX_,________,
  __XX____,_____XX_,________,
  ___XX___,____XX__,________,
  ___XX___,____XX__,________,
  ___XXX__,___XXX__,________,
  ____XX__,___XX___,________,
  ____XX__,___XX___,________,
  ____XXX_,__XXX___,________,
  _____XX_,__XX____,________,
  _____XX_,_XXX____,________,
  ______XX,_XX_____,________,
  ______XX,_XX_____,________,
  ______XX,XXX_____,________,
  _______X,XX______,________,
  _______X,XX______,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0057[128] = { /* code 0057 */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  XX______,____XXX_,________,_XX_____,
  XX______,____XXX_,________,_XX_____,
  _XX_____,___XX_XX,________,XX______,
  _XX_____,___XX_XX,________,XX______,
  _XX_____,___XX_XX,________,XX______,
  _XX_____,__XX___X,X_______,XX______,
  __XX____,__XX___X,X______X,X_______,
  __XX____,__XX___X,X______X,X_______,
  __XX____,_XX_____,XX_____X,X_______,
  __XXX___,_XX_____,XX____XX,X_______,
  ___XX___,_XX_____,XX____XX,________,
  ___XX___,XXX_____,_XX___XX,________,
  ___XX___,XX______,_XX___XX,________,
  ___XXX__,XX______,_XX__XX_,________,
  ____XX_X,XX______,_XXX_XX_,________,
  ____XX_X,X_______,__XX_XX_,________,
  ____XX_X,X_______,__XX_XX_,________,
  _____XXX,X_______,__XXXX__,________,
  _____XXX,________,___XXX__,________,
  _____XXX,________,___XXX__,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0058[ 96] = { /* code 0058 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXX____,_____XXX,________,
  __XXX___,____XXX_,________,
  ___XX___,____XX__,________,
  ___XXX__,___XXX__,________,
  ____XXX_,__XXX___,________,
  _____XXX,_XXX____,________,
  _____XXX,_XXX____,________,
  ______XX,_XX_____,________,
  _______X,XX______,________,
  _______X,XX______,________,
  _______X,XX______,________,
  ______XX,_XX_____,________,
  _____XXX,_XXX____,________,
  ____XXX_,__XXX___,________,
  ____XXX_,__XXX___,________,
  ___XXX__,___XXX__,________,
  __XXX___,____XXX_,________,
  __XXX___,_____XX_,________,
  _XXX____,_____XXX,________,
  XXX_____,______XX,X_______,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0059[ 96] = { /* code 0059 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XX_____,______XX,X_______,
  __XX____,_____XXX,________,
  ___XX___,_____XX_,________,
  ___XX___,____XXX_,________,
  ____XX__,____XX__,________,
  ____XXX_,___XXX__,________,
  _____XXX,__XXX___,________,
  ______XX,__XX____,________,
  ______XX,__XX____,________,
  _______X,XXX_____,________,
  _______X,XXX_____,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,XX______,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_005A[ 96] = { /* code 005A */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _XXXXXXX,XXXXXXXX,________,
  _XXXXXXX,XXXXXXXX,________,
  ________,_____XX_,________,
  ________,____XX__,________,
  ________,___XX___,________,
  ________,__XXX___,________,
  ________,_XXX____,________,
  ________,_XX_____,________,
  ________,XX______,________,
  _______X,XX______,________,
  ______XX,X_______,________,
  ______XX,________,________,
  _____XX_,________,________,
  ____XX__,________,________,
  ___XXX__,________,________,
  __XXX___,________,________,
  __XX____,________,________,
  _XX_____,________,________,
  XXXXXXXX,XXXXXXXX,________,
  XXXXXXXX,XXXXXXXX,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_005B[ 32] = { /* code 005B */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXXX_,
  __XXXXX_,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XXXXX_,
  __XXXXX_,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_005C[ 32] = { /* code 005C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  XX______,
  XX______,
  _XX_____,
  _XX_____,
  _XX_____,
  __XX____,
  __XX____,
  __XX____,
  __XXX___,
  ___XX___,
  ___XX___,
  ___XX___,
  ____XX__,
  ____XX__,
  ____XX__,
  _____XX_,
  _____XX_,
  _____XX_,
  _____XXX,
  ______XX,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_005D[ 32] = { /* code 005D */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXX__,
  _XXXXX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  ____XX__,
  _XXXXX__,
  _XXXXX__,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_005E[ 64] = { /* code 005E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  ____XXXX,________,
  ___XX__X,X_______,
  ___XX__X,X_______,
  ___XX__X,X_______,
  __XX____,XX______,
  __XX____,XX______,
  __XX____,XX______,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_005F[ 64] = { /* code 005F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXXXXXXX,XXXXXXX_,
  XXXXXXXX,XXXXXXX_,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0060[ 64] = { /* code 0060 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  __XXX___,________,
  ___XX___,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0061[ 64] = { /* code 0061 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,XXX_____,
  __XXXXXX,XXXX____,
  __XX____,__XXX___,
  _XX_____,___XX___,
  ________,___XX___,
  ________,XXXXX___,
  ____XXXX,XXXXX___,
  __XXXXXX,X__XX___,
  __XX____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,__XXX___,
  _XXX____,XXXXX___,
  __XXXXXX,XX_XX___,
  ___XXXXX,X___XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0062[ 64] = { /* code 0062 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX__XX,XX______,
  __XX_XXX,XXXX____,
  __XXXX__,__XXX___,
  __XXX___,___XX___,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,___XXX__,
  __XXX___,___XX___,
  __XXXX__,__XXX___,
  __XXXXXX,XXXX____,
  __XX__XX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0063[ 64] = { /* code 0063 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XXX___,
  _XX_____,___XX___,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,___XX___,
  _XX_____,___XX___,
  __XX____,__XX____,
  __XXX___,_XXX____,
  ___XXXXX,XXX_____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0064[ 64] = { /* code 0064 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  _____XXX,X__XX___,
  ___XXXXX,XX_XX___,
  __XXX___,_XXXX___,
  __XX____,__XXX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XXX____,___XX___,
  __XX____,__XXX___,
  __XXX___,_XXXX___,
  ___XXXXX,XXXXX___,
  _____XXX,X__XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0065[ 64] = { /* code 0065 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXX___,__XXX___,
  __XX____,___XX___,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XXXXXXX,XXXXXX__,
  _XXXXXXX,XXXXXX__,
  _XX_____,________,
  _XX_____,________,
  _XXX____,________,
  __XX____,____XX__,
  __XXXX__,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0066[ 32] = { /* code 0066 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XXXX_,
  __XXXXX_,
  __XX____,
  __XX____,
  __XX____,
  XXXXXXX_,
  XXXXXXX_,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0067[ 64] = { /* code 0067 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X__XX___,
  ___XXXXX,XX_XX___,
  __XXX___,_XXXX___,
  __XX____,__XXX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  __XX____,__XXX___,
  __XXX___,_XXXX___,
  ___XXXXX,XX_XX___,
  _____XXX,X__XX___,
  _XX_____,___XX___,
  _XX_____,__XXX___,
  _XXX____,_XXX____,
  __XXXXXX,XXX_____,
  ____XXXX,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0068[ 64] = { /* code 0068 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX__XX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXX__,__XXX___,
  __XXX___,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0069[ 32] = { /* code 0069 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_006A[ 32] = { /* code 006A */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  XXX_____,
  XXX_____,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_006B[ 64] = { /* code 006B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,___XXX__,
  __XX____,__XXX___,
  __XX____,_XXX____,
  __XX____,XXX_____,
  __XX___X,XX______,
  __XX_XXX,X_______,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  __XXX__X,XX______,
  __XX____,XXX_____,
  __XX____,XXX_____,
  __XX____,_XXX____,
  __XX____,__XX____,
  __XX____,__XXX___,
  __XX____,___XXX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_006C[ 32] = { /* code 006C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_006D[ 96] = { /* code 006D */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  __XX__XX,XX____XX,XX______,
  __XX_XXX,XXX_XXXX,XXX_____,
  __XXXX__,_XXXXX__,_XXX____,
  __XXX___,__XXX___,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  __XX____,__XX____,__XX____,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_006E[ 64] = { /* code 006E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX__XX,XXX_____,
  __XXXXXX,XXXX____,
  __XXXX__,__XXX___,
  __XXX___,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_006F[ 64] = { /* code 006F */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXXX____,
  __XXX___,__XXX___,
  __XX____,___XX___,
  _XXX____,___XXX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XX_____,____XX__,
  _XXX____,___XXX__,
  __XX____,___XX___,
  __XXX___,__XXX___,
  ___XXXXX,XXXX____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0070[ 64] = { /* code 0070 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX__XX,XX______,
  __XX_XXX,XXXX____,
  __XXXX__,__XXX___,
  __XXX___,___XX___,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XX____,____XX__,
  __XXX___,___XX___,
  __XXXX__,__XXX___,
  __XX_XXX,XXXX____,
  __XX__XX,XX______,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0071[ 64] = { /* code 0071 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X__XX___,
  ___XXXXX,XX_XX___,
  __XXX___,_XXXX___,
  __XX____,__XXX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XX_____,___XX___,
  _XXX____,___XX___,
  __XX____,__XXX___,
  __XXX___,_XXXX___,
  ___XXXXX,XX_XX___,
  _____XXX,X__XX___,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,___XX___,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0072[ 64] = { /* code 0072 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX_XXX,X_______,
  __XXXXXX,X_______,
  __XXX___,________,
  __XXX___,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  __XX____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0073[ 64] = { /* code 0073 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XXX_____,
  _XXX____,_XXX____,
  _XX_____,__XX____,
  _XX_____,________,
  _XXXX___,________,
  __XXXXXX,X_______,
  ___XXXXX,XXXX____,
  ______XX,XXXX____,
  ________,__XXX___,
  _XX_____,___XX___,
  _XXX____,___XX___,
  __XXX___,__XX____,
  ___XXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0074[ 32] = { /* code 0074 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___X____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  XXXXXXX_,
  XXXXXXX_,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XXXXX_,
  ___XXXX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0075[ 64] = { /* code 0075 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,___XX___,
  __XX____,__XXX___,
  __XXX___,_XXXX___,
  ___XXXXX,XX_XX___,
  ____XXXX,X__XX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0076[ 64] = { /* code 0076 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX______,___XX___,
  XX______,___XX___,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XXX____,_XXX____,
  __XX____,_XX_____,
  __XXX___,_XX_____,
  ___XX___,XX______,
  ___XX___,XX______,
  ___XXX_X,X_______,
  ____XX_X,X_______,
  ____XX_X,X_______,
  _____XXX,________,
  _____XXX,________,
  ______X_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0077[ 96] = { /* code 0077 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  XX______,_X______,_XX_____,
  XX______,XXX_____,_XX_____,
  XX______,XXX_____,_XX_____,
  _XX_____,X_X_____,XX______,
  _XX____X,X_XX____,XX______,
  _XX____X,X_XX___X,XX______,
  __XX___X,X_XX___X,X_______,
  __XX___X,___X___X,X_______,
  __XX__XX,___XX_XX,X_______,
  ___XX_XX,___XX_XX,________,
  ___XX_XX,___XX_XX,________,
  ____X_X_,____X_X_,________,
  ____XXX_,____XXX_,________,
  ____XXX_,____XXX_,________,
  _____X__,_____X__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0078[ 64] = { /* code 0078 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,__XX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXX___,XX______,
  ___XX__X,X_______,
  ____XXXX,X_______,
  ____XXXX,________,
  _____XX_,________,
  ____XXXX,________,
  ____XXXX,________,
  ___XX__X,X_______,
  __XXX__X,XX______,
  __XX____,XX______,
  _XX_____,_XX_____,
  XXX_____,_XXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_0079[ 64] = { /* code 0079 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX_____,___XX___,
  _XX_____,___XX___,
  __XX____,__XX____,
  __XX____,__XX____,
  __XXX___,__XX____,
  ___XX___,_XX_____,
  ___XX___,_XX_____,
  ____XX__,_XX_____,
  ____XX__,XX______,
  ____XX__,XX______,
  _____XX_,XX______,
  _____XXX,X_______,
  _____XXX,X_______,
  ______XX,X_______,
  ______XX,________,
  ______XX,________,
  _____XX_,________,
  _____XX_,________,
  __XXXX__,________,
  __XXX___,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_007A[ 64] = { /* code 007A */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  ________,_XXX____,
  ________,XXX_____,
  _______X,XX______,
  ______XX,X_______,
  _____XXX,________,
  _____XXX,________,
  ____XXX_,________,
  ___XXX__,________,
  __XXX___,________,
  _XXX____,________,
  XXX_____,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_007B[ 64] = { /* code 007B */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ______XX,X_______,
  _____XXX,X_______,
  ____XXX_,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ___XX___,________,
  _XXX____,________,
  _XXX____,________,
  ___XX___,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  _____XXX,X_______,
  ______XX,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_007C[ 32] = { /* code 007C */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  __XX____,
  ________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_007D[ 64] = { /* code 007D */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XXX_____,________,
  XXXX____,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ____XX__,________,
  _____XXX,________,
  _____XXX,________,
  ____XX__,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  XXXX____,________,
  XXX_____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFont32_ASCII_007E[ 64] = { /* code 007E */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,________,
  _XXXXXXX,XX___XX_,
  _XX____X,XXXXXXX_,
  _X______,_XXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE GUI_CHARINFO GUI_Font32_ASCII_CharInfo[95] = {
   {   8,   8,  1, acFont32_ASCII_0020 } /* code 0020 */
  ,{   8,   8,  1, acFont32_ASCII_0021 } /* code 0021 */
  ,{  10,  10,  2, acFont32_ASCII_0022 } /* code 0022 */
  ,{  15,  15,  2, acFont32_ASCII_0023 } /* code 0023 */
  ,{  15,  15,  2, acFont32_ASCII_0024 } /* code 0024 */
  ,{  24,  24,  3, acFont32_ASCII_0025 } /* code 0025 */
  ,{  18,  18,  3, acFont32_ASCII_0026 } /* code 0026 */
  ,{   5,   5,  1, acFont32_ASCII_0027 } /* code 0027 */
  ,{   9,   9,  2, acFont32_ASCII_0028 } /* code 0028 */
  ,{   9,   9,  2, acFont32_ASCII_0029 } /* code 0029 */
  ,{  11,  11,  2, acFont32_ASCII_002A } /* code 002A */
  ,{  16,  16,  2, acFont32_ASCII_002B } /* code 002B */
  ,{   8,   8,  1, acFont32_ASCII_002C } /* code 002C */
  ,{   9,   9,  2, acFont32_ASCII_002D } /* code 002D */
  ,{   8,   8,  1, acFont32_ASCII_002E } /* code 002E */
  ,{   8,   8,  1, acFont32_ASCII_002F } /* code 002F */
  ,{  15,  15,  2, acFont32_ASCII_0030 } /* code 0030 */
  ,{  15,  15,  2, acFont32_ASCII_0031 } /* code 0031 */
  ,{  15,  15,  2, acFont32_ASCII_0032 } /* code 0032 */
  ,{  15,  15,  2, acFont32_ASCII_0033 } /* code 0033 */
  ,{  15,  15,  2, acFont32_ASCII_0034 } /* code 0034 */
  ,{  15,  15,  2, acFont32_ASCII_0035 } /* code 0035 */
  ,{  15,  15,  2, acFont32_ASCII_0036 } /* code 0036 */
  ,{  15,  15,  2, acFont32_ASCII_0037 } /* code 0037 */
  ,{  15,  15,  2, acFont32_ASCII_0038 } /* code 0038 */
  ,{  15,  15,  2, acFont32_ASCII_0039 } /* code 0039 */
  ,{   8,   8,  1, acFont32_ASCII_003A } /* code 003A */
  ,{   8,   8,  1, acFont32_ASCII_003B } /* code 003B */
  ,{  16,  16,  2, acFont32_ASCII_003C } /* code 003C */
  ,{  16,  16,  2, acFont32_ASCII_003D } /* code 003D */
  ,{  16,  16,  2, acFont32_ASCII_003E } /* code 003E */
  ,{  15,  15,  2, acFont32_ASCII_003F } /* code 003F */
  ,{  27,  27,  4, acFont32_ASCII_0040 } /* code 0040 */
  ,{  18,  18,  3, acFont32_ASCII_0041 } /* code 0041 */
  ,{  18,  18,  3, acFont32_ASCII_0042 } /* code 0042 */
  ,{  20,  20,  3, acFont32_ASCII_0043 } /* code 0043 */
  ,{  20,  20,  3, acFont32_ASCII_0044 } /* code 0044 */
  ,{  18,  18,  3, acFont32_ASCII_0045 } /* code 0045 */
  ,{  17,  17,  3, acFont32_ASCII_0046 } /* code 0046 */
  ,{  21,  21,  3, acFont32_ASCII_0047 } /* code 0047 */
  ,{  19,  19,  3, acFont32_ASCII_0048 } /* code 0048 */
  ,{   8,   8,  1, acFont32_ASCII_0049 } /* code 0049 */
  ,{  13,  13,  2, acFont32_ASCII_004A } /* code 004A */
  ,{  18,  18,  3, acFont32_ASCII_004B } /* code 004B */
  ,{  15,  15,  2, acFont32_ASCII_004C } /* code 004C */
  ,{  23,  23,  3, acFont32_ASCII_004D } /* code 004D */
  ,{  19,  19,  3, acFont32_ASCII_004E } /* code 004E */
  ,{  21,  21,  3, acFont32_ASCII_004F } /* code 004F */
  ,{  17,  17,  3, acFont32_ASCII_0050 } /* code 0050 */
  ,{  21,  21,  3, acFont32_ASCII_0051 } /* code 0051 */
  ,{  20,  20,  3, acFont32_ASCII_0052 } /* code 0052 */
  ,{  18,  18,  3, acFont32_ASCII_0053 } /* code 0053 */
  ,{  16,  16,  2, acFont32_ASCII_0054 } /* code 0054 */
  ,{  19,  19,  3, acFont32_ASCII_0055 } /* code 0055 */
  ,{  17,  17,  3, acFont32_ASCII_0056 } /* code 0056 */
  ,{  28,  28,  4, acFont32_ASCII_0057 } /* code 0057 */
  ,{  17,  17,  3, acFont32_ASCII_0058 } /* code 0058 */
  ,{  18,  18,  3, acFont32_ASCII_0059 } /* code 0059 */
  ,{  17,  17,  3, acFont32_ASCII_005A } /* code 005A */
  ,{   8,   8,  1, acFont32_ASCII_005B } /* code 005B */
  ,{   8,   8,  1, acFont32_ASCII_005C } /* code 005C */
  ,{   8,   8,  1, acFont32_ASCII_005D } /* code 005D */
  ,{  12,  12,  2, acFont32_ASCII_005E } /* code 005E */
  ,{  15,  15,  2, acFont32_ASCII_005F } /* code 005F */
  ,{   9,   9,  2, acFont32_ASCII_0060 } /* code 0060 */
  ,{  15,  15,  2, acFont32_ASCII_0061 } /* code 0061 */
  ,{  15,  15,  2, acFont32_ASCII_0062 } /* code 0062 */
  ,{  14,  14,  2, acFont32_ASCII_0063 } /* code 0063 */
  ,{  15,  15,  2, acFont32_ASCII_0064 } /* code 0064 */
  ,{  15,  15,  2, acFont32_ASCII_0065 } /* code 0065 */
  ,{   7,   7,  1, acFont32_ASCII_0066 } /* code 0066 */
  ,{  15,  15,  2, acFont32_ASCII_0067 } /* code 0067 */
  ,{  15,  15,  2, acFont32_ASCII_0068 } /* code 0068 */
  ,{   6,   6,  1, acFont32_ASCII_0069 } /* code 0069 */
  ,{   6,   6,  1, acFont32_ASCII_006A } /* code 006A */
  ,{  14,  14,  2, acFont32_ASCII_006B } /* code 006B */
  ,{   6,   6,  1, acFont32_ASCII_006C } /* code 006C */
  ,{  22,  22,  3, acFont32_ASCII_006D } /* code 006D */
  ,{  15,  15,  2, acFont32_ASCII_006E } /* code 006E */
  ,{  15,  15,  2, acFont32_ASCII_006F } /* code 006F */
  ,{  15,  15,  2, acFont32_ASCII_0070 } /* code 0070 */
  ,{  15,  15,  2, acFont32_ASCII_0071 } /* code 0071 */
  ,{   9,   9,  2, acFont32_ASCII_0072 } /* code 0072 */
  ,{  14,  14,  2, acFont32_ASCII_0073 } /* code 0073 */
  ,{   8,   8,  1, acFont32_ASCII_0074 } /* code 0074 */
  ,{  15,  15,  2, acFont32_ASCII_0075 } /* code 0075 */
  ,{  13,  13,  2, acFont32_ASCII_0076 } /* code 0076 */
  ,{  19,  19,  3, acFont32_ASCII_0077 } /* code 0077 */
  ,{  12,  12,  2, acFont32_ASCII_0078 } /* code 0078 */
  ,{  14,  14,  2, acFont32_ASCII_0079 } /* code 0079 */
  ,{  13,  13,  2, acFont32_ASCII_007A } /* code 007A */
  ,{   9,   9,  2, acFont32_ASCII_007B } /* code 007B */
  ,{   6,   6,  1, acFont32_ASCII_007C } /* code 007C */
  ,{   9,   9,  2, acFont32_ASCII_007D } /* code 007D */
  ,{  16,  16,  2, acFont32_ASCII_007E } /* code 007E */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_Font32_ASCII_Prop1 = {
   0x0020                         /* first character */
  ,0x007E                         /* last character  */
  ,&GUI_Font32_ASCII_CharInfo[0]  /* address of first character */
  ,(const GUI_FONT_PROP*)0        /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font32_ASCII = {
   GUI_FONTTYPE_PROP        /* type of font    */
  ,32                       /* height of font  */
  ,32                       /* space of font y */
  ,1                        /* magnification x */
  ,1                        /* magnification y */
  ,{&GUI_Font32_ASCII_Prop1}
  ,26, 15, 20
};

