/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : FComic18.C
Purpose     : Font, similar to Comic
Height      : 18
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"


GUI_CONST_STORAGE unsigned char acFontComic18B_1_160[18] = { /* code 160 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_161[18] = { /* code 161 */
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_162[36] = { /* code 162 */
  ________,________,
  ____XX__,________,
  ____XX__,________,
  ___XXXX_,X_______,
  __XXXXXX,X_______,
  _XX_XX_X,X_______,
  XX__XX__,________,
  XX__XX__,________,
  XX__XX__,________,
  XX__XX__,X_______,
  XXX_XX_X,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ____XX__,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_163[36] = { /* code 163 */
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  ___XX___,_XX_____,
  __XXX___,________,
  __XX____,________,
  __XX____,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  ___X____,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,___X____,
  __XXXXX_,__XX____,
  __XXXXXX,XXXX____,
  _______X,XXX_____,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_164[36] = { /* code 164 */
  ________,________,
  ________,________,
  ________,________,
  XX______,________,
  XXX_____,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,X_______,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXX_,________,
  XXXXXXXX,________,
  XX_____X,X_______,
  _______X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_165[36] = { /* code 165 */
  ________,________,
  ________,________,
  ________,________,
  _XX____X,X_______,
  _XX____X,X_______,
  __XX__XX,________,
  _XXX__XX,X_______,
  _XXX__XX,X_______,
  ___XXXX_,________,
  ____XX__,________,
  __XXXXXX,________,
  __XXXXXX,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_166[18] = { /* code 166 */
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_167[36] = { /* code 167 */
  ________,________,
  ________,________,
  ________,________,
  __XXXXX_,________,
  _XXXXXXX,________,
  _XX___XX,________,
  _XX_____,________,
  XXXXXX__,________,
  XX___XXX,________,
  _XXX__XX,________,
  ___XXXX_,________,
  X_____XX,________,
  XX____XX,________,
  _XXXXXXX,________,
  __XXXXX_,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_168[36] = { /* code 168 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XX__XX_,________,
  _XX__XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_169[36] = { /* code 169 */
  ________,________,
  ________,________,
  _____XXX,X_______,
  ___XXXXX,XXX_____,
  __XXX___,_XX_____,
  __XX__XX,__XX____,
  _XX__XXX,__XX____,
  _XX_XX__,__XX____,
  _XX_XX__,X_XX____,
  _XX_XXXX,X_XX____,
  _XX__XXX,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_170[18] = { /* code 170 */
  ________,
  ________,
  ________,
  __XXXX__,
  _XXXXX__,
  _XX_XX__,
  _XX_XX__,
  _XXX_XX_,
  _XXX_XX_,
  __X__XX_,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_171[36] = { /* code 171 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XX__X,X_______,
  __XX__XX,________,
  _XX__XX_,________,
  XX__XX__,________,
  _XX__XX_,________,
  __XX__XX,________,
  ___XX__X,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_172[36] = { /* code 172 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  ______XX,________,
  ______XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_173[18] = { /* code 173 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XXXXX__,
  _XXXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_174[36] = { /* code 174 */
  ________,________,
  ________,________,
  ____XXXX,X_______,
  ___XXXXX,XX______,
  __XXX___,_XX_____,
  __XXXXXX,_XXX____,
  _XX_X__X,__XX____,
  _XX_X__X,__XX____,
  _XX_XXX_,__XX____,
  _XX_XXX_,__XX____,
  _XX_XX_X,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_175[36] = { /* code 175 */
  ________,________,
  XXXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_176[18] = { /* code 176 */
  ________,
  _XXXX___,
  XXXXXX__,
  XX__XX__,
  XX__XX__,
  XXXXXX__,
  _XXXX___,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_177[18] = { /* code 177 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ___XX___,
  ___XX___,
  ___XX___,
  XXXXXXXX,
  XXXXXXXX,
  ___XX___,
  ___XX___,
  ___XX___,
  ________,
  XXXXXXXX,
  XXXXXXXX,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_178[36] = { /* code 178 */
  ________,________,
  ____XX__,________,
  ___XXXX_,________,
  _____XX_,________,
  _____X__,________,
  ____X___,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_179[36] = { /* code 179 */
  ________,________,
  __XXXX__,________,
  __XXXXX_,________,
  _____XX_,________,
  ____XX__,________,
  _____XX_,________,
  __XXXXX_,________,
  __XXXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_180[18] = { /* code 180 */
  ________,
  ________,
  ___XX___,
  __XX____,
  _XX_____,
  _X______,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_181[18] = { /* code 181 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX___XX,
  _XX___XX,
  XX____X_,
  XX___XX_,
  XX___XX_,
  XX___X__,
  XXXXXX__,
  XXXXXX__,
  X_______,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_182[36] = { /* code 182 */
  ________,________,
  ________,________,
  ________,________,
  ______XX,XX______,
  ___XXXXX,XX______,
  __XX_XX_,XX______,
  _XX__XX_,XX______,
  _XX__XX_,XX______,
  _XX__XX_,XX______,
  _XX_XXX_,XX______,
  _XXXXXXX,X_______,
  __XXXX_X,X_______,
  ____XX_X,X_______,
  ____XX_X,X_______,
  ___XX_XX,________,
  ___XX_XX,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_183[18] = { /* code 183 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_184[36] = { /* code 184 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XX___,________,
  ____XX__,________,
  ____XX__,________,
  __XXXX__,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_185[36] = { /* code 185 */
  ________,________,
  _____XX_,________,
  ____XXX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ____XXXX,________,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_186[18] = { /* code 186 */
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  _XX__XX_,
  _XX__XX_,
  __XXXXX_,
  __XXXX__,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_187[36] = { /* code 187 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  X__XX___,________,
  XX__XX__,________,
  _XX__XX_,________,
  __XX__XX,________,
  _XX__XX_,________,
  XX__XX__,________,
  X__XX___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_188[36] = { /* code 188 */
  ____XX__,________,
  ___XXX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  ________,________,
  ____XX__,________,
  ____XX__,________,
  ___XXX__,________,
  __X_XX__,________,
  _XXXXXX_,________,
  ____XX__,________,
  ____XX__,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_189[36] = { /* code 189 */
  ____XX__,________,
  ___XXX__,________,
  ____XX__,________,
  ____XX__,________,
  ____XX__,________,
  ___XXXX_,________,
  ___XXXX_,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  ________,________,
  ____XXX_,________,
  ___XXXXX,________,
  ___X__XX,________,
  ______X_,________,
  ____XX__,________,
  ___XXXXX,________,
  ___XXXXX,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_190[36] = { /* code 190 */
  __XXXX__,________,
  __XXXXX_,________,
  _____XX_,________,
  ___XXXX_,________,
  _____XX_,________,
  __XXXXX_,________,
  __XXXX__,________,
  ________,________,
  _XXXXXXX,X_______,
  _XXXXXXX,X_______,
  ________,________,
  ____XX__,________,
  ____XX__,________,
  ___XXX__,________,
  __X_XX__,________,
  _XXXXXX_,________,
  ____XX__,________,
  ____XX__,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_191[36] = { /* code 191 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  _____X__,________,
  ___XXX__,________,
  __XX____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXX__XX,________,
  __XXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_192[36] = { /* code 192 */
  ______XX,________,
  _______X,________,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_193[36] = { /* code 193 */
  ______XX,________,
  ______X_,________,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_194[36] = { /* code 194 */
  ______XX,XX______,
  _____XX_,_XX_____,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_195[36] = { /* code 195 */
  ____XXXX,XXX_____,
  ____X__X,XX______,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_196[36] = { /* code 196 */
  ____XX__,XX______,
  ____XX__,XX______,
  ________,________,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_197[36] = { /* code 197 */
  ______X_,__X_____,
  ______X_,__X_____,
  _______X,XX______,
  _______X,X_______,
  _______X,X_______,
  ______XX,X_______,
  _____XX_,XX______,
  _____XX_,XX______,
  ____XX__,XX______,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  __XX____,XXX_____,
  __XX____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_198[54] = { /* code 198 */
  ________,________,________,
  ________,________,________,
  ________,__XXXXXX,XX______,
  ________,_XXXXXXX,XX______,
  ________,XXXX____,________,
  _______X,X_XX____,________,
  ______XX,__XX____,________,
  ______XX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,X_______,
  ____XX__,__XX____,________,
  ___XX___,__XX____,________,
  ___XX___,__XX____,________,
  __XX____,__XX____,________,
  _XX_____,__XX____,________,
  _XX_____,__XXXXXX,X_______,
  ________,___XXXXX,X_______,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_199[36] = { /* code 199 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  ___XXXXX,X_______,
  __XXX__X,X_______,
  __XX____,________,
  _XX_____,________,
  _XX_____,________,
  XX______,________,
  XX______,________,
  XX______,________,
  XXX____X,X_______,
  _XXXXXXX,X_______,
  __XXXXX_,________,
  ____XX__,________,
  _____X__,________,
  __XXX___,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_200[36] = { /* code 200 */
  _____XX_,________,
  ______X_,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_201[36] = { /* code 201 */
  ____X___,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_202[36] = { /* code 202 */
  ___XXXX_,________,
  __XX__XX,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_203[36] = { /* code 203 */
  __XX__XX,________,
  __XX__XX,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XXXXXXX,________,
  __XXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_204[36] = { /* code 204 */
  ___XX___,________,
  ____X___,________,
  ________,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_205[36] = { /* code 205 */
  ___XX___,________,
  ___X____,________,
  ________,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_206[36] = { /* code 206 */
  _XX__XX_,________,
  ________,________,
  ________,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_207[36] = { /* code 207 */
  _XX__XX_,________,
  _XX__XX_,________,
  ________,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  ___XX___,________,
  XXXXXXXX,________,
  XXXXXXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_208[36] = { /* code 208 */
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  __XXXXX_,________,
  __XX_XXX,X_______,
  __XX___X,XX______,
  __XX____,_XX_____,
  XXXXXXX_,_XXX____,
  XXXXXXX_,__XX____,
  __XX____,__XX____,
  __XX____,__XX____,
  __XX____,_XXX____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_209[36] = { /* code 209 */
  ___XXXXX,XX______,
  ___X__XX,X_______,
  ________,________,
  _XX_____,__X_____,
  _XX_____,__XX____,
  _XXX____,__XX____,
  _XXXX___,__XX____,
  _XX_XX__,__XX____,
  _XX__XX_,__XX____,
  _XX___X_,__XX____,
  _XX___XX,__XX____,
  _XX____X,X_XX____,
  _XX_____,XXXX____,
  _XX_____,_XXX____,
  _XX_____,__XX____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_210[36] = { /* code 210 */
  _______X,X_______,
  ________,X_______,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,_XXX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_211[36] = { /* code 211 */
  ______XX,________,
  ______X_,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,_XXX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_212[36] = { /* code 212 */
  ____XX__,XX______,
  ________,________,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,_XXX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_213[36] = { /* code 213 */
  ____XXXX,XXX_____,
  ____X__X,XX______,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,_XXX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_214[36] = { /* code 214 */
  ____XX__,XX______,
  ____XX__,XX______,
  ________,________,
  _____XXX,XX______,
  ___XXXXX,XXX_____,
  __XXX___,_XXX____,
  __XX____,__XX____,
  _XXX____,__XX____,
  _XX_____,__XX____,
  _XX_____,__XX____,
  _XX_____,_XXX____,
  _XX_____,_XX_____,
  __XX____,XXX_____,
  __XXXXXX,XX______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_215[18] = { /* code 215 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  _XX__XX_,
  __XXXXX_,
  ___XX___,
  ___XXX__,
  __XX_XX_,
  __X___X_,
  ________,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_216[36] = { /* code 216 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,XX__X___,
  ____XXXX,XXXX____,
  ___XX___,_XX_____,
  __XX____,XXXX____,
  __XX___X,X_XX____,
  _XX____X,__XX____,
  _XX___X_,__XX____,
  _XX__X__,_XXX____,
  _XX_X___,_XX_____,
  _XXXX___,XXX_____,
  __XXXXXX,XX______,
  _XXXXXXX,X_______,
  _X______,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_217[36] = { /* code 217 */
  _____XX_,________,
  ______X_,________,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XX___X,XX______,
  __XXXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_218[36] = { /* code 218 */
  _____XX_,________,
  _____X__,________,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XX___X,XX______,
  __XXXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_219[36] = { /* code 219 */
  ___XX__X,X_______,
  ________,________,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XX___X,XX______,
  __XXXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_220[36] = { /* code 220 */
  ___XX__X,X_______,
  ___XX__X,X_______,
  ________,________,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XX_____,_XX_____,
  _XXX____,XX______,
  __XX___X,XX______,
  __XXXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_221[36] = { /* code 221 */
  ____XX__,________,
  ____X___,________,
  ________,________,
  _XX_____,XX______,
  _XX_____,XX______,
  __XX___X,XX______,
  __XX___X,X_______,
  ___XX_XX,X_______,
  ___XX_XX,________,
  ____XXXX,________,
  ____XXXX,________,
  _____XX_,________,
  ____XXX_,________,
  ____XX__,________,
  ___XX___,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_222[18] = { /* code 222 */
  ________,
  ________,
  ________,
  _XX_____,
  _XXXXXX_,
  _XXXXXXX,
  _XX___XX,
  _XX____X,
  _XX____X,
  _XX___XX,
  _XXXXXXX,
  _XXXXXX_,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_223[18] = { /* code 223 */
  ________,
  ________,
  ___XXX__,
  __XXXXX_,
  _XXX_XX_,
  _XX__XX_,
  _XX__XX_,
  _XX_XXX_,
  _XX_XX__,
  _XX_XXX_,
  _XX__XX_,
  _XX__XX_,
  _XXX_XX_,
  _XXXXXX_,
  _XX_XX__,
  _XX_____,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_224[18] = { /* code 224 */
  ________,
  ________,
  __X_____,
  __XX____,
  ___XX___,
  ____X___,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_225[18] = { /* code 225 */
  ________,
  ________,
  _____XX_,
  ____XX__,
  ___XX___,
  ___X____,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_226[18] = { /* code 226 */
  ________,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_227[18] = { /* code 227 */
  ________,
  ________,
  ________,
  __XXX__X,
  _XXXXXXX,
  _X__XXX_,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_228[18] = { /* code 228 */
  ________,
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_229[18] = { /* code 229 */
  ________,
  ___XXX__,
  __X___X_,
  __X___X_,
  ___XXX__,
  ________,
  ________,
  __XXXXX_,
  _XXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXX_XX,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_230[36] = { /* code 230 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,_XXX____,
  __XXXXXX,XXXXX___,
  _XXX___X,X_XXX___,
  _XX____X,XXXX____,
  _XX____X,XX______,
  _XXX___X,X____X__,
  __XXXXXX,XXXXXX__,
  ___XXXX_,XXXXX___,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_231[18] = { /* code 231 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXXX__,
  _XXXXXX_,
  _XX___X_,
  XX______,
  XX______,
  XX___XX_,
  XXXXXXX_,
  _XXXXX__,
  ___XX___,
  ____X___,
  _XXXX___};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_232[18] = { /* code 232 */
  ________,
  ________,
  __X_____,
  __XX____,
  ___XX___,
  ____X___,
  ________,
  __XXXX__,
  _XXXXXX_,
  XXX__XX_,
  XX__XX__,
  XX_XX___,
  XXX___X_,
  XXXXXXX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_233[18] = { /* code 233 */
  ________,
  ________,
  _____XX_,
  ____XX__,
  ___XX___,
  ___X____,
  ________,
  __XXXX__,
  _XXXXXX_,
  XXX__XX_,
  XX__XX__,
  XX_XX___,
  XXX___X_,
  XXXXXXX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_234[18] = { /* code 234 */
  ________,
  ________,
  ________,
  ___XX___,
  __XXXX__,
  _XX__XX_,
  ________,
  __XXXX__,
  _XXXXXX_,
  XXX__XX_,
  XX__XX__,
  XX_XX___,
  XXX___X_,
  XXXXXXX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_235[18] = { /* code 235 */
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  __XXXX__,
  _XXXXXX_,
  XXX__XX_,
  XX__XX__,
  XX_XX___,
  XXX___X_,
  XXXXXXX_,
  __XXXX__,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_236[18] = { /* code 236 */
  ________,
  ________,
  X_______,
  XX______,
  _XX_____,
  __X_____,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_237[18] = { /* code 237 */
  ________,
  ________,
  __XX____,
  _XX_____,
  XX______,
  X_______,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_238[18] = { /* code 238 */
  ________,
  ________,
  ________,
  _XX_____,
  XXXX____,
  X__XX___,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_239[18] = { /* code 239 */
  ________,
  ________,
  ________,
  ________,
  X__XX___,
  X__XX___,
  ________,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  _XX_____,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_240[18] = { /* code 240 */
  ________,
  ________,
  _XX_____,
  _XX_____,
  __XXXXX_,
  __XXX___,
  _XXXXX__,
  _XX_XX__,
  ____XXX_,
  __XXXXX_,
  _XX__XX_,
  XX___XX_,
  XX___XX_,
  XXXXXX__,
  _XXXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_241[18] = { /* code 241 */
  ________,
  ________,
  ________,
  __XXX__X,
  _XXXXXXX,
  _X__XXX_,
  ________,
  XX_XXX__,
  XXXXXXX_,
  XXX__XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_242[18] = { /* code 242 */
  ________,
  ________,
  ___X____,
  ___XX___,
  ____XX__,
  _____X__,
  ________,
  __XXX___,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_243[18] = { /* code 243 */
  ________,
  ________,
  _____XX_,
  ____XX__,
  ___XX___,
  ___X____,
  ________,
  __XXX___,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_244[18] = { /* code 244 */
  ________,
  ________,
  ________,
  __XX____,
  _XXXX___,
  XX__XX__,
  ________,
  __XXX___,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_245[18] = { /* code 245 */
  ________,
  ________,
  ________,
  _XXX__X_,
  XXXXXXX_,
  X__XXX__,
  ________,
  __XXX___,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_246[18] = { /* code 246 */
  ________,
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  __XXX___,
  _XXXXX__,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  _XXXXX__,
  __XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_247[36] = { /* code 247 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____X___,________,
  ____X___,________,
  ________,________,
  ________,________,
  _XXXXXXX,________,
  _XXXXXXX,________,
  ________,________,
  ____X___,________,
  ____X___,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_248[18] = { /* code 248 */
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  ________,
  __XXX_X_,
  _XXXXXX_,
  XXX__XX_,
  XX_XXXX_,
  XXX__XX_,
  XX__XXX_,
  XXXXXX__,
  X_XXX___,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_249[18] = { /* code 249 */
  ________,
  ________,
  __X_____,
  __XX____,
  ___XX___,
  ____X___,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_250[18] = { /* code 250 */
  ________,
  ________,
  _____XX_,
  ____XX__,
  ___XX___,
  ___X____,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_251[18] = { /* code 251 */
  ________,
  ________,
  ________,
  __XX____,
  _XXXX___,
  XX__XX__,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_252[18] = { /* code 252 */
  ________,
  ________,
  ________,
  _XX__XX_,
  _XX__XX_,
  ________,
  ________,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XX___XX_,
  XXXXXXX_,
  _XXXXXX_,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_253[36] = { /* code 253 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XX__,________,
  ___XX___,________,
  ___X____,________,
  ________,________,
  XX____XX,________,
  XXX___XX,________,
  _XX___XX,________,
  _XXX_XX_,________,
  __XX_XX_,________,
  __XXXX__,________,
  ___XXX__,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  __XX____,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_254[36] = { /* code 254 */
  ________,________,
  ________,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________,
  _XX_XXX_,________,
  _XXXXXXX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XX___XX,________,
  _XXXXXX_,________,
  _XXXXX__,________,
  _XX_____,________,
  _XX_____,________,
  _XX_____,________};

GUI_CONST_STORAGE unsigned char acFontComic18B_1_255[36] = { /* code 255 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX__XX__,________,
  XX__XX__,________,
  ________,________,
  XX____XX,________,
  XXX___XX,________,
  _XX___XX,________,
  _XXX_XX_,________,
  __XX_XX_,________,
  __XXXX__,________,
  ___XXX__,________,
  ___XX___,________,
  ___XX___,________,
  __XX____,________,
  __XX____,________};



GUI_CONST_STORAGE GUI_CHARINFO CharInfoComic18B_1_160_255[193] = {
   {   5,   5,  1, acFontComic18B_1_160 } /* code 160 */
  ,{   4,   4,  1, acFontComic18B_1_161 } /* code 161 */
  ,{  10,  10,  2, acFontComic18B_1_162 } /* code 162 */
  ,{  13,  13,  2, acFontComic18B_1_163 } /* code 163 */
  ,{  10,  10,  2, acFontComic18B_1_164 } /* code 164 */
  ,{  10,  10,  2, acFontComic18B_1_165 } /* code 165 */
  ,{   6,   6,  1, acFontComic18B_1_166 } /* code 166 */
  ,{  10,  10,  2, acFontComic18B_1_167 } /* code 167 */
  ,{   9,   9,  2, acFontComic18B_1_168 } /* code 168 */
  ,{  13,  13,  2, acFontComic18B_1_169 } /* code 169 */
  ,{   8,   8,  1, acFontComic18B_1_170 } /* code 170 */
  ,{   9,   9,  2, acFontComic18B_1_171 } /* code 171 */
  ,{   9,   9,  2, acFontComic18B_1_172 } /* code 172 */
  ,{   7,   7,  1, acFontComic18B_1_173 } /* code 173 */
  ,{  13,  13,  2, acFontComic18B_1_174 } /* code 174 */
  ,{  10,  10,  2, acFontComic18B_1_175 } /* code 175 */
  ,{   7,   7,  1, acFontComic18B_1_176 } /* code 176 */
  ,{   8,   8,  1, acFontComic18B_1_177 } /* code 177 */
  ,{  10,  10,  2, acFontComic18B_1_178 } /* code 178 */
  ,{  10,  10,  2, acFontComic18B_1_179 } /* code 179 */
  ,{   8,   8,  1, acFontComic18B_1_180 } /* code 180 */
  ,{   8,   8,  1, acFontComic18B_1_181 } /* code 181 */
  ,{  11,  11,  2, acFontComic18B_1_182 } /* code 182 */
  ,{   4,   4,  1, acFontComic18B_1_183 } /* code 183 */
  ,{   9,   9,  2, acFontComic18B_1_184 } /* code 184 */
  ,{  10,  10,  2, acFontComic18B_1_185 } /* code 185 */
  ,{   8,   8,  1, acFontComic18B_1_186 } /* code 186 */
  ,{   9,   9,  2, acFontComic18B_1_187 } /* code 187 */
  ,{  10,  10,  2, acFontComic18B_1_188 } /* code 188 */
  ,{  10,  10,  2, acFontComic18B_1_189 } /* code 189 */
  ,{  10,  10,  2, acFontComic18B_1_190 } /* code 190 */
  ,{   9,   9,  2, acFontComic18B_1_191 } /* code 191 */
  ,{  12,  12,  2, acFontComic18B_1_192 } /* code 192 */
  ,{  12,  12,  2, acFontComic18B_1_193 } /* code 193 */
  ,{  12,  12,  2, acFontComic18B_1_194 } /* code 194 */
  ,{  12,  12,  2, acFontComic18B_1_195 } /* code 195 */
  ,{  12,  12,  2, acFontComic18B_1_196 } /* code 196 */
  ,{  12,  12,  2, acFontComic18B_1_197 } /* code 197 */
  ,{  19,  19,  3, acFontComic18B_1_198 } /* code 198 */
  ,{  10,  10,  2, acFontComic18B_1_199 } /* code 199 */
  ,{  10,  10,  2, acFontComic18B_1_200 } /* code 200 */
  ,{  10,  10,  2, acFontComic18B_1_201 } /* code 201 */
  ,{  10,  10,  2, acFontComic18B_1_202 } /* code 202 */
  ,{  10,  10,  2, acFontComic18B_1_203 } /* code 203 */
  ,{   9,   9,  2, acFontComic18B_1_204 } /* code 204 */
  ,{   9,   9,  2, acFontComic18B_1_205 } /* code 205 */
  ,{   9,   9,  2, acFontComic18B_1_206 } /* code 206 */
  ,{   9,   9,  2, acFontComic18B_1_207 } /* code 207 */
  ,{  12,  12,  2, acFontComic18B_1_208 } /* code 208 */
  ,{  13,  13,  2, acFontComic18B_1_209 } /* code 209 */
  ,{  13,  13,  2, acFontComic18B_1_210 } /* code 210 */
  ,{  13,  13,  2, acFontComic18B_1_211 } /* code 211 */
  ,{  13,  13,  2, acFontComic18B_1_212 } /* code 212 */
  ,{  13,  13,  2, acFontComic18B_1_213 } /* code 213 */
  ,{  13,  13,  2, acFontComic18B_1_214 } /* code 214 */
  ,{   8,   8,  1, acFontComic18B_1_215 } /* code 215 */
  ,{  13,  13,  2, acFontComic18B_1_216 } /* code 216 */
  ,{  12,  12,  2, acFontComic18B_1_217 } /* code 217 */
  ,{  12,  12,  2, acFontComic18B_1_218 } /* code 218 */
  ,{  12,  12,  2, acFontComic18B_1_219 } /* code 219 */
  ,{  12,  12,  2, acFontComic18B_1_220 } /* code 220 */
  ,{  11,  11,  2, acFontComic18B_1_221 } /* code 221 */
  ,{   8,   8,  1, acFontComic18B_1_222 } /* code 222 */
  ,{   8,   8,  1, acFontComic18B_1_223 } /* code 223 */
  ,{   8,   8,  1, acFontComic18B_1_224 } /* code 224 */
  ,{   8,   8,  1, acFontComic18B_1_225 } /* code 225 */
  ,{   8,   8,  1, acFontComic18B_1_226 } /* code 226 */
  ,{   8,   8,  1, acFontComic18B_1_227 } /* code 227 */
  ,{   8,   8,  1, acFontComic18B_1_228 } /* code 228 */
  ,{   8,   8,  1, acFontComic18B_1_229 } /* code 229 */
  ,{  15,  15,  2, acFontComic18B_1_230 } /* code 230 */
  ,{   8,   8,  1, acFontComic18B_1_231 } /* code 231 */
  ,{   8,   8,  1, acFontComic18B_1_232 } /* code 232 */
  ,{   8,   8,  1, acFontComic18B_1_233 } /* code 233 */
  ,{   8,   8,  1, acFontComic18B_1_234 } /* code 234 */
  ,{   8,   8,  1, acFontComic18B_1_235 } /* code 235 */
  ,{   5,   5,  1, acFontComic18B_1_236 } /* code 236 */
  ,{   5,   5,  1, acFontComic18B_1_237 } /* code 237 */
  ,{   5,   5,  1, acFontComic18B_1_238 } /* code 238 */
  ,{   5,   5,  1, acFontComic18B_1_239 } /* code 239 */
  ,{   8,   8,  1, acFontComic18B_1_240 } /* code 240 */
  ,{   8,   8,  1, acFontComic18B_1_241 } /* code 241 */
  ,{   8,   8,  1, acFontComic18B_1_242 } /* code 242 */
  ,{   8,   8,  1, acFontComic18B_1_243 } /* code 243 */
  ,{   8,   8,  1, acFontComic18B_1_244 } /* code 244 */
  ,{   8,   8,  1, acFontComic18B_1_245 } /* code 245 */
  ,{   8,   8,  1, acFontComic18B_1_246 } /* code 246 */
  ,{   9,   9,  2, acFontComic18B_1_247 } /* code 247 */
  ,{   8,   8,  1, acFontComic18B_1_248 } /* code 248 */
  ,{   8,   8,  1, acFontComic18B_1_249 } /* code 249 */
  ,{   8,   8,  1, acFontComic18B_1_250 } /* code 250 */
  ,{   8,   8,  1, acFontComic18B_1_251 } /* code 251 */
  ,{   8,   8,  1, acFontComic18B_1_252 } /* code 252 */
  ,{   9,   9,  2, acFontComic18B_1_253 } /* code 253 */
  ,{   9,   9,  2, acFontComic18B_1_254 } /* code 254 */
  ,{   9,   9,  2, acFontComic18B_1_255 } /* code 255 */
};

GUI_CONST_STORAGE GUI_FONT_PROP FontComic18BProp_1_160 = {
   160                        /* first character               */
  ,255                        /* last character                */
  ,CharInfoComic18B_1_160_255 /* address of first character    */
  ,(const GUI_FONT_PROP*)0    /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP FontComic18BProp_1_32 = {
   32                       /* first character               */
  ,127                      /* last character                */
  ,CharInfo18B_ASCII        /* address of first character    */
  ,&FontComic18BProp_1_160  /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontComic18B_1 = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,18                 /* height of font  */
  ,18                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&FontComic18BProp_1_32}
  ,15, 8, 12
};

