/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : F24B.C
Purpose     : Similar to Comic
Height      : 24
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

GUI_CONST_STORAGE unsigned char acFontComic24B_160[48] = { /* code 160 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_161[24] = { /* code 161 */
  ________,
  ________,
  ________,
  _XX_____,
  _XXX____,
  __XX____,
  ________,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_162[48] = { /* code 162 */
  ________,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  _____XXX,XXXX____,
  ___XXXXX,XXXX____,
  __XXXXXX,XXXX____,
  __XXX_XX,__X_____,
  _XXXX_XX,________,
  _XXX__XX,________,
  _XXX__XX,__XX____,
  _XXX__XX,__XX____,
  _XXXX_XX,_XXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  _____XXX,X_______,
  ______XX,________,
  ______XX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_163[72] = { /* code 163 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  _______X,XXXX____,________,
  _____XXX,XXXXXX__,________,
  ____XXXX,XXXXXXX_,________,
  ___XXXX_,____XXX_,________,
  ___XXX__,_____XX_,________,
  ___XXX__,________,________,
  XXXXXXXX,XXXXX___,________,
  XXXXXXXX,XXXXX___,________,
  XXXXXXXX,XXXXX___,________,
  ___XXX__,________,________,
  ____XXX_,________,________,
  ____XXX_,______XX,________,
  ____XXX_,______XX,________,
  ____XXXX,X____XXX,________,
  ___XXXXX,XXXXXXXX,________,
  __XXXXXX,XXXXXXX_,________,
  __XX____,XXXXXX__,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_164[48] = { /* code 164 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  _XXXX___,___XX___,
  _XXXXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  XXXX_XXX,XXXX____,
  XXXX____,_XXXX___,
  XXX_____,__XXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_165[48] = { /* code 165 */
  ________,________,
  ________,________,
  ________,________,
  XXX_____,_XXX____,
  XXXX____,_XXX____,
  _XXX____,XXXX____,
  __XXX___,XXX_____,
  __XXX__X,XXX_____,
  _XXXXX_X,XXXX____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXXX____,
  _____XXX,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_166[48] = { /* code 166 */
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_167[48] = { /* code 167 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX___X,XXX_____,
  _XXXX___,_XX_____,
  __XXXXXX,________,
  _XXXXXXX,XX______,
  _XXX___X,XXX_____,
  _XXX____,XXX_____,
  _XXXXX__,XXX_____,
  __XXXXXX,XXX_____,
  XX___XXX,XXX_____,
  XXX_____,XXX_____,
  XXX_____,XXX_____,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_168[48] = { /* code 168 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX_X,XX______,
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_169[72] = { /* code 169 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXX____,________,
  ____XXXX,XXXXX___,________,
  ___XXX__,___XXX__,________,
  __XXX_XX,XX__XXX_,________,
  _XXX_XXX,XX___XX_,________,
  _XX_XXX_,_____XX_,________,
  _XX_XX__,_____XX_,________,
  _XX_XX__,_XX__XX_,________,
  _XX_XXXX,XXX_XX__,________,
  _XXX__XX,XX_XXX__,________,
  __XXX___,__XXX___,________,
  ___XXXXX,XXXX____,________,
  _____XXX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_170[48] = { /* code 170 */
  ________,________,
  ________,________,
  ________,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX__XX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_171[48] = { /* code 171 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,___XX___,
  ___XXXX_,_XXXX___,
  __XXXX__,XXXX____,
  _XXXX__X,XXX_____,
  XXXX__XX,XX______,
  _XXXX__X,XXX_____,
  __XXXX__,XXXX____,
  ___XXXX_,_XXXX___,
  ____XXX_,__XXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_172[48] = { /* code 172 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XX______,
  __XXXXXX,XXX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_173[48] = { /* code 173 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXXXXX,XX______,
  __XXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_174[72] = { /* code 174 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXX____,________,
  ____XXXX,XXXXXX__,________,
  ___XXX__,____XXX_,________,
  __XXX_XX,XXX__XX_,________,
  __XX_XXX,XXXX__XX,________,
  _XX__XXX,__XX__XX,________,
  _XX_XXX_,_XXX__XX,________,
  _XX_XXXX,XXX___XX,________,
  _XX_XXXX,XX____XX,________,
  _XX_XXX_,XXX__XX_,________,
  __XXXX__,_XX_XXX_,________,
  __XXX___,___XXX__,________,
  ___XXXXX,XXXXX___,________,
  _____XXX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_175[48] = { /* code 175 */
  XXXXXXXX,XXXXX___,
  XXXXXXXX,XXXXX___,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_176[48] = { /* code 176 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,X_______,
  __XX____,XX______,
  __XX____,XX______,
  __XX___X,XX______,
  ___XXXXX,X_______,
  ____XXXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_177[48] = { /* code 177 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_178[48] = { /* code 178 */
  ________,________,
  _____XXX,X_______,
  ___XXXXX,XX______,
  ___XXX__,XX______,
  ___XX__X,XX______,
  _____XXX,XX______,
  ____XXXX,X_______,
  ___XXXX_,________,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_179[48] = { /* code 179 */
  ________,________,
  _____XXX,X_______,
  _____XXX,XX______,
  ________,XX______,
  ______XX,XX______,
  ______XX,XX______,
  _______X,XX______,
  ________,XX______,
  ____XXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_180[48] = { /* code 180 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXX_,________,
  ___XXX__,________,
  __XXX___,________,
  __XX____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_181[48] = { /* code 181 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,__XXX___,
  ____XXX_,__XXX___,
  ____XXX_,__XXX___,
  ___XXX__,__XX____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXX__,_XXX____,
  ___XXX__,_XX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  _XXXX___,________,
  _XXX____,________,
  _XXX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_182[48] = { /* code 182 */
  ________,________,
  ________,________,
  ________,________,
  ________,XXX_XX__,
  ____XXXX,XXXXXXX_,
  ___XXXXX,XXXXXXX_,
  __XXXXXX,XXX_XXX_,
  _XXXXX__,XXX_XXX_,
  XXXX____,XXX_XXX_,
  XXX_____,XXX_XXX_,
  XXX_____,XXX_XXX_,
  XXXX____,XXX_XXX_,
  _XXXXXXX,XXXXXX__,
  __XXXXXX,XXXXXX__,
  ____XXXX,XX_XXX__,
  _______X,XX_XXX__,
  _______X,XX_XXX__,
  ______XX,XX_XXX__,
  ______XX,XXXXX___,
  ______XX,X_XXX___,
  ______XX,X_XXX___,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_183[48] = { /* code 183 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XXX,________,
  _____XXX,________,
  _____XXX,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_184[48] = { /* code 184 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,________,
  ____XXXX,X_______,
  _______X,X_______,
  ___XXXXX,X_______,
  ____XXXX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_185[48] = { /* code 185 */
  ________,________,
  _____XX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXXX_,________,
  _____XX_,________,
  _____XX_,________,
  _____XX_,________,
  ___XXXXX,X_______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_186[48] = { /* code 186 */
  ________,________,
  ________,________,
  ________,________,
  _____XXX,X_______,
  ____XXXX,XXX_____,
  ___XXXXX,XXX_____,
  __XXXX__,_XXX____,
  __XXX___,_XXX____,
  __XXXX__,XXXX____,
  ___XXXXX,XXXX____,
  ___XXXXX,XXX_____,
  _____XXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_187[48] = { /* code 187 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  XX____XX,________,
  XXXX__XX,XX______,
  _XXXX__X,XXX_____,
  __XXXX__,XXXX____,
  ___XXXX_,_XXXX___,
  __XXXX__,XXXX____,
  _XXXX__X,XXX_____,
  XXXX__XX,XX______,
  XXX___XX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_188[48] = { /* code 188 */
  ________,________,
  ______XX,________,
  _____XXX,________,
  ____XXXX,________,
  _____XXX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ____XXXX,XX______,
  ____XXXX,XX______,
  ________,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ________,________,
  _______X,X_______,
  ______XX,X_______,
  _____XXX,X_______,
  ____XX_X,X_______,
  ___XX__X,X_______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  _______X,X_______,
  _______X,X_______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_189[48] = { /* code 189 */
  ________,________,
  ______XX,________,
  _____XXX,________,
  ____XXXX,________,
  ____XXXX,________,
  ______XX,________,
  ______XX,________,
  ______XX,________,
  ____XXXX,XX______,
  ____XXXX,XX______,
  ________,________,
  _XXXXXXX,XXXXX___,
  _XXXXXXX,XXXXX___,
  ________,________,
  _____XXX,X_______,
  ___XXXXX,XX______,
  ___XXX_X,XX______,
  ___XX_XX,XX______,
  _____XXX,XX______,
  ____XXXX,X_______,
  ___XXXX_,________,
  ___XXXXX,XX______,
  ___XXXXX,XX______,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_190[48] = { /* code 190 */
  ________,________,
  ____XXXX,________,
  ____XXXX,X_______,
  _______X,X_______,
  _____XXX,X_______,
  _____XXX,X_______,
  ______XX,X_______,
  _______X,X_______,
  ___XXXXX,X_______,
  ___XXXXX,________,
  ________,________,
  XXXXXXXX,XXXX____,
  XXXXXXXX,XXXX____,
  ________,________,
  ______XX,________,
  _____XXX,________,
  ____XXXX,________,
  ___XX_XX,________,
  __XX__XX,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  ______XX,________,
  ______XX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_191[48] = { /* code 191 */
  ________,________,
  ________,________,
  ________,________,
  _______X,XX______,
  _______X,XX______,
  _______X,XX______,
  ________,________,
  ________,________,
  ______XX,X_______,
  _____XXX,X_______,
  ____XXXX,________,
  ___XXXX_,________,
  __XXXX__,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXX___,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_192[48] = { /* code 192 */
  ________,_XXX____,
  ________,__XX____,
  ________,________,
  ________,_XX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_193[48] = { /* code 193 */
  ________,_XXX____,
  ________,_XX_____,
  ________,________,
  ________,_XX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_194[48] = { /* code 194 */
  _____XXX,X__XXX__,
  _____XXX,____XX__,
  ________,________,
  ________,_XX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_195[48] = { /* code 195 */
  _____XXX,_XXXXX__,
  _____XX_,__XXXX__,
  ________,________,
  ________,_XX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_196[48] = { /* code 196 */
  ______XX,XX_XXXX_,
  ______XX,X__XXXX_,
  ________,________,
  ________,_XX_____,
  ________,XXX_____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_197[48] = { /* code 197 */
  ______XX,XXXXX___,
  ______XX,___XX___,
  ______XX,___XX___,
  ______XX,XXXXX___,
  _______X,XXXX____,
  ________,XXX_____,
  _______X,XXX_____,
  ______XX,XXXX____,
  ______XX,XXXX____,
  _____XXX,_XXX____,
  _____XXX,_XXX____,
  ____XXX_,_XXX____,
  ____XXXX,XXXX____,
  ___XXXXX,XXXXX___,
  __XXXXXX,XXXXX___,
  __XXX___,__XXX___,
  __XXX___,__XXX___,
  _XXXX___,___XXX__,
  _XXX____,___XXX__,
  _XXX____,____XX__,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_198[72] = { /* code 198 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,___XXXXX,XXXXX___,
  ________,__XXXXXX,XXXXXX__,
  ________,_XXXXXXX,XXXXX___,
  ________,XXXXXX__,________,
  _______X,XXXXXX__,________,
  ______XX,XX_XXX__,________,
  _____XXX,X__XXX__,________,
  _____XXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXX___,
  __XXXX__,___XXX__,________,
  __XXX___,___XXX__,________,
  _XXXX___,___XXX__,________,
  _XXX____,___XXX__,________,
  XXXX____,___XXXXX,XXXXX___,
  XXX_____,____XXXX,XXXXXX__,
  ________,_____XXX,XXXXX___,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_199[48] = { /* code 199 */
  ________,________,
  ________,________,
  ________,________,
  _______X,XXXXX___,
  ______XX,XXXXX___,
  _____XXX,XXXXX___,
  ____XXXX,__XXX___,
  ___XXXX_,___XX___,
  __XXXX__,________,
  __XXX___,________,
  __XXX___,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,__XX____,
  _XXXX___,XXXX____,
  __XXXXXX,XXXX____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ____XXXX,________,
  _____XXX,________,
  _XXXXXXX,________,
  _XXXXX__,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_200[48] = { /* code 200 */
  _______X,X_______,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  ___XXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_201[48] = { /* code 201 */
  ______XX,________,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  ___XXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_202[48] = { /* code 202 */
  __XXX___,_XX_____,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  ___XXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_203[48] = { /* code 203 */
  ___XXX__,XXXX____,
  ________,________,
  ________,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  _XXXXXXX,XXXX____,
  _XXXXXXX,XXX_____,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,XXX_____,
  __XXXXXX,XXXX____,
  ___XXXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_204[48] = { /* code 204 */
  _____XXX,________,
  ______XX,________,
  ________,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_205[48] = { /* code 205 */
  ____XXX_,________,
  ____XX__,________,
  ________,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_206[48] = { /* code 206 */
  _XXXX__X,XX______,
  _XXX____,XX______,
  ________,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_207[48] = { /* code 207 */
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  ________,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  ____XXX_,________,
  _XXXXXXX,XX______,
  XXXXXXXX,XXX_____,
  _XXXXXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_208[48] = { /* code 208 */
  ________,________,
  ________,________,
  ________,________,
  ___XX___,________,
  __XXXXX_,________,
  __XXXXXX,XX______,
  __XXX_XX,XXX_____,
  __XXX___,XXXX____,
  __XXX___,__XXX___,
  __XXX___,___XXX__,
  XXXXXXXX,____XXX_,
  XXXXXXXX,X___XXX_,
  XXXXXXXX,X___XXX_,
  __XXX___,____XXX_,
  __XXX___,____XXX_,
  __XXX___,___XXX__,
  __XXX___,__XXXX__,
  __XXXXXX,XXXXX___,
  __XXXXXX,XXXX____,
  ____XXXX,XX______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_209[72] = { /* code 209 */
  ___XXX_X,XXXX____,________,
  ___XX___,XXXX____,________,
  ________,________,________,
  _XXX____,_____XX_,________,
  _XXX____,_____XXX,________,
  _XXXX___,_____XXX,________,
  _XXXXX__,_____XXX,________,
  _XXXXX__,_____XXX,________,
  _XXXXXX_,_____XXX,________,
  _XXX_XXX,_____XXX,________,
  _XXX_XXX,X____XXX,________,
  _XXX__XX,X____XXX,________,
  _XXX___X,XX___XXX,________,
  _XXX____,XXX__XXX,________,
  _XXX____,_XXX_XXX,________,
  _XXX____,__XXXXXX,________,
  _XXX____,__XXXXXX,________,
  _XXX____,___XXXXX,________,
  _XXX____,____XXXX,________,
  __X_____,______X_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_210[72] = { /* code 210 */
  ________,__XXX___,________,
  ________,___XX___,________,
  ________,________,________,
  _______X,XXXXX___,________,
  ______XX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,_____XXX,________,
  ___XXXX_,______XX,X_______,
  ___XXX__,______XX,X_______,
  ___XXX__,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,_____XXX,________,
  __XXX___,_____XXX,________,
  __XXXX__,____XXXX,________,
  ___XXXX_,___XXXX_,________,
  ____XXXX,XXXXXX__,________,
  _____XXX,XXXXX___,________,
  ______XX,XXXX____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_211[72] = { /* code 211 */
  ________,_XXX____,________,
  ________,_XX_____,________,
  ________,________,________,
  ______XX,XXXX____,________,
  _____XXX,XXXXXX__,________,
  ____XXXX,XXXXXXX_,________,
  ___XXXX_,____XXX_,________,
  __XXXX__,_____XXX,________,
  __XXX___,_____XXX,________,
  __XXX___,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,____XXX_,________,
  _XXX____,____XXX_,________,
  _XXXX___,___XXXX_,________,
  __XXXX__,__XXXX__,________,
  ___XXXXX,XXXXX___,________,
  ____XXXX,XXXX____,________,
  _____XXX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_212[72] = { /* code 212 */
  ______XX,XX__XXX_,________,
  ______XX,X____XX_,________,
  ________,________,________,
  _______X,XXXXX___,________,
  ______XX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,_____XXX,________,
  ___XXXX_,______XX,X_______,
  ___XXX__,______XX,X_______,
  ___XXX__,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,_____XXX,________,
  __XXX___,_____XXX,________,
  __XXXX__,____XXXX,________,
  ___XXXX_,___XXXX_,________,
  ____XXXX,XXXXXX__,________,
  _____XXX,XXXXX___,________,
  ______XX,XXXX____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_213[72] = { /* code 213 */
  _____XXX,_XXXXX__,________,
  _____XX_,__XXXX__,________,
  ________,________,________,
  _______X,XXXXX___,________,
  ______XX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,________,
  ____XXXX,_____XXX,________,
  ___XXXX_,______XX,X_______,
  ___XXX__,______XX,X_______,
  ___XXX__,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,______XX,X_______,
  __XXX___,_____XXX,________,
  __XXX___,_____XXX,________,
  __XXXX__,____XXXX,________,
  ___XXXX_,___XXXX_,________,
  ____XXXX,XXXXXX__,________,
  _____XXX,XXXXX___,________,
  ______XX,XXXX____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_214[72] = { /* code 214 */
  ______XX,XX_XXXX_,________,
  ______XX,X__XXXX_,________,
  ________,________,________,
  ______XX,XXXX____,________,
  _____XXX,XXXXXX__,________,
  ____XXXX,XXXXXXX_,________,
  ___XXXX_,____XXX_,________,
  __XXXX__,_____XXX,________,
  __XXX___,_____XXX,________,
  __XXX___,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,_____XXX,________,
  _XXX____,____XXX_,________,
  _XXX____,____XXX_,________,
  _XXXX___,___XXXX_,________,
  __XXXX__,__XXXX__,________,
  ___XXXXX,XXXXX___,________,
  ____XXXX,XXXX____,________,
  _____XXX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_215[48] = { /* code 215 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  __XXX___,XXX_____,
  __XXXX_X,XXX_____,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  ___XXXXX,XX______,
  ___XXX_X,XXX_____,
  ___XXX__,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_216[72] = { /* code 216 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ______XX,XXXX___X,X_______,
  ____XXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,________,
  __XXXXX_,___XXXX_,________,
  __XXX___,__XXXXXX,________,
  _XXX____,_XXXXXXX,________,
  _XXX____,XXXX_XXX,________,
  XXX____X,XXX__XXX,________,
  XXX___XX,XX___XXX,________,
  XXX__XXX,X____XXX,________,
  XXX_XXXX,____XXXX,________,
  XXXXXXX_,____XXX_,________,
  XXXXXX__,___XXXX_,________,
  _XXXXX__,__XXXX__,________,
  _XXXXXXX,XXXXX___,________,
  XXX_XXXX,XXXX____,________,
  XX___XXX,XXX_____,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_217[48] = { /* code 217 */
  _______X,XX______,
  ________,XX______,
  ________,________,
  __X_____,____X___,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXX___,__XXX___,
  __XXX___,_XXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_218[48] = { /* code 218 */
  ______XX,X_______,
  ______XX,________,
  ________,________,
  __X_____,____X___,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXX___,__XXX___,
  __XXX___,_XXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_219[48] = { /* code 219 */
  ___XXXX_,_XXX____,
  ___XXX__,__XX____,
  ________,________,
  __X_____,____X___,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXX___,__XXX___,
  __XXX___,_XXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_220[48] = { /* code 220 */
  ____XXXX,_XXXX___,
  ____XXX_,_XXXX___,
  ________,________,
  __X_____,____X___,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XXX__,
  _XXX____,___XX___,
  _XXX____,__XXX___,
  _XXX____,__XXX___,
  _XXXX___,__XXX___,
  __XXX___,_XXX____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_221[48] = { /* code 221 */
  ______XX,________,
  ________,________,
  ________,________,
  XXX_____,__XXX___,
  XXX_____,__XXX___,
  XXXX____,_XXXX___,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXX___,XXX_____,
  ___XXX_X,XXX_____,
  ___XXX_X,XX______,
  ____XXXX,XX______,
  ____XXXX,X_______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ___XXXX_,________,
  ___XXX__,________,
  ___XXX__,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_222[48] = { /* code 222 */
  ________,________,
  ________,________,
  ________,________,
  _XXX____,________,
  _XXX____,________,
  _XXXXXXX,________,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXX___X,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX___X,XXX_____,
  _XXXXXXX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_223[48] = { /* code 223 */
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,X_______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX__XX,XX______,
  _XXX__XX,X_______,
  _XXX_XXX,________,
  _XXX_XXX,X_______,
  _XXX__XX,X_______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX_XXX,XX______,
  _XXX_XXX,X_______,
  _XXX_XXX,X_______,
  _XX_____,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_224[48] = { /* code 224 */
  ________,________,
  ________,________,
  ___XX___,________,
  ___XXX__,________,
  ____XXX_,________,
  _____XXX,________,
  ______XX,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_225[48] = { /* code 225 */
  ________,________,
  ________,________,
  ________,XX______,
  _______X,XX______,
  ______XX,X_______,
  _____XXX,________,
  _____XX_,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_226[48] = { /* code 226 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  _XXXX__X,XX______,
  _XXX____,XX______,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_227[48] = { /* code 227 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,_XX_____,
  __XXXXX_,XXX_____,
  _XXX_XXX,XX______,
  _XX___XX,XX______,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_228[48] = { /* code 228 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX_X,XX______,
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_229[48] = { /* code 229 */
  ________,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  __XX___X,X_______,
  __XX___X,X_______,
  __XXXXXX,X_______,
  ___XXXXX,________,
  ________,________,
  ____XXXX,________,
  ___XXXXX,XX______,
  __XXXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXX_,_XX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_230[72] = { /* code 230 */
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ____XXXX,X_XXXXX_,________,
  __XXXXXX,XXXXXXXX,X_______,
  _XXXXXXX,XXXXXXXX,X_______,
  _XXX___X,XXX___XX,X_______,
  XXXX___X,XX_XXXXX,________,
  XXX____X,XXXXXXX_,________,
  XXX____X,XXXXX___,________,
  XXX____X,XXX_____,XX______,
  XXXX___X,XXX____X,XX______,
  _XXXXXXX,XXXXXXXX,XX______,
  __XXXXXX,XXXXXXXX,X_______,
  ___XXXX_,XX_XXXX_,________,
  ________,________,________,
  ________,________,________,
  ________,________,________,
  ________,________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_231[48] = { /* code 231 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXXX,________,
  __XXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXX___,XX______,
  XXXX____,________,
  XXX_____,________,
  XXX_____,________,
  XXXX___X,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  ___XXXXX,X_______,
  _____XXX,________,
  ______XX,________,
  __XXXXXX,________,
  __XXXXXX,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_232[48] = { /* code 232 */
  ________,________,
  ________,________,
  ___XX___,________,
  ___XXX__,________,
  ____XXX_,________,
  _____XXX,________,
  ______XX,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX____,XXX_____,
  XXXX__XX,XXX_____,
  XXX_XXXX,XX______,
  XXXXXXXX,________,
  XXXXXX__,________,
  XXXX____,XXX_____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_233[48] = { /* code 233 */
  ________,________,
  ________,________,
  _______X,X_______,
  ______XX,X_______,
  _____XXX,________,
  ____XXX_,________,
  ____XX__,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX____,XXX_____,
  XXXX__XX,XXX_____,
  XXX_XXXX,XX______,
  XXXXXXXX,________,
  XXXXXX__,________,
  XXXX____,XXX_____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_234[48] = { /* code 234 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  _XXXX__X,XX______,
  _XXX____,XX______,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX____,XXX_____,
  XXXX__XX,XXX_____,
  XXX_XXXX,XX______,
  XXXXXXXX,________,
  XXXXXX__,________,
  XXXX____,XXX_____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_235[48] = { /* code 235 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX_X,XX______,
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  ________,________,
  ________,________,
  ____XXXX,X_______,
  __XXXXXX,XX______,
  _XXXXXXX,XXX_____,
  _XXX____,XXX_____,
  XXXX__XX,XXX_____,
  XXX_XXXX,XX______,
  XXXXXXXX,________,
  XXXXXX__,________,
  XXXX____,XXX_____,
  _XXXXXXX,XXX_____,
  __XXXXXX,XX______,
  ___XXXXX,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_236[24] = { /* code 236 */
  ________,
  ________,
  XX______,
  XXX_____,
  _XXX____,
  __XXX___,
  ___XX___,
  ________,
  __X_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __X_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_237[24] = { /* code 237 */
  ________,
  ________,
  ____XX__,
  ___XXX__,
  __XXX___,
  _XXX____,
  _XX_____,
  ________,
  __X_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __X_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_238[24] = { /* code 238 */
  ________,
  ________,
  __XX____,
  _XXXX___,
  XXXXXX__,
  XX__XX__,
  X____X__,
  ________,
  __X_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __X_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_239[24] = { /* code 239 */
  ________,
  ________,
  ________,
  ________,
  XXX_XX__,
  XXX_XX__,
  XX__XX__,
  ________,
  __X_____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  _XXX____,
  __X_____,
  ________,
  ________,
  ________,
  ________};

GUI_CONST_STORAGE unsigned char acFontComic24B_240[48] = { /* code 240 */
  ________,________,
  ________,________,
  ________,________,
  ___XX___,________,
  ___XXXXX,X_______,
  ____XXXX,X_______,
  ___XXXXX,________,
  __XXXXX_,________,
  __XXX_XX,________,
  _____XXX,X_______,
  ____XXXX,X_______,
  ___XXXXX,XX______,
  __XXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX__XX,XX______,
  __XXXXXX,X_______,
  __XXXXXX,X_______,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_241[48] = { /* code 241 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,_XX_____,
  __XXXXX_,XXX_____,
  _XXX_XXX,XX______,
  _XX___XX,XX______,
  ________,________,
  _XXX_XXX,X_______,
  _XXXXXXX,X_______,
  _XXXXXXX,XX______,
  _XXXXX_X,XX______,
  _XXXX__X,XX______,
  _XXXX__X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  _XXX___X,XX______,
  __X_____,X_______,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_242[48] = { /* code 242 */
  ________,________,
  ________,________,
  ____XX__,________,
  ____XXX_,________,
  _____XXX,________,
  ______XX,X_______,
  _______X,X_______,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXX__XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_243[48] = { /* code 243 */
  ________,________,
  ________,________,
  _______X,X_______,
  ______XX,X_______,
  _____XXX,________,
  ____XXX_,________,
  ____XX__,________,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXX__XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_244[48] = { /* code 244 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  _XXXX__X,XX______,
  _XXX____,XX______,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXX__XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_245[48] = { /* code 245 */
  ________,________,
  ________,________,
  ________,________,
  ___XXX__,_XX_____,
  __XXXXX_,XXX_____,
  _XXX_XXX,XX______,
  _XX___XX,XX______,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXX__XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_246[48] = { /* code 246 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX_X,XX______,
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  ________,________,
  ___XXXXX,________,
  __XXXXXX,X_______,
  _XXXXXXX,X_______,
  _XXX__XX,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXX____X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  _XXXXXXX,________,
  ___XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_247[48] = { /* code 247 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  __XXXXXX,XXX_____,
  __XXXXXX,XXX_____,
  ________,________,
  _____XX_,________,
  _____XX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_248[48] = { /* code 248 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXXX_,XX______,
  __XXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXX__XX,XX______,
  XXX__XXX,XX______,
  XXX_XXXX,XX______,
  XXXXXX_X,XX______,
  XXXXX__X,XX______,
  XXXX__XX,XX______,
  _XXXXXXX,X_______,
  XXXXXXXX,________,
  XX_XXXX_,________,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_249[48] = { /* code 249 */
  ________,________,
  ________,________,
  ____XX__,________,
  ____XXX_,________,
  _____XXX,________,
  ______XX,X_______,
  _______X,X_______,
  ________,________,
  ___X____,_X______,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_250[48] = { /* code 250 */
  ________,________,
  ________,________,
  ________,XX______,
  _______X,XX______,
  ______XX,X_______,
  _____XXX,________,
  _____XX_,________,
  ________,________,
  ___X____,_X______,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_251[48] = { /* code 251 */
  ________,________,
  ________,________,
  _____XX_,________,
  ____XXXX,________,
  __XXXXXX,X_______,
  _XXXX__X,XX______,
  _XXX____,XX______,
  ________,________,
  ___X____,_X______,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_252[48] = { /* code 252 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ____XXX_,XXX_____,
  ___XXXX_,XXX_____,
  ___XXX__,XXX_____,
  ________,________,
  ___X____,_X______,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXX___,XXX_____,
  __XXXXXX,XXX_____,
  ___XXXXX,XXX_____,
  ____XXXX,XXX_____,
  ________,________,
  ________,________,
  ________,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_253[48] = { /* code 253 */
  ________,________,
  ________,________,
  ______XX,________,
  _____XXX,________,
  ____XXX_,________,
  ___XXX__,________,
  ___XX___,________,
  ________,________,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXX___,XXX_____,
  __XXXX_X,XXX_____,
  ___XXX_X,XX______,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_254[48] = { /* code 254 */
  ________,________,
  ________,________,
  ________,________,
  __XX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  _XXX_XXX,X_______,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXX___,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX____,XXX_____,
  _XXX___X,XXX_____,
  _XXXXXXX,XX______,
  _XXXXXXX,XX______,
  _XXXXXXX,________,
  _XXX____,________,
  _XXX____,________,
  _XXX____,________,
  ________,________};

GUI_CONST_STORAGE unsigned char acFontComic24B_255[48] = { /* code 255 */
  ________,________,
  ________,________,
  ________,________,
  ________,________,
  ___XXX_X,XX______,
  __XXXX_X,XXX_____,
  __XXX__X,XXX_____,
  ________,________,
  _XXX____,_XXX____,
  _XXX____,_XXX____,
  _XXXX___,XXXX____,
  __XXX___,XXX_____,
  __XXXX_X,XXX_____,
  ___XXX_X,XX______,
  ___XXXXX,XX______,
  ____XXXX,X_______,
  ____XXXX,X_______,
  _____XXX,X_______,
  _____XXX,________,
  ____XXXX,________,
  ____XXX_,________,
  ____XXX_,________,
  ___XXXX_,________,
  ________,________};



GUI_CONST_STORAGE GUI_CHARINFO CharInfo24B_160_255[] = {
   {  10,  10,  2, acFontComic24B_160 } /* code 160 */
  ,{   5,   5,  1, acFontComic24B_161 } /* code 161 */
  ,{  13,  13,  2, acFontComic24B_162 } /* code 162 */
  ,{  17,  17,  3, acFontComic24B_163 } /* code 163 */
  ,{  13,  13,  2, acFontComic24B_164 } /* code 164 */
  ,{  13,  13,  2, acFontComic24B_165 } /* code 165 */
  ,{   9,   9,  2, acFontComic24B_166 } /* code 166 */
  ,{  13,  13,  2, acFontComic24B_167 } /* code 167 */
  ,{  12,  12,  2, acFontComic24B_168 } /* code 168 */
  ,{  17,  17,  3, acFontComic24B_169 } /* code 169 */
  ,{  13,  13,  2, acFontComic24B_170 } /* code 170 */
  ,{  13,  13,  2, acFontComic24B_171 } /* code 171 */
  ,{  13,  13,  2, acFontComic24B_172 } /* code 172 */
  ,{  13,  13,  2, acFontComic24B_173 } /* code 173 */
  ,{  17,  17,  3, acFontComic24B_174 } /* code 174 */
  ,{  13,  13,  2, acFontComic24B_175 } /* code 175 */
  ,{  13,  13,  2, acFontComic24B_176 } /* code 176 */
  ,{  13,  13,  2, acFontComic24B_177 } /* code 177 */
  ,{  13,  13,  2, acFontComic24B_178 } /* code 178 */
  ,{  13,  13,  2, acFontComic24B_179 } /* code 179 */
  ,{  12,  12,  2, acFontComic24B_180 } /* code 180 */
  ,{  13,  13,  2, acFontComic24B_181 } /* code 181 */
  ,{  16,  16,  2, acFontComic24B_182 } /* code 182 */
  ,{  13,  13,  2, acFontComic24B_183 } /* code 183 */
  ,{  12,  12,  2, acFontComic24B_184 } /* code 184 */
  ,{  13,  13,  2, acFontComic24B_185 } /* code 185 */
  ,{  13,  13,  2, acFontComic24B_186 } /* code 186 */
  ,{  13,  13,  2, acFontComic24B_187 } /* code 187 */
  ,{  13,  13,  2, acFontComic24B_188 } /* code 188 */
  ,{  13,  13,  2, acFontComic24B_189 } /* code 189 */
  ,{  13,  13,  2, acFontComic24B_190 } /* code 190 */
  ,{  12,  12,  2, acFontComic24B_191 } /* code 191 */
  ,{  15,  15,  2, acFontComic24B_192 } /* code 192 */
  ,{  15,  15,  2, acFontComic24B_193 } /* code 193 */
  ,{  15,  15,  2, acFontComic24B_194 } /* code 194 */
  ,{  15,  15,  2, acFontComic24B_195 } /* code 195 */
  ,{  15,  15,  2, acFontComic24B_196 } /* code 196 */
  ,{  15,  15,  2, acFontComic24B_197 } /* code 197 */
  ,{  23,  23,  3, acFontComic24B_198 } /* code 198 */
  ,{  13,  13,  2, acFontComic24B_199 } /* code 199 */
  ,{  13,  13,  2, acFontComic24B_200 } /* code 200 */
  ,{  13,  13,  2, acFontComic24B_201 } /* code 201 */
  ,{  13,  13,  2, acFontComic24B_202 } /* code 202 */
  ,{  13,  13,  2, acFontComic24B_203 } /* code 203 */
  ,{  11,  11,  2, acFontComic24B_204 } /* code 204 */
  ,{  11,  11,  2, acFontComic24B_205 } /* code 205 */
  ,{  11,  11,  2, acFontComic24B_206 } /* code 206 */
  ,{  11,  11,  2, acFontComic24B_207 } /* code 207 */
  ,{  15,  15,  2, acFontComic24B_208 } /* code 208 */
  ,{  17,  17,  3, acFontComic24B_209 } /* code 209 */
  ,{  17,  17,  3, acFontComic24B_210 } /* code 210 */
  ,{  17,  17,  3, acFontComic24B_211 } /* code 211 */
  ,{  17,  17,  3, acFontComic24B_212 } /* code 212 */
  ,{  17,  17,  3, acFontComic24B_213 } /* code 213 */
  ,{  17,  17,  3, acFontComic24B_214 } /* code 214 */
  ,{  13,  13,  2, acFontComic24B_215 } /* code 215 */
  ,{  17,  17,  3, acFontComic24B_216 } /* code 216 */
  ,{  15,  15,  2, acFontComic24B_217 } /* code 217 */
  ,{  15,  15,  2, acFontComic24B_218 } /* code 218 */
  ,{  15,  15,  2, acFontComic24B_219 } /* code 219 */
  ,{  15,  15,  2, acFontComic24B_220 } /* code 220 */
  ,{  13,  13,  2, acFontComic24B_221 } /* code 221 */
  ,{  11,  11,  2, acFontComic24B_222 } /* code 222 */
  ,{  11,  11,  2, acFontComic24B_223 } /* code 223 */
  ,{  12,  12,  2, acFontComic24B_224 } /* code 224 */
  ,{  12,  12,  2, acFontComic24B_225 } /* code 225 */
  ,{  12,  12,  2, acFontComic24B_226 } /* code 226 */
  ,{  12,  12,  2, acFontComic24B_227 } /* code 227 */
  ,{  12,  12,  2, acFontComic24B_228 } /* code 228 */
  ,{  12,  12,  2, acFontComic24B_229 } /* code 229 */
  ,{  19,  19,  3, acFontComic24B_230 } /* code 230 */
  ,{  11,  11,  2, acFontComic24B_231 } /* code 231 */
  ,{  12,  12,  2, acFontComic24B_232 } /* code 232 */
  ,{  12,  12,  2, acFontComic24B_233 } /* code 233 */
  ,{  12,  12,  2, acFontComic24B_234 } /* code 234 */
  ,{  12,  12,  2, acFontComic24B_235 } /* code 235 */
  ,{   6,   6,  1, acFontComic24B_236 } /* code 236 */
  ,{   6,   6,  1, acFontComic24B_237 } /* code 237 */
  ,{   6,   6,  1, acFontComic24B_238 } /* code 238 */
  ,{   6,   6,  1, acFontComic24B_239 } /* code 239 */
  ,{  11,  11,  2, acFontComic24B_240 } /* code 240 */
  ,{  11,  11,  2, acFontComic24B_241 } /* code 241 */
  ,{  11,  11,  2, acFontComic24B_242 } /* code 242 */
  ,{  11,  11,  2, acFontComic24B_243 } /* code 243 */
  ,{  11,  11,  2, acFontComic24B_244 } /* code 244 */
  ,{  11,  11,  2, acFontComic24B_245 } /* code 245 */
  ,{  11,  11,  2, acFontComic24B_246 } /* code 246 */
  ,{  13,  13,  2, acFontComic24B_247 } /* code 247 */
  ,{  11,  11,  2, acFontComic24B_248 } /* code 248 */
  ,{  11,  11,  2, acFontComic24B_249 } /* code 249 */
  ,{  11,  11,  2, acFontComic24B_250 } /* code 250 */
  ,{  11,  11,  2, acFontComic24B_251 } /* code 251 */
  ,{  11,  11,  2, acFontComic24B_252 } /* code 252 */
  ,{  12,  12,  2, acFontComic24B_253 } /* code 253 */
  ,{  11,  11,  2, acFontComic24B_254 } /* code 254 */
  ,{  12,  12,  2, acFontComic24B_255 } /* code 255 */
};

GUI_CONST_STORAGE GUI_FONT_PROP FontComic24BProp_1_160_255 = {
   160                      /* first character               */
  ,255                      /* last character                */
  ,CharInfo24B_160_255      /* address of first character    */
  ,(const GUI_FONT_PROP*)0  /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP FontComic24BProp_1_ASCII = {
   32                         /* first character               */
  ,127                        /* last character                */
  ,CharInfo24B_ASCII          /* address of first character    */
  ,&FontComic24BProp_1_160_255 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontComic24B_1 = {
   GUI_FONTTYPE_PROP  /* type of font    */
  ,24                 /* height of font  */
  ,24                 /* space of font y */
  ,1                  /* magnification x */
  ,1                  /* magnification y */
  ,{&FontComic24BProp_1_ASCII}
  ,20, 12, 17
};

