/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : FD64.C
Purpose     : Implementation of the non-proportional 48 by 64 pixel digit font
Height      : 64
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

GUI_CONST_STORAGE unsigned char acFontD48x64[15][384] = {
{
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,_XXXXXXX,XXXXX___,____XXXX,XXXXXXXX,________,
  ________,XXXXXXXX,XXXX____,_____XXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XX______,_______X,XXXXXXXX,XX______,
  _______X,XXXXXXXX,X_______,________,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,X_______,________,XXXXXXXX,XXX_____,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXX_____,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXX_____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXX___,________,________,____XXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXX___,________,________,____XXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXX_____,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXX_____,
  ______XX,XXXXXXXX,X_______,________,XXXXXXXX,XXX_____,
  _______X,XXXXXXXX,X_______,________,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XX______,_______X,XXXXXXXX,XX______,
  ________,XXXXXXXX,XXXX____,_____XXX,XXXXXXXX,X_______,
  ________,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,________,_XXXXXXX,XXXXXXXX,________,________,
  ________,________,____XXXX,XXXXX___,________,________},

{
  ________,________,_______X,XXXXXXX_,________,________,
  ________,________,_______X,XXXXXXX_,________,________,
  ________,________,_______X,XXXXXXX_,________,________,
  ________,________,______XX,XXXXXXX_,________,________,
  ________,________,______XX,XXXXXXX_,________,________,
  ________,________,_____XXX,XXXXXXX_,________,________,
  ________,________,_____XXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,___XXXXX,XXXXXXX_,________,________,
  ________,________,_XXXXXXX,XXXXXXX_,________,________,
  ________,_______X,XXXXXXXX,XXXXXXX_,________,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXXX_,________,________},

{
  ________,________,_____XXX,XXXXXX__,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XX______,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,_XXXXXXX,XXXXXX__,_____XXX,XXXXXXXX,XX______,
  ________,XXXXXXXX,XXXX____,_______X,XXXXXXXX,XXX_____,
  ________,XXXXXXXX,XXX_____,________,XXXXXXXX,XXX_____,
  _______X,XXXXXXXX,XX______,________,_XXXXXXX,XXXX____,
  _______X,XXXXXXXX,X_______,________,__XXXXXX,XXXX____,
  _______X,XXXXXXXX,X_______,________,__XXXXXX,XXXX____,
  ______XX,XXXXXXXX,________,________,__XXXXXX,XXXX____,
  ______XX,XXXXXXXX,________,________,___XXXXX,XXXXX___,
  ______XX,XXXXXXXX,________,________,___XXXXX,XXXXX___,
  ______XX,XXXXXXXX,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  ________,________,________,________,__XXXXXX,XXXX____,
  ________,________,________,________,_XXXXXXX,XXXX____,
  ________,________,________,________,_XXXXXXX,XXX_____,
  ________,________,________,________,XXXXXXXX,XXX_____,
  ________,________,________,_______X,XXXXXXXX,XX______,
  ________,________,________,______XX,XXXXXXXX,XX______,
  ________,________,________,_____XXX,XXXXXXXX,X_______,
  ________,________,________,____XXXX,XXXXXXXX,________,
  ________,________,________,___XXXXX,XXXXXXX_,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,
  ________,________,________,XXXXXXXX,XXXXXX__,________,
  ________,________,_______X,XXXXXXXX,XXXXX___,________,
  ________,________,_____XXX,XXXXXXXX,XXX_____,________,
  ________,________,____XXXX,XXXXXXXX,XX______,________,
  ________,________,___XXXXX,XXXXXXXX,X_______,________,
  ________,________,_XXXXXXX,XXXXXXXX,________,________,
  ________,________,XXXXXXXX,XXXXXX__,________,________,
  ________,_______X,XXXXXXXX,XXXXX___,________,________,
  ________,______XX,XXXXXXXX,XXXX____,________,________,
  ________,____XXXX,XXXXXXXX,XX______,________,________,
  ________,___XXXXX,XXXXXXXX,X_______,________,________,
  ________,___XXXXX,XXXXXXX_,________,________,________,
  ________,__XXXXXX,XXXXXX__,________,________,________,
  ________,_XXXXXXX,XXXXX___,________,________,________,
  ________,XXXXXXXX,XXXX____,________,________,________,
  ________,XXXXXXXX,XXX_____,________,________,________,
  _______X,XXXXXXXX,XX______,________,________,________,
  _______X,XXXXXXXX,X_______,________,________,________,
  ______XX,XXXXXXXX,________,________,________,________,
  ______XX,XXXXXXXX,________,________,________,________,
  _____XXX,XXXXXXXX,________,________,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___},

{
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XXX_____,______XX,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XX______,_______X,XXXXXXXX,XXX_____,
  ______XX,XXXXXXXX,X_______,________,XXXXXXXX,XXX_____,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,_XXXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXX__,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXX_____,
  ________,________,________,________,_XXXXXXX,XXX_____,
  ________,________,________,________,_XXXXXXX,XXX_____,
  ________,________,________,________,XXXXXXXX,XX______,
  ________,________,________,________,XXXXXXXX,XX______,
  ________,________,________,______XX,XXXXXXXX,X_______,
  ________,________,________,_____XXX,XXXXXXXX,X_______,
  ________,________,________,__XXXXXX,XXXXXXX_,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXX__,________,
  ________,________,____XXXX,XXXXXXXX,XXXX____,________,
  ________,________,____XXXX,XXXXXXXX,XXXX____,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXX_,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXXX,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,________,____XXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,________,________,____XXXX,XXXXXXXX,XXX_____,
  ________,________,________,_______X,XXXXXXXX,XXXX____,
  ________,________,________,________,_XXXXXXX,XXXX____,
  ________,________,________,________,__XXXXXX,XXXXX___,
  ________,________,________,________,__XXXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,__XXXXXX,XXXXX___,
  _____XXX,XXXXXXXX,________,________,_XXXXXXX,XXXX____,
  _____XXX,XXXXXXXX,X_______,________,XXXXXXXX,XXXX____,
  ______XX,XXXXXXXX,XX______,_______X,XXXXXXXX,XXX_____,
  ______XX,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,XXX_____,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,________,___XXXXX,XXXXX___,________,________},

{
  ________,________,________,______XX,XXXXXX__,________,
  ________,________,________,______XX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,____XXXX,XXXXXX__,________,
  ________,________,________,___XXXXX,XXXXXX__,________,
  ________,________,________,___XXXXX,XXXXXX__,________,
  ________,________,________,__XXXXXX,XXXXXX__,________,
  ________,________,________,_XXXXXXX,XXXXXX__,________,
  ________,________,________,XXXXXXXX,XXXXXX__,________,
  ________,________,________,XXXXXXXX,XXXXXX__,________,
  ________,________,_______X,XXXXXXXX,XXXXXX__,________,
  ________,________,______XX,XXXXXXXX,XXXXXX__,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXX__,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXX__,________,
  ________,________,____XXXX,XXXX_XXX,XXXXXX__,________,
  ________,________,___XXXXX,XXXX_XXX,XXXXXX__,________,
  ________,________,___XXXXX,XXX__XXX,XXXXXX__,________,
  ________,________,__XXXXXX,XX___XXX,XXXXXX__,________,
  ________,________,_XXXXXXX,XX___XXX,XXXXXX__,________,
  ________,________,XXXXXXXX,X____XXX,XXXXXX__,________,
  ________,________,XXXXXXXX,_____XXX,XXXXXX__,________,
  ________,_______X,XXXXXXX_,_____XXX,XXXXXX__,________,
  ________,______XX,XXXXXXX_,_____XXX,XXXXXX__,________,
  ________,_____XXX,XXXXXX__,_____XXX,XXXXXX__,________,
  ________,_____XXX,XXXXX___,_____XXX,XXXXXX__,________,
  ________,____XXXX,XXXXX___,_____XXX,XXXXXX__,________,
  ________,___XXXXX,XXXX____,_____XXX,XXXXXX__,________,
  ________,__XXXXXX,XXX_____,_____XXX,XXXXXX__,________,
  ________,__XXXXXX,XXX_____,_____XXX,XXXXXX__,________,
  ________,_XXXXXXX,XX______,_____XXX,XXXXXX__,________,
  ________,XXXXXXXX,X_______,_____XXX,XXXXXX__,________,
  ________,XXXXXXXX,________,_____XXX,XXXXXX__,________,
  _______X,XXXXXXXX,________,_____XXX,XXXXXX__,________,
  ______XX,XXXXXXX_,________,_____XXX,XXXXXX__,________,
  _____XXX,XXXXXX__,________,_____XXX,XXXXXX__,________,
  _____XXX,XXXXXX__,________,_____XXX,XXXXXX__,________,
  ____XXXX,XXXXX___,________,_____XXX,XXXXXX__,________,
  ___XXXXX,XXXX____,________,_____XXX,XXXXXX__,________,
  ___XXXXX,XXXX____,________,_____XXX,XXXXXX__,________,
  ___XXXXX,XXX_____,________,_____XXX,XXXXXX__,________,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,_____XXX,XXXXXX__,________},

{
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,
  ________,_XXXXXXX,XX______,________,________,________,
  ________,_XXXXXXX,XX______,________,________,________,
  ________,_XXXXXXX,XX______,________,________,________,
  ________,_XXXXXXX,XX______,________,________,________,
  ________,XXXXXXXX,XX______,________,________,________,
  ________,XXXXXXXX,X_______,________,________,________,
  ________,XXXXXXXX,X_______,________,________,________,
  ________,XXXXXXXX,X_______,________,________,________,
  ________,XXXXXXXX,X_______,________,________,________,
  _______X,XXXXXXXX,X_______,________,________,________,
  _______X,XXXXXXXX,________,________,________,________,
  _______X,XXXXXXXX,________,________,________,________,
  _______X,XXXXXXXX,_______X,XXXXXXX_,________,________,
  _______X,XXXXXXXX,____XXXX,XXXXXXXX,XX______,________,
  ______XX,XXXXXXX_,__XXXXXX,XXXXXXXX,XXXX____,________,
  ______XX,XXXXXXX_,_XXXXXXX,XXXXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XXXX____,____XXXX,XXXXXXXX,XXX_____,
  _____XXX,XXXXXXXX,XX______,______XX,XXXXXXXX,XXX_____,
  _____XXX,XXXXXXXX,________,________,XXXXXXXX,XXXX____,
  _____XXX,XXXXXXX_,________,________,_XXXXXXX,XXXX____,
  ____XXXX,XXXXXXX_,________,________,__XXXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ________,________,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXXX_,________,________,__XXXXXX,XXXX____,
  _____XXX,XXXXXXXX,________,________,_XXXXXXX,XXXX____,
  _____XXX,XXXXXXXX,X_______,________,XXXXXXXX,XXX_____,
  _____XXX,XXXXXXXX,XX______,_______X,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,________,____XXXX,XXXXX___,________,________},

{
  ________,________,______XX,XXXXXXX_,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XX______,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,__XXXXXX,XXXXXX__,_____XXX,XXXXXXXX,XX______,
  ________,_XXXXXXX,XXXXX___,_______X,XXXXXXXX,XXX_____,
  ________,XXXXXXXX,XXX_____,________,XXXXXXXX,XXX_____,
  ________,XXXXXXXX,XX______,________,_XXXXXXX,XXXX____,
  _______X,XXXXXXXX,X_______,________,__XXXXXX,XXXX____,
  _______X,XXXXXXXX,X_______,________,__XXXXXX,XXXX____,
  ______XX,XXXXXXXX,________,________,___XXXXX,XXXXX___,
  ______XX,XXXXXXXX,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,________,___XX___,
  _____XXX,XXXXXXX_,________,________,________,________,
  _____XXX,XXXXXXX_,________,________,________,________,
  _____XXX,XXXXXX__,________,________,________,________,
  ____XXXX,XXXXXX__,________,________,________,________,
  ____XXXX,XXXXXX__,________,________,________,________,
  ____XXXX,XXXXXX__,________,________,________,________,
  ____XXXX,XXXXXX__,_______X,XXXXXXX_,________,________,
  ____XXXX,XXXXXX__,____XXXX,XXXXXXXX,XX______,________,
  ___XXXXX,XXXXX___,__XXXXXX,XXXXXXXX,XXXX____,________,
  ___XXXXX,XXXXX___,_XXXXXXX,XXXXXXXX,XXXXXX__,________,
  ___XXXXX,XXXXX__X,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ___XXXXX,XXXXX__X,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ___XXXXX,XXXXX_XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXX__,_____XXX,XXXXXXXX,XXX_____,
  ___XXXXX,XXXXXXXX,XXX_____,_______X,XXXXXXXX,XXX_____,
  ___XXXXX,XXXXXXXX,XX______,________,XXXXXXXX,XXXX____,
  ___XXXXX,XXXXXXXX,X_______,________,_XXXXXXX,XXXX____,
  ___XXXXX,XXXXXXXX,________,________,__XXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,________,________,__XXXXXX,XXXXX___,
  ___XXXXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,____XXXX,XXXXXX__,
  _____XXX,XXXXXXX_,________,________,____XXXX,XXXXXX__,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  _____XXX,XXXXXXX_,________,________,___XXXXX,XXXXX___,
  ______XX,XXXXXXXX,________,________,__XXXXXX,XXXXX___,
  ______XX,XXXXXXXX,________,________,__XXXXXX,XXXXX___,
  ______XX,XXXXXXXX,X_______,________,_XXXXXXX,XXXX____,
  _______X,XXXXXXXX,XX______,________,XXXXXXXX,XXXX____,
  _______X,XXXXXXXX,XXX_____,_______X,XXXXXXXX,XXX_____,
  ________,XXXXXXXX,XXXXXX__,_____XXX,XXXXXXXX,XX______,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,________,_XXXXXXX,XXXXXXXX,XX______,________,
  ________,________,_____XXX,XXXXXX__,________,________},

{
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,__XXXXXX,XXXX____,
  ________,________,________,________,__XXXXXX,XXXX____,
  ________,________,________,________,_XXXXXXX,XXX_____,
  ________,________,________,________,_XXXXXXX,XX______,
  ________,________,________,________,XXXXXXXX,X_______,
  ________,________,________,_______X,XXXXXXXX,________,
  ________,________,________,______XX,XXXXXXXX,________,
  ________,________,________,_____XXX,XXXXXXX_,________,
  ________,________,________,_____XXX,XXXXXX__,________,
  ________,________,________,____XXXX,XXXXX___,________,
  ________,________,________,___XXXXX,XXXXX___,________,
  ________,________,________,__XXXXXX,XXXX____,________,
  ________,________,________,__XXXXXX,XXX_____,________,
  ________,________,________,_XXXXXXX,XXX_____,________,
  ________,________,________,XXXXXXXX,XX______,________,
  ________,________,________,XXXXXXXX,X_______,________,
  ________,________,_______X,XXXXXXXX,X_______,________,
  ________,________,_______X,XXXXXXXX,________,________,
  ________,________,______XX,XXXXXXXX,________,________,
  ________,________,_____XXX,XXXXXXX_,________,________,
  ________,________,_____XXX,XXXXXXX_,________,________,
  ________,________,____XXXX,XXXXXX__,________,________,
  ________,________,____XXXX,XXXXXX__,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,__XXXXXX,XXXX____,________,________,
  ________,________,__XXXXXX,XXXX____,________,________,
  ________,________,__XXXXXX,XXXX____,________,________,
  ________,________,_XXXXXXX,XXX_____,________,________,
  ________,________,_XXXXXXX,XXX_____,________,________,
  ________,________,XXXXXXXX,XX______,________,________,
  ________,________,XXXXXXXX,XX______,________,________,
  ________,________,XXXXXXXX,XX______,________,________,
  ________,_______X,XXXXXXXX,XX______,________,________,
  ________,_______X,XXXXXXXX,X_______,________,________,
  ________,_______X,XXXXXXXX,X_______,________,________,
  ________,______XX,XXXXXXXX,X_______,________,________,
  ________,______XX,XXXXXXXX,________,________,________,
  ________,______XX,XXXXXXXX,________,________,________,
  ________,_____XXX,XXXXXXXX,________,________,________,
  ________,_____XXX,XXXXXXXX,________,________,________,
  ________,_____XXX,XXXXXXXX,________,________,________,
  ________,_____XXX,XXXXXXX_,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,
  ________,____XXXX,XXXXXX__,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________},

{
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XXX_____,______XX,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XX______,_______X,XXXXXXXX,XX______,
  _______X,XXXXXXXX,X_______,________,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXX_____,
  ______XX,XXXXXXXX,________,________,_XXXXXXX,XXX_____,
  ______XX,XXXXXXX_,________,________,__XXXXXX,XXX_____,
  ______XX,XXXXXXX_,________,________,__XXXXXX,XXX_____,
  ______XX,XXXXXXX_,________,________,__XXXXXX,XXX_____,
  ______XX,XXXXXXX_,________,________,__XXXXXX,XXX_____,
  ______XX,XXXXXXX_,________,________,__XXXXXX,XXX_____,
  ______XX,XXXXXXX_,________,________,__XXXXXX,XXX_____,
  _______X,XXXXXXX_,________,________,__XXXXXX,XX______,
  _______X,XXXXXXXX,________,________,_XXXXXXX,XX______,
  _______X,XXXXXXXX,________,________,_XXXXXXX,XX______,
  ________,XXXXXXXX,X_______,________,XXXXXXXX,X_______,
  ________,XXXXXXXX,XX______,_______X,XXXXXXXX,X_______,
  ________,_XXXXXXX,XXX_____,______XX,XXXXXXXX,________,
  ________,__XXXXXX,XXXXX___,____XXXX,XXXXXXX_,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,XXX_____,
  _____XXX,XXXXXXXX,XX______,_______X,XXXXXXXX,XXXX____,
  _____XXX,XXXXXXXX,X_______,________,XXXXXXXX,XXXX____,
  ____XXXX,XXXXXXXX,________,________,_XXXXXXX,XXXXX___,
  ____XXXX,XXXXXXX_,________,________,__XXXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXX__,
  ___XXXXX,XXXXXX__,________,________,___XXXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXX__,________,________,___XXXXX,XXXXX___,
  ____XXXX,XXXXXXX_,________,________,__XXXXXX,XXXXX___,
  _____XXX,XXXXXXXX,________,________,_XXXXXXX,XXXX____,
  _____XXX,XXXXXXXX,X_______,________,XXXXXXXX,XXXX____,
  ______XX,XXXXXXXX,XX______,_______X,XXXXXXXX,XXX_____,
  ______XX,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,XXX_____,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,________,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,________,____XXXX,XXXXX___,________,________},

{
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,___XXXXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XX______,_____XXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,X_______,_______X,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,________,________,XXXXXXXX,XXX_____,
  ____XXXX,XXXXXXX_,________,________,_XXXXXXX,XXX_____,
  ____XXXX,XXXXXXX_,________,________,_XXXXXXX,XXX_____,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXX____,
  ___XXXXX,XXXXX___,________,________,__XXXXXX,XXXX____,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXX___,
  ___XXXXX,XXXXX___,________,________,___XXXXX,XXXXXX__,
  ___XXXXX,XXXXXX__,________,________,__XXXXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXXXX__,
  ____XXXX,XXXXXX__,________,________,__XXXXXX,XXXXXX__,
  ____XXXX,XXXXXXX_,________,________,_XXXXXXX,XXXXXX__,
  ____XXXX,XXXXXXX_,________,________,_XXXXXXX,XXXXXX__,
  _____XXX,XXXXXXXX,________,________,XXXXXXXX,XXXXXX__,
  _____XXX,XXXXXXXX,X_______,_______X,XXXXXXXX,XXXXXX__,
  ______XX,XXXXXXXX,XX______,_____XXX,XXXXXXXX,XXXXXX__,
  ______XX,XXXXXXXX,XXXX____,___XXXXX,XXXXXXXX,XXXXXX__,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_XXXX,XXXXXX__,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XX__XXXX,XXXXXX__,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XX__XXXX,XXXXXX__,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,____XXXX,XXXXXX__,
  ________,_____XXX,XXXXXXXX,XXXXXXX_,____XXXX,XXXXX___,
  ________,_______X,XXXXXXXX,XXXXX___,___XXXXX,XXXXX___,
  ________,________,__XXXXXX,XX______,___XXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXXX___,
  ________,________,________,________,___XXXXX,XXXX____,
  ________,________,________,________,__XXXXXX,XXXX____,
  ________,________,________,________,__XXXXXX,XXXX____,
  ____XX__,________,________,________,__XXXXXX,XXXX____,
  ____XXXX,XXXXXX__,________,________,_XXXXXXX,XXX_____,
  ____XXXX,XXXXXX__,________,________,_XXXXXXX,XXX_____,
  _____XXX,XXXXXXX_,________,________,XXXXXXXX,XX______,
  _____XXX,XXXXXXX_,________,________,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,________,_______X,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,X_______,______XX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XX______,_____XXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,___XXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,_______X,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,__XXXXXX,XXX_____,________,________},

{
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,____XXXX,XXXXX___,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________},

{
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________},

{
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________},

{
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,________,________,________,________},

{
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,________,________,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXX___,________,________,
  ________,________,________,________,________,________}
};

GUI_CONST_STORAGE GUI_CHARINFO GUI_FontD48x64_CharInfo[15] = {
   {  48,  48,  6, acFontD48x64[12] } /* code 0020 ' ' */
  ,{  48,  48,  6, acFontD48x64[10] } /* code 002B '+' */
  ,{  48,  48,  6, acFontD48x64[11] } /* code 002D '-' */
  ,{  48,  48,  6, acFontD48x64[13] } /* code 002E '.' */
  ,{  48,  48,  6, acFontD48x64[0]  } /* code 0030 '0' */
  ,{  48,  48,  6, acFontD48x64[1]  } /* code 0031 '1' */
  ,{  48,  48,  6, acFontD48x64[2]  } /* code 0032 '2' */
  ,{  48,  48,  6, acFontD48x64[3]  } /* code 0033 '3' */
  ,{  48,  48,  6, acFontD48x64[4]  } /* code 0034 '4' */
  ,{  48,  48,  6, acFontD48x64[5]  } /* code 0035 '5' */
  ,{  48,  48,  6, acFontD48x64[6]  } /* code 0036 '6' */
  ,{  48,  48,  6, acFontD48x64[7]  } /* code 0037 '7' */
  ,{  48,  48,  6, acFontD48x64[8]  } /* code 0038 '8' */
  ,{  48,  48,  6, acFontD48x64[9]  } /* code 0039 '9' */
  ,{  48,  48,  6, acFontD48x64[14] } /* code 003A ':' */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD48x64_Prop4 = {
   0x0030 /* first character */
  ,0x003A /* last character  */
  ,&GUI_FontD48x64_CharInfo[  4] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP*)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD48x64_Prop3 = {
   0x002D /* first character */
  ,0x002E /* last character  */
  ,&GUI_FontD48x64_CharInfo[  2] /* address of first character */
  ,&GUI_FontD48x64_Prop4 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD48x64_Prop2 = {
   0x002B /* first character */
  ,0x002B /* last character  */
  ,&GUI_FontD48x64_CharInfo[  1] /* address of first character */
  ,&GUI_FontD48x64_Prop3 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD48x64_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_FontD48x64_CharInfo[  0] /* address of first character */
  ,&GUI_FontD48x64_Prop2 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontD48x64 = {
   GUI_FONTTYPE_PROP /* type of font    */
  ,64 /* height of font  */
  ,64 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontD48x64_Prop1}
  ,64 /* Baseline */
  ,0 /* LHeight */
  ,64 /* CHeight */
};

