/*
*********************************************************************************************************
*                                                uC/GUI
*                        Universal graphic software for embedded applications
*
*                       (c) Copyright 2002, Micrium Inc., Weston, FL
*                       (c) Copyright 2002, SEGGER Microcontroller Systeme GmbH
*
*              C/GUI is protected by international copyright laws. Knowledge of the
*              source code may not be used to write a similar product. This file may
*              only be used in accordance with a license and should not be redistributed
*              in any way. We appreciate your understanding and fairness.
*
----------------------------------------------------------------------
File        : FD80.C
Purpose     : Implementation of the proportional 80 pixel digit
Height      : 80
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI_FontIntern.h"

GUI_CONST_STORAGE unsigned char acFontD80[12][640] = {
{
  ________,________,________,__XXXXXX,XXX_____,________,________,________,
  ________,________,______XX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,___XXXXX,XXXXXXXX,XXXXXXXX,X_______,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,___XXXXX,XXXXXXXX,XXX_____,__XXXXXX,XXXXXXXX,XX______,________,
  ________,__XXXXXX,XXXXXXXX,X_______,____XXXX,XXXXXXXX,XXX_____,________,
  ________,__XXXXXX,XXXXXXXX,________,_____XXX,XXXXXXXX,XXX_____,________,
  ________,_XXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXX____,________,
  ________,_XXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXX____,________,
  ________,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXX___,________,
  _______X,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXX____,________,
  ________,_XXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXXXX,________,_____XXX,XXXXXXXX,XXX_____,________,
  ________,__XXXXXX,XXXXXXXX,X_______,____XXXX,XXXXXXXX,XXX_____,________,
  ________,___XXXXX,XXXXXXXX,XXX_____,__XXXXXX,XXXXXXXX,XX______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,___XXXXX,XXXXXXXX,XXXXXXXX,XX______,________,________,
  ________,________,______XX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,__XXXXXX,XXX_____,________,________,________},

{
  ________,________,________,_____XXX,XXXXXXX_,________,________,________,
  ________,________,________,_____XXX,XXXXXXX_,________,________,________,
  ________,________,________,_____XXX,XXXXXXX_,________,________,________,
  ________,________,________,____XXXX,XXXXXXX_,________,________,________,
  ________,________,________,____XXXX,XXXXXXX_,________,________,________,
  ________,________,________,___XXXXX,XXXXXXX_,________,________,________,
  ________,________,________,___XXXXX,XXXXXXX_,________,________,________,
  ________,________,________,__XXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,_______X,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,______XX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXXX_,________,________,________},

{
  ________,________,________,___XXXXX,XXXXX___,________,________,________,
  ________,________,_______X,XXXXXXXX,XXXXXXXX,X_______,________,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,XXX_____,___XXXXX,XXXXXXXX,XXXXX___,________,
  ________,__XXXXXX,XXXXXXXX,X_______,______XX,XXXXXXXX,XXXXXX__,________,
  ________,_XXXXXXX,XXXXXXXX,________,_______X,XXXXXXXX,XXXXXX__,________,
  ________,_XXXXXXX,XXXXXX__,________,________,_XXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXX__,________,________,_XXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXX___,________,________,__XXXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  ________,________,________,________,________,__XXXXXX,XXXXXXXX,________,
  ________,________,________,________,________,__XXXXXX,XXXXXXXX,________,
  ________,________,________,________,________,__XXXXXX,XXXXXXX_,________,
  ________,________,________,________,________,_XXXXXXX,XXXXXXX_,________,
  ________,________,________,________,________,XXXXXXXX,XXXXXX__,________,
  ________,________,________,________,_______X,XXXXXXXX,XXXXXX__,________,
  ________,________,________,________,______XX,XXXXXXXX,XXXXX___,________,
  ________,________,________,________,_____XXX,XXXXXXXX,XXXX____,________,
  ________,________,________,________,____XXXX,XXXXXXXX,XXXX____,________,
  ________,________,________,________,___XXXXX,XXXXXXXX,XXX_____,________,
  ________,________,________,________,__XXXXXX,XXXXXXXX,XX______,________,
  ________,________,________,________,_XXXXXXX,XXXXXXXX,X_______,________,
  ________,________,________,_______X,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,______XX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,________,____XXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,________,________,___XXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXX____,________,________,
  ________,________,________,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,_______X,XXXXXXXX,XXXXXXXX,X_______,________,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXX_,________,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXX___,________,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXX____,________,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XX______,________,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,X_______,________,________,________,
  ________,______XX,XXXXXXXX,XXXXXXX_,________,________,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXX__,________,________,________,________,
  ________,____XXXX,XXXXXXXX,XXXX____,________,________,________,________,
  ________,___XXXXX,XXXXXXXX,XXX_____,________,________,________,________,
  ________,__XXXXXX,XXXXXXXX,XX______,________,________,________,________,
  ________,__XXXXXX,XXXXXXXX,X_______,________,________,________,________,
  ________,_XXXXXXX,XXXXXXXX,________,________,________,________,________,
  ________,XXXXXXXX,XXXXXXX_,________,________,________,________,________,
  ________,XXXXXXXX,XXXXXX__,________,________,________,________,________,
  _______X,XXXXXXXX,XXXXX___,________,________,________,________,________,
  _______X,XXXXXXXX,XXXX____,________,________,________,________,________,
  ______XX,XXXXXXXX,XXXX____,________,________,________,________,________,
  ______XX,XXXXXXXX,XXX_____,________,________,________,________,________,
  ______XX,XXXXXXXX,XXX_____,________,________,________,________,________,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______},

{
  ________,________,________,__XXXXXX,XXXX____,________,________,________,
  ________,________,______XX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,___XXXXX,XXXXXXXX,XXXXXXXX,XX______,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,__XXXXXX,XXXXXXXX,XXX_____,__XXXXXX,XXXXXXXX,XXXX____,________,
  ________,_XXXXXXX,XXXXXXXX,X_______,_____XXX,XXXXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXX__,________,
  _____XXX,XXXXXXXX,XX______,________,________,_XXXXXXX,XXXXXX__,________,
  ________,________,________,________,________,_XXXXXXX,XXXXXX__,________,
  ________,________,________,________,________,_XXXXXXX,XXXXXX__,________,
  ________,________,________,________,________,XXXXXXXX,XXXXX___,________,
  ________,________,________,________,_______X,XXXXXXXX,XXXXX___,________,
  ________,________,________,________,______XX,XXXXXXXX,XXXX____,________,
  ________,________,________,________,_____XXX,XXXXXXXX,XXX_____,________,
  ________,________,________,________,___XXXXX,XXXXXXXX,XXX_____,________,
  ________,________,________,________,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,________,________,________,__XXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,________,________,________,______XX,XXXXXXXX,XXXXXX__,________,
  ________,________,________,________,________,XXXXXXXX,XXXXXXX_,________,
  ________,________,________,________,________,_XXXXXXX,XXXXXXXX,________,
  ________,________,________,________,________,__XXXXXX,XXXXXXXX,________,
  ________,________,________,________,________,___XXXXX,XXXXXXXX,________,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,X_______,________,________,_____XXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXXXX___,________,________,_XXXXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXXXXX,XX______,___XXXXX,XXXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,________,XXXXXXXX,XXXX____,________,________,________},

{
  ________,________,________,________,_____XXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,___XXXXX,XXXXXXXX,________,________,
  ________,________,________,________,__XXXXXX,XXXXXXXX,________,________,
  ________,________,________,________,__XXXXXX,XXXXXXXX,________,________,
  ________,________,________,________,_XXXXXXX,XXXXXXXX,________,________,
  ________,________,________,________,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_______X,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_______X,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,______XX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_____XXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_____XXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,____XXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,___XXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,___XXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,________,XXXXXXXX,XXX_XXXX,XXXXXXXX,________,________,
  ________,________,________,XXXXXXXX,XX__XXXX,XXXXXXXX,________,________,
  ________,________,_______X,XXXXXXXX,XX__XXXX,XXXXXXXX,________,________,
  ________,________,______XX,XXXXXXXX,X___XXXX,XXXXXXXX,________,________,
  ________,________,______XX,XXXXXXXX,____XXXX,XXXXXXXX,________,________,
  ________,________,_____XXX,XXXXXXX_,____XXXX,XXXXXXXX,________,________,
  ________,________,____XXXX,XXXXXXX_,____XXXX,XXXXXXXX,________,________,
  ________,________,___XXXXX,XXXXXX__,____XXXX,XXXXXXXX,________,________,
  ________,________,___XXXXX,XXXXX___,____XXXX,XXXXXXXX,________,________,
  ________,________,__XXXXXX,XXXXX___,____XXXX,XXXXXXXX,________,________,
  ________,________,_XXXXXXX,XXXX____,____XXXX,XXXXXXXX,________,________,
  ________,________,_XXXXXXX,XXX_____,____XXXX,XXXXXXXX,________,________,
  ________,________,XXXXXXXX,XXX_____,____XXXX,XXXXXXXX,________,________,
  ________,_______X,XXXXXXXX,XX______,____XXXX,XXXXXXXX,________,________,
  ________,______XX,XXXXXXXX,X_______,____XXXX,XXXXXXXX,________,________,
  ________,______XX,XXXXXXXX,X_______,____XXXX,XXXXXXXX,________,________,
  ________,_____XXX,XXXXXXXX,________,____XXXX,XXXXXXXX,________,________,
  ________,____XXXX,XXXXXXX_,________,____XXXX,XXXXXXXX,________,________,
  ________,____XXXX,XXXXXXX_,________,____XXXX,XXXXXXXX,________,________,
  ________,___XXXXX,XXXXXX__,________,____XXXX,XXXXXXXX,________,________,
  ________,__XXXXXX,XXXXX___,________,____XXXX,XXXXXXXX,________,________,
  ________,_XXXXXXX,XXXXX___,________,____XXXX,XXXXXXXX,________,________,
  ________,_XXXXXXX,XXXX____,________,____XXXX,XXXXXXXX,________,________,
  ________,XXXXXXXX,XXX_____,________,____XXXX,XXXXXXXX,________,________,
  _______X,XXXXXXXX,XXX_____,________,____XXXX,XXXXXXXX,________,________,
  _______X,XXXXXXXX,XX______,________,____XXXX,XXXXXXXX,________,________,
  ______XX,XXXXXXXX,X_______,________,____XXXX,XXXXXXXX,________,________,
  _____XXX,XXXXXXXX,X_______,________,____XXXX,XXXXXXXX,________,________,
  _____XXX,XXXXXXXX,________,________,____XXXX,XXXXXXXX,________,________,
  ____XXXX,XXXXXXX_,________,________,____XXXX,XXXXXXXX,________,________,
  ___XXXXX,XXXXXX__,________,________,____XXXX,XXXXXXXX,________,________,
  ___XXXXX,XXXXXX__,________,________,____XXXX,XXXXXXXX,________,________,
  ___XXXXX,XXXXX___,________,________,____XXXX,XXXXXXXX,________,________,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________},

{
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  ________,____XXXX,XXXXXXXX,________,________,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,________,________,
  ________,____XXXX,XXXXXXX_,________,________,________,________,________,
  ________,___XXXXX,XXXXXXX_,________,________,________,________,________,
  ________,___XXXXX,XXXXXXX_,________,________,________,________,________,
  ________,___XXXXX,XXXXXXX_,________,________,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________,________,________,
  ________,___XXXXX,XXXXXX__,________,________,________,________,________,
  ________,__XXXXXX,XXXXXX__,________,________,________,________,________,
  ________,__XXXXXX,XXXXXX__,________,________,________,________,________,
  ________,__XXXXXX,XXXXX___,________,________,________,________,________,
  ________,__XXXXXX,XXXXX___,________,________,________,________,________,
  ________,__XXXXXX,XXXXX___,________,________,________,________,________,
  ________,_XXXXXXX,XXXXX___,________,________,________,________,________,
  ________,_XXXXXXX,XXXXX___,________,________,________,________,________,
  ________,_XXXXXXX,XXXX____,______XX,XXXXXX__,________,________,________,
  ________,_XXXXXXX,XXXX____,__XXXXXX,XXXXXXXX,XX______,________,________,
  ________,_XXXXXXX,XXXX____,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,XXXXXXXX,XXXX__XX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,XXXXXXXX,XXXX_XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,XXXXXXXX,XXX_XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  _______X,XXXXXXXX,XXXXXXXX,XX______,___XXXXX,XXXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXXXXX_,________,_____XXX,XXXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXXX,________,
  ________,________,________,________,________,___XXXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,X_______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ________,________,________,________,________,_____XXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,X_______,________,________,_____XXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,_____XXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,____XXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXXX____,________,________,__XXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXXXX___,________,________,_XXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXXXXX,________,______XX,XXXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXXXXXX,XXX_____,___XXXXX,XXXXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________},

{
  ________,________,________,____XXXX,XXXXX___,________,________,________,
  ________,________,________,XXXXXXXX,XXXXXXXX,X_______,________,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,____XXXX,XXXXXXXX,XXXXX___,____XXXX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,XX______,______XX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,X_______,_______X,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXXX,________,________,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXX_,________,________,_XXXXXXX,XXXXXXX_,________,
  ________,_XXXXXXX,XXXXXX__,________,________,__XXXXXX,XXXXXXX_,________,
  ________,_XXXXXXX,XXXXX___,________,________,__XXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXX___,________,________,___XXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXXX____,________,________,____XXXX,XXXXXXXX,________,
  _______X,XXXXXXXX,XXX_____,________,________,________,________,________,
  _______X,XXXXXXXX,XXX_____,________,________,________,________,________,
  ______XX,XXXXXXXX,XXX_____,________,________,________,________,________,
  ______XX,XXXXXXXX,XX______,________,________,________,________,________,
  ______XX,XXXXXXXX,XX______,________,________,________,________,________,
  _____XXX,XXXXXXXX,XX______,________,________,________,________,________,
  _____XXX,XXXXXXXX,XX______,________,________,________,________,________,
  _____XXX,XXXXXXXX,XX______,______XX,XXXXXX__,________,________,________,
  _____XXX,XXXXXXXX,X_______,__XXXXXX,XXXXXXXX,XX______,________,________,
  _____XXX,XXXXXXXX,X_______,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  _____XXX,XXXXXXXX,X_____XX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  _____XXX,XXXXXXXX,X____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ____XXXX,XXXXXXXX,X___XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ____XXXX,XXXXXXXX,X__XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ____XXXX,XXXXXXXX,X_XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXX____,___XXXXX,XXXXXXXX,XXXXXX__,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,X_______,______XX,XXXXXXXX,XXXXXX__,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,________,_______X,XXXXXXXX,XXXXXXX_,________,
  ____XXXX,XXXXXXXX,XXXXXXX_,________,________,_XXXXXXX,XXXXXXX_,________,
  ____XXXX,XXXXXXXX,XXXXXX__,________,________,__XXXXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,XXXXX___,________,________,__XXXXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XX______,________,________,_____XXX,XXXXXXXX,X_______,
  ______XX,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XXX_____,________,________,____XXXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,X_______,
  _______X,XXXXXXXX,XXXX____,________,________,___XXXXX,XXXXXXXX,________,
  ________,XXXXXXXX,XXXXX___,________,________,__XXXXXX,XXXXXXXX,________,
  ________,XXXXXXXX,XXXXXX__,________,________,_XXXXXXX,XXXXXXX_,________,
  ________,_XXXXXXX,XXXXXXX_,________,________,XXXXXXXX,XXXXXXX_,________,
  ________,_XXXXXXX,XXXXXXXX,________,_______X,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXXX,X_______,______XX,XXXXXXXX,XXXXXX__,________,
  ________,__XXXXXX,XXXXXXXX,XXXX____,___XXXXX,XXXXXXXX,XXXXX___,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,________,
  ________,________,______XX,XXXXXXXX,XXXXXXXX,X_______,________,________,
  ________,________,________,__XXXXXX,XXXXX___,________,________,________},

{
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,________,
  ________,________,________,________,________,___XXXXX,XXXXXXX_,________,
  ________,________,________,________,________,___XXXXX,XXXXXX__,________,
  ________,________,________,________,________,__XXXXXX,XXXXXX__,________,
  ________,________,________,________,________,_XXXXXXX,XXXXX___,________,
  ________,________,________,________,________,XXXXXXXX,XXXX____,________,
  ________,________,________,________,_______X,XXXXXXXX,XXX_____,________,
  ________,________,________,________,______XX,XXXXXXXX,XX______,________,
  ________,________,________,________,______XX,XXXXXXXX,XX______,________,
  ________,________,________,________,_____XXX,XXXXXXXX,X_______,________,
  ________,________,________,________,____XXXX,XXXXXXXX,________,________,
  ________,________,________,________,___XXXXX,XXXXXXX_,________,________,
  ________,________,________,________,___XXXXX,XXXXXXX_,________,________,
  ________,________,________,________,__XXXXXX,XXXXXX__,________,________,
  ________,________,________,________,_XXXXXXX,XXXXX___,________,________,
  ________,________,________,________,_XXXXXXX,XXXXX___,________,________,
  ________,________,________,________,XXXXXXXX,XXXX____,________,________,
  ________,________,________,_______X,XXXXXXXX,XXX_____,________,________,
  ________,________,________,_______X,XXXXXXXX,XXX_____,________,________,
  ________,________,________,______XX,XXXXXXXX,XX______,________,________,
  ________,________,________,______XX,XXXXXXXX,XX______,________,________,
  ________,________,________,_____XXX,XXXXXXXX,X_______,________,________,
  ________,________,________,____XXXX,XXXXXXXX,X_______,________,________,
  ________,________,________,____XXXX,XXXXXXXX,________,________,________,
  ________,________,________,___XXXXX,XXXXXXXX,________,________,________,
  ________,________,________,___XXXXX,XXXXXXX_,________,________,________,
  ________,________,________,__XXXXXX,XXXXXXX_,________,________,________,
  ________,________,________,__XXXXXX,XXXXXX__,________,________,________,
  ________,________,________,_XXXXXXX,XXXXXX__,________,________,________,
  ________,________,________,_XXXXXXX,XXXXX___,________,________,________,
  ________,________,________,XXXXXXXX,XXXXX___,________,________,________,
  ________,________,________,XXXXXXXX,XXXX____,________,________,________,
  ________,________,_______X,XXXXXXXX,XXXX____,________,________,________,
  ________,________,_______X,XXXXXXXX,XXX_____,________,________,________,
  ________,________,______XX,XXXXXXXX,XXX_____,________,________,________,
  ________,________,______XX,XXXXXXXX,XXX_____,________,________,________,
  ________,________,______XX,XXXXXXXX,XX______,________,________,________,
  ________,________,_____XXX,XXXXXXXX,XX______,________,________,________,
  ________,________,_____XXX,XXXXXXXX,X_______,________,________,________,
  ________,________,____XXXX,XXXXXXXX,X_______,________,________,________,
  ________,________,____XXXX,XXXXXXXX,X_______,________,________,________,
  ________,________,____XXXX,XXXXXXXX,X_______,________,________,________,
  ________,________,___XXXXX,XXXXXXXX,________,________,________,________,
  ________,________,___XXXXX,XXXXXXXX,________,________,________,________,
  ________,________,___XXXXX,XXXXXXXX,________,________,________,________,
  ________,________,__XXXXXX,XXXXXXX_,________,________,________,________,
  ________,________,__XXXXXX,XXXXXXX_,________,________,________,________,
  ________,________,__XXXXXX,XXXXXXX_,________,________,________,________,
  ________,________,_XXXXXXX,XXXXXXX_,________,________,________,________,
  ________,________,_XXXXXXX,XXXXXX__,________,________,________,________,
  ________,________,_XXXXXXX,XXXXXX__,________,________,________,________,
  ________,________,_XXXXXXX,XXXXXX__,________,________,________,________,
  ________,________,XXXXXXXX,XXXXXX__,________,________,________,________,
  ________,________,XXXXXXXX,XXXXXX__,________,________,________,________,
  ________,________,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,________,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,________,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXXX___,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXX____,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXX____,________,________,________,________,
  ________,_______X,XXXXXXXX,XXXX____,________,________,________,________,
  ________,______XX,XXXXXXXX,XXXX____,________,________,________,________,
  ________,______XX,XXXXXXXX,XXXX____,________,________,________,________,
  ________,______XX,XXXXXXXX,XXXX____,________,________,________,________,
  ________,______XX,XXXXXXXX,XXXX____,________,________,________,________},

{
  ________,________,________,_XXXXXXX,XXXXX___,________,________,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXXXX,X_______,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXXXX,XXX_____,___XXXXX,XXXXXXXX,XXXX____,________,
  ________,_XXXXXXX,XXXXXXXX,X_______,_____XXX,XXXXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXXXXX_,________,_______X,XXXXXXXX,XXXXX___,________,
  ________,XXXXXXXX,XXXXXX__,________,________,XXXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXX___,________,________,_XXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXX___,________,________,_XXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXX____,________,________,__XXXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXXX____,________,________,__XXXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXX____,________,________,__XXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXX____,________,________,__XXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXX___,________,
  ________,__XXXXXX,XXXXX___,________,________,_XXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXX__,________,________,XXXXXXXX,XXXX____,________,
  ________,___XXXXX,XXXXXXX_,________,_______X,XXXXXXXX,XXX_____,________,
  ________,____XXXX,XXXXXXXX,X_______,_____XXX,XXXXXXXX,XX______,________,
  ________,_____XXX,XXXXXXXX,XXX_____,___XXXXX,XXXXXXXX,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  _______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXXXXXX,XX______,___XXXXX,XXXXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,___XXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ___XXXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ___XXXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,XX______,
  ____XXXX,XXXXXXXX,________,________,________,_____XXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XXX_____,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXXX,________,
  ______XX,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXXX_,________,
  ______XX,XXXXXXXX,XXXXXX__,________,_______X,XXXXXXXX,XXXXXXX_,________,
  _______X,XXXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXXXX__,________,
  _______X,XXXXXXXX,XXXXXXXX,XX______,___XXXXX,XXXXXXXX,XXXXXX__,________,
  ________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________},

{
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,_____XXX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,_______X,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX_____,________,
  ________,_XXXXXXX,XXXXXXXX,XX______,__XXXXXX,XXXXXXXX,XXXX____,________,
  ________,XXXXXXXX,XXXXXXXX,________,_____XXX,XXXXXXXX,XXXX____,________,
  ________,XXXXXXXX,XXXXXX__,________,______XX,XXXXXXXX,XXXXX___,________,
  _______X,XXXXXXXX,XXXXX___,________,_______X,XXXXXXXX,XXXXX___,________,
  _______X,XXXXXXXX,XXXX____,________,________,XXXXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,________,
  _____XXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,________,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,X_______,________,________,____XXXX,XXXXXXXX,X_______,
  _____XXX,XXXXXXXX,X_______,________,________,___XXXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XX______,________,________,___XXXXX,XXXXXXXX,XX______,
  _____XXX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XXX_____,________,________,__XXXXXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XXXX____,________,________,_XXXXXXX,XXXXXXXX,XX______,
  ______XX,XXXXXXXX,XXXXX___,________,________,XXXXXXXX,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XXXXX___,________,_______X,XXXXXXXX,XXXXXXXX,XX______,
  _______X,XXXXXXXX,XXXXXXX_,________,______XX,XXXXXXXX,XXXXXXXX,XX______,
  ________,XXXXXXXX,XXXXXXXX,________,_____XXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,XXXXXXXX,XXXXXXXX,XX______,__XXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX_XXX,XXXXXXXX,XX______,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXX__XXX,XXXXXXXX,XX______,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX___XXX,XXXXXXXX,X_______,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X____XXX,XXXXXXXX,X_______,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,_____XXX,XXXXXXXX,X_______,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXX__,_____XXX,XXXXXXXX,X_______,
  ________,________,____XXXX,XXXXXXXX,XXXX____,_____XXX,XXXXXXXX,X_______,
  ________,________,________,XXXXXXXX,X_______,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,____XXXX,XXXXXXXX,________,
  ________,________,________,________,________,____XXXX,XXXXXXXX,________,
  ________,________,________,________,________,____XXXX,XXXXXXXX,________,
  ________,________,________,________,________,___XXXXX,XXXXXXX_,________,
  ________,________,________,________,________,___XXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,X_______,________,________,___XXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXXX_,________,
  _____XXX,XXXXXXXX,XX______,________,________,__XXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XX______,________,________,_XXXXXXX,XXXXXX__,________,
  ______XX,XXXXXXXX,XXX_____,________,________,_XXXXXXX,XXXXX___,________,
  ______XX,XXXXXXXX,XXX_____,________,________,XXXXXXXX,XXXXX___,________,
  ______XX,XXXXXXXX,XXXX____,________,_______X,XXXXXXXX,XXXX____,________,
  _______X,XXXXXXXX,XXXXX___,________,______XX,XXXXXXXX,XXXX____,________,
  _______X,XXXXXXXX,XXXXXX__,________,_____XXX,XXXXXXXX,XXX_____,________,
  ________,XXXXXXXX,XXXXXXX_,________,____XXXX,XXXXXXXX,XX______,________,
  ________,XXXXXXXX,XXXXXXXX,XX______,_XXXXXXX,XXXXXXXX,XX______,________,
  ________,_XXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,________,
  ________,__XXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,________,________,
  ________,___XXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXX_,________,________,
  ________,____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXX__,________,________,
  ________,_____XXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXX___,________,________,
  ________,______XX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXX____,________,________,
  ________,________,XXXXXXXX,XXXXXXXX,XXXXXXXX,XX______,________,________,
  ________,________,__XXXXXX,XXXXXXXX,XXXXXXXX,________,________,________,
  ________,________,____XXXX,XXXXXXXX,XXXXXX__,________,________,________,
  ________,________,________,XXXXXXXX,XX______,________,________,________},

{
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,_XXXXXXX,XXXX____,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________},

{
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ____XXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,XXXXXXXX,X_______,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________,
  ________,________,________,________,________,________,________,________}
};

GUI_CONST_STORAGE unsigned char acFontD80_0020[320] = { /* code 0020 */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________};

GUI_CONST_STORAGE unsigned char acFontD80_002E[320] = { /* code 002E */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,________,________,________};


GUI_CONST_STORAGE unsigned char acFontD80_003A[320] = { /* code 003A */
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,________,________,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,XXXXXXXX,XXXXXXX_,________,
  ________,________,________,________};

GUI_CONST_STORAGE GUI_CHARINFO GUI_FontD80_CharInfo[15] = {
   {  31,  31,  4, acFontD80_0020 } /* code 0020 ' ' */
  ,{  61,  61,  8, acFontD80[10]  } /* code 002B '+' */
  ,{  61,  61,  8, acFontD80[11]  } /* code 002D '-' */
  ,{  31,  31,  4, acFontD80_002E } /* code 002E '.' */
  ,{  61,  61,  8, acFontD80[0]   } /* code 0030 '0' */
  ,{  61,  61,  8, acFontD80[1]   } /* code 0031 '1' */
  ,{  61,  61,  8, acFontD80[2]   } /* code 0032 '2' */
  ,{  61,  61,  8, acFontD80[3]   } /* code 0033 '3' */
  ,{  61,  61,  8, acFontD80[4]   } /* code 0034 '4' */
  ,{  61,  61,  8, acFontD80[5]   } /* code 0035 '5' */
  ,{  61,  61,  8, acFontD80[6]   } /* code 0036 '6' */
  ,{  61,  61,  8, acFontD80[7]   } /* code 0037 '7' */
  ,{  61,  61,  8, acFontD80[8]   } /* code 0038 '8' */
  ,{  61,  61,  8, acFontD80[9]   } /* code 0039 '9' */
  ,{  31,  31,  4, acFontD80_003A } /* code 003A ':' */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD80_Prop4 = {
   0x0030 /* first character */
  ,0x003A /* last character  */
  ,&GUI_FontD80_CharInfo[  4] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP*)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD80_Prop3 = {
   0x002D /* first character */
  ,0x002E /* last character  */
  ,&GUI_FontD80_CharInfo[  2] /* address of first character */
  ,&GUI_FontD80_Prop4 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD80_Prop2 = {
   0x002B /* first character */
  ,0x002B /* last character  */
  ,&GUI_FontD80_CharInfo[  1] /* address of first character */
  ,&GUI_FontD80_Prop3 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD80_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_FontD80_CharInfo[  0] /* address of first character */
  ,&GUI_FontD80_Prop2 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontD80 = {
   GUI_FONTTYPE_PROP /* type of font    */
  ,80 /* height of font  */
  ,80 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontD80_Prop1}
  ,80 /* Baseline */
  ,0 /* LHeight */
  ,80 /* CHeight */
};

