#include "lan8720.h"
#include "stm32f4x7_eth.h"
#include "usart.h" 
#include "delay.h"
#include "malloc.h" 
 
ETH_DMADESCTypeDef *DMARxDscrTab;	//̫DMAݽṹָ
ETH_DMADESCTypeDef *DMATxDscrTab;	//̫DMAݽṹָ 
uint8_t *Rx_Buff; 					//̫ײbuffersָ 
uint8_t *Tx_Buff; 					//̫ײbuffersָ
  
static void ETHERNET_NVICConfiguration(void);
//LAN8720ʼ
//ֵ:0,ɹ;
//    ,ʧ
u8 LAN8720_Init(void)
{
	u8 rval=0;
	GPIO_InitTypeDef GPIO_InitStructure;
  
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOA|RCC_AHB1Periph_GPIOC|RCC_AHB1Periph_GPIOG|RCC_AHB1Periph_GPIOD, ENABLE);//ʹGPIOʱ RMIIӿ
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, ENABLE);   //ʹSYSCFGʱ
  
	SYSCFG_ETH_MediaInterfaceConfig(SYSCFG_ETH_MediaInterface_RMII); //MACPHY֮ʹRMIIӿ

	/* RMIIӿ
	  ETH_MDIO -------------------------> PA2
	  ETH_MDC --------------------------> PC1
	  ETH_RMII_REF_CLK------------------> PA1
	  ETH_RMII_CRS_DV ------------------> PA7
	  ETH_RMII_RXD0 --------------------> PC4
	  ETH_RMII_RXD1 --------------------> PC5
	  ETH_RMII_TX_EN -------------------> PG11
	  ETH_RMII_TXD0 --------------------> PG13
	  ETH_RMII_TXD1 --------------------> PG14
	  ETH_RESET-------------------------> PD3*/
					
	  //PA1 PA2 PA7
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1|GPIO_Pin_2|GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL ;  
	GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	GPIO_PinAFConfig(GPIOA, GPIO_PinSource1, GPIO_AF_ETH); //Ÿõӿ
	GPIO_PinAFConfig(GPIOA, GPIO_PinSource2, GPIO_AF_ETH);
	GPIO_PinAFConfig(GPIOA, GPIO_PinSource7, GPIO_AF_ETH);

	//PC1,PC4 and PC5
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1 | GPIO_Pin_4 | GPIO_Pin_5;
	GPIO_Init(GPIOC, &GPIO_InitStructure);
	GPIO_PinAFConfig(GPIOC, GPIO_PinSource1, GPIO_AF_ETH); //Ÿõӿ
	GPIO_PinAFConfig(GPIOC, GPIO_PinSource4, GPIO_AF_ETH);
	GPIO_PinAFConfig(GPIOC, GPIO_PinSource5, GPIO_AF_ETH);
                                
	//PG11, PG14 and PG13 
	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_11 | GPIO_Pin_13 | GPIO_Pin_14;
	GPIO_Init(GPIOG, &GPIO_InitStructure);
	GPIO_PinAFConfig(GPIOG, GPIO_PinSource11, GPIO_AF_ETH);
	GPIO_PinAFConfig(GPIOG, GPIO_PinSource13, GPIO_AF_ETH);
	GPIO_PinAFConfig(GPIOG, GPIO_PinSource14, GPIO_AF_ETH);
	
	//PD3Ϊ
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_3;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;	//
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL ;  
	GPIO_Init(GPIOD, &GPIO_InitStructure);
	
	LAN8720_RST=0;					//ӲλLAN8720
	delay_ms(50);	
	LAN8720_RST=1;				 	//λ 
	ETHERNET_NVICConfiguration();	//жȼ
	rval=ETH_MACDMA_Config();		//MACDMA
	return !rval;					//ETHĹΪ:0,ʧ;1,ɹ;Ҫȡһ 
}

//̫жϷ
void ETHERNET_NVICConfiguration(void)
{
	NVIC_InitTypeDef NVIC_InitStructure;
	
	NVIC_InitStructure.NVIC_IRQChannel = ETH_IRQn;  //̫ж
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0X00;  //жϼĴ2ȼ
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0X00;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);
}


//õ8720ٶģʽ
//ֵ:
//001:10M˫
//101:10Mȫ˫
//010:100M˫
//110:100Mȫ˫
//:.
u8 LAN8720_Get_Speed(void)
{
	u8 speed;
	speed=((ETH_ReadPHYRegister(0x00,31)&0x1C)>>2); //LAN872031żĴжȡٶȺ˫ģʽ
	return speed;
}
/////////////////////////////////////////////////////////////////////////////////////////////////
//²ΪSTM32F407/ӿں.

//ʼETH MAC㼰DMA
//ֵ:ETH_ERROR,ʧ(0)
//		ETH_SUCCESS,ͳɹ(1)
u8 ETH_MACDMA_Config(void)
{
	u8 rval;
	ETH_InitTypeDef ETH_InitStructure; 
	
	//ʹ̫MACԼMACպͷʱ
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_ETH_MAC | RCC_AHB1Periph_ETH_MAC_Tx |RCC_AHB1Periph_ETH_MAC_Rx, ENABLE);
                        
	ETH_DeInit();  								//AHB̫
	ETH_SoftwareReset();  						//
	while (ETH_GetSoftwareResetStatus() == SET);//ȴ 
	ETH_StructInit(&ETH_InitStructure); 	 	//ʼΪĬֵ  

	///MAC 
	ETH_InitStructure.ETH_AutoNegotiation = ETH_AutoNegotiation_Enable;   			//Ӧ
	ETH_InitStructure.ETH_LoopbackMode = ETH_LoopbackMode_Disable;					//رշ
	ETH_InitStructure.ETH_RetryTransmission = ETH_RetryTransmission_Disable; 		//رش
	ETH_InitStructure.ETH_AutomaticPadCRCStrip = ETH_AutomaticPadCRCStrip_Disable; 	//رԶȥPDA/CRC 
	ETH_InitStructure.ETH_ReceiveAll = ETH_ReceiveAll_Disable;						//رսе֡
	ETH_InitStructure.ETH_BroadcastFramesReception = ETH_BroadcastFramesReception_Enable;//й㲥֡
	ETH_InitStructure.ETH_PromiscuousMode = ETH_PromiscuousMode_Disable;			//رջģʽĵַ  
	ETH_InitStructure.ETH_MulticastFramesFilter = ETH_MulticastFramesFilter_Perfect;//鲥ַʹַ   
	ETH_InitStructure.ETH_UnicastFramesFilter = ETH_UnicastFramesFilter_Perfect;	//Եַʹַ 
#ifdef CHECKSUM_BY_HARDWARE
	ETH_InitStructure.ETH_ChecksumOffload = ETH_ChecksumOffload_Enable; 			//ipv4TCP/UDP/ICMP֡Уж   
#endif
	//ʹ֡УжعܵʱһҪʹܴ洢תģʽ,洢תģʽҪ֤֡洢FIFO,
	//MACܲ/ʶ֡Уֵ,УȷʱDMAͿԴ֡,Ͷ֡
	ETH_InitStructure.ETH_DropTCPIPChecksumErrorFrame = ETH_DropTCPIPChecksumErrorFrame_Enable; //TCP/IP֡
	ETH_InitStructure.ETH_ReceiveStoreForward = ETH_ReceiveStoreForward_Enable;     //ݵĴ洢תģʽ    
	ETH_InitStructure.ETH_TransmitStoreForward = ETH_TransmitStoreForward_Enable;   //ݵĴ洢תģʽ  

	ETH_InitStructure.ETH_ForwardErrorFrames = ETH_ForwardErrorFrames_Disable;     	//ֹת֡  
	ETH_InitStructure.ETH_ForwardUndersizedGoodFrames = ETH_ForwardUndersizedGoodFrames_Disable;	//תСĺ֡ 
	ETH_InitStructure.ETH_SecondFrameOperate = ETH_SecondFrameOperate_Enable;  		//򿪴ڶ֡
	ETH_InitStructure.ETH_AddressAlignedBeats = ETH_AddressAlignedBeats_Enable;  	//DMAĵַ빦
	ETH_InitStructure.ETH_FixedBurst = ETH_FixedBurst_Enable;            			//̶ͻ    
	ETH_InitStructure.ETH_RxDMABurstLength = ETH_RxDMABurstLength_32Beat;     		//DMA͵ͻΪ32   
	ETH_InitStructure.ETH_TxDMABurstLength = ETH_TxDMABurstLength_32Beat;			//DMAյͻΪ32
	ETH_InitStructure.ETH_DMAArbitration = ETH_DMAArbitration_RoundRobin_RxTx_2_1;
	rval=ETH_Init(&ETH_InitStructure,LAN8720_PHY_ADDRESS);		//ETH
	if(rval==ETH_SUCCESS)//óɹ
	{
		ETH_DMAITConfig(ETH_DMA_IT_NIS|ETH_DMA_IT_R,ENABLE);  	//ʹ̫ж	
	}
	return rval;
}

extern void lwip_pkt_handle(void);		//lwip_comm.c涨
//̫DMAжϷ
void ETH_IRQHandler(void)
{
	while(ETH_GetRxPktSize(DMARxDescToGet)!=0) 	//Ƿյݰ
	{ 
		lwip_pkt_handle();		
	}
	ETH_DMAClearITPendingBit(ETH_DMA_IT_R); 	//DMAжϱ־λ
	ETH_DMAClearITPendingBit(ETH_DMA_IT_NIS);	//DMAжϱ־λ
}  
//һݰ
//ֵ:ݰ֡ṹ
FrameTypeDef ETH_Rx_Packet(void)
{ 
	u32 framelength=0;
	FrameTypeDef frame={0,0};   
	//鵱ǰ,ǷETHERNET DMA(õʱ)/CPU(λʱ)
	if((DMARxDescToGet->Status&ETH_DMARxDesc_OWN)!=(u32)RESET)
	{	
		frame.length=ETH_ERROR; 
		if ((ETH->DMASR&ETH_DMASR_RBUS)!=(u32)RESET)  
		{ 
			ETH->DMASR = ETH_DMASR_RBUS;//ETH DMARBUSλ 
			ETH->DMARPDR=0;//ָDMA
		}
		return frame;//,OWNλ
	}  
	if(((DMARxDescToGet->Status&ETH_DMARxDesc_ES)==(u32)RESET)&& 
	((DMARxDescToGet->Status & ETH_DMARxDesc_LS)!=(u32)RESET)&&  
	((DMARxDescToGet->Status & ETH_DMARxDesc_FS)!=(u32)RESET))  
	{       
		framelength=((DMARxDescToGet->Status&ETH_DMARxDesc_FL)>>ETH_DMARxDesc_FrameLengthShift)-4;//õհ֡(4ֽCRC)
 		frame.buffer = DMARxDescToGet->Buffer1Addr;//õڵλ
	}else framelength=ETH_ERROR;//  
	frame.length=framelength; 
	frame.descriptor=DMARxDescToGet;  
	//ETH DMAȫRxΪһRx
	//ΪһbufferȡһDMA Rx
	DMARxDescToGet=(ETH_DMADESCTypeDef*)(DMARxDescToGet->Buffer2NextDescAddr);   
	return frame;  
}
//һݰ
//FrameLength:ݰ
//ֵ:ETH_ERROR,ʧ(0)
//		ETH_SUCCESS,ͳɹ(1)
u8 ETH_Tx_Packet(u16 FrameLength)
{   
	//鵱ǰ,ǷETHERNET DMA(õʱ)/CPU(λʱ)
	if((DMATxDescToSet->Status&ETH_DMATxDesc_OWN)!=(u32)RESET)return ETH_ERROR;//,OWNλ 
 	DMATxDescToSet->ControlBufferSize=(FrameLength&ETH_DMATxDesc_TBS1);//֡,bits[12:0]
	DMATxDescToSet->Status|=ETH_DMATxDesc_LS|ETH_DMATxDesc_FS;//һ͵һλλ(1һ֡)
  	DMATxDescToSet->Status|=ETH_DMATxDesc_OWN;//TxOWNλ,bufferعETH DMA
	if((ETH->DMASR&ETH_DMASR_TBUS)!=(u32)RESET)//Tx Bufferλ(TBUS)õʱ,.ָ
	{ 
		ETH->DMASR=ETH_DMASR_TBUS;//ETH DMA TBUSλ 
		ETH->DMATPDR=0;//ָDMA
	} 
	//ETH DMAȫTxΪһTx
	//ΪһbufferһDMA Tx 
	DMATxDescToSet=(ETH_DMADESCTypeDef*)(DMATxDescToSet->Buffer2NextDescAddr);    
	return ETH_SUCCESS;   
}
//õǰTx bufferַ
//ֵ:Tx bufferַ
u32 ETH_GetCurrentTxBuffer(void)
{  
  return DMATxDescToSet->Buffer1Addr;//Tx bufferַ  
}

//ΪETHײڴ
//ֵ:0,
//    ,ʧ
u8 ETH_Mem_Malloc(void)
{ 
	DMARxDscrTab=mymalloc(SRAMIN,ETH_RXBUFNB*sizeof(ETH_DMADESCTypeDef));//ڴ
	DMATxDscrTab=mymalloc(SRAMIN,ETH_TXBUFNB*sizeof(ETH_DMADESCTypeDef));//ڴ  
	Rx_Buff=mymalloc(SRAMIN,ETH_RX_BUF_SIZE*ETH_RXBUFNB);	//ڴ
	Tx_Buff=mymalloc(SRAMIN,ETH_TX_BUF_SIZE*ETH_TXBUFNB);	//ڴ
	if(!DMARxDscrTab||!DMATxDscrTab||!Rx_Buff||!Tx_Buff)
	{
		ETH_Mem_Free();
		return 1;	//ʧ
	}	
	return 0;		//ɹ
}

//ͷETH ײڴ
void ETH_Mem_Free(void)
{ 
	myfree(SRAMIN,DMARxDscrTab);//ͷڴ
	myfree(SRAMIN,DMATxDscrTab);//ͷڴ
	myfree(SRAMIN,Rx_Buff);		//ͷڴ
	myfree(SRAMIN,Tx_Buff);		//ͷڴ  
}
























