#ifndef __LAN8720_H
#define __LAN8720_H
#include "includes.h"
#include "stm32f4x7_eth.h"

//IOڲ궨
#define BITBAND(addr, bitnum) ((addr & 0xF0000000)+0x2000000+((addr &0xFFFFF)<<5)+(bitnum<<2)) 
#define MEM_ADDR(addr)  *((volatile unsigned long  *)(addr)) 
#define BIT_ADDR(addr, bitnum)   MEM_ADDR(BITBAND(addr, bitnum)) 
//IOڵַӳ
#define GPIOA_ODR_Addr    (GPIOA_BASE+20) //0x40020014
#define GPIOB_ODR_Addr    (GPIOB_BASE+20) //0x40020414 
#define GPIOC_ODR_Addr    (GPIOC_BASE+20) //0x40020814 
#define GPIOD_ODR_Addr    (GPIOD_BASE+20) //0x40020C14 
#define GPIOE_ODR_Addr    (GPIOE_BASE+20) //0x40021014 
#define GPIOF_ODR_Addr    (GPIOF_BASE+20) //0x40021414    
#define GPIOG_ODR_Addr    (GPIOG_BASE+20) //0x40021814   
#define GPIOH_ODR_Addr    (GPIOH_BASE+20) //0x40021C14    
#define GPIOI_ODR_Addr    (GPIOI_BASE+20) //0x40022014     

#define GPIOA_IDR_Addr    (GPIOA_BASE+16) //0x40020010 
#define GPIOB_IDR_Addr    (GPIOB_BASE+16) //0x40020410 
#define GPIOC_IDR_Addr    (GPIOC_BASE+16) //0x40020810 
#define GPIOD_IDR_Addr    (GPIOD_BASE+16) //0x40020C10 
#define GPIOE_IDR_Addr    (GPIOE_BASE+16) //0x40021010 
#define GPIOF_IDR_Addr    (GPIOF_BASE+16) //0x40021410 
#define GPIOG_IDR_Addr    (GPIOG_BASE+16) //0x40021810 
#define GPIOH_IDR_Addr    (GPIOH_BASE+16) //0x40021C10 
#define GPIOI_IDR_Addr    (GPIOI_BASE+16) //0x40022010 
 
//IOڲ,ֻԵһIO!
//ȷnֵС16!
#define PAout(n)   BIT_ADDR(GPIOA_ODR_Addr,n)  // 
#define PAin(n)    BIT_ADDR(GPIOA_IDR_Addr,n)  // 

#define PBout(n)   BIT_ADDR(GPIOB_ODR_Addr,n)  // 
#define PBin(n)    BIT_ADDR(GPIOB_IDR_Addr,n)  // 

#define PCout(n)   BIT_ADDR(GPIOC_ODR_Addr,n)  // 
#define PCin(n)    BIT_ADDR(GPIOC_IDR_Addr,n)  // 

#define PDout(n)   BIT_ADDR(GPIOD_ODR_Addr,n)  // 
#define PDin(n)    BIT_ADDR(GPIOD_IDR_Addr,n)  // 

#define PEout(n)   BIT_ADDR(GPIOE_ODR_Addr,n)  // 
#define PEin(n)    BIT_ADDR(GPIOE_IDR_Addr,n)  //

#define PFout(n)   BIT_ADDR(GPIOF_ODR_Addr,n)  // 
#define PFin(n)    BIT_ADDR(GPIOF_IDR_Addr,n)  //

#define PGout(n)   BIT_ADDR(GPIOG_ODR_Addr,n)  // 
#define PGin(n)    BIT_ADDR(GPIOG_IDR_Addr,n)  //

#define PHout(n)   BIT_ADDR(GPIOH_ODR_Addr,n)  // 
#define PHin(n)    BIT_ADDR(GPIOH_IDR_Addr,n)  //

#define PIout(n)   BIT_ADDR(GPIOI_ODR_Addr,n)  // 
#define PIin(n)    BIT_ADDR(GPIOI_IDR_Addr,n)  //


#define LAN8720_PHY_ADDRESS  	0x00				//LAN8720 PHYоƬַ.
#define LAN8720_RST 		   	PDout(3) 			//LAN8720λ	 

extern ETH_DMADESCTypeDef *DMARxDscrTab;			//̫DMAݽṹָ
extern ETH_DMADESCTypeDef *DMATxDscrTab;			//̫DMAݽṹָ 
extern uint8_t *Rx_Buff; 							//̫ײbuffersָ 
extern uint8_t *Tx_Buff; 							//̫ײbuffersָ
extern ETH_DMADESCTypeDef  *DMATxDescToSet;			//DMA׷ָ
extern ETH_DMADESCTypeDef  *DMARxDescToGet; 		//DMA׷ָ 
extern ETH_DMA_Rx_Frame_infos *DMA_RX_FRAME_infos;	//DMAյ֡Ϣָ
 

u8 LAN8720_Init(void);
u8 LAN8720_Get_Speed(void);
u8 ETH_MACDMA_Config(void);
FrameTypeDef ETH_Rx_Packet(void);
u8 ETH_Tx_Packet(u16 FrameLength);
u32 ETH_GetCurrentTxBuffer(void);
u8 ETH_Mem_Malloc(void);
void ETH_Mem_Free(void);
#endif 

