// cc.hLWIP TCP/IPЭջһ
// : Adam Dunkels <adam@sics.se>

#ifndef __CC_H__
#define __CC_H__

#include "lwip_cpu.h"
#include "stdio.h"
#include "includes.h"  //ʹUCOS ҪӴͷļ

//ƽ̨޹ص
typedef unsigned   char    u8_t;  	//޷8λ  
typedef signed     char    s8_t;   	//з8λ 
typedef unsigned   short   u16_t;  	//޷16λ
typedef signed     short   s16_t;   //з16λ
typedef unsigned   long    u32_t;   //޷32λ
typedef signed     long    s32_t;   //з32λ
typedef u32_t mem_ptr_t;            //ڴַ
typedef int sys_prot_t;				//ٽ籣

//ʹòϵͳʱٽUCOS IIΪ
//OS_CRITICAL_METHODʱ˵ʹUCOS II
#if CPU_CFG_CRITICAL_METHOD == 1
#define SYS_ARCH_DECL_PROTECT(lev)
#define SYS_ARCH_PROTECT(lev)		CPU_INT_DIS()
#define SYS_ARCH_UNPROTECT(lev)		CPU_INT_EN()
#endif

#if CPU_CFG_CRITICAL_METHOD == 3  
#define SYS_ARCH_DECL_PROTECT(lev)	u32_t lev
#define SYS_ARCH_PROTECT(lev)		lev = CPU_SR_Save() 	//UCOS IIIнٽ,ж
#define SYS_ARCH_UNPROTECT(lev)		CPU_SR_Restore(lev)		//UCOS III˳Aٽж 
#endif

//ݲͬıһЩ
#if defined (__ICCARM__)

#define PACK_STRUCT_BEGIN
#define PACK_STRUCT_STRUCT 
#define PACK_STRUCT_END
#define PACK_STRUCT_FIELD(x) x
#define PACK_STRUCT_USE_INCLUDES

#elif defined (__CC_ARM)

#define PACK_STRUCT_BEGIN __packed
#define PACK_STRUCT_STRUCT 
#define PACK_STRUCT_END
#define PACK_STRUCT_FIELD(x) x

#elif defined (__GNUC__)

#define PACK_STRUCT_BEGIN
#define PACK_STRUCT_STRUCT __attribute__ ((__packed__))
#define PACK_STRUCT_END
#define PACK_STRUCT_FIELD(x) x

#elif defined (__TASKING__)

#define PACK_STRUCT_BEGIN
#define PACK_STRUCT_STRUCT
#define PACK_STRUCT_END
#define PACK_STRUCT_FIELD(x) x

#endif

//LWIPprintfʱʹõһЩ
#define U16_F "4d"
#define S16_F "4d"
#define X16_F "4x"
#define U32_F "8ld"
#define S32_F "8ld"
#define X32_F "8lx"

//궨
#ifndef LWIP_PLATFORM_ASSERT
#define LWIP_PLATFORM_ASSERT(x) \
    do \
    {   printf("Assertion \"%s\" failed at line %d in %s\r\n", x, __LINE__, __FILE__); \
    } while(0)
#endif

#ifndef LWIP_PLATFORM_DIAG
#define LWIP_PLATFORM_DIAG(x) do {printf x;} while(0)
#endif

#endif /* __CC_H__ */
