#include "netif/ethernetif.h" 
#include "lan8720.h"  
#include "lwip_comm.h" 
#include "netif/etharp.h"  
#include "string.h"  

//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ALIENTEK STM32F407
//ethernetif.c 	   
//ԭ@ALIENTEK
//̳:www.openedv.com
//:2014/8/15
//汾V1.0
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2009-2019
//All rights reserved									  
//*******************************************************************************
//޸Ϣ
//
////////////////////////////////////////////////////////////////////////////////// 	   
 
 
//ethernetif_init()ڳʼӲ
//netif:ṹָ 
//ֵ:ERR_OK,
//       ,ʧ
static err_t low_level_init(struct netif *netif)
{
#ifdef CHECKSUM_BY_HARDWARE
	int i; 
#endif 
	netif->hwaddr_len = ETHARP_HWADDR_LEN; //MACַ,Ϊ6ֽ
	//ʼMACַ,ʲôַûԼ,ǲ豸MACַظ
	netif->hwaddr[0]=lwipdev.mac[0]; 
	netif->hwaddr[1]=lwipdev.mac[1]; 
	netif->hwaddr[2]=lwipdev.mac[2];
	netif->hwaddr[3]=lwipdev.mac[3];
	netif->hwaddr[4]=lwipdev.mac[4];
	netif->hwaddr[5]=lwipdev.mac[5];
	netif->mtu=1500; //䵥Ԫ,㲥ARP
	//ҸӲ·
	netif->flags = NETIF_FLAG_BROADCAST|NETIF_FLAG_ETHARP|NETIF_FLAG_LINK_UP;
	
	ETH_MACAddressConfig(ETH_MAC_Address0, netif->hwaddr); //STM32F4MACַĴдMACַ
	ETH_DMATxDescChainInit(DMATxDscrTab, Tx_Buff, ETH_TXBUFNB);
	ETH_DMARxDescChainInit(DMARxDscrTab, Rx_Buff, ETH_RXBUFNB);
#ifdef CHECKSUM_BY_HARDWARE 	//ʹӲ֡У
	for(i=0;i<ETH_TXBUFNB;i++)	//ʹTCP,UDPICMPķ֡У,TCP,UDPICMPĽ֡УDMA
	{
		ETH_DMATxDescChecksumInsertionConfig(&DMATxDscrTab[i], ETH_DMATxDesc_ChecksumTCPUDPICMPFull);
	}
#endif
	ETH_Start(); //MACDMA				
	return ERR_OK;
} 
//ڷݰײ㺯(lwipͨnetif->linkoutputָú)
//netif:ṹָ
//p:pbufݽṹָ
//ֵ:ERR_OK,
//       ERR_MEM,ʧ
static err_t low_level_output(struct netif *netif, struct pbuf *p)
{
	u8 res;
	struct pbuf *q;
	int l = 0;
	u8 *buffer=(u8 *)ETH_GetCurrentTxBuffer(); 
	for(q=p;q!=NULL;q=q->next) 
	{
		memcpy((u8_t*)&buffer[l], q->payload, q->len);
		l=l+q->len;
	} 
	res=ETH_Tx_Packet(l); 
	if(res==ETH_ERROR)return ERR_MEM;//ش״̬
	return ERR_OK;
} 
//ڽݰײ㺯
//neitif:ṹָ
//ֵ:pbufݽṹָ
static struct pbuf * low_level_input(struct netif *netif)
{  
	struct pbuf *p, *q;
	u16_t len;
	int l =0;
	FrameTypeDef frame;
	u8 *buffer;
	p = NULL;
	frame=ETH_Rx_Packet();
	len=frame.length;//õС
	buffer=(u8 *)frame.buffer;//õݵַ 
	p=pbuf_alloc(PBUF_RAW,len,PBUF_POOL);//pbufsڴطpbuf
	if(p!=NULL)
	{
		for(q=p;q!=NULL;q=q->next)
		{
			memcpy((u8_t*)q->payload,(u8_t*)&buffer[l], q->len);
			l=l+q->len;
		}    
	}
	frame.descriptor->Status=ETH_DMARxDesc_OWN;//RxOWNλ,bufferعETH DMA 
	if((ETH->DMASR&ETH_DMASR_RBUS)!=(u32)RESET)//Rx Bufferλ(RBUS)õʱ,.ָ
	{ 
		ETH->DMASR=ETH_DMASR_RBUS;//ETH DMA RBUSλ 
		ETH->DMARPDR=0;//ָDMA
	}
	return p;
} 
//(lwipֱӵ)
//netif:ṹָ
//ֵ:ERR_OK,
//       ERR_MEM,ʧ
err_t ethernetif_input(struct netif *netif)
{
	err_t err;
	struct pbuf *p;
	p=low_level_input(netif);
	if(p==NULL) return ERR_MEM;
	err=netif->input(p, netif);
	if(err!=ERR_OK)
	{
		LWIP_DEBUGF(NETIF_DEBUG,("ethernetif_input: IP input error\n"));
		pbuf_free(p);
		p = NULL;
	} 
	return err;
} 
//ʹlow_level_init()ʼ
//netif:ṹָ
//ֵ:ERR_OK,
//       ,ʧ
err_t ethernetif_init(struct netif *netif)
{
	LWIP_ASSERT("netif!=NULL",(netif!=NULL));
#if LWIP_NETIF_HOSTNAME			//LWIP_NETIF_HOSTNAME 
	netif->hostname="lwip";  	//ʼ
#endif 
	netif->name[0]=IFNAME0; 	//ʼnetifnameֶ
	netif->name[1]=IFNAME1; 	//ļⶨﲻùľֵ
	netif->output=etharp_output;//IP㷢ݰ
	netif->linkoutput=low_level_output;//ARPģ鷢ݰ
	low_level_init(netif); 		//ײӲʼ
	return ERR_OK;
}














