#include "lwip_comm.h" 
#include "netif/etharp.h"
#include "lwip/dhcp.h"
#include "ethernetif.h" 
#include "lwip/timers.h"
#include "lwip/tcp_impl.h"
#include "lwip/ip_frag.h"
#include "lwip/tcpip.h" 
#include "malloc.h"
#include "delay.h"
#include "usart.h"  
#include <stdio.h>
#include "includes.h" 
//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ALIENTEK STM32F407
//lwipͨ 	   
//ԭ@ALIENTEK
//̳:www.openedv.com
//:2014/8/15
//汾V1.0
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2009-2019
//All rights reserved									  
//*******************************************************************************
//޸Ϣ
//
////////////////////////////////////////////////////////////////////////////////// 	   
   
  
__lwip_dev lwipdev;						//lwipƽṹ 
struct netif lwip_netif;				//һȫֵӿ

extern u32 memp_get_memorysize(void);	//memp.c涨
extern u8_t *memp_memory;				//memp.c涨.
extern u8_t *ram_heap;					//mem.c涨.


/////////////////////////////////////////////////////////////////////////////////
//lwip(ںDHCP)

//lwipںջ(ȼͶջСlwipopts.h) 
CPU_STK * TCPIP_THREAD_TASK_STK;	


//lwip DHCP
//ȼ
#define LWIP_DHCP_TASK_PRIO       		7
//ջС
#define LWIP_DHCP_STK_SIZE  		    256
//ƿ
OS_TCB LwipdhcpTaskTCB;
//ջڴķʽ	
CPU_STK * LWIP_DHCP_TASK_STK;	
//
void lwip_dhcp_task(void *pdata); 


//̫жϵ
void lwip_pkt_handle(void)
{
	ethernetif_input(&lwip_netif);
}
//lwipں˲,ڴ
//ֵ:0,ɹ;
//    ,ʧ
u8 lwip_comm_mem_malloc(void)
{
	u32 mempsize;
	u32 ramheapsize; 
	mempsize=memp_get_memorysize();			//õmemp_memoryС
	memp_memory=mymalloc(SRAMIN,mempsize);	//Ϊmemp_memoryڴ
	ramheapsize=LWIP_MEM_ALIGN_SIZE(MEM_SIZE)+2*LWIP_MEM_ALIGN_SIZE(4*3)+MEM_ALIGNMENT;//õram heapС
	ram_heap=mymalloc(SRAMIN,ramheapsize);	//Ϊram_heapڴ 
	TCPIP_THREAD_TASK_STK=mymalloc(SRAMIN,TCPIP_THREAD_STACKSIZE*4);//ںջ 
	LWIP_DHCP_TASK_STK=mymalloc(SRAMIN,LWIP_DHCP_STK_SIZE*4);		//dhcpջڴռ
	if(!memp_memory||!ram_heap||!TCPIP_THREAD_TASK_STK||!LWIP_DHCP_TASK_STK)//ʧܵ
	{
		lwip_comm_mem_free();
		return 1;
	}
	return 0;	
}
//lwipں˲,ڴͷ
void lwip_comm_mem_free(void)
{ 	
	myfree(SRAMIN,memp_memory);
	myfree(SRAMIN,ram_heap);
	myfree(SRAMIN,TCPIP_THREAD_TASK_STK);
	myfree(SRAMIN,LWIP_DHCP_TASK_STK);
}
//lwip ĬIP
//lwipx:lwipƽṹָ
void lwip_comm_default_ip_set(__lwip_dev *lwipx)
{
	u32 sn0;
	sn0=*(vu32*)(0x1FFF7A10);//ȡSTM32ΨһIDǰ24λΪMACַֽ
	//ĬԶIPΪ:192.168.1.100
	lwipx->remoteip[0]=192;	
	lwipx->remoteip[1]=168;
	lwipx->remoteip[2]=1;
	lwipx->remoteip[3]=100;
	//MACַ(ֽڹ̶Ϊ:2.0.0,ֽSTM32ΨһID)
	lwipx->mac[0]=2;//ֽ(IEEE֮Ϊ֯ΨһID,OUI)̶ַΪ:2.0.0
	lwipx->mac[1]=0;
	lwipx->mac[2]=0;
	lwipx->mac[3]=(sn0>>16)&0XFF;//ֽSTM32ΨһID
	lwipx->mac[4]=(sn0>>8)&0XFFF;;
	lwipx->mac[5]=sn0&0XFF; 
	//ĬϱIPΪ:192.168.1.30
	lwipx->ip[0]=192;	
	lwipx->ip[1]=168;
	lwipx->ip[2]=1;
	lwipx->ip[3]=30;
	//Ĭ:255.255.255.0
	lwipx->netmask[0]=255;	
	lwipx->netmask[1]=255;
	lwipx->netmask[2]=255;
	lwipx->netmask[3]=0;
	//Ĭ:192.168.1.1
	lwipx->gateway[0]=192;	
	lwipx->gateway[1]=168;
	lwipx->gateway[2]=1;
	lwipx->gateway[3]=1;	
	lwipx->dhcpstatus=0;//ûDHCP	
} 

//LWIPʼ(LWIPʱʹ)
//ֵ:0,ɹ
//      1,ڴ
//      2,LAN8720ʼʧ
//      3,ʧ.
u8 lwip_comm_init(void)
{
	CPU_SR_ALLOC();
	
	struct netif *Netif_Init_Flag;		//netif_add()ʱķֵ,жʼǷɹ
	struct ip_addr ipaddr;  			//ipַ
	struct ip_addr netmask; 			//
	struct ip_addr gw;      			//Ĭ 
	if(ETH_Mem_Malloc())return 1;		//ڴʧ
	if(lwip_comm_mem_malloc())return 1;	//ڴʧ
	if(LAN8720_Init())return 2;			//ʼLAN8720ʧ 
	tcpip_init(NULL,NULL);				//ʼtcp ipں,úᴴtcpip_threadں
	lwip_comm_default_ip_set(&lwipdev);	//ĬIPϢ
#if LWIP_DHCP		//ʹö̬IP
	ipaddr.addr = 0;
	netmask.addr = 0;
	gw.addr = 0;
#else				//ʹþ̬IP
	IP4_ADDR(&ipaddr,lwipdev.ip[0],lwipdev.ip[1],lwipdev.ip[2],lwipdev.ip[3]);
	IP4_ADDR(&netmask,lwipdev.netmask[0],lwipdev.netmask[1] ,lwipdev.netmask[2],lwipdev.netmask[3]);
	IP4_ADDR(&gw,lwipdev.gateway[0],lwipdev.gateway[1],lwipdev.gateway[2],lwipdev.gateway[3]);
	printf("enMACַΪ:................%d.%d.%d.%d.%d.%d\r\n",lwipdev.mac[0],lwipdev.mac[1],lwipdev.mac[2],lwipdev.mac[3],lwipdev.mac[4],lwipdev.mac[5]);
	printf("̬IPַ........................%d.%d.%d.%d\r\n",lwipdev.ip[0],lwipdev.ip[1],lwipdev.ip[2],lwipdev.ip[3]);
	printf("..........................%d.%d.%d.%d\r\n",lwipdev.netmask[0],lwipdev.netmask[1],lwipdev.netmask[2],lwipdev.netmask[3]);
	printf("Ĭ..........................%d.%d.%d.%d\r\n",lwipdev.gateway[0],lwipdev.gateway[1],lwipdev.gateway[2],lwipdev.gateway[3]);
#endif
	OS_CRITICAL_ENTER();  //ٽ
	Netif_Init_Flag=netif_add(&lwip_netif,&ipaddr,&netmask,&gw,NULL,&ethernetif_init,&tcpip_input);//бһ
	OS_CRITICAL_EXIT();  //˳ٽ
	if(Netif_Init_Flag==NULL)return 3;//ʧ 
	else//ӳɹ,netifΪĬֵ,Ҵnetif
	{
		netif_set_default(&lwip_netif); //netifΪĬ
		netif_set_up(&lwip_netif);		//netif
	}
	return 0;//OK.
}   
//ʹDHCP
#if LWIP_DHCP
//DHCP
void lwip_comm_dhcp_creat(void)
{
	OS_ERR err;
	CPU_SR_ALLOC();
	
	OS_CRITICAL_ENTER();//ٽ
	//ʼ
	OSTaskCreate((OS_TCB 	* )&LwipdhcpTaskTCB,		//ƿ
				 (CPU_CHAR	* )"dhcp task", 			//
                 (OS_TASK_PTR )lwip_dhcp_task, 			//
                 (void		* )0,						//ݸĲ
                 (OS_PRIO	  )LWIP_DHCP_TASK_PRIO, 	//ȼ
                 (CPU_STK   * )&LWIP_DHCP_TASK_STK[0],	//ջַ
                 (CPU_STK_SIZE)LWIP_DHCP_STK_SIZE/10,	//ջλ
                 (CPU_STK_SIZE)LWIP_DHCP_STK_SIZE,		//ջС
                 (OS_MSG_QTY  )0,						//ڲϢܹյϢĿ,Ϊ0ʱֹϢ
                 (OS_TICK	  )0,						//ʹʱƬתʱʱƬȣΪ0ʱΪĬϳȣ
                 (void   	* )0,						//ûĴ洢
                 (OS_OPT      )OS_OPT_TASK_STK_CHK|OS_OPT_TASK_STK_CLR, //ѡ
                 (OS_ERR 	* )&err);					//Ÿúʱķֵ
	OS_CRITICAL_EXIT();	//˳ٽ	 
}
//ɾDHCP
void lwip_comm_dhcp_delete(void)
{
	OS_ERR err;
	
	dhcp_stop(&lwip_netif); 		//رDHCP
	OSTaskDel(&LwipdhcpTaskTCB,&err);//ɾDHCP
}
//DHCP
void lwip_dhcp_task(void *pdata)
{
	u32 ip=0,netmask=0,gw=0;
	dhcp_start(&lwip_netif);//DHCP 
	lwipdev.dhcpstatus=0;	//DHCP
	printf("ڲDHCP,Ե...........\r\n");   
	while(1)
	{ 
		printf("ڻȡַ...\r\n");
		ip=lwip_netif.ip_addr.addr;		//ȡIPַ
		netmask=lwip_netif.netmask.addr;//ȡ
		gw=lwip_netif.gw.addr;			//ȡĬ 
		if(ip!=0)   					//ȷȡIPַʱ
		{
			lwipdev.dhcpstatus=2;	//DHCPɹ
 			printf("enMACַΪ:................%d.%d.%d.%d.%d.%d\r\n",lwipdev.mac[0],lwipdev.mac[1],lwipdev.mac[2],lwipdev.mac[3],lwipdev.mac[4],lwipdev.mac[5]);
			//ͨDHCPȡIPַ
			lwipdev.ip[3]=(uint8_t)(ip>>24); 
			lwipdev.ip[2]=(uint8_t)(ip>>16);
			lwipdev.ip[1]=(uint8_t)(ip>>8);
			lwipdev.ip[0]=(uint8_t)(ip);
			printf("ͨDHCPȡIPַ..............%d.%d.%d.%d\r\n",lwipdev.ip[0],lwipdev.ip[1],lwipdev.ip[2],lwipdev.ip[3]);
			//ͨDHCPȡַ
			lwipdev.netmask[3]=(uint8_t)(netmask>>24);
			lwipdev.netmask[2]=(uint8_t)(netmask>>16);
			lwipdev.netmask[1]=(uint8_t)(netmask>>8);
			lwipdev.netmask[0]=(uint8_t)(netmask);
			printf("ͨDHCPȡ............%d.%d.%d.%d\r\n",lwipdev.netmask[0],lwipdev.netmask[1],lwipdev.netmask[2],lwipdev.netmask[3]);
			//ͨDHCPȡĬ
			lwipdev.gateway[3]=(uint8_t)(gw>>24);
			lwipdev.gateway[2]=(uint8_t)(gw>>16);
			lwipdev.gateway[1]=(uint8_t)(gw>>8);
			lwipdev.gateway[0]=(uint8_t)(gw);
			printf("ͨDHCPȡĬ..........%d.%d.%d.%d\r\n",lwipdev.gateway[0],lwipdev.gateway[1],lwipdev.gateway[2],lwipdev.gateway[3]);
			break;
		}else if(lwip_netif.dhcp->tries>LWIP_MAX_DHCP_TRIES) //ͨDHCPȡIPַʧ,ҳԴ
		{  
			lwipdev.dhcpstatus=0XFF;//DHCPʧ.
			//ʹþ̬IPַ
			IP4_ADDR(&(lwip_netif.ip_addr),lwipdev.ip[0],lwipdev.ip[1],lwipdev.ip[2],lwipdev.ip[3]);
			IP4_ADDR(&(lwip_netif.netmask),lwipdev.netmask[0],lwipdev.netmask[1],lwipdev.netmask[2],lwipdev.netmask[3]);
			IP4_ADDR(&(lwip_netif.gw),lwipdev.gateway[0],lwipdev.gateway[1],lwipdev.gateway[2],lwipdev.gateway[3]);
			printf("DHCPʱ,ʹþ̬IPַ!\r\n");
			printf("enMACַΪ:................%d.%d.%d.%d.%d.%d\r\n",lwipdev.mac[0],lwipdev.mac[1],lwipdev.mac[2],lwipdev.mac[3],lwipdev.mac[4],lwipdev.mac[5]);
			printf("̬IPַ........................%d.%d.%d.%d\r\n",lwipdev.ip[0],lwipdev.ip[1],lwipdev.ip[2],lwipdev.ip[3]);
			printf("..........................%d.%d.%d.%d\r\n",lwipdev.netmask[0],lwipdev.netmask[1],lwipdev.netmask[2],lwipdev.netmask[3]);
			printf("Ĭ..........................%d.%d.%d.%d\r\n",lwipdev.gateway[0],lwipdev.gateway[1],lwipdev.gateway[2],lwipdev.gateway[3]);
			break;
		}  
		delay_ms(250); //ʱ250ms
	}
	lwip_comm_dhcp_delete();//ɾDHCP 
}
#endif 



























