#include "includes.h"
#include "malloc.h"
#include "includes.h"
#include "udp_src.h"

extern OS_SEM USART1_SEM;               //1ź
extern OS_SEM USART2_SEM;               //2ź
extern OS_SEM USART3_SEM;               //3ź
extern OS_SEM USART4_SEM;               //4ź

OS_TCB  *UDP_Port_1_send_TcbPtr;     //˿1Ӧƿ
CPU_STK *UDP_Port_1_send_StkPtr;     //˿1Ӧջָ
OS_TCB  *UDP_Port_1_Recv_TcbPtr;     //˿1Ӧƿ
CPU_STK *UDP_Port_1_Recv_StkPtr;     //˿1Ӧջָ

OS_TCB  *UDP_Port_2_send_TcbPtr;     //˿2Ӧƿ
CPU_STK *UDP_Port_2_send_StkPtr;     //˿2Ӧջָ
OS_TCB  *UDP_Port_2_Recv_TcbPtr;     //˿2Ӧƿ
CPU_STK *UDP_Port_2_Recv_StkPtr;     //˿2Ӧջָ

OS_TCB  *UDP_Port_3_send_TcbPtr;     //˿3Ӧƿ
CPU_STK *UDP_Port_3_send_StkPtr;     //˿3Ӧջָ
OS_TCB  *UDP_Port_3_Recv_TcbPtr;     //˿3Ӧƿ
CPU_STK *UDP_Port_3_Recv_StkPtr;     //˿3Ӧջָ

OS_TCB  *UDP_Port_4_send_TcbPtr;     //˿4Ӧƿ
CPU_STK *UDP_Port_4_send_StkPtr;     //˿4Ӧջָ
OS_TCB  *UDP_Port_4_Recv_TcbPtr;     //˿4Ӧƿ
CPU_STK *UDP_Port_4_Recv_StkPtr;     //˿4Ӧջָ


static struct netconn *udpcon_1;     //˿1UDP    
static struct netconn *udpcon_2;     //˿2UDP
static struct netconn *udpcon_3;     //˿3UDP
static struct netconn *udpcon_4;     //˿4UDP

u8 *udp_demo_sendbuf = "1231431545431231431545fnbdfbdsbdgbgdbgdbsfsdgfnd12gfndsfsdgfnbgfnbdfbdsbdgbgdbgdbsfsdgf";
u8 udp_port1_recvbuf[100];	         //UDPӦ˿1ݻ
u8 udp_port2_recvbuf[100];	         //UDPӦ˿2ݻ
u8 udp_port3_recvbuf[100];	         //UDPӦ˿3ݻ
u8 udp_port4_recvbuf[100];	         //UDPӦ˿4ݻ

u16_t udp_port[4] = {5000,4000,3000,2000};  //UDPĶ˿ں
/*****************************************************
** @udp_demo_init
** @  UDP߳
** @  void
** @ֵ0:UDPɹ
*****************************************************/
void udp_demo_init(void)
{
    OS_ERR  err;
	CPU_SR_ALLOC();
    //Ϊ˿1Ӧ̷߳ڴ
    UDP_Port_1_send_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_1_send_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port1_Send_STACKSIZE* sizeof(CPU_STK));  //ջռ
	
    UDP_Port_1_Recv_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_1_Recv_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port1_Recv_STACKSIZE* sizeof(CPU_STK));  //ջռ
	
    //Ϊ˿2Ӧ̷߳ڴ
    UDP_Port_2_send_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_2_send_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port2_Send_STACKSIZE* sizeof(CPU_STK));  //ջռ
	
    UDP_Port_2_Recv_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_2_Recv_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port2_Recv_STACKSIZE* sizeof(CPU_STK));  //ջռ

    //Ϊ˿3Ӧ̷߳ڴ
    UDP_Port_3_send_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_3_send_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port3_Send_STACKSIZE* sizeof(CPU_STK));  //ջռ
	
    UDP_Port_3_Recv_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_3_Recv_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port3_Recv_STACKSIZE* sizeof(CPU_STK));  //ջռ

    //Ϊ˿4Ӧ̷߳ڴ
    UDP_Port_4_send_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_4_send_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port4_Send_STACKSIZE* sizeof(CPU_STK));  //ջռ
	
    UDP_Port_4_Recv_TcbPtr = (OS_TCB *)mymalloc(SRAMEX,sizeof(OS_TCB));                              //ƿռ
    UDP_Port_4_Recv_StkPtr = (CPU_STK *)mymalloc(SRAMEX,UDP_Port4_Recv_STACKSIZE* sizeof(CPU_STK));  //ջռ

	OS_CRITICAL_ENTER();	//ж
    //˿1
    OSTaskCreate((OS_TCB     *)UDP_Port_1_send_TcbPtr,                 //ƿ
                (CPU_CHAR    *)"UDP_Port1_Send_thread",                //
                (OS_TASK_PTR  )UDP_Port1_Send_thread,                  //ִк
                (void        *)0,                                      //ݸĲ
                (OS_PRIO      )UDP_Port1_Send_PRIO,                    //ȼ
                (CPU_STK     *)UDP_Port_1_send_StkPtr,                 //ջַ
                (CPU_STK_SIZE )UDP_Port1_Send_STACKSIZE/10,            //ջʹֵ
                (CPU_STK_SIZE )UDP_Port1_Send_STACKSIZE,               //ջС
                (OS_MSG_QTY   )0,
                (OS_TICK      )0,
                (void        *)0,
                (OS_OPT       )(OS_OPT_TASK_STK_CHK | OS_OPT_TASK_STK_CLR),
                (OS_ERR      *)&err); 
    //˿1
    OSTaskCreate((OS_TCB     *)UDP_Port_1_Recv_TcbPtr,                 //ƿ
                (CPU_CHAR    *)"UDP_Port1_Recv_thread",                //
                (OS_TASK_PTR  )UDP_Port1_Recv_thread,                  //ִк
                (void        *)0,                                      //ݸĲ
                (OS_PRIO      )UDP_Port1_Recv_PRIO,                    //ȼ
                (CPU_STK     *)UDP_Port_1_Recv_StkPtr,                 //ջַ
                (CPU_STK_SIZE )UDP_Port1_Recv_STACKSIZE/10,            //ջʹֵ
                (CPU_STK_SIZE )UDP_Port1_Recv_STACKSIZE,               //ջС
                (OS_MSG_QTY   )0,
                (OS_TICK      )0,
                (void        *)0,
                (OS_OPT       )(OS_OPT_TASK_STK_CHK | OS_OPT_TASK_STK_CLR),
                (OS_ERR      *)&err);
    //˿2
    OSTaskCreate((OS_TCB     *)UDP_Port_2_send_TcbPtr,                 //ƿ
                (CPU_CHAR    *)"UDP_Port2_Send_thread",                //
                (OS_TASK_PTR  )UDP_Port2_Send_thread,                  //ִк
                (void        *)0,                                      //ݸĲ
                (OS_PRIO      )UDP_Port2_Send_PRIO,                    //ȼ
                (CPU_STK     *)UDP_Port_2_send_StkPtr,                 //ջַ
                (CPU_STK_SIZE )UDP_Port2_Send_STACKSIZE/10,            //ջʹֵ
                (CPU_STK_SIZE )UDP_Port2_Send_STACKSIZE,               //ջС
                (OS_MSG_QTY   )0,
                (OS_TICK      )0,
                (void        *)0,
                (OS_OPT       )(OS_OPT_TASK_STK_CHK | OS_OPT_TASK_STK_CLR),
                (OS_ERR      *)&err); 
    //˿2
    OSTaskCreate((OS_TCB     *)UDP_Port_2_Recv_TcbPtr,                 //ƿ
                (CPU_CHAR    *)"UDP_Port2_Recv_thread",                //
                (OS_TASK_PTR  )UDP_Port2_Recv_thread,                  //ִк
                (void        *)0,                                      //ݸĲ
                (OS_PRIO      )UDP_Port2_Recv_PRIO,                    //ȼ
                (CPU_STK     *)UDP_Port_2_Recv_StkPtr,                 //ջַ
                (CPU_STK_SIZE )UDP_Port2_Recv_STACKSIZE/10,            //ջʹֵ
                (CPU_STK_SIZE )UDP_Port2_Recv_STACKSIZE,               //ջС
                (OS_MSG_QTY   )0,
                (OS_TICK      )0,
                (void        *)0,
                (OS_OPT       )(OS_OPT_TASK_STK_CHK | OS_OPT_TASK_STK_CLR),
                (OS_ERR      *)&err);
				
	OS_CRITICAL_EXIT();		//ж			
}
/*****************************************************
** @UDP_Port1_Send_thread
** @  UDPӦ˿1ķ߳
** @  void
** @ֵ
*****************************************************/
void UDP_Port1_Send_thread(void *arg)
{
	OS_ERR  os_err;
	err_t err;
	CPU_TS  ts;
	struct ip_addr destipaddr;
	
	static struct netbuf  *sentbuf;
//	udpcon_1 = netconn_new(NETCONN_UDP);                                                                    //һUDP
//    IP4_ADDR(&destipaddr,lwipdev.ip[0],lwipdev.ip[1], lwipdev.ip[2],lwipdev.ip[3]);                         //ĿIPַ	
//    err = netconn_bind(udpcon_1,&destipaddr,udp_port[0]);                                                   //󶨱IP 
//	IP4_ADDR(&destipaddr,lwipdev.remoteip[0],lwipdev.remoteip[1], lwipdev.remoteip[2],lwipdev.remoteip[3]); //ĿIPַ
//	err = netconn_connect(udpcon_1,&destipaddr,udp_port[0]); 	                                            //ӵԶ	
//	if(err == ERR_OK)                                                                                       // NETCONN_NONE
//	{
//	  sentbuf = netbuf_new();                                                                               //һݷ
//    }
	while(1)
	{
//	  if(udpcon_1 != NULL)  //UDPӳɹ
//	  {
//		   OSSemPend(&USART1_SEM,0,OS_OPT_PEND_BLOCKING,&ts,&os_err); 	
//		  
//		   netbuf_alloc(sentbuf,strlen((char *)udp_demo_sendbuf));
//		   sentbuf->p->payload = (char*)udp_demo_sendbuf;   	        //ָudp_demo_sendbuf			
//		   err = netconn_send(udpcon_1,sentbuf);  	                //netbufеݷͳȥ
//	  }
	  OSTimeDly(500,OS_OPT_TIME_DLY,&os_err);
	}
}
/*****************************************************
** @UDP_Port1_Recv_thread
** @  UDPӦ˿1Ľ߳
** @  void
** @ֵ
*****************************************************/
void UDP_Port1_Recv_thread(void *arg)
{
	OS_ERR  os_err;
	CPU_SR_ALLOC();
	struct pbuf *q;
	static struct netbuf  *recvbuf;
	while(1)
	{
	   if(udpcon_1 != NULL)
       {
		  netconn_recv(udpcon_1,&recvbuf);                    //
		  if(recvbuf != NULL)                                 //յ
		  { 
             OS_CRITICAL_ENTER();                             //ж
			 memset(udp_port1_recvbuf,0,100);                 //ݽջ
	
			 for(q=recvbuf->p;q!=NULL;q=q->next)              //pbuf
			 {
               memcpy(udp_port1_recvbuf,q->payload,q->len);   //
			 }
			  OS_CRITICAL_EXIT();                             //ж
			  netbuf_delete(recvbuf);                         //ɾbuf
           }
       }				
	   OSTimeDly(500,OS_OPT_TIME_DLY,&os_err);
	}
}	
///////////////////////////////////////
/*****************************************************
** @UDP_Port1_Send_thread
** @  UDPӦ˿1ķ߳
** @  void
** @ֵ
*****************************************************/
void UDP_Port2_Send_thread(void *arg)
{
	OS_ERR  os_err;
	err_t err;
	CPU_TS  ts;
	struct ip_addr destipaddr;
	
	static struct netbuf  *sentbuf;
	udpcon_2 = netconn_new(NETCONN_UDP);                                                                    //һUDP
    IP4_ADDR(&destipaddr,lwipdev.ip[0],lwipdev.ip[1], lwipdev.ip[2],lwipdev.ip[3]);                         //ĿIPַ	
    err = netconn_bind(udpcon_2,&destipaddr,udp_port[1]);                                                   //󶨱IP 
	IP4_ADDR(&destipaddr,lwipdev.remoteip[0],lwipdev.remoteip[1], lwipdev.remoteip[2],lwipdev.remoteip[3]); //ĿIPַ
	err = netconn_connect(udpcon_2,&destipaddr,udp_port[1]); 	                                            //ӵԶ	
	if(err == ERR_OK)                                                                                       // NETCONN_NONE
	{
	  sentbuf = netbuf_new();                                                                               //һݷ
    }
	while(1)
	{
	  if(udpcon_2 != NULL)  //UDPӳɹ
	  {
		  OSSemPend(&USART2_SEM,0,OS_OPT_PEND_BLOCKING,&ts,&os_err);
		  
		  netbuf_alloc(sentbuf,strlen((char *)udp_demo_sendbuf));
		  sentbuf->p->payload = (char*)udp_demo_sendbuf;   	        //ָudp_demo_sendbuf			
		  err = netconn_send(udpcon_2,sentbuf);  	                //netbufеݷͳȥ
	  }
	  OSTimeDly(50,OS_OPT_TIME_DLY,&os_err);
	}
}
/*****************************************************
** @UDP_Port1_Recv_thread
** @  UDPӦ˿1Ľ߳
** @  void
** @ֵ
*****************************************************/
void UDP_Port2_Recv_thread(void *arg)
{
	OS_ERR  os_err;
	CPU_SR_ALLOC();
	struct pbuf *q;
	static struct netbuf  *recvbuf;
	while(1)
	{
	   if(udpcon_2 != NULL)
       {
		  netconn_recv(udpcon_2,&recvbuf);                    //
		  if(recvbuf != NULL)                                 //յ
		  { 
             OS_CRITICAL_ENTER();                             //ж
			 memset(udp_port2_recvbuf,0,100);                 //ݽջ
	
			 for(q=recvbuf->p;q!=NULL;q=q->next)              //pbuf
			 {
               memcpy(udp_port2_recvbuf,q->payload,q->len);   //
			 }
			  OS_CRITICAL_EXIT();                             //ж
			  netbuf_delete(recvbuf);                         //ɾbuf
           }
       }				
	   OSTimeDly(50,OS_OPT_TIME_DLY,&os_err);
	}
}	




