#include "malloc.h"
//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ALIENTEK STM32F407
//ڴ 	   
//ԭ@ALIENTEK
//̳:www.openedv.com
//:2014/5/15
//汾V1.0
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2014-2024
//All rights reserved									  
////////////////////////////////////////////////////////////////////////////////// 	 


//ڴ(4ֽڶ)
__align(4) u8 mem1base[MEM1_MAX_SIZE];
__align(4) u8 mem2base[MEM2_MAX_SIZE] __attribute__((at(0x68000000))); //ⲿSRAMڴ
__align(4) u8 mem3base[MEM3_MAX_SIZE] __attribute__((at(0x10000000))); //ڲCMMڴ
//ڴ
u16 mem1mapbase[MEM1_ALLOC_TABLE_SIZE];													//ڲSRAMڴMAP
u16 mem2mapbase[MEM2_ALLOC_TABLE_SIZE] __attribute__((at(0X68000000+MEM2_MAX_SIZE)));	//ⲿSRAMڴMAP
u16 mem3mapbase[MEM3_ALLOC_TABLE_SIZE] __attribute__((at(0X10000000+MEM3_MAX_SIZE)));	//ڲCCMڴMAP
//ڴ	   
const u32 memtblsize[SRAMBANK]={MEM1_ALLOC_TABLE_SIZE,MEM2_ALLOC_TABLE_SIZE,MEM3_ALLOC_TABLE_SIZE};	//ڴС
const u32 memblksize[SRAMBANK]={MEM1_BLOCK_SIZE,MEM2_BLOCK_SIZE,MEM3_BLOCK_SIZE};					//ڴֿС
const u32 memsize[SRAMBANK]={MEM1_MAX_SIZE,MEM2_MAX_SIZE,MEM3_MAX_SIZE};							//ڴܴС

//ڴ
struct _m_mallco_dev mallco_dev=
{
	mymem_init,							//ڴʼ
	mem_perused,						//ڴʹ
	mem1base,mem2base,mem3base,			//ڴ
	mem1mapbase,mem2mapbase,mem3mapbase,//ڴ״̬
	0,0,0,  		 					//ڴδ
};

//ڴ
//*des:Ŀĵַ
//*src:Դַ
//n:ҪƵڴ泤(ֽΪλ)
void mymemcpy(void *des,void *src,u32 n)
{
	u8 *xdes = des;
	u8 *xsrc = src;
	while(n--) *xdes++ = *xsrc++;
}

//ڴ
//*s:ڴ׵ַ
//c :Ҫõֵ
//count:ҪõڴС(ֽΪλ)
void mymemset(void*s,u8 c,u32 count)
{
	u8 *xs = s;
	while(count--) *xs++=c;
}

//ڴʼ  
//memx:ڴ
void mymem_init(u8 memx)
{
	mymemset(mallco_dev.memmap[memx],0,memtblsize[memx]*2); //ڴ״̬
	mymemset(mallco_dev.membase[memx], 0,memsize[memx]);	//ڴ  
	mallco_dev.memrdy[memx]=1;								//ڴʼOK  
}

//ȡڴʹ
//memx:ڴ
//ֵ:ʹ(0~100)
u8 mem_perused(u8 memx)  
{  
    u32 used=0;  
    u32 i;  
    for(i=0;i<memtblsize[memx];i++)  
    {  
        if(mallco_dev.memmap[memx][i])used++; 
    } 
    return (used*100)/(memtblsize[memx]);  
} 

//ڴ(ڲ)
//memx:ڴ
//size:ҪڴС(ֽ)
//ֵ:0XFFFFFFFF,;,ڴƫƵַ 
u32 mymem_malloc(u8 memx,u32 size)  
{  
    signed long offset=0;  
    u16 nmemb;	//Ҫڴ  
		u16 cmemb=0;//ڴ
    u32 i;  
    if(!mallco_dev.memrdy[memx])mallco_dev.init(memx);//δʼ,ִгʼ 
    if(size==0)return 0XFFFFFFFF;//Ҫ
    nmemb=size/memblksize[memx];  	//ȡҪڴ
    if(size%memblksize[memx])nmemb++;  
    for(offset=memtblsize[memx]-1;offset>=0;offset--)//ڴ  
    {     
		if(!mallco_dev.memmap[memx][offset])cmemb++;//ڴ
		else cmemb=0;								//ڴ
		if(cmemb==nmemb)							//ҵnmembڴ
		{
            for(i=0;i<nmemb;i++)  					//עڴǿ 
            {  
                mallco_dev.memmap[memx][offset+i]=nmemb;  
            }  
            return (offset*memblksize[memx]);//ƫƵַ  
		}
    }  
    return 0XFFFFFFFF;//δҵϷڴ  
}  

//ͷڴ(ڲ) 
//memx:ڴ
//offset:ڴַƫ
//ֵ:0,ͷųɹ;1,ͷʧ;  
u8 mymem_free(u8 memx,u32 offset)  
{  
	int i;  
  if(!mallco_dev.memrdy[memx])//δʼ,ִгʼ
	{
		mallco_dev.init(memx);    
    return 1;//δʼ  
  }  
  if(offset<memsize[memx])//ƫڴ. 
  {  
		int index=offset/memblksize[memx];			//ƫڴ  
    int nmemb=mallco_dev.memmap[memx][index];	//ڴ
    for(i=0;i<nmemb;i++)  						//ڴ
    {  
			mallco_dev.memmap[memx][index+i]=0;  
    }  
    return 0;  
  }else return 2;//ƫƳ.  
}  

//ͷڴ(ⲿ) 
//memx:ڴ
//ptr:ڴ׵ַ 
void myfree(u8 memx,void *ptr)  
{  
	u32 offset;  
    if(ptr==NULL)return;//ַΪ0.  
 	offset=(u32)ptr-(u32)mallco_dev.membase[memx];  
    mymem_free(memx,offset);//ͷڴ     
}  

//ڴ(ⲿ)
//memx:ڴ
//size:ڴС(ֽ)
//ֵ:䵽ڴ׵ַ.
void *mymalloc(u8 memx,u32 size)  
{  
  u32 offset;  									      
	offset=mymem_malloc(memx,size);  	   				   
  if(offset==0XFFFFFFFF)return NULL;  
  else return (void*)((u32)mallco_dev.membase[memx]+offset);  
}  

//·ڴ(ⲿ)
//memx:ڴ
//*ptr:ڴ׵ַ
//size:ҪڴС(ֽ)
//ֵ:·䵽ڴ׵ַ.
void *myrealloc(u8 memx,void *ptr,u32 size)  
{  
    u32 offset;  
    offset=mymem_malloc(memx,size);  
    if(offset==0XFFFFFFFF)return NULL;     
    else  
    {  									   
	    mymemcpy((void*)((u32)mallco_dev.membase[memx]+offset),ptr,size);	//ڴݵڴ   
        myfree(memx,ptr);  											  		//ͷžڴ
        return (void*)((u32)mallco_dev.membase[memx]+offset);  				//ڴ׵ַ
    }  
}
