#include "delay.h"


#include "includes.h"
////////////////////////////////////////////////////////////////////////////////// 	 
//ʹucos,ͷļ.
#define SYSTEM_SUPPORT_UCOS		1		//ϵͳļǷ֧UCOS
#if SYSTEM_SUPPORT_UCOS
#include "includes.h"					//ucos ʹ	  
#endif
//////////////////////////////////////////////////////////////////////////////////  
//ֻѧϰʹãδɣκ;
//ALIENTEK STM32F407
//ʹSysTickͨģʽӳٽй(֧ucosiiucosiii)
//delay_us,delay_ms
//ԭ@ALIENTEK
//̳:www.openedv.com
//޸:2014/5/2
//汾V1.1
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2014-2024
//All rights reserved
//********************************************************************************
//޸˵
//V1.1޸˵
//˶UCOSIII֧
////////////////////////////////////////////////////////////////////////////////// 
static u8  fac_us=0;//usʱ
static u16 fac_ms=0;//msʱ
#if SYSTEM_SUPPORT_UCOS						//SYSTEM_SUPPORT_UCOS,˵Ҫ֧OS(UCOS).
#ifdef 	OS_CRITICAL_METHOD						//OS_CRITICAL_METHOD,˵Ҫ֧UCOSII				
#define delay_osrunning		OSRunning			//OSǷб,0,;1,
#define delay_tickspersec	OS_TICKS_PER_SEC	//OSʱӽ,ÿȴ
#define delay_intnesting 	OSIntNesting		//жǶ׼,жǶ״
#endif

//֧UCOSIII
#ifdef 	CPU_CFG_CRITICAL_METHOD					//CPU_CFG_CRITICAL_METHOD,˵Ҫ֧UCOSIII	
#define delay_osrunning		OSRunning			//OSǷб,0,;1,
#define delay_tickspersec	OSCfg_TickRate_Hz	//OSʱӽ,ÿȴ
#define delay_intnesting 	OSIntNestingCtr		//жǶ׼,жǶ״
#endif

//usʱʱ,ر(ֹusӳ)
void delay_schedlock(void)
{
#ifdef CPU_CFG_CRITICAL_METHOD   			//ʹUCOSIII
	OS_ERR err; 
	OSSchedLock(&err);						//UCOSIIIķʽ,ֹȣֹusʱ
#else										//UCOSII
	OSSchedLock();							//UCOSIIķʽ,ֹȣֹusʱ
#endif
}

//usʱʱ,ָ
void delay_schedunlock(void)
{	
#ifdef CPU_CFG_CRITICAL_METHOD   			//ʹUCOSIII
	OS_ERR err; 
	OSSchedUnlock(&err);					//UCOSIIIķʽ,ָ
#else										//UCOSII
	OSSchedUnlock();						//UCOSIIķʽ,ָ
#endif
}

//OSԴʱʱ
//ticks:ʱĽ
void delay_ostimedly(u32 ticks)
{
#ifdef CPU_CFG_CRITICAL_METHOD
	OS_ERR err; 
	OSTimeDly(ticks,OS_OPT_TIME_PERIODIC,&err);//UCOSIIIʱģʽ
#else
	OSTimeDly(ticks);						//UCOSIIʱ
#endif 
}
 
//systickжϷ,ʹucosʱõ
void SysTick_Handler(void)
{	
	if(delay_osrunning==1)					//OSʼ,ִĵȴ
	{
		OSIntEnter();						//ж
		OSTimeTick();       				//ucosʱӷ               
		OSIntExit();       	 				//лж
	}
}
#endif

//ʼӳٺ
//ʹucosʱ,˺ʼucosʱӽ
//SYSTICKʱӹ̶ΪHCLKʱӵ1/8
//SYSCLK:ϵͳʱ
void delay_init(u8 SYSCLK)
{
#if SYSTEM_SUPPORT_UCOS	//Ҫ֧OS.
	u32 reload;
#endif  
 	SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK_Div8);
	fac_us=SYSCLK/8;						//Ϊϵͳʱӵ1/8   
#if SYSTEM_SUPPORT_UCOS 					//Ҫ֧OS.
	reload=SYSCLK/8;						//ÿӵļ λΪK	   
	reload*=1000000/delay_tickspersec;		//OS_TICKS_PER_SEC趨ʱ
											//reloadΪ24λĴ,ֵ:16777216,168M,Լ0.7989s	
	fac_ms=1000/delay_tickspersec;			//ucosʱٵλ	   
	SysTick->CTRL|=SysTick_CTRL_TICKINT_Msk;//SYSTICKж
	SysTick->LOAD=reload; 					//ÿ1/OS_TICKS_PER_SECжһ	
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk; //SYSTICK
#else
	fac_ms=(u16)fac_us*1000;//ucos,ÿmsҪsystickʱ   
#endif //SYSTEM_SUPPORT_UCOS
}								    


#if SYSTEM_SUPPORT_UCOS 	//ʹucos
//ʱnus
//nus:Ҫʱus.		    								   
void delay_us(u32 nus)
{		
	u32 ticks;
	u32 told,tnow,tcnt=0;
	u32 reload=SysTick->LOAD;	//LOADֵ	    	 
	ticks=nus*fac_us; 			//ҪĽ	  		 
	tcnt=0;
	delay_schedlock();			//ֹOSȣֹusʱ
	told=SysTick->VAL;        	//սʱļֵ
	while(1)
	{
		tnow=SysTick->VAL;	
		if(tnow!=told)
		{	    
			if(tnow<told)tcnt+=told-tnow;//עһSYSTICKһݼļͿ.
			else tcnt+=reload-tnow+told;	    
			told=tnow;
			if(tcnt>=ticks)break;	//ʱ䳬/Ҫӳٵʱ,˳.
		}  
	};
	delay_schedunlock();			//ָOS											    
}

//ʱnms
//nms:Ҫʱms
void delay_ms(u16 nms)
{	
	if(delay_osrunning&&delay_intnesting==0)//osѾ	   
	{		  
		if(nms>=fac_ms)//ʱʱucosʱ 
		{
			delay_ostimedly(nms/fac_ms);	//OSʱ
		}
		nms%=fac_ms;						//ucosѾ޷ṩôСʱ,ͨʽʱ    
	}
	delay_us((u32)(nms*1000));		//ͨʽʱ 
}
#else  //ʹòϵͳ
//ʱnus
//nusΪҪʱus.	
//ע:nusֵ,Ҫ798915us
void delay_us(u32 nus)
{		
	u32 temp;	    	  
	SysTick->LOAD=nus*fac_us; //ʱ	  		 
	SysTick->VAL=0x00;        //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ 
	do
	{
		temp=SysTick->CTRL;
	}
	while((temp&0x01)&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ	 
}
//ʱnms
//עnmsķΧ
//SysTick->LOADΪ24λĴ,,ʱΪ:
//nms<=0xffffff*8*1000/SYSCLK
//SYSCLKλΪHz,nmsλΪms
//168M,nms<=798ms 
void delay_xms(u16 nms)
{	 		  	  
	u32 temp;		   
	SysTick->LOAD=(u32)nms*fac_ms;//ʱ(SysTick->LOADΪ24bit)
	SysTick->VAL =0x00;           //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ  
	do
	{
		temp=SysTick->CTRL;
	}
	while((temp&0x01)&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ	  	    
} 
//ʱnms 
//nms:0~65535
void delay_ms(u16 nms)
{	 	 
	u32 temp;		   
	SysTick->LOAD=(u32)nms*fac_ms;//ʱ(SysTick->LOADΪ24bit)
	SysTick->VAL =0x00;           //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ  
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ
}
#endif
			 



































