#include "delay.h"
#include "LAN8720.h"
#include "timer.h"
#include "sram.h"
#include "malloc.h"
#include "lwip_comm.h"
#include "includes.h"
#include "lwipopts.h"
#include "udp_src.h"

#define START_TASK_PRIO		10          //ȼ
#define START_STK_SIZE		512         //ջС
OS_TCB StartTaskTCB;                    //ƿ
CPU_STK START_TASK_STK[START_STK_SIZE]; //ջ
void start_task(void *pdata);           //ں


OS_SEM USART1_SEM;               //1ź
OS_SEM USART2_SEM;               //2ź
OS_SEM USART3_SEM;               //3ź
OS_SEM USART4_SEM;               //4ź

int main(void)
{
	OS_ERR err;
	CPU_SR_ALLOC();
	
	delay_init(168);       	                        //ʱʼ
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);	//жϷ

	FSMC_SRAM_Init();		//SRAMʼ
	
	mymem_init(SRAMIN);  	//ʼڲڴ
	mymem_init(SRAMEX);  	//ʼⲿڴ
	mymem_init(SRAMCCM); 	//ʼCCMڴ
	
	OSInit(&err); 					//UCOSIIIʼ
	while(lwip_comm_init()); 		//lwipʼ
	udp_demo_init();                //ʼUDP
	OS_CRITICAL_ENTER();                                                //ٽ
	OSTaskCreate((OS_TCB 	* )&StartTaskTCB,		                    //ƿ
				 (CPU_CHAR	* )"start task", 		                    //
                 (OS_TASK_PTR )start_task, 			                    //
                 (void		* )0,					                    //ݸĲ
                 (OS_PRIO	  )START_TASK_PRIO,                         //ȼ
                 (CPU_STK   * )&START_TASK_STK[0],	                    //ջַ
                 (CPU_STK_SIZE)START_STK_SIZE/10,	                    //ջλ
                 (CPU_STK_SIZE)START_STK_SIZE,		                    //ջС
                 (OS_MSG_QTY  )0,					                    //ڲϢܹյϢĿ,Ϊ0ʱֹϢ
                 (OS_TICK	  )0,					                    //ʹʱƬתʱʱƬȣΪ0ʱΪĬϳȣ
                 (void   	* )0,					                    //ûĴ洢
                 (OS_OPT      )OS_OPT_TASK_STK_CHK|OS_OPT_TASK_STK_CLR, //ѡ
                 (OS_ERR 	* )&err);				                    //Ÿúʱķֵ
				 
    /****************һź***********************/
    OSSemCreate(&USART1_SEM,"usart1_sem",(OS_SEM_CTR)0,&err); 	
    OSSemCreate(&USART2_SEM,"usart2_sem",(OS_SEM_CTR)0,&err);
    OSSemCreate(&USART3_SEM,"usart3_sem",(OS_SEM_CTR)0,&err); 	
    OSSemCreate(&USART4_SEM,"usart4_sem",(OS_SEM_CTR)0,&err);
				 
	OS_CRITICAL_EXIT();                                                 //˳ٽ	 
	OSStart(&err); 		                                                //ʼUCOS
}


u8_t flag_1 = 0;
u8_t flag_2 = 0;
u8_t flag_3 = 0;
u8_t flag_4 = 0;

//start
void start_task(void *p_arg)
{
	OS_ERR err;
//	CPU_SR_ALLOC();
	CPU_Init();
#if OS_CFG_STAT_TASK_EN > 0u
   OSStatTaskCPUUsageInit(&err);  	                    //ͳ                
#endif
	
#ifdef CPU_CFG_INT_DIS_MEAS_EN		                    //ʹ˲жϹرʱ
    CPU_IntDisMeasMaxCurReset();	
#endif

#if	OS_CFG_SCHED_ROUND_ROBIN_EN                         //ʹʱƬתʱ
	OSSchedRoundRobinCfg(DEF_ENABLED,1,&err);           //ʹʱƬתȹ,ʱƬΪ1ϵͳʱӽģ1*5=5ms 
#endif	
    while(1)
	{		
       //OS_TaskSuspend((OS_TCB*)&StartTaskTCB,&err);		//ʼ
	   if(flag_1 == 1)
	   {
		   OSSemPost(&USART1_SEM,OS_OPT_POST_1,&err);	
		   flag_1 = 0;
	   }
	   if(flag_2 == 1)
	   {
		   OSSemPost(&USART2_SEM,OS_OPT_POST_1,&err);	
		   flag_2 = 0;
	   }
	   if(flag_3 == 1)
	   {
		   OSSemPost(&USART3_SEM,OS_OPT_POST_1,&err);	
		   flag_3 = 0;
	   }
	   if(flag_4 == 1)
	   {
		   OSSemPost(&USART4_SEM,OS_OPT_POST_1,&err);	
		   flag_4 = 0;
	   }
        OSTimeDly(200,OS_OPT_TIME_DLY,&err);	   
	}		
}












