//ʱ

#include "BspTime3.h"
#include "bsp.h"

static void (*IRQHandler)(void) = NULL;

void TIM_Delay_Init(void)//ʱʱ
{
	TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;

	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM3, ENABLE); 
	
	TIM_DeInit(TIM3);//ʼλλֵ
	TIM_InternalClockConfig(TIM3);//ڲʱ
	TIM_TimeBaseStructure.TIM_Period = 0xffff;//Զװֵ;ϼ0xffff,ֵ,5000Ϊ5ms
	TIM_TimeBaseStructure.TIM_Prescaler =71;//ԤƵֵ,1MhzļƵ
	TIM_TimeBaseStructure.TIM_ClockDivision = 0;//ʱӷָΪ0
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;//TIMϼģʽ
	TIM_TimeBaseInit(TIM3, &TIM_TimeBaseStructure);//ʼTIMxʱλ
	TIM_Cmd(TIM3, DISABLE);
}

//رնʱ
void BspTim3Close(void)
{
    TIM_Cmd(TIM3, DISABLE);
    TIM_SetCounter(TIM3, 0);
    TIM_ITConfig(TIM3, TIM_IT_Update, DISABLE);
}

void TIM_DelayUs(u16 i)//1~65535usʱ	  
{
	u16 TIMCounter = 0;
	TIM_SetCounter(TIM3, TIMCounter);
	TIM_Cmd(TIM3, ENABLE);
	while (TIMCounter<i)
	{
		TIMCounter = TIM_GetCounter(TIM3);
	}
	TIM_Cmd(TIM3, DISABLE);
}


//ͨöʱ4ʼ
void BspTim4Init(void)
{
    NVIC_InitTypeDef NvicInitdef;
    TIM_TimeBaseInitTypeDef timbase;	
    u16 cnt = 170 * 72;     //170us 

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, ENABLE);	

    TIM_DeInit(TIM4); 
    timbase.TIM_CounterMode = TIM_CounterMode_Up;
    timbase.TIM_ClockDivision = TIM_CKD_DIV1;
    timbase.TIM_Period = cnt - 1;
    timbase.TIM_Prescaler = 0; 	        // 1Ƶ
    TIM_TimeBaseInit(TIM4, &timbase);

    NvicInitdef.NVIC_IRQChannel = TIM4_IRQn;
    NvicInitdef.NVIC_IRQChannelPreemptionPriority = 0;
    NvicInitdef.NVIC_IRQChannelSubPriority = 2;
    NvicInitdef.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NvicInitdef);

    TIM_SetCounter(TIM4, 0);
    TIM_ITConfig(TIM4, TIM_IT_Update, DISABLE);
    TIM_ClearITPendingBit( TIM4, TIM_IT_Update);

    /* TIMX enable counter */
    TIM_Cmd(TIM4, DISABLE);
}

//ʹܶʱ
void BspTim4Open(void)
{
    TIM_SetCounter(TIM4, 0);
    TIM_Cmd(TIM4, ENABLE);
    TIM_ITConfig(TIM4, TIM_IT_Update, ENABLE);
}

//رնʱ
void BspTim4Close(void)
{
    TIM_Cmd(TIM4, DISABLE);
    TIM_SetCounter(TIM4, 0);
    TIM_ITConfig(TIM4, TIM_IT_Update, DISABLE);
}

//üֵ
void BspTim4SetCounter(u16 count)
{
    TIM_SetCounter(TIM4, count);
}

//жϺ
void BspTim4SetIRQCallBack(void *fun)
{
    IRQHandler = (void (*)(void))fun;
}

//timxжϺ
void TIM4_IRQHandler(void)
{
    if( SET == TIM_GetITStatus(TIM4,TIM_IT_Update) )
    {
        TIM_ClearITPendingBit( TIM4, TIM_IT_Update);

        if (IRQHandler != NULL)
            (*IRQHandler)();//жϺ
    }
}
